/*
 * flexion.java
 *
 * Created on 10 juillet 2007, 22:06
 */
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import java.awt.*;
import javax.swing.*;
import java.math.*;
import java.util.*;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.omg.CORBA.portable.ValueBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import java.io.*;
/**
 *
 * @author  Neil Abroug
 */


/*******************/  
/***BrowseControl***/
/*******************/ 
class BrowserControl
{
    /**
     * Display a file in the system browser.  If you want to display a
     * file, you must include the absolute path name.
     *
     * @param url the file's url (the url must start with either "http://"
or
     * "file://").
     */
    public static void displayURL(String url)
    {
        boolean windows = isWindowsPlatform();
        String cmd = null;
        try
        {
            if (windows)
            {
                // cmd = 'rundll32 url.dll,FileProtocolHandler http://...'
                cmd = WIN_PATH + " " + WIN_FLAG + " " + url;
                Process p = Runtime.getRuntime().exec(cmd);
            }
            else
            {
                // Under Unix, Netscape has to be running for the "-remote"
                // command to work.  So, we try sending the command and
                // check for an exit value.  If the exit command is 0,
                // it worked, otherwise we need to start the browser.
                // cmd = 'netscape -remote openURL(http://www.javaworld.com)'
                cmd = UNIX_PATH + " " + UNIX_FLAG + "(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try
                {
                    // wait for exit code -- if it's 0, command worked,
                    // otherwise we need to start the browser up.
                    int exitCode = p.waitFor();
                    if (exitCode != 0)
                    {
                        // Command failed, start up the browser
                        // cmd = 'netscape http://www.javaworld.com'
                        cmd = UNIX_PATH + " "  + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch(InterruptedException x)
                {
                    System.err.println("Error bringing up browser, cmd='" +
                                       cmd + "'");
                    System.err.println("Caught: " + x);
                }
            }
        }
        catch(IOException x)
        {
            // couldn't exec browser
            System.err.println("Could not invoke browser, command=" + cmd);
            System.err.println("Caught: " + x);
        }
    }
    /**
     * Try to determine whether this application is running under Windows
     * or some other platform by examing the "os.name" property.
     *
     * @return true if this application is running under a Windows OS
     */
    public static boolean isWindowsPlatform()
    {
        String os = System.getProperty("os.name");
        if ( os != null && os.startsWith(WIN_ID))
            return true;
        else
            return false;
    }
    /**
     * Simple example.
     */
    public static void main(String[] args)
    {
        displayURL("http://www.javaworld.com");
    }
    // Used to identify the windows platform.
    private static final String WIN_ID = "Windows";
    // The default system browser under windows.
    private static final String WIN_PATH = "rundll32";
    // The flag to display a url.
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    // The default browser under unix.
    private static final String UNIX_PATH = "netscape";
    // The flag to display a url.
    private static final String UNIX_FLAG = "-remote openURL";
}
/*******************/  
/*End BrowseControl*/
/*******************/


public class flexion extends javax.swing.JFrame {
    /** Creates new form flexion */
    public flexion() {
        initComponents();
        initializeTree();
    }
    
    
    public int v=0;
    int u=0;
    double a1=0,a2=0,a3=0,a4=0,a5=0;
    //public double igz;
    double igz;
    double x,y,z;
    double E;
    int m1,m2;
    double F1,F2;
    double L,L1,L2;
    double strain=0,strain2=0,sigma=0,sigmas=0;
    double fn=0;
    double ms=0,ms1=0,ms2=0,ms3=0;
    double t,t1;
    boolean isSelected1;
    boolean isSelected2;
    double sf,bm,bm2;
    double L3,L4;
    double s;
    String dateb = (new Date()).toString(); 
    String date=dateb.substring(0,11)+dateb.substring(25,29);
    String line,report;
    String pos;
    String def;
    double stress,stres,i0,t2;
    double f;
    
    
     public double round(double value, int dec) {
        double mult = Math.pow (10.0, (double)dec);
        return Math.round(value * mult) / mult;
    }   
    
    
    /* This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttonGroup1 = new javax.swing.ButtonGroup();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanel9 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jScrollBar1 = new javax.swing.JScrollBar();
        jPanel6 = new javax.swing.JPanel();
        textField1 = new java.awt.TextField();
        textField2 = new java.awt.TextField();
        textField3 = new java.awt.TextField();
        textField4 = new java.awt.TextField();
        textField5 = new java.awt.TextField();
        jPanel8 = new javax.swing.JPanel();
        //jPanel8.setIconImage(new ImageIcon(getClass().getResource("T.jpg")).getImage());
        //ImageIcon i = new ImageIcon("T.jpg");
        jLabel3 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jComboBox13 = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jScrollBar2 = new javax.swing.JScrollBar();
        jPanel7 = new javax.swing.JPanel();
        jTextField5 = new javax.swing.JTextField();
        jTextField6 = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jTextField7 = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel9 = new javax.swing.JLabel();
        jComboBox12 = new javax.swing.JComboBox();
        jPanel3 = new javax.swing.JPanel();
        jPanel10 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();
        jPanel11 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jTextField10 = new javax.swing.JTextField();
        jTextField11 = new javax.swing.JTextField();
        jTextField12 = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        jPanel16 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jPanel12 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        jComboBox2 = new javax.swing.JComboBox();
        jTextField13 = new javax.swing.JTextField();
        jTextField14 = new javax.swing.JTextField();
        jLabel36 = new javax.swing.JLabel();
        jTextField39 = new javax.swing.JTextField();
        jComboBox16 = new javax.swing.JComboBox();
        jPanel13 = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jTextField8 = new javax.swing.JTextField();
        jComboBox3 = new javax.swing.JComboBox();
        jTextField44 = new javax.swing.JTextField();
        jComboBox17 = new javax.swing.JComboBox();
        jTextField9 = new javax.swing.JTextField();
        jComboBox4 = new javax.swing.JComboBox();
        jLabel16 = new javax.swing.JLabel();
        jTextField15 = new javax.swing.JTextField();
        jComboBox5 = new javax.swing.JComboBox();
        jLabel17 = new javax.swing.JLabel();
        jTextField29 = new javax.swing.JTextField();
        jTextField42 = new javax.swing.JTextField();
        jLabel41 = new javax.swing.JLabel();
        jLabel38 = new javax.swing.JLabel();
        jTextField28 = new javax.swing.JTextField();
        jLabel42 = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();
        jButton4 = new javax.swing.JButton();
        jTextField35 = new javax.swing.JTextField();
        jTextField36 = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        jLabel32 = new javax.swing.JLabel();
        jComboBox7 = new javax.swing.JComboBox();
        jTextField34 = new javax.swing.JTextField();
        jTextField20 = new javax.swing.JTextField();
        jTextField19 = new javax.swing.JTextField();
        jLabel31 = new javax.swing.JLabel();
        jComboBox14 = new javax.swing.JComboBox();
        jLabel19 = new javax.swing.JLabel();
        jComboBox6 = new javax.swing.JComboBox();
        jLabel33 = new javax.swing.JLabel();
        jTextField37 = new javax.swing.JTextField();
        jComboBox15 = new javax.swing.JComboBox();
        jLabel26 = new javax.swing.JLabel();
        jComboBox18 = new javax.swing.JComboBox();
        jComboBox19 = new javax.swing.JComboBox();
        jComboBox20 = new javax.swing.JComboBox();
        jTextField1 = new javax.swing.JTextField();
        jTextField18 = new javax.swing.JTextField();
        jTextField23 = new javax.swing.JTextField();
        jTextField24 = new javax.swing.JTextField();
        jTextField25 = new javax.swing.JTextField();
        jTextField26 = new javax.swing.JTextField();
        jTextField27 = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        jTextField21 = new javax.swing.JTextField();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jLabel35 = new javax.swing.JLabel();
        jComboBox8 = new javax.swing.JComboBox();
        jTextField45 = new javax.swing.JTextField();
        jTextField46 = new javax.swing.JTextField();
        jLabel39 = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jComboBox21 = new javax.swing.JComboBox();
        jComboBox22 = new javax.swing.JComboBox();
        jComboBox25 = new javax.swing.JComboBox();
        jLabel43 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jTextField47 = new javax.swing.JTextField();
        jTextField48 = new javax.swing.JTextField();
        jComboBox24 = new javax.swing.JComboBox();
        jPanel15 = new javax.swing.JPanel();
        jComboBox9 = new javax.swing.JComboBox();
        jTextField22 = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        jTextField16 = new javax.swing.JTextField();
        jLabel23 = new javax.swing.JLabel();
        jComboBox10 = new javax.swing.JComboBox();
        jComboBox11 = new javax.swing.JComboBox();
        jTextField17 = new javax.swing.JTextField();
        jLabel24 = new javax.swing.JLabel();
        jTextField40 = new javax.swing.JTextField();
        jTextField41 = new javax.swing.JTextField();
        jLabel37 = new javax.swing.JLabel();
        jButton5 = new javax.swing.JButton();
        jLabel34 = new javax.swing.JLabel();
        jButton9 = new javax.swing.JButton();
        jTextField38 = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        buttonGroup1.add(jRadioButton1);
        buttonGroup1.add(jRadioButton2);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Loading Calculator");
        jScrollPane2.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane2.setAutoscrolls(true);
        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Profiles"));
        jScrollBar1.setUnitIncrement(10);
        jScrollBar1.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
            public void adjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {
                jScrollBar1AdjustmentValueChanged(evt);
            }
        });

        jPanel6.setBackground(new java.awt.Color(255, 255, 255));
        textField1.setEditable(false);
        textField1.setEnabled(false);

        textField2.setEditable(false);
        textField2.setEnabled(false);

        textField3.setEditable(false);
        textField3.setEnabled(false);

        textField4.setEditable(false);
        textField4.setEnabled(false);

        textField5.setEditable(false);
        textField5.setEnabled(false);

        jLabel3.setBackground(new java.awt.Color(102, 255, 255));
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/umpty.JPG")));

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel3)
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel3)
        );

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jComboBox13.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(textField3, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel6Layout.createSequentialGroup()
                                .addComponent(textField5, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(78, 78, 78)
                                .addComponent(textField4, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(textField1, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(68, 68, 68)
                        .addComponent(jButton1)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(textField2, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox13, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(textField4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(textField5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                        .addComponent(textField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(39, 39, 39)
                        .addComponent(textField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jButton1)
                        .addComponent(jComboBox13, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(textField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(23, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Loads"));
        jScrollBar2.setUnitIncrement(10);
        jScrollBar2.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
            public void adjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {
                jScrollBar2AdjustmentValueChanged(evt);
            }
        });

        jPanel7.setBackground(new java.awt.Color(255, 255, 255));
        jTextField5.setEditable(false);

        jTextField6.setEditable(false);

        jLabel12.setText("L:");

        jTextField7.setEditable(false);

        jLabel13.setText("L1:");

        jLabel14.setText("L2:");

        jButton3.setText("OK");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jSeparator1.setOrientation(javax.swing.SwingConstants.VERTICAL);

        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/umpty.JPG")));
        jLabel9.setText("jLabel9");

        jComboBox12.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox12.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox12ItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 272, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(3, 3, 3)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel12)
                        .addGap(12, 12, 12)
                        .addComponent(jTextField7, javax.swing.GroupLayout.DEFAULT_SIZE, 38, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel13)
                        .addGap(6, 6, 6)
                        .addComponent(jTextField6, javax.swing.GroupLayout.DEFAULT_SIZE, 38, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel14)
                        .addGap(6, 6, 6)
                        .addComponent(jTextField5, javax.swing.GroupLayout.DEFAULT_SIZE, 38, Short.MAX_VALUE))
                    .addComponent(jComboBox12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton3))
                .addContainerGap())
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel9, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup()
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel12)
                            .addComponent(jTextField7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel13)
                            .addComponent(jTextField6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel14)
                            .addComponent(jTextField5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE)
                        .addComponent(jButton3))
                    .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE))
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollBar2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(32, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollBar2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("materials"));
        jPanel10.setBorder(javax.swing.BorderFactory.createTitledBorder("Material"));
        jTree1.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                jTree1ValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(jTree1);

        javax.swing.GroupLayout jPanel10Layout = new javax.swing.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel10Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 191, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel10Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 161, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanel11.setBorder(javax.swing.BorderFactory.createTitledBorder("Properties"));
        jLabel5.setText("Young Module(E):");

        jTextField2.setEditable(false);

        jLabel6.setText("Yield Stength(Re):");

        jTextField3.setEditable(false);

        jLabel11.setText("Tensile Strength(Rm):");

        jTextField4.setEditable(false);

        jTextField10.setEditable(false);
        jTextField10.setText(" N/m^2");

        jTextField11.setEditable(false);
        jTextField11.setText(" Kg/m^2");

        jTextField12.setEditable(false);
        jTextField12.setText(" Kg/m^2");

        javax.swing.GroupLayout jPanel11Layout = new javax.swing.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(jLabel6)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jTextField2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 115, Short.MAX_VALUE)
                            .addComponent(jTextField3, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextField4, javax.swing.GroupLayout.Alignment.LEADING))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jTextField12)
                            .addComponent(jTextField10)
                            .addComponent(jTextField11)))
                    .addComponent(jLabel11))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField11, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButton2.setText("OK");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel11, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton2))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(jPanel11, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton2))
                    .addComponent(jPanel10, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(36, Short.MAX_VALUE))
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jScrollPane2.setViewportView(jPanel9);

        jPanel16.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 0, 11), new java.awt.Color(255, 0, 51)));
        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Calibration"));
        jPanel12.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jLabel10.setText("Maximal Force:");

        jLabel7.setText("F1:");

        jLabel8.setText("F2:");

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N", "kN" }));
        jComboBox1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox1ItemStateChanged(evt);
            }
        });

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N", "kN" }));
        jComboBox2.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox2ItemStateChanged(evt);
            }
        });

        jTextField13.setEditable(false);
        jTextField13.setEnabled(false);
        jTextField13.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField13ActionPerformed(evt);
            }
        });

        jTextField14.setEditable(false);
        jTextField14.setEnabled(false);

        jLabel36.setText("s:");

        jTextField39.setEditable(false);
        jTextField39.setEnabled(false);

        jComboBox16.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm" }));
        jComboBox16.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox16ItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout jPanel12Layout = new javax.swing.GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jLabel36, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jLabel8, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addComponent(jLabel7))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextField13, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                            .addComponent(jTextField14, javax.swing.GroupLayout.DEFAULT_SIZE, 52, Short.MAX_VALUE)
                            .addComponent(jTextField39, javax.swing.GroupLayout.DEFAULT_SIZE, 52, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jComboBox1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox2, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox16, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addComponent(jLabel10))
                .addContainerGap())
        );
        jPanel12Layout.setVerticalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField13, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(jTextField14, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel36)
                    .addComponent(jTextField39, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox16, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(84, Short.MAX_VALUE))
        );

        jPanel13.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jLabel15.setText("Igz:");

        jTextField8.setEditable(false);

        jComboBox3.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm^4", "m^4" }));
        jComboBox3.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox3ItemStateChanged(evt);
            }
        });

        jTextField44.setEditable(false);

        jComboBox17.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox17.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox17ItemStateChanged(evt);
            }
        });

        jTextField9.setEditable(false);

        jComboBox4.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N/mm^2", "N/m^2" }));
        jComboBox4.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox4ItemStateChanged(evt);
            }
        });

        jLabel16.setText("E:");

        jTextField15.setEditable(false);

        jComboBox5.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox5.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox5ItemStateChanged(evt);
            }
        });

        jLabel17.setText("L:");

        jTextField42.setEditable(false);

        jLabel41.setText("L3:");

        jLabel38.setText("t:");

        jTextField28.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField28ActionPerformed(evt);
            }
        });

        jLabel42.setText("t1:");

        jSeparator2.setOrientation(javax.swing.SwingConstants.VERTICAL);

        jButton4.setText("Calculate");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jTextField35.setEditable(false);

        jTextField36.setEditable(false);

        jLabel18.setText("Deflexion:");

        jLabel32.setText("Shear Force:");

        jComboBox7.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox7.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox7ItemStateChanged(evt);
            }
        });

        jTextField34.setEditable(false);

        jTextField20.setEditable(false);

        jTextField19.setEditable(false);

        jLabel31.setText("Stress:");

        jComboBox14.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N", "kN" }));
        jComboBox14.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox14ItemStateChanged(evt);
            }
        });

        jLabel19.setText("Strain:");

        jComboBox6.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox6.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox6ItemStateChanged(evt);
            }
        });

        jLabel33.setText("Bending Moment:");

        jTextField37.setEditable(false);
        jTextField37.setText("MPa");

        jComboBox15.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N.mm", "N.m" }));
        jComboBox15.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox15ItemStateChanged(evt);
            }
        });

        jLabel26.setText("NF:");

        jComboBox18.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox18.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox18ItemStateChanged(evt);
            }
        });

        jComboBox19.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox19.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox19ItemStateChanged(evt);
            }
        });

        jComboBox20.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox20.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox20ItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout jPanel13Layout = new javax.swing.GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel15)
                    .addComponent(jLabel16)
                    .addComponent(jLabel17)
                    .addComponent(jLabel41)
                    .addComponent(jLabel38)
                    .addComponent(jLabel42)
                    .addComponent(jLabel26))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jTextField28, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField42, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField29, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField15, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField9, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField44, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField8, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 54, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jComboBox18, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox5, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox3, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox17, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox4, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox20, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox19, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel13Layout.createSequentialGroup()
                        .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel32)
                            .addComponent(jLabel18)
                            .addComponent(jLabel19)
                            .addComponent(jLabel33)
                            .addComponent(jLabel31))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jTextField36)
                            .addComponent(jTextField20)
                            .addComponent(jTextField35)
                            .addComponent(jTextField34)
                            .addComponent(jTextField19, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jComboBox6, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox14, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox15, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox7, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jTextField37)))
                    .addGroup(jPanel13Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jTextField25, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel13Layout.createSequentialGroup()
                                .addComponent(jTextField18, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextField23, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextField24, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel13Layout.createSequentialGroup()
                                .addComponent(jTextField26, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextField27, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap(27, Short.MAX_VALUE))
        );
        jPanel13Layout.setVerticalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel15, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTextField8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField44, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox17, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel26))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel16))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel17))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField29, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel41)
                    .addComponent(jComboBox18, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField42, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel38)
                    .addComponent(jComboBox19, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField28, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel42)
                    .addComponent(jComboBox20, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
            .addComponent(jSeparator2, javax.swing.GroupLayout.DEFAULT_SIZE, 176, Short.MAX_VALUE)
            .addComponent(jButton4, javax.swing.GroupLayout.DEFAULT_SIZE, 176, Short.MAX_VALUE)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel18)
                    .addComponent(jTextField19, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel32)
                    .addComponent(jTextField34, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox14, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel33)
                    .addComponent(jTextField35, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel19)
                    .addComponent(jTextField20, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel31)
                    .addComponent(jTextField36, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField18, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField23, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField24, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField25, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField26, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField27, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel13, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel13, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel12, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Measurement"));
        jPanel14.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jLabel20.setText("Mesurement:");

        jLabel21.setText("Strain:");

        jRadioButton1.setText("Top");
        jRadioButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jRadioButton2.setText("Buttom");
        jRadioButton2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton2.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabel35.setText("Sensor Position:");

        jComboBox8.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));

        jTextField45.setEditable(false);

        jTextField46.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField46ActionPerformed(evt);
            }
        });

        jLabel39.setText("t:");

        jLabel40.setText("Stress Location:");

        jLabel25.setText("t1:");

        jComboBox21.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox21.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox21ItemStateChanged(evt);
            }
        });

        jComboBox22.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));

        jComboBox25.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox25.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox25ItemStateChanged(evt);
            }
        });

        jLabel43.setText("L3:");

        jLabel27.setText("L:");

        jTextField47.setEditable(false);
        jTextField47.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField47ActionPerformed(evt);
            }
        });

        jTextField48.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField48ActionPerformed(evt);
            }
        });

        jComboBox24.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));
        jComboBox24.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox24ItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout jPanel14Layout = new javax.swing.GroupLayout(jPanel14);
        jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel20)
            .addGroup(jPanel14Layout.createSequentialGroup()
                .addComponent(jRadioButton1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton2))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel14Layout.createSequentialGroup()
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel14Layout.createSequentialGroup()
                        .addComponent(jLabel35)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                    .addGroup(jPanel14Layout.createSequentialGroup()
                        .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel21)
                            .addComponent(jLabel43)
                            .addComponent(jLabel27)
                            .addComponent(jLabel39)
                            .addComponent(jLabel25))
                        .addGap(5, 5, 5)
                        .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextField21, javax.swing.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE)
                            .addComponent(jTextField47, javax.swing.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE)
                            .addComponent(jTextField48, javax.swing.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE)
                            .addComponent(jTextField46, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE)
                            .addComponent(jTextField45, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE))
                        .addGap(6, 6, 6))
                    .addGroup(jPanel14Layout.createSequentialGroup()
                        .addComponent(jLabel40)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jComboBox24, javax.swing.GroupLayout.Alignment.TRAILING, 0, 42, Short.MAX_VALUE)
                        .addComponent(jComboBox8, javax.swing.GroupLayout.Alignment.TRAILING, 0, 42, Short.MAX_VALUE)
                        .addComponent(jComboBox25, javax.swing.GroupLayout.Alignment.TRAILING, 0, 42, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(jComboBox21, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jComboBox22, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        );
        jPanel14Layout.setVerticalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel14Layout.createSequentialGroup()
                .addComponent(jLabel20)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel21)
                    .addComponent(jComboBox8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField21, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel40)
                .addGap(7, 7, 7)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel27)
                    .addComponent(jComboBox24, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField47, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel43)
                    .addComponent(jComboBox25, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField48, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel39)
                    .addComponent(jComboBox21, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField45, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel25)
                    .addComponent(jComboBox22, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField46, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel35)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE)
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButton1)
                    .addComponent(jRadioButton2)))
        );

        jPanel15.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jComboBox9.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "mm", "m" }));

        jTextField22.setEditable(false);

        jLabel22.setText("Deflexion:");

        jTextField16.setEditable(false);

        jLabel23.setText("F1:");

        jComboBox10.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N", "kN" }));
        jComboBox10.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox10ItemStateChanged(evt);
            }
        });

        jComboBox11.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "N", "kN" }));
        jComboBox11.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox11ItemStateChanged(evt);
            }
        });

        jTextField17.setEditable(false);

        jLabel24.setText("F2:");

        jTextField40.setEditable(false);

        jTextField41.setEditable(false);
        jTextField41.setText("MPa");

        jLabel37.setText("Stress:");

        jButton5.setText("Calculate");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel15Layout = new javax.swing.GroupLayout(jPanel15);
        jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel15Layout.createSequentialGroup()
                .addComponent(jButton5, javax.swing.GroupLayout.PREFERRED_SIZE, 88, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel22)
                    .addComponent(jLabel37)
                    .addComponent(jLabel23)
                    .addComponent(jLabel24))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTextField17, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
                    .addComponent(jTextField22, javax.swing.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
                    .addComponent(jTextField16, javax.swing.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE)
                    .addComponent(jTextField40, javax.swing.GroupLayout.DEFAULT_SIZE, 74, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jComboBox11, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox9, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTextField41, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jComboBox10, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        jPanel15Layout.setVerticalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel15Layout.createSequentialGroup()
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField41, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel37)
                    .addComponent(jTextField40, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel22)
                    .addComponent(jTextField22, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel23)
                    .addComponent(jTextField16, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox11, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel24)
                    .addComponent(jTextField17, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(109, Short.MAX_VALUE))
            .addComponent(jButton5, javax.swing.GroupLayout.DEFAULT_SIZE, 207, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel14, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel14, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel15, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jLabel34.setIcon(new javax.swing.ImageIcon(getClass().getResource("/stres.JPG")));

        jButton9.setText("Storage");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton9ActionPerformed(evt);
            }
        });

        jTextField38.setEditable(false);
        jTextField38.setFont(new java.awt.Font("Tahoma", 0, 14));
        jTextField38.setText(date);

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/kistler.jpg")));
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel1MouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jLabel1MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jLabel1MouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel16Layout = new javax.swing.GroupLayout(jPanel16);
        jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(
            jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel16Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel16Layout.createSequentialGroup()
                        .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel1)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addGroup(jPanel16Layout.createSequentialGroup()
                                    .addComponent(jTextField38)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(jButton9, javax.swing.GroupLayout.PREFERRED_SIZE, 97, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addComponent(jLabel34, javax.swing.GroupLayout.Alignment.LEADING)))))
                .addContainerGap())
        );
        jPanel16Layout.setVerticalGroup(
            jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel16Layout.createSequentialGroup()
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel16Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel16Layout.createSequentialGroup()
                        .addGap(14, 14, 14)
                        .addComponent(jLabel34)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel16Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButton9, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextField38, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel1)))
                .addContainerGap())
        );
        jScrollPane3.setViewportView(jPanel16);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 515, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 812, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 578, Short.MAX_VALUE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 578, Short.MAX_VALUE))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBox6ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox6ItemStateChanged
        switch(jComboBox6.getSelectedIndex()) {
            case 0:
                jTextField19.setText(Double.toString(round(f,3)));
                break;
            case 1:
                jTextField19.setText(Double.toString(round(f/1000,3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox6ItemStateChanged

    private void jLabel1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseExited
setCursor(Cursor.getDefaultCursor());// TODO add your handling code here:
    }//GEN-LAST:event_jLabel1MouseExited

    private void jLabel1MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseEntered
setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR) );// TODO add your handling code here:
    }//GEN-LAST:event_jLabel1MouseEntered

    private void jLabel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseClicked
BrowserControl.displayURL("http://www.kistler.com");
    }//GEN-LAST:event_jLabel1MouseClicked

    private void jComboBox25ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox25ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox25ItemStateChanged

    private void jTextField48ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField48ActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_jTextField48ActionPerformed

    private void jTextField47ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField47ActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_jTextField47ActionPerformed

    private void jComboBox24ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox24ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox24ItemStateChanged

    private void jComboBox21ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox21ItemStateChanged
switch(jComboBox21.getSelectedIndex()) {
            case 0:
        jTextField45.setText(Double.toString(round(t, 3)));
                break;
            case 1:
        jTextField45.setText(Double.toString(round(t/1000, 3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox21ItemStateChanged

    private void jComboBox17ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox17ItemStateChanged
switch(jComboBox17.getSelectedIndex()) {
            case 0:
        jTextField44.setText(Double.toString(round(fn, 3)));
                break;
            case 1:
        jTextField44.setText(Double.toString(round(fn/1000, 3)));
                break;
        } // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox17ItemStateChanged

    private void jComboBox20ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox20ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox20ItemStateChanged

    private void jComboBox19ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox19ItemStateChanged
switch(jComboBox19.getSelectedIndex()) {
            case 0:
        jTextField42.setText(Double.toString(round(t, 3)));
                break;
            case 1:
        jTextField42.setText(Double.toString(round(t/1000, 3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox19ItemStateChanged

    private void jComboBox18ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox18ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox18ItemStateChanged

    private void jComboBox7ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox7ItemStateChanged
        switch(jComboBox7.getSelectedIndex()) {
            case 0:
                jTextField20.setText(Double.toString(round(strain,3)));
                break;
            case 1:
                jTextField20.setText(Double.toString(round(strain/1000,3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox7ItemStateChanged

private void jTextField13ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField13ActionPerformed
    // TODO add your handling code here:
}//GEN-LAST:event_jTextField13ActionPerformed

    private void jComboBox5ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox5ItemStateChanged
        switch(jComboBox5.getSelectedIndex()) {
            case 0:
                jTextField15.setText(Double.toString(round(L,3)));
                break;
            case 1:
                jTextField15.setText(Double.toString(round(L/1000,3)));
                break;
        }
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox5ItemStateChanged

    private void jComboBox1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox1ItemStateChanged
        
    }//GEN-LAST:event_jComboBox1ItemStateChanged

    private void jComboBox2ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox2ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox2ItemStateChanged

    private void jComboBox16ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox16ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox16ItemStateChanged

    private void jComboBox3ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox3ItemStateChanged
        switch(jComboBox3.getSelectedIndex()) {
            case 0:
                jTextField8.setText(Double.toString(round(igz,3)));
                break;
            case 1:
                jTextField8.setText(Double.toString(round(igz/(1E12),3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox3ItemStateChanged

    private void jComboBox4ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox4ItemStateChanged
        switch(jComboBox4.getSelectedIndex()) {
            case 0:
                jTextField9.setText(Double.toString(round(E,3)));
                break;
            case 1:
                jTextField9.setText(Double.toString(round(E*1000000,3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox4ItemStateChanged

    private void jComboBox14ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox14ItemStateChanged
        switch(jComboBox14.getSelectedIndex()) {
            case 0:
                jTextField34.setText(Double.toString(round(sf,3)));
                break;
            case 1:
                jTextField34.setText(Double.toString(round(sf/1000,3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox14ItemStateChanged

    private void jComboBox15ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox15ItemStateChanged
        switch(jComboBox15.getSelectedIndex()) {
            case 0:
                jTextField35.setText(Double.toString(round(bm,3)));
                break;
            case 1:
                jTextField35.setText(Double.toString(round(bm/1000,3)));
                break;
        }// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox15ItemStateChanged

    private void jTextField28ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField28ActionPerformed
        
    }//GEN-LAST:event_jTextField28ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        if(jTextField13.isEnabled()){
            try {
                Double.parseDouble(jTextField13.getText());
            } catch(NumberFormatException e) {
                JOptionPane.showMessageDialog(null,"Invalid Entries");
                return;
            }
            switch(jComboBox1.getSelectedIndex()) {
                case 0:
                    F1=Double.parseDouble(jTextField13.getText());
                    break;
                case 1:
                    F1=Double.parseDouble(jTextField13.getText())*1000;
                    break;
            }
        }
        if(jTextField14.isEnabled()){
            try {
                Double.parseDouble(jTextField14.getText());
            } catch(NumberFormatException e) {
                JOptionPane.showMessageDialog(null,"Invalid Entries");
                return;
            }
            switch(jComboBox2.getSelectedIndex()) {
                case 0:
                    F2=Double.parseDouble(jTextField14.getText());
                    break;
                case 1:
                    F2=Double.parseDouble(jTextField14.getText())*1000;
                    break;
            }
        }
        if(jTextField39.isEnabled()){
            try {
                Double.parseDouble(jTextField39.getText());
            } catch(NumberFormatException e) {
                JOptionPane.showMessageDialog(null,"Invalid Entries");
                return;
            }
            switch(jComboBox16.getSelectedIndex()) {
                case 0:
                    s=Double.parseDouble(jTextField39.getText());
                    break;
                case 1:
                    s=Double.parseDouble(jTextField39.getText())*1000;
                    break;
            }
        }
            
            try {
                Double.parseDouble(jTextField29.getText());
            } catch(NumberFormatException e) {
                JOptionPane.showMessageDialog(null,"Invalid Entries");
                return;
            }
            switch(jComboBox18.getSelectedIndex()) {
                case 0:
                    L3=Double.parseDouble(jTextField29.getText());
                    break;
                case 1:
                    L3=Double.parseDouble(jTextField29.getText())*1000;
                    break;
            }
            
            if(u==1){
                if(L3<=L1){
                    sf=F1;
                    bm=F1*(L3-L1);
                } else{
                    sf=0;
                    bm=0;
                }
                f=-F1*Math.pow(L1,2)*(3*L-L1)/(6*E*igz);
                strain=Math.sqrt(Math.abs((fn-t1)*f));
        jTextField1.setText(Double.toString(t1));
        jTextField18.setText(Double.toString(fn));
        jTextField23.setText(Double.toString(fn-t1));
        jTextField24.setText(Double.toString((fn-t1)*f));
        jTextField25.setText(Double.toString(Math.abs((fn-t1)*f)));  
        jTextField26.setText(Double.toString(Math.sqrt(Math.abs((fn-t1)*f)))); 
        jTextField27.setText(Double.toString(strain));  
            }else
            if(u==2){
                if(L3<=L1){
                    sf=(F1/s)*(L-L1-L2);
                    bm=(F1/s)*(L-L1-L2)*(L3-L1)-(F1/s)*Math.pow((L-L1-L2),2)/2;
                }else if(L1<L3 & L3<=(L-L2)){
                    sf=-(F1/s)*(L3-L1)+(F1/s)*(L-L1-L2);
                    bm=-(F1/s)*Math.pow((L-L3-L2),2)/2;
                }else{
                    sf=0;
                    bm=0;
                }
                f=-F1*Math.pow(L1,2)*(3*L-L1)/(6*E*igz)-F1*Math.pow((L-L2),2)*(2*L+L2)/(6*E*igz)-(F1/s)*Math.pow((L-L1-L2),4)/(8*E*igz);
                strain=Math.sqrt(Math.abs((fn-t1)*f));
            }else
            if(u==3){
                if(L3<=L1){
                    sf=-F1*(L-L1)/L;
                    bm=F1*(L-L1)*L3/L;
                }else if(L3<=L){
                    sf=F1*(L1)/L;
                    bm=F1*(L-L3)*L1/L;
                }
                f=-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(3*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/2));
             }else
             if(u==4){
                if(L3<=L1){
                    sf=-F1*(L-L1)/L;
                    bm=F1*(L-L1)*L3/L;
                }else if(L1<L3 & L3<=(L-L2)){
                    sf=F2*(L-L2)/L-F1*(L-L1)/L;
                    bm=(F2*(L-L2)*L2/L-F1*(L-L1)*L1/L)*(L3-L1)/(L-L1-L2)+F1*(L-L1)*L1/L;
                }else if(L3<=L){
                    sf=F2*(L-L2)/L;
                    bm=F2*(L-L3)*(L-L2)/L;
                }
                f=-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(3*E*igz*L)-F2*Math.pow(L2,2)*Math.pow((L-L2),2)/(3*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/2));
             }else
             if(u==5){
                if(L3<=L1){
                    sf=-(F1/s)*(L-L1-L2)*(L-L1+L2)/(2*L);
                    bm=(F1/s)*(L-L1-L2)*(L-L1+L2)*L3/(2*L);
                }else if(L1<L3 & L3<=(L-L2)){
                    sf=(F1/s)*(L3-L1)-(F1/s)*(L-L1-L2)*(L-L1+L2)/(2*L);
                    bm=(F1/s)*(L3-L1)*(L-L2-L3)/2+(F1/s)*(L-L1-L2)*(L-L1+L2)*L1/(2*L);
                }else if(L3<=L){
                    sf=(F1/s)*(L-L1-L2)*(L+L1-L2)/(2*L);
                    bm=-(F1/s)*(L-L1-L2)*(L+L1-L2)*(L3-(L+L1-L2)/2)/(2*L)+(F1/s)*(L-L1-L2)*(L+L1-L2)*(L-L1+L2)/(4*L);
                }
                f=-5*(F1/s)*Math.pow((L-L1-L2),4)/(384*E*igz)-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(3*E*igz*L)-F1*Math.pow(L2,2)*Math.pow((L-L2),2)/(3*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/2));
            }else
            if(u==6){
                if(L3<=(L-L1)){
                    sf=F1*(L1)/L;
                    bm=(-F1*L1/L)*L3;
                }else if(L3<=L){
                    sf=-F1;
                    bm=F1*(L3-L)-F1*L1;
                }
                f=-F1*Math.pow(L1,2)*(L1+L)/(3*E*igz);                
                strain=Math.sqrt(Math.abs((fn-t1)*(Math.abs(f)+(F1*L1*Math.pow(L,2)*Math.sqrt(3)/27*E*igz))));
           }else
           if(u==7){
                if(L3<=L1){
                    sf=-F1*(L-L1)/L;
                    bm=F1*(L-L1)*L3/L-F1*(L-L1)*L1/(2*L);
                }else if(L3<=L){
                    sf=F1*(L1)/L;
                    bm=F1*(L-L3)*L1/L+F1*(L-L1)*L1/(2*L);
                }
                f=-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(12*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/4));
           }else
           if(u==8){
                if(L3<=L1){
                    sf=-F1*(L-L1)/L;
                    bm=F1*(L-L1)*L3/L-F1*(L-L1)*L1/(2*L);
                }else if(L1<L3 & L3<=(L-L2)){
                    sf=F2*(L-L2)/L-F1*(L-L1)/L;
                    bm=(F2*(L2)*(L-L2)/(2*L)-F1*(L-L1)*L1/(2*L))*(L3-L1)/(L-L1-L2)+F1*(L-L1)*L1/(2*L);
                }else if(L3<=L){
                    sf=F2*(L-L2)/L;
                    bm=F2*(L-L3)*(L-L2)/L+F2*(L2)*(L-L2)/(2*L);
                }
                f=-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(12*E*igz*L)-F2*Math.pow(L2,2)*Math.pow((L-L2),2)/(12*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/4));
           }else
           if(u==9){
                if(L3<=L1){
                    sf=-(F1/s)*(L-L1-L2)*(L-L1+L2)/(2*L);
                    bm=(F1/s)*(L-L1-L2)*(L-L1+L2)*L3/(2*L)-(F1/s)*(L-L1-L2)*(L-L1+L2)*(L+L1-L2)/(4*L);
                }else if(L1<L3 & L3<=(L-L2)){
                    sf=(F1/s)*(L3-L1)-(F1/s)*(L-L1-L2)*(L-L1+L2)/(2*L);
                    bm=(F1/s)*(L3-L1)*(L-L2-L3)/2+(F1/s)*(L-L1-L2)*(L-L1+L2)*L1/(2*L)+(F1/s)*(L-L1-L2)*(L-L1+L2)*(L+L1-L2)/(4*L);
                }else if(L3<=L){
                    sf=(F1/s)*(L-L1-L2)*(L+L1-L2)/(2*L);
                    bm=-(F1/s)*(L-L1-L2)*(L+L1-L2)*(L3-(L+L1-L2)/2)/(2*L)+(F1/s)*(L-L1-L2)*(L+L1-L2)*(L-L1+L2)/(8*L);
                }
                f=-(F1/s)*Math.pow((L-L1-L2),4)/(384*E*igz)-F1*Math.pow(L1,2)*Math.pow((L-L1),2)/(12*E*igz*L)-F1*Math.pow(L2,2)*Math.pow((L-L2),2)/(12*E*igz*L);
                strain=Math.sqrt(Math.abs((fn-t1)*f/4));
                                            }
        switch(jComboBox14.getSelectedIndex()) {
            case 0:
                jTextField34.setText(Double.toString(round(sf,3)));
                break;
            case 1:
                jTextField34.setText(Double.toString(round(sf/1000,3)));
                break;
        }
        
        switch(jComboBox15.getSelectedIndex()) {
            case 0:
                jTextField35.setText(Double.toString(round(bm,3)));
                break;
            case 1:
                jTextField35.setText(Double.toString(round(bm/1000,3)));
                break;
        }
        try {
            Double.parseDouble(jTextField28.getText());
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
            return;
        }
        switch(jComboBox20.getSelectedIndex()) {
                case 0:
                    t1=Double.parseDouble(jTextField28.getText());
                    break;
                case 1:
                    t1=Double.parseDouble(jTextField28.getText())*1000;
                    break;
        }
        stres=-bm*(fn-t1)/igz;
        
        jTextField36.setText(Double.toString(round(stres,3)));
        
        switch(jComboBox7.getSelectedIndex()) {
            case 0:
                jTextField20.setText(Double.toString(round(strain,3)));
                break;
            case 1:
                jTextField20.setText(Double.toString(round(strain/1000,3)));
                break;
        }
        switch(jComboBox6.getSelectedIndex()) {
            case 0:
                jTextField19.setText(Double.toString(round(f,3)));
                break;
            case 1:
                jTextField19.setText(Double.toString(round(f/1000,3)));
                break;
        }
        
           
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jTextField46ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField46ActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_jTextField46ActionPerformed

    private void jComboBox10ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox10ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox10ItemStateChanged

    private void jComboBox11ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox11ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox11ItemStateChanged

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        try {
            Double.parseDouble(jTextField21.getText());
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
            return;
        }
        switch(jComboBox8.getSelectedIndex()) {
            case 0:
                strain2=Double.parseDouble(jTextField21.getText());
                break;
            case 1:
                strain2=Double.parseDouble(jTextField21.getText())*1000;
                break;
        }
        
        try {
            Double.parseDouble(jTextField48.getText());
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
            return;
        }
        switch(jComboBox25.getSelectedIndex()) {
                case 0:
                    L4=Double.parseDouble(jTextField48.getText());
                    break;
                case 1:
                    L4=Double.parseDouble(jTextField48.getText())*1000;
                    break;
        }
        
        try {
            Double.parseDouble(jTextField46.getText());
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
            return;
        }
        switch(jComboBox22.getSelectedIndex()) {
                case 0:
                    t2=Double.parseDouble(jTextField46.getText());
                    break;
                case 1:
                    t2=Double.parseDouble(jTextField46.getText())*1000;
                    break;
        }
        
        bm2=sigma/igz;
        if(u==1){
            
        }else
        if(u==2){
            
        }else
        if(u==3){
            
        }else
        if(u==4){
            
        }else
        if(u==5){
            
        }else
        if(u==6){
            
        }else            
        if(u==7){
            
        }else
        if(u==8){
            
        }else        
        if(u==9){
            
        }
        
    //    sigmas=;
        isSelected1 = jRadioButton1.isSelected();
        isSelected2 = jRadioButton2.isSelected();
        
        if(isSelected1){
            if(t2<fn){
                sigma=sigmas*((fn-t2)/fn);// TODO add your handling code here:
            }else if(t2<t){
                sigma=sigmas*((t2-fn)/fn);
            }
        }
        if(isSelected2){
            if(t2<fn){
                sigma=sigmas*(((t-fn)-t2)/(t-fn));// TODO add your handling code here:
            }else if(t2<t){
                sigma=sigmas*((t2-(t-fn))/(t-fn));
            }
        }
        jTextField40.setText(Double.toString(sigma));
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton9ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton9ActionPerformed
        report="";
        if(isSelected1) pos="TOP";
        if(isSelected2) pos="BUTTOM";
        try{
            InputStream ips=new FileInputStream("report.kys");
            InputStreamReader ipsr=new InputStreamReader(ips);
            BufferedReader br=new BufferedReader(ipsr);
            while ((line=br.readLine())!=null){
                report+=line+"\n";
            }
            br.close();
        } catch (Exception e){
            JOptionPane.showMessageDialog(null,"impossible to read");
        }
        report+=jTextField38.getText()+"    "+igz+"mm4"+"    "+E+"MPa"+"    "+L+"mm"+"    "+L1+"mm"+"    "+L2+"mm"+"    "+L3+"mm"+"    "+L4+"mm"+"    "+t+"mm"+"    "+t1+"mm"+"    "+F1+"N"+"    "+F2+"N"+"    "+s+"mm"+"    "+sf+"N"+"    "+bm+"N.mm"+"    "+def+"mm"+"    "+strain+"mm"+"    "+pos+"    "+sigma+"MPa"+"\n";
        try {
            FileWriter fw = new FileWriter("report.kys");
            fw.write(report);
            fw.flush();
            fw.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_jButton9ActionPerformed

    private void jComboBox12ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox12ItemStateChanged
// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox12ItemStateChanged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
if(jTextField5.isEnabled()){
        try {
           Double.parseDouble(jTextField5.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          return;
        }
        switch(jComboBox12.getSelectedIndex()) {
            case 0:
        L2=Double.parseDouble(jTextField5.getText());
                break;
            case 1:
        L2=Double.parseDouble(jTextField5.getText())*1000;
                break;
        } 
}
if(jTextField6.isEnabled()){
        try {
           Double.parseDouble(jTextField6.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          return;
        }
        switch(jComboBox12.getSelectedIndex()) {
            case 0:
        L1=Double.parseDouble(jTextField6.getText());
                break;
            case 1:
        L1=Double.parseDouble(jTextField6.getText())*1000;
                break;
        }  
}
if(jTextField7.isEnabled()){
        try {
           Double.parseDouble(jTextField7.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          return;
        }
        switch(jComboBox12.getSelectedIndex()) {
            case 0:
        L=Double.parseDouble(jTextField7.getText());
                break;
            case 1:
        L=Double.parseDouble(jTextField7.getText())*1000;
                break;
        }  
}
switch(jComboBox5.getSelectedIndex()) {
            case 0:
        jTextField15.setText(Double.toString(L));
                break;
            case 1:
        jTextField15.setText(Double.toString(L/1000));
                break;
        } 
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        if( selectedNode!=null ) {
            E = selectedNode.elasticModulus/1000000;// TODO add your handling code here:
        }
        else{
            JOptionPane.showMessageDialog(null,"No material selected"); 
        }
        
        switch(jComboBox4.getSelectedIndex()) {
            case 0:
                jTextField9.setText(Double.toString(E));
                break;
            case 1:
                jTextField9.setText(Double.toString(E*1000000));
                break;
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jTree1ValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTree1ValueChanged
        Object src = evt.getPath().getLastPathComponent();
        if(src instanceof MaterialNode) {
          selectedNode = (MaterialNode)src;
          // Updade textfields
          jTextField2.setText(Double.toString(selectedNode.elasticModulus));
          jTextField3.setText(Double.toString(selectedNode.yieldStrength));
          jTextField4.setText(Double.toString(selectedNode.tensileStrength));
        }// TODO add your handling code here:
    }//GEN-LAST:event_jTree1ValueChanged

    private void initializeTree() {
                        
        // Read the XML files        
        DocumentBuilderFactory dbf;
        DocumentBuilder db;
        Document doc;
        File file;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            doc = db.parse("MAT.xml");
        } catch (java.io.IOException e1) {
            JOptionPane.showMessageDialog(null,"Failed to read XML file:\n"+e1.getMessage());
            return;
        } catch (SAXException e2) {
            JOptionPane.showMessageDialog(null,"Failed to parse XML file:\n"+e2.getMessage());            
            return;
        } catch (ParserConfigurationException e3) {
            JOptionPane.showMessageDialog(null,"Parser configuration exception:\n"+e3.getMessage());            
            return;
        }  
        
        doc.getDocumentElement().normalize();        
        NodeList rows = doc.getElementsByTagName("Row");
        // Start at row 2 (1st row is column names,2nd row is empty) 
        root = new FamilyNode("Root");
        for(int i=2;i<rows.getLength();i++)
          addToTree(getRow(rows.item(i)));              
        
        // Initialise the tree model
        matTreeModel = new DefaultTreeModel(root);
        jTree1.setModel(matTreeModel);
        jTree1.setRootVisible(false);
        jTree1.setShowsRootHandles(true);
                
    }    

    // Add the specified row to the tree
    private void addToTree(Vector rowItems) {
        
        String family = (String)rowItems.get(0);
        
        // Search if family already exists
        boolean found = false;
        int i=0;
        while(i<root.getChildCount() && !found) {
          found = ( root.getChildAt(i).toString().equalsIgnoreCase(family) ); 
          if(!found) i++;
        }
        
        if(found) {
            
          // Add the material to the family
          FamilyNode curNode = (FamilyNode)root.getChildAt(i);
          MaterialNode newMatNode = new MaterialNode(rowItems);
          
          // Check that the material is not duplicated
          boolean found2 = false;
          int j=0;
          while(j<curNode.getChildCount() && !found2) {
            MaterialNode n = (MaterialNode)curNode.getChildAt(j);
            found2 = n.equals(newMatNode); 
            if(!found2) j++;
          }
          if(!found2) curNode.add(newMatNode);
          
        } else {
            
          // Create the new family
          FamilyNode newNode = new FamilyNode(family);
          newNode.add(new MaterialNode(rowItems));
          root.add( newNode );     
          
        }
        
    }
    
    // Parse a Row and return a vector containing cells.
    private Vector getRow(Node n) {
        
        Vector values = new Vector();
        int curIdx = 1;
        
        NodeList children1 = n.getChildNodes();
        int length1 = children1.getLength();
        for(int i=0;i<length1;i++) {
           Node child1 = children1.item(i);
           if(child1.getNodeName()=="Cell") {
               
             Node indexChild = child1.getAttributes().getNamedItem("ss:Index");
             if( indexChild!=null ) {
               try {
                 int newIdx = Integer.parseInt(indexChild.getNodeValue());  
                 // Shift cells
                 for(int k=0;k<newIdx-curIdx;k++)
                    values.add("");
                 curIdx = newIdx;                 
               } catch( NumberFormatException e) {
                 System.out.println("Warning, incorrect index attribute.");
               }
             }
             NodeList children2 = child1.getChildNodes();
             int length2 = children2.getLength();
             for(int j=0;j<length2;j++) {
               Node child2 = children2.item(j);
               if(child2.getNodeName()=="Data") {
                 values.add(child2.getFirstChild().getNodeValue());
                 curIdx++;
               }
             }
                
           }
        }
        
        // Last columns
        for(int k=curIdx;k<=9;k++)
          values.add("");
        
        return values;
    }    
    
    public void jScrollBar1AdjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {//GEN-FIRST:event_jScrollBar1AdjustmentValueChanged
        v=jScrollBar1.getValue()/10;
        if(v==0) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/umpty.JPG")));
            textField1.setEnabled(false);
            textField1.setEditable(false);
            textField2.setEnabled(false);
            textField2.setEditable(false);
            textField3.setEnabled(false);
            textField3.setEditable(false);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==1) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/rectangular1.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(false);
            textField2.setEditable(false);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==2) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/rectangular2.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==3) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/cercle1.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(false);
            textField2.setEditable(false);
            textField3.setEnabled(false);
            textField3.setEditable(false);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==4) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/cercle2.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(false);
            textField3.setEditable(false);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==5) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/L.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(true);
            textField5.setEditable(true);
        } else if(v==6) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/U.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(false);
            textField4.setEditable(false);
            textField5.setEnabled(true);
            textField5.setEditable(true);
        } else if(v==7) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/T.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(true);
            textField4.setEditable(true);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==8) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/H.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(true);
            textField4.setEditable(true);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        } else if(v==9) {
            jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/profiles/omega.JPG")));
            textField1.setEnabled(true);
            textField1.setEditable(true);
            textField2.setEnabled(true);
            textField2.setEditable(true);
            textField3.setEnabled(true);
            textField3.setEditable(true);
            textField4.setEnabled(true);
            textField4.setEditable(true);
            textField5.setEnabled(false);
            textField5.setEditable(false);
        }
// TODO add your handling code here:
    }//GEN-LAST:event_jScrollBar1AdjustmentValueChanged

    private void jScrollBar2AdjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {//GEN-FIRST:event_jScrollBar2AdjustmentValueChanged
u=jScrollBar2.getValue()/10;
     if(u==0) {
            jTextField5.setEnabled(false);
            jTextField5.setEditable(false);
            jTextField6.setEnabled(false);
            jTextField6.setEditable(false);
            jTextField7.setEnabled(false);
            jTextField7.setEditable(false);
            jTextField13.setEnabled(false);
            jTextField13.setEditable(false);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/umpty.JPG")));
}
else if(u==1) {
            jTextField5.setEnabled(false);
            jTextField5.setEditable(false);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case1.JPG")));
    }
else if(u==2) {
            jTextField5.setEnabled(true);
            jTextField5.setEditable(true);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(true);
            jTextField39.setEditable(true);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case2.JPG")));
    }
else if(u==3) {
            jTextField5.setEnabled(false);
            jTextField5.setEditable(false);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case3.JPG")));
    }
else if(u==4) {
            jTextField5.setEnabled(true);
            jTextField5.setEditable(true);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(true);
            jTextField14.setEditable(true);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case4.JPG")));
    }
else if(u==5) {
            jTextField5.setEnabled(true);
            jTextField5.setEditable(true);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(true);
            jTextField39.setEditable(true);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case5.JPG")));
    }
else if(u==6) {
            jTextField5.setEnabled(false);
            jTextField5.setEditable(false);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case6.JPG")));
    }
else if(u==7) {
            jTextField5.setEnabled(false);
            jTextField5.setEditable(false);
            jTextField6.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case7.JPG")));
    }
else if(u==8) {
            jTextField5.setEditable(true);
            jTextField5.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(true);
            jTextField14.setEditable(true);
            jTextField39.setEnabled(false);
            jTextField39.setEditable(false);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case8.JPG")));
    }
else if(u==9) {
            jTextField5.setEditable(true);
            jTextField5.setEnabled(true);
            jTextField6.setEditable(true);
            jTextField7.setEnabled(true);
            jTextField7.setEditable(true);
            jTextField13.setEnabled(true);
            jTextField13.setEditable(true);
            jTextField14.setEnabled(false);
            jTextField14.setEditable(false);
            jTextField39.setEnabled(true);
            jTextField39.setEditable(true);
        jLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/loads/case9.JPG")));
    }// TODO add your handling code here:
    }//GEN-LAST:event_jScrollBar2AdjustmentValueChanged

    public void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
if(textField1.isEnabled()){
        try {
           Double.parseDouble(textField1.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          a1=0;  
          return;
        }
        switch(jComboBox13.getSelectedIndex()) {
            case 0:
        a1=Double.parseDouble(textField1.getText());
                break;
            case 1:
        a1=Double.parseDouble(textField1.getText())*1000;
                break;
        }
}else a1=0;
if(textField2.isEnabled()){
        try {
           Double.parseDouble(textField2.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          a2=0;  
          return;
        }
        switch(jComboBox13.getSelectedIndex()) {
            case 0:
        a2=Double.parseDouble(textField2.getText());
                break;
            case 1:
        a2=Double.parseDouble(textField2.getText())*1000;
                break;
        } 
}else a2=0;
if(textField3.isEnabled()){
        try {
           Double.parseDouble(textField3.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          a3=0;  
          return;
        }
        switch(jComboBox13.getSelectedIndex()) {
            case 0:
        a3=Double.parseDouble(textField3.getText());
                break;
            case 1:
        a3=Double.parseDouble(textField3.getText())*1000;
                break;
        }
}else a3=0;
if(textField4.isEnabled()){
        try {
           Double.parseDouble(textField4.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          a4=0;  
          return;
        }
        switch(jComboBox13.getSelectedIndex()) {
            case 0:
        a4=Double.parseDouble(textField4.getText());
                break;
            case 1:
        a4=Double.parseDouble(textField4.getText())*1000;
                break;
        } 
}else a4=0;
if(textField5.isEnabled()){
        try {
           Double.parseDouble(textField5.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          a5=0;  
          return;
        }
        switch(jComboBox13.getSelectedIndex()) {
            case 0:
        a5=Double.parseDouble(textField5.getText());
                break;
            case 1:
        a5=Double.parseDouble(textField5.getText())*1000;
                break;
        } 
}else a5=0;

     if(v==0){
    igz=0;
    fn=0;
    i0=0;
}
else if(v==1){
    igz=(a1*Math.pow(a3,3))/12;
    fn=a3/2;
    i0=a1*a3*(a1*a1+a3*a3)/12;
}
else if(v==2){
    igz=((a1*Math.pow(a3,3))/12)-(((a1-2*a2)*Math.pow(a3-2*a2,3))/12);
    fn=a3/2;
    i0=(a1*a3*(a1*a1+a3*a3)/12)-((a1-2*a2)*(a3-2*a2)*((a1-2*a2)*(a1-2*a2)+(a3-2*a2)*(a3-2*a2))/12);
}
else if(v==3){
    igz=(3.1416*Math.pow(a1,4))/64;
    fn=a1/2;
    i0=igz*2;
}
else if(v==4){
    igz=(3.1416*Math.pow(a1,4))/64-(3.1416*Math.pow(a1-2*a2,4))/64;
    fn=a1/2;
    i0=igz*2;
}
else if(v==5){
    igz=(a1*Math.pow(a3,3))/12-((a1-a5)*Math.pow(a3-a2,3))/12;
    ms1=(a1*a3)*a3/2;
    ms2=(a5*(a2-a3))*(a3+((a2-a3)/2));
    ms=ms1+ms2;
    fn=ms/((a1*a3)+(a5*(a2-a3)));
    i0=igz*2;
}
else if(v==6){
    igz=(a1*Math.pow(a3,3))/12-((a1-2*a5)*Math.pow(a3-a2,3))/12;
    ms1=(a1*a3)*a3/2;
    ms2=2*(a5*(a2-a3))*(a3+((a2-a3)/2));
    ms=ms1+ms2;
    fn=ms/((a1*a3)+2*(a5*(a2-a3)));
    i0=(a1*a3*(a1*a1+a3*a3)/12)-((a1-2*a5)*(a3-a2)*((a1-2*a5)*(a1-2*a5)+(a3-a2)*(a3-a2))/12);
}
else if(v==7){
    igz=(a1*Math.pow(a2,3))/12+(a4*Math.pow(a3-a2,3))/12;
    ms1=(a1*a3)*a3/2;
    ms2=(a4*(a2-a3))*(a3+((a2-a3)/2));
    ms=ms1+ms2;
    fn=ms/((a1*a3)+(a4*(a2-a3)));
    i0=(a1*a2*(a1*a1+a2*a2)/12)+(a4*(a3-a2)*(a4*a4+(a3-a2)*(a3-a2))/12);
}
else if(v==8){
    igz=2*(a1*Math.pow(a2,3))/12+(a4*Math.pow(a3-2*a2,3))/12;
    ms1=(a1*a3)*a3/2;
    ms2=(a4*(a2-2*a3))*(a2/2);
    ms3=(a1*a3)*(a2-a3/2);
    ms=ms1+ms2+ms3;
    fn=ms/(2*(a1*a3)+(a4*(a2-2*a3)));
    i0=2*(a1*a2*(a1*a1+a2*a2)/12)+(a4*(a3-a2)*(a4*a4+(a3-a2)*(a3-a2))/12);
}
else if(v==9){
    igz=(a1*Math.pow(a2,3))/12+2*(a2*Math.pow(a3-a2,3))/12;
    fn=0;
    ms1=((a1+2*a3-a4)*a3)*(a3/2);
    ms2=2*(a3*(a2-(2*a3)))*(a2/2);
    ms3=(a4*a3)*(a2-(a3/2));
    ms=ms1+ms2+ms3;
    fn=ms/((a4*a3)+2*(a3*(a2-(2*a3)))+((a1+2*a3-a4)*a3));
    i0=(a1*a2*(a1*a1+a2*a2)/12)+(a2*(a3-a2)*(a2*a2+(a3-a2)*(a3-a2))/12);
}
switch(jComboBox3.getSelectedIndex()) {
            case 0:
        jTextField8.setText(Double.toString(round(igz,3)));
                break;
            case 1:
        jTextField8.setText(Double.toString(round(igz/(1E12),3)));
                break;
        }
if(textField3.isEnabled()){
        try {
           Double.parseDouble(textField3.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          return;
        }
        t=a3;
}else{
        try {
           Double.parseDouble(textField1.getText()); 
        } catch(NumberFormatException e) {
            JOptionPane.showMessageDialog(null,"Invalid Entries");
          return;
        }
        t=a1;
}
switch(jComboBox19.getSelectedIndex()) {
            case 0:
        jTextField42.setText(Double.toString(round(t,3)));
                break;
            case 1:
        jTextField42.setText(Double.toString(round(t/1000,3)));
                break;
        } 
switch(jComboBox17.getSelectedIndex()) {
            case 0:
        jTextField44.setText(Double.toString(round(fn,3)));
                break;
            case 1:
        jTextField44.setText(Double.toString(round(fn/1000,3)));
                break;
        } 
switch(jComboBox21.getSelectedIndex()) {
            case 0:
        jTextField45.setText(Double.toString(round(t,3)));
                break;
            case 1:
        jTextField45.setText(Double.toString(round(t/1000,3)));
                break;
        } 
    }//GEN-LAST:event_jButton1ActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new flexion().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    public javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton9;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox10;
    private javax.swing.JComboBox jComboBox11;
    private javax.swing.JComboBox jComboBox12;
    private javax.swing.JComboBox jComboBox13;
    private javax.swing.JComboBox jComboBox14;
    private javax.swing.JComboBox jComboBox15;
    private javax.swing.JComboBox jComboBox16;
    private javax.swing.JComboBox jComboBox17;
    private javax.swing.JComboBox jComboBox18;
    private javax.swing.JComboBox jComboBox19;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JComboBox jComboBox20;
    private javax.swing.JComboBox jComboBox21;
    private javax.swing.JComboBox jComboBox22;
    private javax.swing.JComboBox jComboBox24;
    private javax.swing.JComboBox jComboBox25;
    private javax.swing.JComboBox jComboBox3;
    private javax.swing.JComboBox jComboBox4;
    private javax.swing.JComboBox jComboBox5;
    private javax.swing.JComboBox jComboBox6;
    private javax.swing.JComboBox jComboBox7;
    private javax.swing.JComboBox jComboBox8;
    private javax.swing.JComboBox jComboBox9;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    public javax.swing.JScrollBar jScrollBar1;
    private javax.swing.JScrollBar jScrollBar2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField10;
    private javax.swing.JTextField jTextField11;
    private javax.swing.JTextField jTextField12;
    private javax.swing.JTextField jTextField13;
    private javax.swing.JTextField jTextField14;
    private javax.swing.JTextField jTextField15;
    private javax.swing.JTextField jTextField16;
    private javax.swing.JTextField jTextField17;
    private javax.swing.JTextField jTextField18;
    private javax.swing.JTextField jTextField19;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField20;
    private javax.swing.JTextField jTextField21;
    private javax.swing.JTextField jTextField22;
    private javax.swing.JTextField jTextField23;
    private javax.swing.JTextField jTextField24;
    private javax.swing.JTextField jTextField25;
    private javax.swing.JTextField jTextField26;
    private javax.swing.JTextField jTextField27;
    private javax.swing.JTextField jTextField28;
    private javax.swing.JTextField jTextField29;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField34;
    private javax.swing.JTextField jTextField35;
    private javax.swing.JTextField jTextField36;
    private javax.swing.JTextField jTextField37;
    private javax.swing.JTextField jTextField38;
    private javax.swing.JTextField jTextField39;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JTextField jTextField40;
    private javax.swing.JTextField jTextField41;
    private javax.swing.JTextField jTextField42;
    private javax.swing.JTextField jTextField44;
    private javax.swing.JTextField jTextField45;
    private javax.swing.JTextField jTextField46;
    private javax.swing.JTextField jTextField47;
    private javax.swing.JTextField jTextField48;
    private javax.swing.JTextField jTextField5;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JTextField jTextField7;
    private javax.swing.JTextField jTextField8;
    private javax.swing.JTextField jTextField9;
    private javax.swing.JTree jTree1;
    private java.awt.TextField textField1;
    private java.awt.TextField textField2;
    private java.awt.TextField textField3;
    private java.awt.TextField textField4;
    private java.awt.TextField textField5;
    // End of variables declaration//GEN-END:variables
    public TreeModel matTreeModel;
    public FamilyNode root;
    public MaterialNode selectedNode = null;
}
class FamilyNode extends DefaultMutableTreeNode {

  String family;
  
  FamilyNode(String family) {      
    this.family = family;
  }  
  
  public String toString() {
     return family; 
  }  
    
}

class MaterialNode extends DefaultMutableTreeNode {

  String family;
  String name;
  double elasticModulus;
  double poissonsRatio;
  double shearModulus;
  double density;
  double tensileStrength;
  double yieldStrength;
  double compressiveStrength;

  MaterialNode(Vector values) {      
      
    family = (String)values.get(0);
    name   = (String)values.get(1);
    String elasticModulusStr = (String)values.get(2);
    String poissonsRatioStr = (String)values.get(3);
    String shearModulusStr = (String)values.get(4);
    String densityStr = (String)values.get(5);
    String tensileStrengthStr = (String)values.get(6);
    String yieldStrengthStr = (String)values.get(7);
    String compressiveStrengthStr = (String)values.get(8);
    
    try {
        
      if(elasticModulusStr=="")  elasticModulus = Double.NaN;
      else                       elasticModulus = Double.parseDouble(elasticModulusStr);

      if(poissonsRatioStr=="")  poissonsRatio = Double.NaN;
      else                      poissonsRatio = Double.parseDouble(poissonsRatioStr);

      if(shearModulusStr=="")  shearModulus = Double.NaN;
      else                     shearModulus = Double.parseDouble(shearModulusStr);

      if(densityStr=="")  density = Double.NaN;
      else                density = Double.parseDouble(densityStr);

      if(tensileStrengthStr=="")  tensileStrength = Double.NaN;
      else                        tensileStrength = Double.parseDouble(tensileStrengthStr);

      if(yieldStrengthStr=="")  yieldStrength = Double.NaN;
      else                      yieldStrength = Double.parseDouble(yieldStrengthStr);

      if(compressiveStrengthStr=="")  compressiveStrength = Double.NaN;
      else                            compressiveStrength = Double.parseDouble(compressiveStrengthStr);
      
    } catch (NumberFormatException e) {
      System.out.println("Warning, incorrect material value.\n" + e.getMessage());
    }
    
  }  
  
  public String toString() {
     return name; 
  }
  
  public boolean equals(MaterialNode m) {
      return (m.name.equals(name)) &&
             (m.family.equals(family));
  }
  
};
