// USBHIDDlg.cpp : implementation file
//

#include "stdafx.h"
#include "USBHID.h"
#include "USBHIDDlg.h"
#include "mcHID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUSBHIDDlg dialog

CUSBHIDDlg::CUSBHIDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUSBHIDDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUSBHIDDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUSBHIDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUSBHIDDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUSBHIDDlg, CDialog)
	//{{AFX_MSG_MAP(CUSBHIDDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_MESSAGE(WM_HID_EVENT, OnHIDEvent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUSBHIDDlg message handlers

BOOL CUSBHIDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUSBHIDDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUSBHIDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUSBHIDDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/*
*******************************************************************************
* Name  : OnCreate                                                            *
* Notes : Create the dialog and connect to the HID DLL                        *
*******************************************************************************
*/
int CUSBHIDDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
   if (CDialog::OnCreate(lpCreateStruct) == -1)
      return -1;
	
   // connect to the HID DLL
   CWnd *HostWnd = AfxGetMainWnd();
   if (LoadHID() == 0)
      Connect(HostWnd->m_hWnd);

   return 0;
}
/*
*******************************************************************************
* Name  : OnHIDEvent                                                          *
* Notes : Message handler for all HID events                                  *
*******************************************************************************
*/
LRESULT CUSBHIDDlg::OnHIDEvent(WPARAM wParam, LPARAM lParam)
{
   CStatic* Label = (CStatic*) GetDlgItem(IDC_STATIC); // get dialog label
   char Text[0xFF];                                    // text buffer
   UINT DevHandle;                                     // HID device handle
   HIDBufferIn BufferIn;                               // HID read buffer
       
   DevHandle = lParam;
   switch(wParam)
   {
	    // a HID device has been plugged in...
		case NOTIFY_PLUGGED:
		{
			// is it our HID device...
			if (GetVendorID(DevHandle) == VENDOR_ID && GetProductID(DevHandle) == PRODUCT_ID)
			{
				   GetProductName(DevHandle,Text,0xFF);
				   Label->SetWindowText(CString("USB Device '") + 
					                    CString(Text) + 
										CString("' is PLUGGED IN"));
			}
			return 1;
		}

		// a HID device has been removed...
		case NOTIFY_UNPLUGGED:
		{
			// is it our HID device...
			if (GetVendorID(DevHandle) == VENDOR_ID && GetProductID(DevHandle) == PRODUCT_ID)
 		       Label->SetWindowText("USB Device has been UNPLUGGED");
			return 1;
		}

		// a HID device has been pluggined in or removed - this event
		// is fired after all PLUGGED and UNPLUGGED messages have
		// been dispatched...
		case NOTIFY_CHANGED:
		{
			// we want our device to send read notification messages...
			DevHandle = GetHandle(VENDOR_ID, PRODUCT_ID);
			SetReadNotify(DevHandle, TRUE);
			return 1;
		}

		// a HID device has sent some data...
		case NOTIFY_READ:
		{
			// read the data...
			Read(DevHandle, BufferIn);

			// *** process data here ***

			// first element BufferIn[0] is the report ID, the
			// rest of the buffer contains the data sent from 
			// the HID device
			return 1;
		}
   }
   return 0;   
}
/*

// To send some data to the HID device, use something like..
void CUSBHIDDlg::SendSomeData()
{  
   // output buffer...
   HIDBufferOut BufferOut;
   
   // first element is the report ID
   BufferOut[0] = 0;

  // rest of the buffer is for data...
  for (int i = 1; i < BUFFER_OUT_SIZE; i++)
     BufferOut[i] = i;

  // now send the data...
  WriteEx(VENDOR_ID, PRODUCT_ID, BufferOut);
}

*/

