
#include "mcHID.h"


CONNECT Connect;
DISCONNECT Disconnect;
GET_ITEM GetItem;
GET_ITEM_COUNT GetItemCount;
READ Read;
WRITE Write;
READ_EX ReadEx;
WRITE_EX WriteEx;
GET_HANDLE GetHandle;
GET_VENDOR_ID GetVendorID;
GET_PRODUCT_ID GetProductID;
GET_VERSION_ID GetVersionID;
GET_VENDOR_NAME GetVendorName;
GET_PRODUCT_NAME GetProductName;
GET_SERIAL_NUMBER GetSerialNumber;
GET_INPUT_REPORT_LENGTH GetInputReportLength;
GET_OUTPUT_REPORT_LENGTH GetOutputReportLength;
SET_READ_NOTIFY SetReadNotify;
IS_READ_NOTIFY_ENABLED IsReadNotifyEnabled;
IS_AVAILABLE IsAvailable;

// handle to HID DLL...
HMODULE HIDModule;

// Release the DLL from memory...
void UnloadHID() 
{
   FreeLibrary(HIDModule);
}

// load the DLL into memory...
int LoadHID() 
{
	
        // load DLL, exit if not found...
        HIDModule = LoadLibrary("mcHID.dll");
	if (HIDModule == NULL) return 1;

        // bind interface...
	Connect = (CONNECT) GetProcAddress(HIDModule,"Connect");
	Disconnect = (DISCONNECT) GetProcAddress(HIDModule,"Disconnect");
	GetItem = (GET_ITEM) GetProcAddress(HIDModule,"GetItem");
	GetItemCount = (GET_ITEM_COUNT) GetProcAddress(HIDModule,"GetItemCount");
	Read = (READ) GetProcAddress(HIDModule,"Read");
	Write = (WRITE) GetProcAddress(HIDModule,"Write");
	ReadEx = (READ_EX) GetProcAddress(HIDModule,"ReadEx");
	WriteEx = (WRITE_EX) GetProcAddress(HIDModule,"WriteEx");
	GetHandle = (GET_HANDLE) GetProcAddress(HIDModule,"GetHandle");
	GetVendorID = (GET_VENDOR_ID) GetProcAddress(HIDModule,"GetVendorID");
	GetProductID = (GET_PRODUCT_ID) GetProcAddress(HIDModule,"GetProductID");
	GetVersionID = (GET_VERSION_ID) GetProcAddress(HIDModule,"GetVersion");
	GetVendorName = (GET_VENDOR_NAME) GetProcAddress(HIDModule,"GetVendorName");
	GetProductName = (GET_PRODUCT_NAME) GetProcAddress(HIDModule,"GetProductName");
	GetSerialNumber = (GET_SERIAL_NUMBER) GetProcAddress(HIDModule,"GetSerialNumber");
	GetInputReportLength = (GET_INPUT_REPORT_LENGTH) GetProcAddress(HIDModule,"GetInputReportLength");
	GetOutputReportLength = (GET_OUTPUT_REPORT_LENGTH) GetProcAddress(HIDModule,"GetOutputReportLength");
	SetReadNotify = (SET_READ_NOTIFY) GetProcAddress(HIDModule,"SetReadNotify");
	IsReadNotifyEnabled = (IS_READ_NOTIFY_ENABLED) GetProcAddress(HIDModule,"IsReadNotifyEnabled");
	IsAvailable = (IS_AVAILABLE) GetProcAddress(HIDModule,"IsAvailable");

	atexit (UnloadHID);

	return 0;
}

