#ifndef LSERIE_H
#define LSERIE_H

#include <string>
using namespace std;


class LSerie  
{
public:
	//------ CONSTRUCTOR ------
	LSerie();									
	virtual ~LSerie();

	//------ OPEN AND CONFIGURE ------
	bool open(int numPort, long speedInBaud);	//Open the serial port COM "numPort" at the speed "speedInBaud".
												// bauds with and this adjustement : 8 bit / 1 stop bit / no parity).
												// Return: true if success.
	bool open(int numPort, long speedInBaud,			//Open the serial port COM "numPort" at the speed "speedInBaud".
			  int nbBit, int parity, float nbStopBit);  // bauds with and this adjustement : "nbBit" bit / "nbStopBit" stop bit / "parity").
														// Return: true if success.
	void closeCom();			                //Close the serial port.
	bool setTimeOut(DWORD ms);					//Set the time-out for receive data. Return: true if success.
	bool setSpeed(DWORD baudrate);				//Set the speed in bauds. Return: true if success.

	//------ SEND AND RECEIVE DATA ------
	int sendData(DWORD lg, LPBYTE data);		//Send table "data" of "lg" bytes.  Return: number of bytes really sent.
	int sendData(string* data);					//Send string "data".  Return: number of bytes really sent.
	int receiveData(DWORD lg, LPBYTE data);		//Receive table "data" who is limit at "lg" bytes.  Return: number of bytes received.
	int receiveData(string* data);				//Receive string "data". Return: number of bytes received.

	//------ READ AND WRITE THE STATE OF THE CONTROL LINE ------
	bool setRts(bool val);			// Set the state of RTS. Return: true if success.
	bool setDtr(bool val);			// Set the state of DTR. Return: true if success.
	bool setTxd(bool val);			// Set the state of TXD. Return: true if success.
	bool getCts();					// Return: The state of CTS.			
	bool getDtr();					// Return: The state of DTR.	
	bool getRi();					// Return: The state of RI.	
	bool getCd();					// Return: The state of CD.	
	
	string getErrorMsg();			// Return: The error message generated by the last function.

private:
	HANDLE			hcom;				//Fichier de sortie sur le port COM		| The file stream use for acces to the serial port.
	_COMMTIMEOUTS	ct;                 //={0,0,0,0,0}; //Config du Time Out	| This variable contain the delay of the time-out. 
	DCB				dcb;				//Config du Port						| This object is use in order to configure the serial port.
	int				bufferSize;

};




#endif 

