﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// signature  : hash = BE966FADF5AA0AE34D925281A8D6EA71 (MD5(SHA256))
namespace NewSat
{
    class Program
    {
        static private List<Vertex> graph_nodes = new List<Vertex>();
        static private Dictionary<string, bool> values = new Dictionary<string, bool>();
        static private Dictionary<string, bool> FoundValues = new Dictionary<string, bool>();
        static private IList<string> EqalValues1 = new List<string>();
        static private IList<string> EqalValues2 = new List<string>();
        static private List<Three> System1 = new List<Three>();
        static private List<Three> BackSystem1 = new List<Three>();
        static private List<Three> RemainSystem1 = new List<Three>();
        static private List<Two> System2 = new List<Two>();
        static private List<List<Vertex>> cycle_list = new List<List<Vertex>>();
        static private IList<string> allVariables = new List<string>();
        static private IList<string> usedVariables = new List<string>();
        static private IDictionary<string ,int> Indexes = new Dictionary<string,int>();
        static private Dictionary<string, IList<string>> children = new Dictionary<string, IList<string>>();
        static private Dictionary<string, IList<string>> parents = new Dictionary<string, IList<string>>();
        static private bool recurvise = true;
        static bool first = true;
        static DateTime startDate;
        static string path = "C:\\Dev/Output";
         static void Main(string[] args)
        {

            Console.ForegroundColor = ConsoleColor.DarkGreen;

            DateTime startDate= DateTime.Now;
           
            Console.WriteLine("Load File (Y) or generate System (N)? ");
            string input = Console.ReadLine();

            bool load = input.ToUpper().Equals("Y") ? true : false;


            

            if (!load)
            {
                Console.WriteLine("Enter the number of  Variables: ");
                input = Console.ReadLine();
                int number;
                Int32.TryParse(input, out number);

                Console.WriteLine("Enter teh number of instances: ");
                string input2 = Console.ReadLine();
                int number2;
                Int32.TryParse(input2, out number2);

                startDate = DateTime.Now;
                Console.WriteLine("Time =" + DateTime.Now);
                // feed matrix
                FeedMatrix(number2, number);

            }
            else
            {
                string file = Path.Combine(path, "Start_3SAT.txt");
                if (!File.Exists(file))
                {

                    Console.WriteLine("You should use N mode once before using this mode");
                    Console.ReadKey();
                }

                LoadFile();
            }

            CopySystem();

            // Check first system.
            // show
            if (!load)
            { 
                Build2SAT();
                ShowdMatrix();
            }

            HandleAll();
            Console.ReadKey();

        }
        static void AddVertex(Vertex parent, Vertex child)
        {

            //if (child.Name =="X280")
            //Console.WriteLine("parent :" + parent.Name + " child :  " + child.Name);
            if (!children.Keys.Contains(parent.Name))
                children.Add(parent.Name, new List<string>() { parent.Name });

            if (!children[parent.Name].Contains(child.Name))
                children[parent.Name].Add(child.Name);
            foreach (Vertex v in child.Dependencies)
                AddVertex(parent, v);

        }

        static void AddParentVertex(Vertex child, Vertex parent)
        {

            if (!parents.Keys.Contains(child.Name))
                parents.Add(child.Name, new List<string>() { child.Name });

            if (!parents[child.Name].Contains(parent.Name))
                parents[child.Name].Add(parent.Name);
            foreach (Vertex v in parent.Parents)
                AddParentVertex(child, v);

        }

        static int PairInTree()
        {
            int ret = 0;
            Console.WriteLine("The First part...");
                // First Part
            for (int i = 0; i < System1.Count;i++ )
            {
                Three t = System1[i];
               
 
                foreach (string v in children.Keys)
                {
                    bool r1 = false;
                    bool r2 = false;
                    bool r3 = false;
                    foreach (string w in children[v])
                    {
                        if (t.First ==w) 
                            r1 = true;
                          if (t.Second ==w)
                              r2 = true;
                          if (t.Third == w)
                              r3 = true;

                        if (r1 && r2 && r3)
                        {
                            if (FoundValues.ContainsKey(v))
                            {
                                if (FoundValues[v])
                                {
                                    return 1;
                                }
                            }
                            else
                            {
                                FoundValues[v]= false;
                                FoundValues[Negative(v)] = true;
                                IList<string> ll = parents[v];

                                for (int k = 0; k < ll.Count; k++)
                                {
                                    if (FoundValues.ContainsKey(ll[k]))
                                    {
                                        if (FoundValues[ll[k]])
                                        {
                                            return 1;
                                        }
                                    }

                                    FoundValues[ll[k]] = false;
                                    FoundValues[Negative(ll[k])] = true;

                                }
                                ret = 2;
                            }
                            
                        }
                    }
                }
            }
            //  Second Part x et !x
            Console.WriteLine("The Second part...");
            bool ret1 = false;
            bool ret2 = false;
           
                for (int i = 0; i < System2.Count; i++)
                {
                    Two t = System2[i];
                    ret1 = false;
                    ret2 = false;

                    foreach (string v in parents.Keys)
                    {
                        ret1 = false;
                        ret2 = false;

                        foreach (string w in parents[v])
                        {
    
                                if (t.First == w)
                                    ret1 = true;

                            if (w == t.Second)
                                ret2 = true;
                        }


                        if (ret1 && ret2)
                        {
                            if ((FoundValues.ContainsKey(v)) && !FoundValues[v])
                                return 1;


                            FoundValues[v] = true;
                            FoundValues[Negative(v)] = false;

                            IList<string> ll = parents[Negative(v)];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = false;
                                FoundValues[Negative(ll[k])] = true;

                            }
                            ret = 2;
                        }
                    }

                }
            

            // Third Part
            Console.WriteLine("The Third part...");

            foreach (string s in parents.Keys)
            {

                IList<string> l = parents[s];
                ret1 = false;
                ret2 = false;

                for (int j = 0; j < l.Count; j++)
                {

                    for (int k = 0; k < l.Count; k++)
                    {
                        if (l[j] == Negative(l[k]))
                        {
                           

                            if ((FoundValues.ContainsKey(s)) && !FoundValues[s])
                                return 1;


                            FoundValues[s] = true;
                            FoundValues[Negative(s)] = false;
                            IList<string> ll = children[s];
                            for (int h = 0; h < ll.Count;h++)
                            {

                                if ((FoundValues.ContainsKey(ll[h])) && !FoundValues[ll[h]])
                                    return 1;

                                FoundValues[ll[h]] = true;
                                FoundValues[Negative(ll[h])] = false;
                            }
                                ret = 2;
                        }
                    }


                }
            }

                //for (int k = 0; k < allVariables.Count; k++)
                //{
                //    string s = allVariables[k];
                //    ret1 = false;
                //    ret2 = false;

                //    foreach (string v in parents.Keys)
                //    {
                //        ret1 = false;
                //        ret2 = false;

                //        foreach (string w in parents[v])
                //        {
                //            if (s == w)
                //                ret1 = true;

                //            if (w == Negative(s))
                //                ret2 = true;
                //        }


                //        if (ret1 && ret2)
                //        {
                //            if ((FoundValues.ContainsKey(v)) && !FoundValues[v])
                //                return 1;


                //            FoundValues[v] = true;
                //            FoundValues[Negative(v)] = false;
                //            ret = 2;
                //        }

                //    }

                //}
           return ret;

        }

        static private string Negative(string value)
        {
            if (value.Substring(0, 1) == "!")
                return value.TrimStart('!');
            else
                return "!" + value;
        }
     
        static bool PairInImplication()
        {
            bool ret = false;
            foreach (string v in children.Keys)
            {
                foreach (string w in children[v])
                {
                    if (v == Negative(w))
                    {
                        FoundValues[v] = false;
                        FoundValues[w] = true;
                        ret = true;
                    }
                }

                // a deplacer 

                string s = Negative(v);

                // children
                IList<string> l = children[v];
                IList<string> ll = children[s];

                for (int i=0;i<l.Count;i++)
                {
                    for (int j=0;j<ll.Count;j++)
                    {
                        if (l[i]==ll[j])
                        {
                            FoundValues[l[i]] = true;
                            FoundValues[Negative(l[i])] = false;
                            IList<string> c = children[l[i]];
                            for (int k = 0; k < c.Count; k++)
                            {
                                FoundValues[c[k]] = true;
                            }
                            IList<string> d = parents[Negative(l[i])];
                            for (int k = 0; k < d.Count; k++)
                            {
                                FoundValues[d[k]] = false;
                            }



                            ret = true;

                        }
                    }
                }


                l = parents[v];
                ll = parents[s];

                for (int i = 0; i < l.Count; i++)
                {
                    for (int j = 0; j < ll.Count; j++)
                    {
                        if (l[i] == ll[j])
                        {
                            FoundValues[l[i]] = false;
                            FoundValues[Negative(l[i])] = true;
                            IList<string> d = parents[l[i]];
                            for (int k = 0; k < d.Count; k++)
                            {
                                FoundValues[d[k]] =false ;
                            }
                            IList<string> c = children[Negative(l[i])];
                            for (int k = 0; k < c.Count; k++)
                            {
                                FoundValues[c[k]] = true;
                            }



                            ret = true;

                        }
                    }
                }


            }

            return ret;
        }
        static void FillChildren()
        {
            try
            {
                children.Clear();
                foreach (Vertex v in graph_nodes)
                {

                    AddVertex(v, v);
                   
                }
            }
            catch(Exception e)
            {
                string s = "";
            }

        }
        static void FillParents()
        {
            try
            {
                parents.Clear();
                foreach (Vertex v in graph_nodes)
                {
                    AddParentVertex(v, v);
                }
            }
            catch (Exception e)
            {
                string s = "";
            }

        }
        static void FillAllVariables()
        {
            allVariables.Clear();

            for (int i = 0; i < System1.Count; i++)
            {
                Three t = System1[i];
                if (!allVariables.Contains(t.First))
                    allVariables.Add(t.First);

                if (!allVariables.Contains(t.Second))
                    allVariables.Add(t.Second);

                if (!allVariables.Contains(t.Third))
                    allVariables.Add(t.Third);

            }
        }


       
        static private bool CheckSimpleSolutions(out int count)
        {
            usedVariables.Clear();
            int aa = -1;
            bool passe = true;
            while (passe)
            {
                FillRemain();
                aa = HandleUpperPart(out passe);
            }

            FillRemain();

            for (int l = 0; l < RemainSystem1.Count; l++)
            {
                Three t = RemainSystem1[l];
                t.use = false;
                string s1 = t.First;
                usedVariables.Clear();
                HandleVertex(Negative(s1));
                passe = true;
                while (passe)
                {
                    FillRemain();
                    aa = HandleUpperPart(out passe);
                }

                string ss1 = t.Second;
                usedVariables.Clear();
                HandleVertex(Negative(ss1));
                FillRemain();
                passe = true;
                while (passe)
                {
                    FillRemain();
                    aa = HandleUpperPart(out passe);
                }

                string sss1 = t.Third;
                usedVariables.Clear();
                FillRemain();
                HandleVertex(Negative(sss1));
                passe = true;
                while (passe)
                {
                    FillRemain();
                    aa = HandleUpperPart(out passe);
                }

                t.use = true;

            }
            count = 0;
            return true;
        }
        static private void LoadFile()
        {


            string file = Path.Combine(path, "Start_3SAT.txt");
            string[] lines = File.ReadAllLines(file, Encoding.UTF8);

            System1.Clear();


            for (int i = 0; i < lines.Length; i++)
            {
                string line = lines[i];

                List<string> ll = line.Split(' ').ToList();

                if (ll.Count < 3)
                    continue;
                Three t = new Three();
                t.First = ll[0];
                t.Second = ll[1];
                t.Third = ll[2];
                BackSystem1.Add(t);
            }
        }

        static private void CopySystem()
        {
            System1.Clear();
            FoundValues.Clear();
            for (int  i=0;i< BackSystem1.Count ;i++)
            {
                Three a = BackSystem1[i].Clone() as Three;
                System1.Add(a);
            }
        }

        static private void UpdateIndex()
        {
            Indexes.Clear();
            for (int i = 0; i < cycle_list.Count; i++)
            {
                Indexes[cycle_list[i][0].Name] = i;
            }
        }
        static private int GetIndex(string s)
        {
            return Indexes[Negative(s)];
            
        }
        private static void FeedMatrix(int p, int n)
        {

            Random r = new Random();
            List<int> l = new List<int>();
            List<int> ll = new List<int>();

            for (int i = 0; i < p; i++)
            {

                l.Clear();
                ll.Clear();
                while (ll.Count < 3)
                {
                    int k = r.Next(0, n);
                    int m = r.Next(0, 2);
                    l.Add(m);
                    if (!ll.Contains(k))
                        ll.Add(k);

                }

                ll.Sort();

                // new code
                Three t = new Three();
                t.First = (l[0] == 0) ? "X" + ll[0].ToString() : "!X" + ll[0].ToString();
                t.Second = (l[1] == 0) ? "X" + ll[1].ToString() : "!X" + ll[1].ToString();
                t.Third = (l[2] == 0) ? "X" + ll[2].ToString() : "!X" + ll[2].ToString();
                BackSystem1.Add(t);
            }


        }
        static private bool CheckFoundValues()
        {
            for (int i = 0; i < BackSystem1.Count;i++ )
            {
                Three t = BackSystem1[i];
                bool r1 = (FoundValues.ContainsKey(t.First) && FoundValues[t.First]);
                bool r2 = (FoundValues.ContainsKey(t.Second) && FoundValues[t.Second]);
                bool r3 = (FoundValues.ContainsKey(t.Third) && FoundValues[t.Third]);

                if (r1 && r2 && r3)
                    return false;
            }

            return true;
        }
        static private void HandleVertex(string name)
        {

            for (int i = 0; i < graph_nodes.Count; i++)
            {
                Vertex v = graph_nodes[i];
                if (name == v.Name)
                {
                    string s = Negative(name);

                    values[s] = false;
                    values[name] = true;

                    IList<string> l = new List<string>();
                    l= GetChildren(v);
                    foreach (Vertex w in v.Dependencies)
                    {
                        HandleVertex(w.Name);
                    }
                }
            }
        }
 
        static private bool  CheckTowOne2()
        {
            bool ret = false;
            IList<string> l = new List<string>();
            IList<string> ll = new List<string>();

            for (int i=0;i< System2.Count;i++)
            {
                Two t = System2[i];
                string x = t.First;
                string y = t.Second;
                int index = t.Index;
                //l.Clear();
                //ll.Clear();

              
                for (int j = 0; j < graph_nodes.Count; j++)
                {
                   
                    if (graph_nodes[j].Name == x)
                    {

                        l= GetChildren(graph_nodes[j]);
                    }

                    if (graph_nodes[j].Name == y)
                    {
                        ll= GetChildren(graph_nodes[j]);
                    }
                }
                // Check

                for (int j=0;j<l.Count;j++)
                {
                    for (int k = 0; k < ll.Count; k++)
                    {
                        if (l[j] == Negative(ll[k]))
                        {
                            Update(x, Negative(y));
                            ret = true;
                        }
                        if ((l[j] == ll[k]))
                        {
                            if ((FoundValues.ContainsKey(l[j]) && (!FoundValues[l[j]])))
                            {
                                Console.WriteLine("Invalid system");
                                Console.ReadKey();
                            }

                            else
                            {
                                FoundValues[l[j]] = true;
                                FoundValues[Negative(l[j])] = false;

                                IList<string> d = children[l[j]];

                                for (int h = 0; h < d.Count; h++)
                                {
                                    if (FoundValues.ContainsKey(d[h]))
                                    {
                                        if (!FoundValues[d[h]])
                                        {
                                            Console.WriteLine("Invalid system");
                                            Console.ReadKey();
                                        }
                                    }

                                    FoundValues[d[h]] = true;
                                    FoundValues[Negative(d[h])] = false;

                                    ret = true;
                                }
                            }
                        }
                    }
                }
            }

            return ret;
        }

        static private  IList<string>  GetChildren(Vertex v )
        {
            if (!children.ContainsKey(v.Name))
                return new List<string>();
            IList<string> sS = children[v.Name];

           return children[v.Name];

        }


        static private bool Handle()
        {
            int p = System1.Count;
            int index = -1; ;
            string pivot = string.Empty;

            Three tt = null;
            for (int i = 0; i < p; i++)
            {
                bool b = true;
                string d = "";
                Three t = System1[i];
        
                tt = t;
                b = values[t.First] && values[t.Second] && values[t.Third];


                if (b)
                {

                    d = t.First;
                  

                    bool r1 = !usedVariables.Contains(t.First);
                    bool r2 = !usedVariables.Contains(t.Second);
                    bool r3 = !usedVariables.Contains(t.Third);

                    int k = 0;
                    if (r1)
                    {
                        k = GetIndex(d);
                        if ((index < k) && (r1))
                        {
                            index = k;
                            pivot = Negative(d);
                        }
                    }
                    d = t.Second;

                    if (r2)
                    {
                        k = GetIndex(d);
                        if ((index < k) && (r2))
                        {
                            index = k;
                            pivot = Negative(d);
                        }
                    }
                    d = t.Third;
                    if (r3)
                    {
                        k = GetIndex(d);
                        if ((index < k) && (r3))
                        {
                            index = k;
                            pivot = Negative(d);
                        }
                    }
                }

            }
            if (string.IsNullOrEmpty(pivot))
            {
                //RemainSystem1.Add(tt);
                 return false;

            }
             
            
            usedVariables.Add(Negative(pivot));
            HandleVertex(pivot);


            return true;
        }

        static private int CountChildren(string name)
        {


                    return children[name].Count;
        }
        static private int CountParent(string name)
        {
            return parents[name].Count;
        }
        static private int HandleUpperPart(out bool passe)
        {

           
            int count = RemainSystem1.Count;
            int nb = count;
            passe = false;
            for (int i = 0; i < RemainSystem1.Count; i++)
            {
                passe = false;
                Three t = RemainSystem1[i];
                string x = t.First;
                string y = t.Second;
                string z = t.Third;
                string s =x;
                bool b = false;
             

                int c = CountChildren(x);

                if (c == 0)
                {
                    c = 1;
                    IList<string> test = children[x];
                }

                int d = CountParent(x); 
                if ((c==1) && (d==3) && !usedVariables.Contains(x))
                {
                    passe = true;
                    usedVariables.Add(x);
                    values[x] = false;
                    values[Negative(x)] = true;
                    b = true;
                    IList<string> l = parents[x];

                    for (int j=0;j<l.Count;j++)
                    {
                        values[l[j]] = false;
                    }

                    l = children[Negative(x)];

                    for (int j = 0; j < l.Count; j++)
                    {
                        values[l[j]] = true;
                    }


                }

                 c = CountChildren(y);

                 if (c == 0)
                     c = 1;
                 d = CountParent(y);
                 if (!b && (c == 1) && (d == 3) && !usedVariables.Contains(y))
                {
                    passe = true;
                    usedVariables.Add(y);
                    values[y] = false;
                    values[Negative(y)] = true;
                    b = true;
                    IList<string> l = parents[y];

                    for (int j = 0; j < l.Count; j++)
                    {
                        values[l[j]] = false;
                    }
                    l = children[Negative(y)];

                    for (int j = 0; j < l.Count; j++)
                    {
                        values[l[j]] = true;
                    }


                }
                c = CountChildren(z);
                d = CountParent(z);


                if (c == 0)
                    c = 1;
                if (!b && (c == 1) && (d == 3) && !usedVariables.Contains(z))
                {
                    passe = true;
                    usedVariables.Add(z);
                    values[z] = false;
                    values[Negative(z)] = true;
                    b = true;
                    IList<string> l = parents[z];

                    for (int j = 0; j < l.Count; j++)
                    {
                        values[l[j]] = false;
                    }

                    l = children[Negative(z)];

                    for (int j = 0; j < l.Count; j++)
                    {
                        values[l[j]] = true;
                    }


                }

                if (!b)
                {
                    
                    int idx =!usedVariables.Contains(Negative(x))? Indexes[Negative(x)]:-1;


                    if ((idx < Indexes[Negative(y)]) && !usedVariables.Contains(Negative(y)))
                    {
                        idx = Indexes[Negative(y)];
                        s = y;
                    }
                    if ((idx < Indexes[Negative(z)]) && !usedVariables.Contains(Negative(z)))
                    {
                        idx = Indexes[Negative(z)];
                        s = z;
                    }

                    if (!usedVariables.Contains(Negative(s)))
                    {
                        passe = true;
                        usedVariables.Add(Negative(s));
                        HandleVertex(Negative(s));
                    }
                   
                }
                count = Count();

                if (count == 0)
                {
                    ShowValues();
                    Console.WriteLine("Solution Found!!!");
                    Console.WriteLine("variables = " + allVariables.Count);
                    Console.WriteLine("Clauses = " + BackSystem1.Count);
                    Console.WriteLine("Time =" + startDate);
                    Console.WriteLine("Time =" + DateTime.Now);
                    Console.ReadKey();
                }
            }

            
            
            return Count();
        }


        static private string GetEqalVariable(string var)
        {



            while ( EqalValues2.Contains(var))
            {
                for (int i=0;i<EqalValues2.Count;i++)
                {
                    if (var == EqalValues2[i])
                        var = EqalValues1[i];
 
                }
            }
            return var; 
        }
       static private void FillRemain()
       {

           RemainSystem1.Clear();
           for (int i=0;i< System1.Count;i++)
           {
               string str = string.Empty;

               Three t = System1[i];
               string x = t.First;
               string y = t.Second;
               string z = t.Third;
               if (FoundValues.ContainsKey(x))
                   continue;
               if (values.ContainsKey(x))
                   str = str + (values[x] ? "1" : "0");

               if (values.ContainsKey(y))
                   str = str + (values[y] ? "1" : "0");
               if (values.ContainsKey(z))
                   str = str + (values[z] ? "1" : "0");


               if (str =="111")
               {
                   RemainSystem1.Add(t);
               }
           }
       }
        static private bool  HandleAll()
        {

            bool ret = false;
            startDate = DateTime.Now;
            usedVariables.Clear();
            FillAllVariables();

            bool check = true;

            while (check)
            {


                Console.WriteLine("CHECK 2SAT.");
                Check2Sat();


                Console.WriteLine("UPDATE");

                int w = UpdateSat();
                if (w == 1)
                {
                    Console.WriteLine("The system is invalid.");
                    Console.ReadKey();
                   
                    return false;
                }
                else if (w == 2)
                    check = true;


                if (Check3Sat())
                {
                    Console.WriteLine("The system is invalid.");
                    Console.ReadKey();
              
                  return false;
                }

                Build2SAT();


                ShowdMatrix2();
                // find strongly connected component
                var tcd = new TarjanCycleDetectStack();


                BuildGraph();


                cycle_list = tcd.DetectCycle(graph_nodes);


                bool b = HasCycle(cycle_list);

                bool ret1 = FindPairInComponents(cycle_list);

                if (ret1)
                {
                    Console.WriteLine("the system is invalid");
                    Console.ReadKey();
                    return false;
                }
                else
                {
                    for (int i = 0; i < cycle_list.Count; i++)
                    {
                        ret1 = ret1 || Update3SAT(cycle_list[i]);
                    }

                }

                ShowdMatrix2();


                Console.WriteLine("Build children: ");
                if (!ret1)
                {
                    FillChildren();
                    FillParents();
                }


                Console.WriteLine("CHECK two in one.");
               b = b || CheckTowOne2();

            
                Console.WriteLine("PairInTree...... ");
                int a = PairInTree();
                bool ret2 = false;
                if (a == 1)
                {
                    Console.WriteLine("The system is invalid.");
                    Console.ReadKey();
                    return false;
                }
                if (a == 2)
                    ret2 = true;

                Console.WriteLine("PairInImplication...... ");
                check = b || ret1 || ret2 || PairInImplication();


                int v = UpdateSat();
                if (v == 1)
                {
                    Console.WriteLine("The system is invalid.");
                    Console.ReadKey();
                    return false;
                }
                else if (v == 2)
                    check = true;
                

                if (!CheckFoundValues())
                {
                    Console.WriteLine("The system is invalid.");
                    Console.ReadKey();
                    return false;
                }
            }


            Console.WriteLine("the system is valid");

            FindaSolution(cycle_list);
            UpdateIndex();


            int c = Count();
            int m = System1.Count;
            Console.WriteLine("Count : " + c + " / " + m);
            int oldCound = c + 20;

            int count2 = oldCound;
            while (c > 0)
            {

                if (!Handle())
                {
                    if (recurvise)
                    {
                        count2 = oldCound - 1;
                      
                        while (count2 <= oldCound)
                        {
                            oldCound = count2;
                            if (first)
                            FillRemain();
                            first = false;

                            bool r = CheckSimpleSolutions(out count2);



                            if (r)
                                Console.ReadKey();
                            else
                            {
                                Console.WriteLine("Global System is invalid.");
                                Console.ReadKey();
                            }
                        }
                    }
                    else
                    {
                        return false;
                    }

                }
                else
                {
                    c = Count();
                    Console.WriteLine("Count : " + c + " / " + m);
                    //if (c >= oldCound + 100)
                    //    Console.ReadKey();
                    oldCound = c;
                }
            }
            ShowValues();
            Console.WriteLine("Solution found");
            Console.WriteLine("variables = " + allVariables.Count);
            Console.WriteLine("Clauses = " + BackSystem1.Count);
            Console.WriteLine("Time =" + startDate);
            Console.WriteLine("Time =" + DateTime.Now);
            //Console.ReadKey();
            return true;

        }
        
        static private string GetValue(string var)
        {
            string x = GetEqalVariable(var);

            if (x != var)
            {
                if (FoundValues.ContainsKey(x))
                    return FoundValues[x] ? "1" : "0";
                else if (values.ContainsKey(x))
                    return values[x] ? "1" : "0";
                else
                    return x;
            }
            else
            {
                if (FoundValues.ContainsKey(var))
                    return FoundValues[var] ? "1" : "0";
                else if (values.ContainsKey(var))
                    return values[var] ? "1" : "0";
                else
                    return var;

            }

        }
        private static void ShowValues()
        {
            
            // we can have a solution to the final system ==> loop on System1
            // we assign values to remaining values in BackSystems1 by using implication graph.

            
            string File = Path.Combine(path, "Result.txt");

            int p = System1.Count;
            using (StreamWriter writetext = new StreamWriter(File))
            {

                writetext.WriteLine("Ending system solutiin");
                string str = "";
                for (int i = 0; i < p; i++)
                {
                    Three t = System1[i];

                    str = "";
                    string x = t.First;
                    string y = t.Second;
                    string z = t.Third;
                    str = GetValue(x);
                    str = str + "_" + GetValue(y);
                    str = str + "_" + GetValue(z);
                    string variables = x + "_" + y + "_" + z;
                    writetext.WriteLine("line: " + i.ToString() + "  variables = " + variables + "  values :" + str);    
                    Console.WriteLine("line: " + i.ToString() + "  variables = " + variables + "  values :" + str);
                }

                writetext.WriteLine("Starting system solution");

                p = BackSystem1.Count;
                str = "";
                for (int i = 0; i < p; i++)
                {
                    Three t = BackSystem1[i];

                    str = "";
                    string x = t.First;
                    string y = t.Second;
                    string z = t.Third;
                    str = GetValue(x);
                    str = str + "_" + GetValue(y);
                    str = str + "_" + GetValue(z);
                    string variables = x + "_" + y + "_" + z;
                    writetext.WriteLine("line: " + i.ToString() + "  variables = " + variables + "  values :" + str); 
                    //Console.WriteLine("line: " + i.ToString() + "  variables = " + variables + "  values :" + str);
                }


                Console.WriteLine("eqal variables....");
                Console.WriteLine("eqal variables....");
                for (int i = 0; i < EqalValues1.Count; i++)
                {
                    writetext.WriteLine(EqalValues2[i] + "  ==  " + EqalValues1[i]); 
                    Console.WriteLine(EqalValues2[i] + "  ==  " + EqalValues1[i]);
                }

            }
        }

        private static int Count()
        {

            int c = 0;
            //RemainSystem1.Clear();
            int p = System1.Count;
            string str = "";
            for (int i = 0; i < p; i++)
            {

                Three t = System1[i];
                bool r1 = false;
                bool r2 = false;
                bool r3 = false;



                string x = t.First;
                string y = t.Second;
                string z = t.Third;


                if (FoundValues.ContainsKey(x))
                    continue;

                if (values.ContainsKey(x))
                    r1 = values[x];
                if (!r1)
                    continue;
                if (values.ContainsKey(y))
                    r2 = values[y];
                if (!r2)
                    continue;

                if (values.ContainsKey(z))
                    r3 = values[z];
                if (!r3)
                    continue;

                if (r1 && r2 && r3)
                {
                    c++;
                }
            }
            return c;
        }
        private static void ShowdMatrix2()
        {



            if (!Directory.Exists(path))
                Directory.CreateDirectory(path);

            string File1 = Path.Combine(path, "End_3SAT.txt");
            string File2 = Path.Combine(path, "End_2SAT.txt");
            

            int p = System1.Count;
            using (StreamWriter writetext = new StreamWriter(File1))
            {
                for (int i = 0; i < p; i++)
                {
                    Three t = System1[i];
                    string str = t.First + " " + t.Second + " " + t.Third ;
                    //Console.Write(str);
                    writetext.WriteLine(str);
                }
            }
            using (StreamWriter writetext = new StreamWriter(File2))
            {

                int p2 = System2.Count;
                for (int i = 0; i < p2; i++)
                {
                    Two t = System2[i];
                    string str = t.First + " " + t.Second;
                    //Console.Write(str);
                    writetext.WriteLine(str);
                }
            }

        }

        private static void ShowdMatrix()
        {

            if (!Directory.Exists(path))
                Directory.CreateDirectory(path);

            string File1 = Path.Combine(path,"Start_3SAT.txt");
            string File2 = Path.Combine(path, "Start_2SAT.txt");

            int p = BackSystem1.Count;
            using (StreamWriter writetext = new StreamWriter(File1))
            {
                for (int i = 0; i < p; i++)
                {
                    Three t = BackSystem1[i];
                    string str = t.First + " " + t.Second + " " + t.Third ;
                    //Console.Write(str);
                    writetext.WriteLine(str);
                }
            }
            using (StreamWriter writetext = new StreamWriter(File2))
            {

                int p2 = System2.Count;
                for (int i = 0; i < p2; i++)
                {
                    Two t = System2[i];
                    string str = t.First + " " + t.Second ;
                    //Console.Write(str);
                    writetext.WriteLine(str);
                }
            }

        }

        private static void Build2SAT()
        {

            System2.Clear();
            for (int i = 0; i < System1.Count; i++)
            {
                List<Two> t = System1[i].GetTwo();
                foreach (var v in t)
                {
                    v.Index = i;
                    System2.Add(v);
                }
            }

        }

        static private bool HasCycle(List<List<Vertex>> ver)
        {
            foreach (List<Vertex> v in ver)
            {
                if (v.Count > 1)
                    return true;
            }
            return false;
        }
        private static void BuildGraph()
        {

            graph_nodes.Clear();
            int count = 0;
            int p = System2.Count;

            Dictionary<string, int> dic = new Dictionary<string, int>();
            for (int i = 0; i < p; i++)
            {
                Two t = System2[i];
                string s = t.First;
                string ss = t.Second;
                if (!dic.ContainsKey(s))
                {
                    dic.Add(s, count);
                    count++;
                }
                s = Negative(s);
                if (!dic.ContainsKey(s))
                {
                    dic.Add(s, count);
                    count++;
                }
                if (!dic.ContainsKey(ss))
                {
                    dic.Add(ss, count);
                    count++;
                }

                ss = Negative(ss);
                if (!dic.ContainsKey(ss))
                {
                    dic.Add(ss, count);
                    count++;
                }
            }

            count = 0;
            List<string> list = new List<string>(dic.Keys);
            for (int i = 0; i < dic.Keys.Count; i++)
            {
                var v1 = new Vertex() { Id = count, Name = list[i] };
                count++;
                graph_nodes.Add(v1);
            }

            count = 1;
            for (int i = 0; i < p; i++)
            {
                Two t = System2[i];
                string x = Negative(t.First);
                string y = t.Second;

                if (!dic.ContainsKey(x))
                    continue;
                if (!dic.ContainsKey(y))
                    continue;

                int m = dic[x];
                int n = dic[y];

                if (y == "X106")
                    x = x;
                Vertex v = graph_nodes[m];
                Vertex w = graph_nodes[n];
                v.Dependencies.Add(w);
                w.Parents.Add(v);

                //reverse case

                x = Negative(t.Second);
                y = t.First;

                if (y == "!X106")
                    x = x;
                if (!dic.ContainsKey(x))
                    continue;
                if (!dic.ContainsKey(y))
                    continue;

                m = dic[x];
                n = dic[y];
                v = graph_nodes[m];
                w = graph_nodes[n];
                v.Dependencies.Add(w);
                w.Parents.Add(v);
            }

            //// tests
            //TarjanStackTest();
            //TarjanStackTest2();

        }

        static private void FindaSolution(List<List<Vertex>> cycles)
        {
            values.Clear();
            for (int i = 0; i < cycles.Count; i++)
            {
                List<Vertex> v = cycles[i];
                for (int j = 0; j < v.Count; j++)
                {
                    Vertex w = v[j];
                    string name = w.Name;
                    if (!values.ContainsKey(name))
                    {
                        values[name] = true;
                        //Console.WriteLine(name + " =  1");
                    }
                    string name2 = Negative(name);
                    if (!values.ContainsKey(name2))
                    {
                        values[name2] = false;
                        //Console.WriteLine(name2 + " =  0");
                    }
                }
            }
        }
     

        static private void Update(string s, string r)
        {


            if (r == s)
                return;

            EqalValues1.Add(r);
            EqalValues1.Add(Negative(r));
            EqalValues2.Add(s);
            EqalValues2.Add(Negative(s));

            foreach (Three t in System1)
            {
                if (t.First == s)
                    t.First = r;
                if (t.First == Negative(s))
                    t.First = Negative(r);

                if (t.Second == s)
                    t.Second = r;
                if (t.Second == Negative(s))
                    t.Second = Negative(r);

                if (t.Third == s)
                    t.Third = r;
                if (t.Third == Negative(s))
                    t.Third = Negative(r);

            }
        }
        static private bool Compare(string a, string b, string c, string d, string rest1, string rest2)
        {

            if ((a == c) && (b == d))
            {
                Update(rest1, rest2);
                return true;
            }
            if ((a == Negative(c)) && (b == d))
            {
                FoundValues[b] = true;
                FoundValues[Negative(b)] = false;
                Update(rest1, Negative(rest2));
                return true;
            }
            if ((a == c) && (b == Negative(d)))
            {
                FoundValues[a] = true;
                FoundValues[Negative(a)] = false;
                Update(rest1, Negative(rest2));
                return true;
            }

            if ((a == Negative(c)) && (b == Negative(d)))
            {
                FoundValues[rest1] = true;
                FoundValues[rest2] = true;
                FoundValues[Negative(rest1)] = false;
                FoundValues[Negative(rest2)] = false;
                Update(a, Negative(b));
                return true;
            }
            return false;
        }
        static private bool Check2Sat(Three a, Three b)
        {
            string x = a.First;
            string y = a.Second;
            string z = a.Third;
            string x1 = b.First;
            string y1 = b.Second;
            string z1 = b.Third;
            bool ret = !Compare(x, y, x1, y1, z, z1);
            ret = ret && !Compare(x, z, x1, y1, y, z1);
            ret = ret && !Compare(y, z, x1, y1, x, z1);
            ret = ret && !Compare(x, y, x1, z1, z, y1);
            ret = ret && !Compare(x, z, x1, z1, y, y1);
            ret = ret && !Compare(y, z, x1, z1, x, y1);
            ret = ret && !Compare(x, y, y1, z1, z, x1);
            ret = ret && !Compare(x, z, y1, z1, y, x1);
            ret = ret && !Compare(y, z, y1, z1, x, x1);
            return ret;
        }
        static private bool Check2Sat()
        {
            bool ret = false;
            int p = System1.Count;
            List<int> l = new List<int>();
            for (int i = 0; i < p; i++)
            {
                Three t1 = System1[i];
                for (int j = i + 1; j < p; j++)
                {
                    Three t2 = System1[j];
                    bool b = !Check2Sat(t1, t2);
                    if (b)
                    {
                        if (!l.Contains(i))
                            l.Add(i);
                    }
                }

            }

            l.Sort();

            for (int i = l.Count - 1; i >= 0; i--)
                System1.RemoveAt(l[i]);
            return ret;

        }

        static private bool Check3Sat()
        {
            bool ret = false;
            int p = System1.Count;
            List<int> ll = new List<int>();
            for (int i = 0; i < p; i++)
            {
                string x = System1[i].First;
                string y = System1[i].Second;
                string z = System1[i].Third;

                ret = Check3(x, y, z);
                if (ret)
                    return ret;

                string r = Positive(x);
                string s = Positive(y);
                string t = Positive(z);

                ret = Check3(r, s, t);

                if (ret)
                {
                    if (x == y)
                    {
                        FoundValues[z] = false;
                        FoundValues[Negative(z)] = true;
                        ll.Add(i);
                    }

                    if (x == z)
                    {
                        FoundValues[y] = false;
                        FoundValues[Negative(y)] = true;
                        ll.Add(i);
                    }

                    if (z == y)
                    {
                        FoundValues[x] = false;
                        FoundValues[Negative(x)] = true;
                        ll.Add(i);
                    }
                }
                else
                {
                    if (r == s)
                    {
                        if (x == y)
                        {
                            FoundValues[z] = false;
                            FoundValues[Negative(z)] = true;
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                            ll.Add(i);
                        }
                        else
                        {
                            FoundValues[z] = true;
                            FoundValues[Negative(z)] = false;
                            ll.Add(i);
                        }
                    }
                    if (r == t)
                    {
                        if (x == z)
                        {
                            FoundValues[y] = false;
                            FoundValues[Negative(y)] = true;
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                            ll.Add(i);
                        }
                        else
                        {
                            FoundValues[y] = true;
                            FoundValues[Negative(y)] = false;
                            ll.Add(i);
                        }
                    }
                    if (s == t)
                    {
                        if (y == z)
                        {
                            FoundValues[x] = false;
                            FoundValues[Negative(x)] = true;
                            FoundValues[y] = true;
                            FoundValues[Negative(y)] = false;
                            ll.Add(i);
                        }
                        else
                        {
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                            ll.Add(i);
                        }
                    }

                }
            }
            // delete item
            ll.Sort();

            for (int i= ll.Count -1 ;i>=0;i--)
            System1.RemoveAt(ll[i]);

            ret = false;
            return ret;
        }

        static private int UpdateSat()
        {

            int ret = 0;


            if (children.Count == 0)
                return ret;

            List<int> l = new List<int>();
            int p = System1.Count;

            for (int i = 0; i < p; i++)
            {
                Three tt = System1[i];
                string x = tt.First;
                string y = tt.Second;
                string z = tt.Third;

                if (FoundValues.ContainsKey(x))
                {
                    l.Add(i);
                    if (FoundValues[x])
                    {
                        Update(y, Negative(z));
                        ret = 2;
                    }
                    else
                    {
                        if (!FoundValues.ContainsKey(y))
                        {
                           FoundValues[y] = true;
                           FoundValues[Negative(y)] = false;
                           IList<string> ll = children[y];

                           for (int k = 0; k < ll.Count; k++)
                           {
                               if (FoundValues.ContainsKey(ll[k]))
                               {
                                   if (FoundValues[ll[k]])
                                   {
                                       return 1;
                                   }
                               }

                               FoundValues[ll[k]] = true;
                               FoundValues[Negative(ll[k])] = false;

                           }

                           ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[y])
                                return 1;
                        }
                        if (!FoundValues.ContainsKey(z))
                        {
                            FoundValues[z] = true;
                            FoundValues[Negative(z)] = false;
                            IList<string> ll = children[z];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = true;
                                FoundValues[Negative(ll[k])] = false;

                            }
                            ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[z])
                                return 1;
                        }

                    }
                }


                if (FoundValues.ContainsKey(y))
                {
                    l.Add(i);
                    if (FoundValues[y])
                    {
                        Update(x, Negative(z));
                        ret = 2;
                    }
                    else
                    {
                        if (!FoundValues.ContainsKey(x))
                        {
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                            IList<string> ll = children[x];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = true;
                                FoundValues[Negative(ll[k])] = false;

                            }
                            ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[x])
                                return 1;
                        }
                        if (!FoundValues.ContainsKey(z))
                        {
                            FoundValues[z] = true;
                            FoundValues[Negative(z)] = false;
                            IList<string> ll = children[z];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = true;
                                FoundValues[Negative(ll[k])] = false;

                            }
                            ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[z])
                                return 1;
                        }
                    }
                }

                if (FoundValues.ContainsKey(z))
                {
                    l.Add(i);
                    if (FoundValues[z])
                    {
                        Update(y, Negative(x));
                        ret = 2;
                    }
                    else
                    {
                        if (!FoundValues.ContainsKey(y))
                        {
                            FoundValues[y] = true;
                            FoundValues[Negative(y)] = false;
                            IList<string> ll = children[y];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = true;
                                FoundValues[Negative(ll[k])] = false;

                            }
                            ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[y])
                                return 1;
                        }
                        if (!FoundValues.ContainsKey(x))
                        {
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                            IList<string> ll = children[x];

                            for (int k = 0; k < ll.Count; k++)
                            {
                                if (FoundValues.ContainsKey(ll[k]))
                                {
                                    if (FoundValues[ll[k]])
                                    {
                                        return 1;
                                    }
                                }

                                FoundValues[ll[k]] = true;
                                FoundValues[Negative(ll[k])] = false;

                            }
                            ret = 2;
                        }
                        else
                        {
                            if (!FoundValues[x])
                                return 1;
                        }
                    }
                }

            }

            // remove 


            l = (from s in l select s).Distinct().ToList();
            l.Sort();
            for (int i = l.Count-1; i>=0;i--)
            {
                System1.RemoveAt(l[i]);
            }
            return ret;
        }
        static private bool Check3SatNew()
        {
            bool ret = false;
            int p = System1.Count;

            for (int i = p - 1; i >= 0; i--)
            {
                Three tt = System1[i];
                string x = tt.First;
                string y = tt.Second;
                string z = tt.Third;

                ret = Check3(x, y, z);
                if (ret)
                    return ret;

                string r = Positive(x);
                string s = Positive(y);
                string t = Positive(z);

                ret = Check3(r, s, t);

                if (ret)
                {

                    if (x == y)
                    {
                        FoundValues[z] = false;
                        FoundValues[Negative(z)] = true;
                        System1.RemoveAt(i);
                    }

                    if (x == z)
                    {
                        FoundValues[y] = false;
                        FoundValues[Negative(y)] = true;
                        System1.RemoveAt(i);
                    }

                    if (z == y)
                    {
                        FoundValues[x] = false;
                        FoundValues[Negative(x)] = true;
                        System1.RemoveAt(i);
                    }
                }
                else
                {
                    if (r == s)
                    {
                        if (x == y)
                        {
                            FoundValues[z] = false;
                            FoundValues[Negative(z)] = true;
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                        }
                        else
                        {
                            FoundValues[z] = true;
                            FoundValues[Negative(z)] = false;
                        }
                        System1.RemoveAt(i);
                    }
                    if (r == t)
                    {
                        if (x == z)
                        {
                            FoundValues[y] = false;
                            FoundValues[Negative(y)] = true;
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                        }
                        else
                        {
                            FoundValues[y] = true;
                            FoundValues[Negative(y)] = false;
                        }
                        System1.RemoveAt(i);
                    }
                    if (s == t)
                    {
                        if (y == z)
                        {
                            FoundValues[x] = false;
                            FoundValues[Negative(x)] = true;
                            FoundValues[y] = true;
                            FoundValues[Negative(y)] = false;
                        }
                        else
                        {
                            FoundValues[x] = true;
                            FoundValues[Negative(x)] = false;
                        }
                        System1.RemoveAt(i);
                    }

                }
            }

            ret = false;
            return ret;
        }
        static private string Positive(string s)
        {
            return (!s.Contains('!')) ? s : Negative(s);
        }
        static private bool Check3(string val1, string val2, string val3)
        {
            bool ret = false;

            ret = val1.Equals(val2);
            ret = ret & val1.Equals(val3);
            return ret;

        }

        static private bool Update3SAT(List<Vertex> list)
        {

            bool ret = false;
            if (list.Count <= 1)
                return false;
            string value = list[0].Name;
            string value1 = Negative(value);

            int p = System1.Count;
            for (int i = 0; i < p; i++)
            {

                Three t = System1[i];
                for (int k = 1; k < list.Count; k++)
                {
                    string v = list[k].Name;
                    string v1 = Negative(v);
                    // First
                    if (t.First == v)
                    {
                        t.First = value;
                        ret = true;
                    }
                    if (t.First == v1)
                    {
                        t.First = value1;
                        ret = true;
                    }
                    // Second
                    if (t.Second == v)
                    {
                        t.Second = value;
                        ret = true;
                    }
                    if (t.Second == v1)
                    {
                        t.Second = value1;
                        ret = true;
                    }
                    // Third
                    if (t.Third == v)
                    {
                        t.Third = value;
                        ret = true;
                    }
                    if (t.Third == v1)
                    {
                        t.Third = value1;
                        ret = true;
                    }

                }
            }
            return ret;
        }

        static private List<string> FindOrigins()
        {
            List<string> ll = new List<string>();

            for (int i = 0; i < graph_nodes.Count; i++)
            {
                if (graph_nodes[i].Parents.Count == 0)
                    ll.Add(graph_nodes[i].Name);
            }
            return ll;
        }

        static private List<string> FindOrigins2()
        {
            List<string> ll = new List<string>();

            foreach (string s in parents.Keys)
            {

                IList<string> ss = parents[s];

                if (ss.Count == 1)
                    ll.Add(s);
            }
            return ll;
        }
        static private bool FindPairInComponents(List<List<Vertex>> DetectCycle)
        {
            bool ret = false;


            for (int i = 0; i < DetectCycle.Count; i++)
            {
                List<Vertex> ll = DetectCycle[i];
                if (ll.Count <= 1)
                    continue;
                
                for (int j = 0; j < ll.Count; j++)
                {
                    string s = ll[j].Name;
                    for (int k = j + 1; k < ll.Count; k++)
                    {
                        string ss = ll[k].Name;
                        if (s == Negative(ss)) 
                        {
                            ret = true;
                            Console.WriteLine(" double " + s + " " + ss);
                        }
                    }

                }

            }


            return ret;
        }
     
    }
}
