///////////////////////////////////////////////////////////////////////////
////                             LCD.C                                 ////
////                 Driver for common LCD modules                     ////
////                                                                   ////
////  lcd_init()   Must be called before any other function.           ////
////  lcd_display(c)  Will display c on the LCD.                       ////
////  lcd_clear ()  clear lcd display                                  ////
////  lcd_instruction(instruct)  send an instruction to lcd display    ////
////  lcd_data(data)  send a data to lcd display                       ////
////  void lcd_nl(); go to the next line                               ////
////  void lcd_home(); cursor back to home                             ////
///////////////////////////////////////////////////////////////////////////

// As defined in the following structure the pin connection is as follows:
//     E0 enable
//     E2  rs
//     E1  rw  
//     D0  DATA0
//     D1  DATA1
//     D2  DATA2
//     D3  DATA3
//     D4  DATA4
//     D5  DATA5
//     D6  DATA6
//     D7  DATA7
//   To modify data pin connection, replace output_d by output_x

//----------------------------------PIN------------------------
#define rs PIN_E2
#define rw PIN_E1
#define e  PIN_E0


void lcd_init();
void lcd_clear ();
void lcd_display(char*);
void lcd_data(char);
void lcd_instruction (char);
void lcd_nl();
void lcd_home();

void lcd_init() {
    delay_ms(30);//le lcd se reveille
    output_low(rs);//command
    output_low(rw);//write
    output_low(e);//disable
    lcd_instruction(0x33);//LCD en mode 8 bits
    lcd_instruction(0x38);//mode 8 bits, 2 lignes, caractres 5x7
    lcd_instruction(0x0c);//pas de curseur
    lcd_instruction(0x06);//ecriture de gauche vers la droite
    lcd_instruction(0x01);//clear lcd
    delay_ms(10);
}

void lcd_display(char *data)
{
   while(*data !='\0')
   {
   if(*data=='\n') lcd_nl();
   else lcd_data(*data);
   data++;
   }
}

void lcd_instruction (char x)
{
   output_low(rs);                         //command. 
   output_low(rw);                         //write not read.  
   output_d(x);                      //data to bus.    
   output_high(e);                          //enable.
   delay_us(1);
   output_low(e);                         //disable. 
   delay_ms(10); //lcd busy protect
}

void lcd_data (char x)
{  
   output_high(rs);                        //data  
   output_low(rw);                        //write not read.   
   output_d(x);                     //data to bus.       
   output_high(e);                         //enable. 
   delay_us(1);
   output_low(e);                         //disable. 
   delay_ms(10); //lcd busy protect
}

void lcd_clear ()
{
   output_low(rs);                         //command. 
   output_low(rw);                         //write not read.  
   output_d(0x01);                      //data to bus.    
   output_high(e);                          //enable. 
   delay_us(1);
   output_low(e);                         //disable. 
   delay_ms(5); //lcd busy protect
}

void lcd_nl()
{
lcd_instruction(0xC0); //command to write to the second line
}

void lcd_home()
{
lcd_instruction(0x02);//comand to go back to home
}

