;;--------------------------------------------------------
; 16 bit Add Immediate
; Operation: DST = DST + Constant
;
; DST is updated, carry is set correctly.
;;--------------------------------------------------------
ADDI16	
	MOVLW   D'128'		; w=ad
	ADDWF   EEprom,F			; DST=DST+w
	MOVLW   D'0'
	BTFSC   STATUS,C
	MOVLW   (HIGH (EEprom)) + 1
	ADDWF   (EEprom)+1,F
	return

;;--------------------------------------------------------
; Initialize a 16 bit value to zero
;;--------------------------------------------------------
CLR16   MACRO   VAR
        CLRF    VAR
        CLRF    VAR+1
        ENDM
        

;;--------------------------------------------------------
; Increment 16 bit value, sets Z on exit.
;
; Operation: DST++
;;--------------------------------------------------------
INC16         
        INCFSZ  (EEprom),W     ; Add one to low byte
        DECF    (EEprom)+1,F   ; No carry (negates next step)
        INCF    (EEprom)+1,F   ; Add one to high byte
        MOVWF   (EEprom)       ; Store updated low byte back.
        IORWF   (EEprom)+1,W   ; Set Z flag
        return
