;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 16F676. Il contient  les informations de  base pour               *
;   dmarrer.                                                                *  
;   ecrit grace  Bigonoff par gilles.chevalerias@free.fr                    *
;*****************************************************************************
;                                                                            *
;    NOM:  Datalog2                                                          *
;    Date: 13/03/2009                                                        *
;    Version: 01                                                             *
;    Circuit:                                                                *
;    Auteur:                                                                 *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F676.inc                                             *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes:                                                                  *
;                                                                            *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************

; Ce modele est un peut particulier dans la serie des 16F, il peut travailler avec une tension 
; faible mme sans version LF, sa memmoire est mappe sur les deux banques comme un 16F84,
; il comporte un registre OSCCAL comme les 12F avec une valeur de calibration  sauver, 
; il se programme sur un support reserv au PIC 8 pattes comme un 12F, il a deux ports le A et le C
; qui n'ont que 6 I/O chacun, l'interruption RB0/int et sur RA2, les interruptions de changement d'etat
; sur le portB sont transferes sur le port A et individuellement reglable, idem pour les resistances de
; pullup.


	ERRORLEVEL -302			; suppression du message bank select 
	LIST      p=16F676            ; Dfinition de processeur
	#include <p16F676.inc>        ; fichier include
	

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT 

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection du programme
; -----------------------
;_CP_ALL		protection totale (attention relecture d'OSCCAL impossible)
;_CP_OFF		Pas de protection


; Protection de l'EEprom
; -----------------------
;_CPD_ON		Mmoire EEprom protge
;_CPD_OFF               Mmoire EEprom dprotge


; Reset de la PIC si tension <4V
; ------------------------------
; _BODEN		Reset tension en service
;			Valide PWRTE_ON automatiquement
; _BODEN_OFF		Reset tension hors service

;Utilisation de la pin MCLR
; ------------------------------
;_MCLRE_ON		RA5/MCLR est utilise pour le reset
;
;_MCLRE_OFF		RA5/MCLR est utilise comme une entree/sortie

; Retard  la mise sous tension
; -----------------------------

;_PWRTE_OFF		Dmarrage rapide
;_PWRTE_ON		Dmarrage temporis

; Watchdog
; --------

;_WDT_ON		Watchdog en service
;_WDT_OFF		Watchdog hors service

; Oscillateur
; -----------
;_EC_OSC 		(ECIO) oscillateur externe sur RA5 avec RA4 en I/O               
;_INTRC_OSC_CLKOUT	oscillateur interne clkout sur RA4, I/O sur RA5 (4MHz)    
;_INTRC_OSC_NOCLKOUT	oscillateur interne I/O sur RA4 et RA5 (4MHz)        
;_EXTRC_OSC_NOCLKOUT	(RCIO) RC externe sur RA5 avec RA4 en I/O
;_EXTRC_OSC_CLKOUT      (RC) RC externe sur RA5 avec Fosc/4 sur RA4         
;_LP_OSC 		Oscillateur basse vitesse (?<F<200Khz)        
;_XT_OSC                Oscilateur moyenne vitesse (0,1MHz<F<4Mhz)     
;_HS_OSC 		Oscillateur haute vitesse (1Mhz<F<20Mhz)


;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'10000000'
			; RAPU      b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    b6 : 1= Interrupt sur front montant de RA2
			;                0= Interrupt sur front descendant de RA2
			; TOCS      b5 : 1= source clock = transition sur RA2
			;                0= horloge interne
			; TOSE      b4 : 1= Slection front descendant RA2(si B5=1)
			;                0= Slection front montant RA2
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        ;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256


; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'00000000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques
			; T0IE      b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RA2/Int
			; RAIE      b3 : masque interruption change PORTA (IOCA doit tre activ)
			; T0IF      b2 : flag tmr0
			; INTF      b1 : flag RA2/Int
			; RAIF      b0 : flag interruption change PORTA


; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; EEIE      b7 : masque interrupt criture EEPROM
			; ADIE      b6 : masque interrupt convertisseur A/D
			; RESERVED  b5 : rserv, laisser  0
			; RESERVED  b4 : rserv, laisser  0
			; CMIE      b3 : masque interrupt comparateur
			; RESERVED  b2 : rserv, laisser  0
			; RESERVED  b1 : rserv, laisser  0
			; TMR1IE    b0 : masque interrupt dbordement tmr1


; REGISTRE IOCA (contrle individuel des interruptions sur le PORTA)
; ------------------------------------------------------------------
IOCAVAL		EQU	B'00000000'
			; RESERVED  b7 : rserv, laisser  0 
			; RESERVED  b6 : rserv, laisser  0
			; IOCA5     b5 : masque interruption de changement sur RA5
			; IOCA4     b4 :        "             "     "       "  RA4 
			; IOCA3     b3 :        "             "     "       "  RA3
			; IOCA2     b2 :        "             "     "       "  RA2
			; IOCA1     b1 :        "             "     "       "  RA1
			; IOCA0     b0 :        "             "     "       "  RA0


; REGISTRE WPUA (contrle individuel des resistances de pull up)
; --------------------------------------------------------------
WPUAVAL	EQU		B'00000000'
			; RESERVED  b7 : rserv, laisser  0 
			; RESERVED  b6 : rserv, laisser  0
			; WPUA5     b5 : mettre  1 pour activ resistance sur RA5
			; WPUA4     b4 :        "           "       "       "  RA4 
			; WPUA3     b3 :        "           "       "       "  RA3
			; WPUA2     b2 :        "           "       "       "  RA2
			; WPUA1     b1 :        "           "       "       "  RA1
			; WPUA0     b0 :        "           "       "       "  RA0
	; pour utiliser les resistances de pull up, RAPU de OPTION doit tre  0


; REGISTRE CMCON (COMPARATEURS)
; ------------------------------------
CMCONVAL	EQU	B'00000111' 
			; RESERVED  b7 : rserv, laisser  0
			; COUT      b6 :sortie comparateur
			; RESERVED  b5 : rserv, laisser  0
			; CINV      b4 :inverseur comparateur
			; CIS       b3 :selection entree du comparateur
			; CM2-CM0   b2-0 :mode des comparateurs
			; configurer le mode 111 pour utiliser RA0 RA1 RA2 en I/O


; REGISTRE VRCON (voltage reference module)
; ------------------------------------
VRCONVAL	EQU	B'00000000'
			; VREN      b7 :Validation du module
			; RESERVED  b6 : rserv, laisser  0
			; VRR       b5 :Choix de la plage 
			; RESERVED  b4 : rserv, laisser  0
			; VR3-VR0   b3-0 :Choix de la valeur dans la plage 
					; si VRR=1 VREF=(VR[3:0]/24)*Vdd
					; si VRR=0 VREF=Vdd/4(VR[3:0]/32)*Vdd


; REGISTRE ANSEL (contrle du convertisseur A/D)
; ----------------------------------------------
ANSELVAL	EQU	B'00000111'
			; ANS7	    b7 : 1=AN7/RC3 analogique, 0=AN7/RC3 digital
			; ANS6	    b6 : 1=AN6/RC2 analogique, 0=AN6/RC2 digital
			; ANS5	    b5 : 1=AN5/RC1 analogique, 0=AN5/RC1 digital
			; ANS4	    b4 : 1=AN4/RC0 analogique, 0=AN4/RC0 digital
			; ANS3	    b3 : 1=AN3/RA4 analogique, 0=AN3/RA4 digital
			; ANS2	    b2 : 1=AN2/RA2 analogique, 0=AN2/RA2 digital
			; ANS1	    b1 : 1=AN1/RA1 analogique, 0=AN1/RA1 digital
			; ANS0	    b0 : 1=AN0/RA0 analogique, 0=AN0/RA0 digital


; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'00011111'	; Direction PORTA  RA5  RA0 (1=entre)
DIRPORTC	EQU	B'00010000'	; Direction PORTC  RC5  RC0


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; exemple
; -------
;MASQUE		EQU	H'00FF'


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************

; exemple
; -------
#DEFINE		LED1 	PORTA,5
#DEFINE		SDA	PORTC,2
#DEFINE		SCL	PORTC,3
#DEFINE   	I2CACK	flag,0 
#DEFINE		RS_port	PORTC				; RS232 : port A ou B
#DEFINE		RS_tx	5				; RS232 : Tx
#DEFINE		RS_rx	4				; RS232 : RX
#DEFINE		RS_qtz	.4000000			; Vitesse du quartz ( ici 4 MHz )
#DEFINE		RS_delay   (((RS_qtz/4)/.9600)/3-2)	; 9600 est la vitesse dsire ( ou 4800 ) 
#DEFINE 	SIGNAL	    PORTA,4		; RA4= entre signal
#DEFINE		MODUL	    flag,4		; flag presence modulation
#DEFINE		BP_Memoire  flag,1		; flag de memorisation position bouton repos
#DEFINE		BP_Lecture  flag,2		; flag de lecture du bouton
#DEFINE 	BP_On	    flag,3		; flag indiquant que le BP a t actionn
#DEFINE 	G_select1	PORTC,1		; 2 sorties pour delection sensibilit
#DEFINE 	G_select0	PORTC,0	

;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

			; Changement de banques
			; ----------------------

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
	endm

	


;*****************************************************************************
;             VARIABLES BANQUE0 et BANQUE1 sont mappes (communes)           *
;*****************************************************************************

; Zone de 64 bytes
; ----------------

	CBLOCK	0x20			; Dbut de la zone (0x20  0x5F)
	w_temp : 1			; Sauvegarde registre W
	status_temp : 1			; sauvegarde registre STATUS
	I2C_VAR1 : 1			; 3 variables pour routine I2C
	I2C_VAR2 : 1
	flag : 1			; seule le bit 0 est utilis
	RS_buff : 1			; RS232 : buffer ( 1 octet ) pour l'envoi ou la reception
	RS_count : 1			; RS232 : Nbr de bits de donnes de la liaison srie
	RS_tmp : 1			; RS232 : variable temporaire pour boucle de tempo
	cmpt1 : 1			; compteur1
	PDel0 : 1			; pour tempo
	PDel1 : 1
	count : 1			; pour compter dans page
	count_xyz : 1			; pour selection axe de mesure
	EEprom : 2			; pour adresse EEprom
	serie : 1			; pour reconnaitre la serie
	result : 1			; pour mesure creneau
	

        ENDC				; Fin de la zone                        
;Exemples
;--------
	;test :1			; Zone de 1 byte
	;table : 10			; zone de 10 bytes
	;var1 	EQU H'006E'		; adresse impose


;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 			; Adresse de dpart aprs reset
  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************

			;sauvegarder registres	
			;---------------------
	org 	0x004			; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp

	BANK0				; passer en banque0

			; switch vers diffrentes interrupts
			; inverser ordre pour modifier priorits
			; mais attention alors au test PEIE
			; effacer les inutiles
			;----------------------------------------
	
	

	
			;restaurer registres
			;-------------------
restorereg
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt







; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0				; slectionner banque0
	clrf	PORTA			; Sorties PORTA  0
	clrf	PORTC			; sorties PORTC  0
	BANK1				; passer en banque1
	movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTC		; Direction PORTC
	movwf	TRISC			; criture dans registre direction

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions
	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1
	movlw	VRCONVAL		; charger valeur registre interruption
	movwf	VRCON			; initialiser interruptions
	movlw	IOCAVAL			; charger valeur registre interruption
	movwf	IOCA			; initialiser interruptions
	movlw	ANSELVAL		; charger valeur registre interruption
	movwf	ANSEL			; initialiser registre
	movlw	WPUAVAL			; charger valeur registre interruption
	movwf	WPUA			; initialiser registre
	BANK0				; slectionner banque 0
	movlw	CMCONVAL		; charger valeur registre interruption
	movwf	CMCON			; initialiser interruptions

			; Effacer RAM banque 0
			; ---------------------
	movlw	0x20			; initialisation pointeur
	movwf	FSR		 	; d'adressage indirect
init1
	clrf	INDF			; effacer ram
	incf	FSR,f			; pointer sur suivant
	btfss	FSR,7			; tester si fin zone atteinte (>7F)
	goto	init1			; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	bsf	INTCON,GIE		; valider interruptions
	goto	start			; programme principal


;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start

	clrwdt			; effacer watch dog
	BANK1	
	movlw	B'00010000'		; diviseur par 8
	movwf	ADCON1
	BANK0
	movlw	B'00000000'		; justification  gauche, Vref=Vdd
	movwf	ADCON0
	bsf		G_select1		; reglage de la sensibilit  +/- 6g
	bsf		G_select0
	
	;attente environ 8 secondes par securit
	bsf		LED1
	call	tempo_4s
	call	tempo_4s
	bcf		LED1

Premier_passage	
	call	Test_presence_modulation	
	btfsc	MODUL			; test du flag
	goto	$+2
	goto 	lire_EEprom		; si pas de modulation alors lire EEprom 
	call	Mesure_creneau
	call	Test_pos_inter
	bcf	BP_Memoire	
	btfsc	BP_Lecture
	bsf	BP_Memoire			; la position du BP est transfere dans le flag memoire

;*******************
; boucle de surveillance
start_1
	bsf 	LED1

	call	Mesure_creneau
	call	Test_pos_inter
	call	Comparaison_BP
	btfss	BP_On			; test si bouton est actionn
	goto	start_1			; non on boucle
	bcf	LED1

	
	call	I2C_INIT
	clrf  	EEprom				; reset adresse EEprom
	clrf	EEprom+1
	call	lecture_serie
debut	movlw	.2	
	movwf	count				; debut de page=2
	clrf	count_xyz			; reset compteur axe
; tempo 10ms	pour delai apres un stop
        MOVLW 0x10  ;16 DEC
        MOVWF PDel1
        MOVLW 0x0CF  ;207 DEC
        MOVWF PDel0
        DECFSZ PDel0,F
        GOTO $-1
        DECFSZ PDel1,F
        GOTO $-5


	call	I2CSTART			; envoie Start condition
	movlw	B'10100000'	
	call	WtoI2C				; envoie adresse EEprom
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom+1,w
	call	WtoI2C    			; envoie msb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom,w
	call	WtoI2C				; lsb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
;      ecrire deux fois serie
	movf	serie,w
	call	WtoI2C				; ecrir valeur
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	serie,w
	call	WtoI2C				; ecrir valeur
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
AA_1
	; tempo 15ms pour frequence d'echantillonnage

	call	tem15ms
	; ici faire conversion 
	call	convert
	;movf	count,w
	call	WtoI2C				; ecrir valeur
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	incf	count_xyz,f			; incrementer compteur axe
	btfss	count_xyz,1			; tester si 3ieme axes
	goto	$+3
	btfsc	count_xyz,0	
	clrf	count_xyz
	
	incf	count,f		
	btfsc	count,7				; tester si fin de page
	goto    $+2
	goto	AA_1
	call	I2CSTOP
	call	ADDI16  		; adresse=adresse+128	


	btfss	STATUS,C			; tester si fin d'EEprom
	goto	debut				; non, boucler
fin2
	bsf		LED1
	nop					; oui fin		
	goto	$-1

lire_EEprom
	call 	lecture
	goto 	fin2
	
	goto start		; boucler


;*****************************************************************************
;*****************************************************************************
;*****************************************************************************
;*****************************************************************************
;*****************************************************************************
;                         SOUS PROGRAMME                                     *
;*****************************************************************************

;-----------------SP de conversion-------------------
convert
	movf	count_xyz,w
	movwf	cmpt1
	rlf		cmpt1,f
	rlf		cmpt1,f
	movf	cmpt1,w			; cmpt ajust dans w
	movwf	ADCON0
	bsf		ADCON0,ADON		; lancer l'aquisition
	call	tem22us
	bsf		ADCON0,GO		; lancer la conversion
	btfsc	ADCON0,GO		; conversion tremine?
	goto	$-1			; non on boucle
	movf	ADRESH,w		; resultat dans w
	return
	

;----------------SP lecture de la serie------------
;-------------------------------------------------
lecture_serie
	call	I2CSTART			; envoie Start condition
	movlw	B'10100000'	
	call	WtoI2C				; envoie adresse EEprom
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom+1,w
	call	WtoI2C    			; envoie msb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom,w
	call	WtoI2C				; lsb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	call	I2CSTART			; envoie Start Repeat
	movlw	B'10100001'	
	call	WtoI2C				; envoie adresse EEprom avec R/W=1 pour lecture
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	call 	I2CtoW  			; lire la donne
	xorlw	0XFF				; inversion des bits
	movwf	serie
	call	I2C_envoie_NoACK
	call	I2CSTOP	
	return
;----------------SP lecture----------------------
;------------------------------------------------
lecture
	call	RSinit
	call	RSrec
	movlw	A'a'				; test si octet reu=a
	subwf	RS_buff,w
	btfsc	STATUS,Z
	goto	lecture_1				; oui 
	goto	$-5				; non on boucle
	
lecture_1	
	bcf		LED1				; etteindre la led
	clrf  	EEprom				; reset adresse EEprom
	clrf	EEprom+1
	call	I2CSTART			; envoie Start condition
	movlw	B'10100000'	
	call	WtoI2C				; envoie adresse EEprom
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom+1,w
	call	WtoI2C    			; envoie msb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	movf	EEprom,w
	call	WtoI2C				; lsb
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
	call	I2CSTART			; envoie Start Repeat
	movlw	B'10100001'	
	call	WtoI2C				; envoie adresse EEprom avec R/W=1 pour lecture
	call	I2C_reception_ACK
	btfss 	I2CACK
	goto	$-1
boucle1
	call 	I2CtoW  			; lire la donne
	call	I2C_envoie_ACK

	call	RSsend				; envoie sur le port serie
	call	test_reception		; teste si PC est pret
	
	call	INC16				; incrementer EEprom (16bits)
	btfsc	STATUS,Z			; tester si fin de l'EEprom
	goto	fin					; oui
	goto	boucle1				; non

fin	
	call	I2C_envoie_NoACK
	call	I2CSTOP				; fin de liaison I2C

	return	
;-----------------SP test aquitement RS232--------
test_reception
	call	RSrec
	movlw	A'b'			; test si octet reu=b
	subwf	RS_buff,w
	btfsc	STATUS,Z
	return					; oui 
	goto	$-5				; non on boucle
;---------------SP mesure creneau et traitement-------------
Mesure_creneau
	BANK1
	bcf	OPTION_REG,2		; prediviseur de TMR0  16
	bsf	OPTION_REG,1
	bsf	OPTION_REG,0
	BANK0
	btfsc	SIGNAL			; tester si signal=0
	goto	$-1			; non boucler
	btfss	SIGNAL			; tester si signal=1
	goto	$-1			; non boucler
	clrf	TMR0			; effacer TMR0
	btfsc	SIGNAL			; tester si signal=0
	goto	$-1			; non boucler
	movf	TMR0,w			; TMR0 dans w
	movwf	result			; w dans result	
	return				; fin de routine
;*****************
Test_pos_inter
	movlw	D'94'			; w=94
	subwf	result,w		; w=result-w
	btfsc	STATUS,C
	goto	result_plus
	goto	result_moins

result_plus
	bsf	BP_Lecture
	return
result_moins
	bcf 	BP_Lecture
	return
;*****************
Comparaison_BP
	btfss	BP_Memoire	
	goto	$+5
; cas memoire BP=1
	bsf	BP_On				; pour BP actionn
	btfsc	BP_Lecture		; est ce que BP_Lecture=BP_Memoire
	bcf	BP_On				; oui donc BP_On =1	
	return	

; cas memoire BP=0
	bsf	BP_On				; pour BP actionn
	btfss	BP_Lecture		; est ce que BP_Lecture=BP_Memoire
	bcf	BP_On				; oui donc BP_On =0
	return 
;*****************
Test_presence_modulation
	bcf	MODUL			; effacer le flag de presence modulation
	BANK1
	bsf	OPTION_REG,2		; prediviseur de TMR0  128
	bsf	OPTION_REG,1
	bcf	OPTION_REG,0
	BANK0
	clrf	TMR0			; reset de TMR0

	bcf	INTCON,T0IF		; effacer le flag
	btfss	SIGNAL			; tester si signal=1
	goto	$+2				; non suite boucle
	goto	Modulation_presente	; oui alors fin de test
	btfss	INTCON,T0IF		; tester debordement
	goto	$-4				; non boucler
	goto	Pas_de_modulation
	
Modulation_presente
	bsf	MODUL	
	return				; retour avec flag modulation  1
Pas_de_modulation
	bcf	MODUL	
	return				; retour avec flag modulation  0


;----------------SP tempo-------------------------
;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 13/03/2009 at 04:32:01
; Description: Waits 22 cycles 22s
;-------------------------------------------------------------
tem22us movlw     .4        ; 1 set number of repetitions
        movwf     PDel0     ; 1 |
PLoop0  clrwdt              ; 1 clear watchdog
        decfsz    PDel0, 1  ; 1 + (1) is the time over?
        goto      PLoop0    ; 2 no, loop
        clrwdt              ; 1 cycle delay
        return              ; 2+2 Done
;-------------------------------------------------------------
;----------Tempo 4 secondes-----------------------------------
;-------------------------------------------------------------

tempo_4s
	movlw	.255	
	movwf	count
	call	tem15ms
	decfsz	count,f	
	goto	$-2
	return

;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 20/03/2009 at 03:35:44
; Description: Waits 15000 cycles  15ms
;-------------------------------------------------------------
tem15ms  movlw     .21       ; 1 set number of repetitions (B)
        movwf     PDel0     ; 1 |
PaLoop1  movlw     .142      ; 1 set number of repetitions (A)
        movwf     PDel1     ; 1 |
PaLoop2  clrwdt              ; 1 clear watchdog
        clrwdt              ; 1 cycle delay
        decfsz    PDel1, 1  ; 1 + (1) is the time over? (A)
        goto      PaLoop2    ; 2 no, loop
        decfsz    PDel0,  1 ; 1 + (1) is the time over? (B)
        goto      PaLoop1    ; 2 no, loop
        clrwdt              ; 1 cycle delay
        return              ; 2+2 Done
;-------------------------------------------------------------




	#include 	i2c.asm
	#include 	rs232.asm
	#include	adition_16bits.asm
	END 				; directive fin de programme

