;;********************************************************************
;               ROUTINES POUR GERER UN BUS I2C                       *
;              sur des pics dont l'horloge est  4MHz                *
;        pour une frequence SCL d'environ 100 KHz (5s+5s)          *
;            3 variables  declarer I2C_VAR1 ,I2C_VAR2               *
;   et flag dont le bit 0 (I2CACK) correspond  l'aquitement         *
;  definir SDA et SCL par ex: #DEFINE	SDA	PORTB,0              *
;                             #DEFINE	SCL	PORTB,1              *
;                             #DEFINE   I2CACK   flag,0              *
; toutes les sorties peuvent etre utilisees sans risque              *
; de court circuit car  1 les I/O sont en entres (haute impedance) *
; faire un #include	i2c.asm juste avant l'instruction END        *
; ecrit par Gilles Chevalerias Email: gilles.chevalerias@Ifrance.com *
; sur la base de la routine ecrite par Pierre COL                    *
;*********************************************************************
	
SDA_1	macro			; sortie SDA en entre
	banksel	H'85'		; on passe en bank1 valable pour les pics 16XXX et 12XXX
	bsf	SDA
	banksel	H'05'
	endm

SDA_0	macro			; sortie SDA en sortie  0
	banksel	H'85'		; on passe en bank1 valable pour les pics 16XXX et 12XXX
	bcf	SDA
	banksel	H'05'
	bcf	SDA
	endm

SCL_1	macro			; sortie SCL en entre
	banksel	H'85'		; on passe en bank1 valable pour les pics 16XXX et 12XXX
	bsf	SCL
	banksel	H'05'
	endm


SCL_0	macro			; sortie SCL en sortie  0
	banksel	H'85'		; on passe en bank1 valable pour les pics 16XXX et 12XXX
	bcf	SCL
	banksel	H'05'
	bcf	SCL
	endm

;********************************************************
;              initialise le port I2C		        *
;     et verifie que les lignes sont libres ( 1)       *
;        si les lignes sont occupes on attend          *
;               quelles se liberent                     *
;  c'est ici que l'on doit gerer un mode multi maitres  *
;********************************************************
;
I2C_INIT
	
	SCL_1				; Initialiser a '1' les
	SDA_1				; deux lignes du bus I2C
	btfss	SCL			; tester si les lignes sont
	goto	$-1			; libres si non attendre leurs
	btfss	SDA			; liberations
	goto	$-3
	clrf	flag
	RETURN

;********************************************************
;   Envoie une sequence 'START' au peripherique I2C     *
;********************************************************
I2CSTART
	BSF       SCL			; Au debut, SCL
	SDA_1				; et SDA sont a '1'
	CALL      Tempo5us		; On attend 5 us
	SDA_0				; puis SDA passe a '0'
	CALL      Tempo5us		; puis on attend 5 us
	SCL_0				; puis SCL passe a '0'
	CALL      Tempo5us		; puis on attend 5 us
	SDA_1 				; SDA doit etre remis a '1' pour pouvoir
	RETURN              		; voir les donnees venant de la memoire.

;********************************************************
;   Envoie une sequence 'STOP' au peripherique I2C      *
;********************************************************
I2CSTOP 
	SDA_0				; Au debut SDA est  0
	SCL_1				; et SCL  1
	CALL      Tempo5us		; On attend 5 s
	SDA_1				; puis SDA passe a '1'
	CALL      Tempo5us		; On attend 5 s
	GOTO      Tempo5us		; on attend 5 s le return est dans la tempo



;**************************************************************************
;  Verifie si le peripherique I2C renvoie un 'Acknowledge' ; si celui-ci  *
;  est present, le bit I2CACK est mis a '1', sinon I2CACK est mis a '0'.  *
;       (la seule variable modifiee est flag)                             *
;**************************************************************************
I2C_reception_ACK     
	SDA_1				; On s'assure que SDA est a '1'.
	SCL_0			  	; On genere l'impulsion positive
	CALL      Tempo5us		; sur SCL : SCL a '0', attente de 5s
	SCL_1				; SCL a '1', attente de 5 s.
	CALL      Tempo5us		; La, on va lire la valeur de SDA :
	BCF       I2CACK		; On met le bit I2CACK a '0'.
	BTFSS     SDA			; On verifie l'ACK (SDA a '0' ?)
	BSF       I2CACK		; si oui, OK: on met I2CACK a '1'.
	SCL_0				; Puis SCL repasse a '0'.
	RETURN				; Et la routine est terminee...


;*****************************************************
;  Envoie un bit 'Acknowledge' au peripherique I2C.  *
;*****************************************************
I2C_envoie_ACK     
	SCL_0				; au debut, SCL est a '0'.
	SDA_0				; SDA est mis a '0' (on applique ACK).
	CALL      Tempo5us		; on attend 5 us.
	SCL_1				; Impulsion positive sur SCL :
	CALL      Tempo5us		; SCL passe a '1' pendant
	SCL_0				; 5 us, puis repasse a '0'.
	SDA_1				; Il faut penser a remettre SDA a '1' !
	RETURN 				; Fin de la routine, retour au programme principal.

;****************************************************
;  Envoie un 'No Acknowledge' au peripherique I2C.  *
;****************************************************
I2C_envoie_NoACK
	SCL_0				; au debut, SCL est a '0'
	SDA_1				; et SDA a '1' (car pas d'ACK).
	CALL      Tempo5us		; on attend 5 s.
	SCL_1				; Impulsion positive sur SCL :
	CALL      Tempo5us		; SCL passe a '1' pendant
	SCL_0			  	; 5 s, puis repasse a '0'.
	RETURN 				; Fin de la routine, retour au programme principal.

;********************************************************************
;  Envoie un octet contenu dans W au peripherique I2C en 'serie' :  *
;  (attention, cela modifie les variables VAR1 et VAR2)             *
;********************************************************************
; L'octet a envoyer est mis dans VAR1 ; on va alors faire subir 8 fois
; a cet octet un decalage vers la gauche, en recopiant a chaque fois au
; prealable le bit B7 sur la broche SDA (avant d'appliquer une impulsion
; d'horloge sur SCL). La variable VAR2 sert de compteur : elle part de 8
; et est decrementee 8 fois jusqu' 0 afin de compter le nombre de
; decalages :
WtoI2C        
	MOVWF     I2C_VAR1		; Octet a envoyer mis dans VAR1.
	MOVLW     8			; 8 (nb de decalages) dans VAR2.
	MOVWF     I2C_VAR2		;
NextBit1 
	SCL_0				; SCL mis a '0'.
	BTFSS     I2C_VAR1,7		; Bit B7 de VAR1 a '1' ?
	goto	$+2
	goto	a1
	SDA_0				; si non : mettre SDA a '0'.
a1	BTFSC     I2C_VAR1,7		; Bit B7 de VAR1 a '0' ?
	goto	$+2
	goto	a2
	SDA_1				; si oui : mettre SDA a '1'.
a2	CALL      Tempo5us		; On applique l'impulsion sur SCL :
	SCL_1				; attente 5 us, SCL passe a '1',
	CALL      Tempo5us		; attente 5 us, SCL repasse a '0'.
	SCL_0				;
	RLF       I2C_VAR1,F		; On decale VAR1 un coup a gauche.
	DECFSZ    I2C_VAR2,F		; On decremente VAR2 ; si ce n'est
	GOTO      NextBit1		; pas la 8ieme fois, on recommence.
	SDA_1				; On remet SDA a '1' (ce qui permet
	RETURN				; de scruter SDA comme une entree).

;***************************************************************
;  Lit un octet depuis le peripherique I2C et le met dans W :  *
;  (attention, cela modifie les variables VAR1 et VAR2)        *
;***************************************************************
; Cette routine ressemble beaucoup a la precedente ; mais au lieu
; de recopier le bit B7 sur SDA et de decaler l'octet vers la gauche
; et ce huit fois de suite, on commence par decaler l'octet, puis on
; recopie SDA sur B0, toujours huit fois de suite. Les bits ne sont
; plus retires un a un, mais au contraire empiles les uns apres les
; autres dans VAR1 :
I2CtoW        
	MOVLW     8			; On met 8 dans VAR2, variable compteur
	MOVWF     I2C_VAR2		; qui va comptabiliser les 8 decalages.
	CLRF      I2C_VAR1		; VAR1 initialisee a 0 (= 00000000b).
NextBit2  
	SCL_0				; SCL mis a '0'.
	SDA_1				; SDA mis a '1' pour etre 'lisible'.
	CALL      Tempo5us		; attente de 5 s.
	SCL_1				; SCL passe a '1'.
	CALL      Tempo5us		; attente de 5 s.
	RLF       I2C_VAR1,F		; decalage de un coup vers la gauche.
	BCF       I2C_VAR1,0		; bit B0 initialise a '0'.
	BTFSC     SDA			; on teste SDA : vaut-il '0' ?
	BSF       I2C_VAR1,0		; si non (SDA='1'), on met B0 a '1'.
	DECFSZ    I2C_VAR2,F		; huitieme cycle ?
	GOTO      NextBit2		; si non, on reboucle : cycle suivant.
	SCL_0				; apres le dernier cycle : SCL a '0'.
	MOVF      I2C_VAR1,W		; VAR1 (l'octet lu) est copie dans W.
	RETURN				; Fin de la routine


;*****************************************************
;  Temporisation de 5 micro-secondes pour respecter  *
;  les temps d'acces au peripherique I2C.            *
;*****************************************************
Tempo5us
	NOP       			; La tempo dure 5 s, avec le "CALL Tempo5us".
	RETURN    			; (CALL=2s) + (NOP=1s) + (RETURN=2s) = 5 s.
