 ;					
; 				SURVEILLANCE BATTERIES CAMPING-CAR
;
;	
;    NOM			:		surv_bat.asm
;    Projet			:		
;    fichier travail:  	
;    Date			:       vendredi 5 mars 2010   12h15
;    Version		:   	V.01                                                  
;    Auteur			:  		CAPAMINODE
;    Commentaires  	:   		
;
;
;
;
;
;
;*****************************************************************************************
;    Fichier requis: P16F648A.inc 
;*****************************************************************************************
 
	LIST      p=16F648A           ; Dfinition de processeur
	#include <p16F648A.inc>       ; Dfinitions des constantes

	__CONFIG _CP_OFF & _BODEN_OFF & _PWRTE_ON  & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT

;_CP_OFF   : pas de protection du code
;_BODEN_ON : reset du PIC si tension alim en dessous seuil ?
;_WDT_OFF  : pas de watchdog
;_PWRTE_ON : attendre 72ms aprs mise sous tension
;_LVP_OFF  : pas de mode programmation basse tension
;_MCLRE_ON : reset du PIC lors de la mise sous tension
;_MCLRE_OFF: reset du PIC en interne, RA5 est configure en entre
;_XT_OSC   : quartz 2 et 4 MHz
;_HS_OSC   : quartz 8 et 16 MHz
;_INTRC_OSC_NOCLKOUT : oscillateur interne

	ERRORLEVEL	-302
	ERRORLEVEL	-305
	ERRORLEVEL	-306
;*********************************************************************
;                        ASSIGNATIONS                          
;*********************************************************************

OPTIONVAL	EQU	b'11000111'		; Rsistances pull-up dsatives(1)/actives(0)
								; Interrupt flanc montant RB0 (1)
								; Prscaler sur timer  256 (0111)
								; Prscaler timer  256 
								; RBPU (bit7) dsactivation auto quand le PORT est en sortie
STATUS_val	equ	b'00000000'
INTCON_val	equ	b'11000000' 	;interr comparateur autorise (bit 6)
TRISA_val	equ	b'00000011'
TRISB_val	equ	b'00000000'
PCON_val	equ	b'00001000'	
PIE1_val	equ	b'01000000'		;autorisation interr comparateur(bit 6)
PIR_val		equ	b'00000000'		;tat flag interr comparateur (bit 6)
CMCON_val	equ	b'00000010'		;configuration 2 comparateurs 4 entres multiplexs
VRCON_val	equ	b'10101010'		;rfrence = 2,08 V

;**************************************
;		DEFINE
;**************************************

#define	sortieC1			CMCON,6
#define	sortieC2			CMCON,7
#define	V1					PORTB,1
#define	V2					PORTB,2

;**************************************
;		MACRO
;**************************************

bank0	macro
		bcf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank1	macro
		bsf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank2	macro
		bcf	STATUS,RP0
		bsf	STATUS,RP1
		endm

bank3	macro
		bsf	STATUS,RP0
		bsf	STATUS,RP1
		endm	


					
;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

;exemples
;---------

	CBLOCK 0x20   		; dbut de la zone variables
	w_temp			:1
	status_temp 	:1		; zone de 1 byte
	PDel0			:1
	PDel1			:1


	ENDC
;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

			org 	0x000 		; Adresse de dpart aprs reset
	    	goto	init		; Adresse 0: initialiser

;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 	0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp
	
	;+++++++++++++++++++++++++++++++++++++++++++


	movf	CMCON,0
	andlw	b'11000000'
	movwf	PORTB
	bank0
	bcf		PIR1,6		;effacer le flag interruption comparateur


	;+++++++++++++++++++++++++++++++++++++++++++

			;restaurer registres
			;-------------------
fin_interr	swapf	status_temp,w	
			movwf	STATUS	 
			swapf	w_temp,f	           	
			swapf	w_temp,w
			retfie  	

;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

init	bank1				; slectionner banque 1
		clrf	EEADR		; permet de diminuer la consommation
		movlw	OPTIONVAL	; charger masque
		movwf	OPTION_REG	; initialiser registre option
		movlw	b'00101111'
		movwf	TRISA
		movlw	TRISB_val
		movwf	TRISB
		movlw	PIE1_val
		movwf	PIE1
		bank0				; Slectionner banque 0
		clrf	PORTA		; Sorties portA  0
		clrf	PORTB		; sorties portB  0
		movlw	INTCON_val	; masque interruption
		movwf	INTCON		; charger interrupt control
;**************************  effacement de toute la RAM  **************************
init1	movlw	0x20
		movwf	FSR
ini		clrf	INDF
		incf	FSR,1
		movlw	0x80
		subwf	FSR,0
		btfss	STATUS,Z
		goto	ini		
		
;**************************  fin d'effacement de la RAM  **************************


;******  configurer module comparateur  ******

	bank0
	movlw	b'00000010'
	movwf	CMCON	
	call	t3ms

	bank1
	movlw	b'00000011'
	movwf	TRISA
	movlw	b'00000000'
	movwf	TRISB
	
;*********  configurer rfrence tension  **********
		movlw	0xA6				;rglage Vrf  2,08 Volts  (b'10101010')
		movwf	VRCON			
		bcf		STATUS,RP0
		call	t3ms
;***************************************************

loop	nop
		goto	loop




;&&&&&&&&&&&&&&&&&&&&&&&&&&& TEMPORISATIONS &&&&&&&&&&&&&&&&&&&&&&&&&&&
;--- 3ms avec 4  et  186

		
t3ms	movlw   4        
        movwf   PDel0      
t3ms1   movlw   186    
        movwf   PDel1      
t3ms2   clrwdt               
        decfsz  PDel1,1   
        goto    t3ms2     
        decfsz  PDel0,1  
        goto    t3ms1     
t3ms3   goto	t3ms4          
t3ms4	clrwdt               
        return               
        


	END

