;This software is licensed under the GNU GPLv3.
;(c) 2009 Jeroen Domburg

;We're using a tiny13 here.
.device ATTiny13
;You might want to include the ATTiny13-definitions included with
;your assembler. I use gavrasm, which doesn't need them.
;.include "tn13def.h"

;The fuses should be configured as follows:
;FUSE_L=0x7a
;FUSE_H=0xFf

;Port declarations
.equ rxpin	=	4
.equ txpin	=	3
.equ accelx	=	2
.equ accely	=	3
.equ accelz	=	4
.equ scl	=	1
.equ sda	=	0

;adc equivalents
.equ adc_x	=	1
.equ adc_y	=	2
.equ adc_z	=	3

;registers
.def temp	=	R16 	;The temp register
.def temp2	=	R17 	;Second temp register
.def temp3	=	R18
.def baudwaitl	=	r24
.def baudwaith	=	r25
.def ylo	=	r28
.def yhi	=	r29
.def zlo	=	r30
.def zhi	=	r31

	rjmp start		; reset vector
	reti			; External Int 0 not enabled
	reti			; Pin Change int 0 not enabled
	reti			; Timer 0 Overflow Int not enabled
	reti			; Eeprom ready not enabled
	reti			; Anacomp interrupt Not enabled
	reti			; Timer 0 comparator A not enabled
	reti			; Timer 0 comparator B not enabled
	reti			; ADC conversion complete Not enabled


start:
	ldi temp,RAMEND		; top of memory
	out SPL,temp		; init stack pointer
	ldi temp,0b00011	; Port B direction options
	out DDRB,temp		; Setup port direction
	ldi temp,0b00011
	out PORTB,temp
	
	;Initialize i2c bus
	ldi temp,0xff
	rcall i2csendb
	ldi temp,0xff
	rcall i2csendb
	rcall i2cstop
	rcall i2cstart
	rcall i2cstop

	
mainloop:
	;Enable uart and do autobaud.
	sbi ddrb,txpin
	sbi portb,txpin
	rcall autobaud

	;Autobaud succeeded. Now write out all data contained in the
	;EEPROM.
	ldi ylo,0
	ldi yhi,0

	rcall i2cstart
	ldi temp,0xA0 ;write
	rcall i2csendb
	mov temp,yhi
	rcall i2csendb
	mov temp,ylo
	rcall i2csendb
	rcall i2cstop
readout:
	rcall i2cstart
	rcall i2cstop
	rcall i2cstart
	ldi temp,0xA1 ;read
	rcall i2csendb

	mov temp,yhi
	rcall sendhex
	mov temp,ylo
	rcall sendhex
	ldi temp,':'
	rcall uartsend
	rcall i2crecvb
	rcall sendhex
	rcall i2crecvb
	rcall sendhex
	ldi temp,','
	rcall uartsend
	rcall i2crecvb
	rcall sendhex
	rcall i2crecvb
	rcall sendhex
	ldi temp,','
	rcall uartsend
	rcall i2crecvb
	rcall sendhex
	rcall i2crecvb
	rcall sendhex
	rcall i2cstop
	ldi temp,13
	rcall uartsend
	ldi temp,10
	rcall uartsend
	
	adiw ylo,6
	cpi yhi,0x80
	brne readout

	;Ok, all data has been written. Autobaud a second time, which basically
	;amounts to waiting for a character before starting to record accel-data.
	rcall autobaud

	;Indicate we're recording now.
	ldi temp,'R'
	rcall uartsend
	ldi temp,'E'
	rcall uartsend
	ldi temp,'C'
	rcall uartsend

	;Disable uart so we can use the pins as analog input pins again
	cbi ddrb,txpin
	cbi portb,txpin

	;Read 32k worth of data and stuff it into the eeprom.
	ldi ylo,0
	ldi yhi,0
writeloop:
	ldi temp,adc_x
	rcall measure_axis
	rcall i2cstart
	rcall i2cstop
	rcall i2cstart
	ldi temp,0xA0 ;write
	rcall i2csendb
	mov temp,yhi
	rcall i2csendb
	mov temp,ylo
	rcall i2csendb
	mov temp,zhi
	rcall i2csendb
	mov temp,zlo
	rcall i2csendb
	adiw ylo,2
	rcall i2cstop

	ldi temp,adc_y
	rcall measure_axis
	rcall i2cstart
	rcall i2cstop
	rcall i2cstart
	ldi temp,0xA0 ;write
	rcall i2csendb
	mov temp,yhi
	rcall i2csendb
	mov temp,ylo
	rcall i2csendb
	mov temp,zhi
	rcall i2csendb
	mov temp,zlo
	rcall i2csendb
	adiw ylo,2
	rcall i2cstop

	ldi temp,adc_z
	rcall measure_axis
	rcall i2cstart
	rcall i2cstop
	rcall i2cstart
	ldi temp,0xA0 ;write
	rcall i2csendb
	mov temp,yhi
	rcall i2csendb
	mov temp,ylo
	rcall i2csendb
	mov temp,zhi
	rcall i2csendb
	mov temp,zlo
	rcall i2csendb
	adiw ylo,2
	rcall i2cstop

	cpi yhi,0x80
	brne writeloop
	
	;All done.
	rjmp start


;Send an i2c start condition
i2cstart:
	sbi ddrb,sda
	cbi portb,sda
	rcall i2cw
    	cbi portb,scl
	rcall i2cw
	ret

;Send an i2c stop condition
i2cstop:
	sbi ddrb,sda
	cbi portb,sda
	sbi portb,scl
	rcall i2cw
	sbi ddrb,sda
	sbi portb,sda
	rcall i2cw
	ret
	
;Receive a byte via i2c
i2crecvb:
	push temp2
	sbi portb,sda
	cbi ddrb,sda

	ldi temp2,8
	ldi temp,0
i2crloop:
	sbi portb,scl
	rcall i2cw

	lsl temp
	sbic pinb,sda
	 ori temp,1

	cbi portb,scl
	rcall i2cw
	
	dec temp2
	brne i2crloop

	;Send the ack.
	sbi ddrb,sda
	cbi portb,sda
	rcall i2cw

	sbi portb,scl
	rcall i2cw

	cbi portb,scl
	sbi ddrb,sda
	sbi portb,sda

	pop temp2
	ret

;Send a byte via i2c
i2csendb:
	push temp2
	sbi ddrb,sda

	ldi temp2,8
i2csloop:
	sbi ddrb,sda
	cbi portb,sda
	sbrc temp,7
	 sbi portb,sda

	rcall i2cw
	sbi portb,scl
	rcall i2cw

	cbi portb,scl
	rcall i2cw
	
	lsl temp
	dec temp2
	brne i2csloop
	
	;Receive ack
	sbi portb,sda
	cbi ddrb,sda
	rcall i2cw

	sbi portb,scl
	rcall i2cw

	ldi temp,1
	sbic pinb,sda
	 ldi temp,0

	cbi portb,scl
	rcall i2cw

	pop temp2
	ret

;Wait about 0.1 ms
i2cw:
	push temp
	ldi temp,32
i2cwl:
	dec temp
	brne i2cwl
	pop temp
	ret
	

;Measures the value of an axis, a few times to compensate for
;the missing Cs on the input pins :X. ADC-pin of the accelleration sensor for
;that axis is in temp.
measure_axis:
	out ADMUX,temp
	ldi zlo,0
	ldi zhi,0
	ldi temp2,64
measure_once_more:
	ldi temp,0xC7
	out ADCSRA,temp
measurewait:
	sbic ADCSRA,6
	 rjmp measurewait

	in temp,ADCL
	add zlo,temp
	in temp,ADCH
	adc zhi,temp
	
	dec temp2
	brne measure_once_more
	ret

;Sends the hex byte in temp to the 'uart'.
sendhex:
	push temp
	push temp
	swap temp
	andi temp,0xf
	rcall convnibble
	rcall uartsend
	pop temp
	andi temp,0xf
	rcall convnibble
	rcall uartsend
	pop temp
	ret

convnibble:
	cpi temp,0xA
	brlo convnibblenum
	subi temp,-'A'+10
	ret
convnibblenum:
	subi temp,-'0'
	ret


;Routine to autobaud the sw uart routines. This measures usually the start bit
;of the connection. This depends on the received character being one with a set
;lsb. 'c' will work.
autobaud:
	ldi baudwaith,0
	ldi baudwaitl,0
	;Wait for pin to go low
abpinlow:
	sbic pinb,rxpin		;2 if skipped
	 rjmp abpinlow
	
	;Time duration. This routine will pick up anything down to 24 baud.
abdo:
	adiw baudwaitl,1	;2c
	nop			;1c
	sbis pinb,rxpin		;1c if no skip
	 rjmp abdo		;2c

	;A bit-time will now be measured to have cost
	; (baudwait*6)+2 cycles.

	;Reject everything under ca 1000 baud.
	cpi baudwaith,0x8
	brsh autobaud
	
	ret

;Send one byte (in temp) as a software uart over the txpin line.
uartsend:
	push zlo
	push zhi
	push temp
	push temp2
	cbi portb, txpin
	rcall uartwait
	nop			;1c
	nop			;1c
	nop			;1c
	ldi temp2,8		;1c
uartsendloop:
	cbi portb,txpin		;1c
	sbrc temp,0		;1c
	 sbi portb,txpin	;1c
	rcall uartwait
	lsr temp		;1c
	dec temp2		;1c
	brne uartsendloop	;2c
	
	nop			;1
	nop			;1
	sbi portb,txpin		;1
	;2 stopbytes to give the uart on the other side some
	;extra breathing room to cope with speed variations on
	;our side
	rcall uartwait
	rcall uartwait
	pop temp2
	pop temp
	pop zhi
	pop zlo
	ret


uartrecv:
	;ToDo: Write this :X
	ret

;Wait one bit length, with 7 cycles to spare. Kills zlo/zhi
uartwait: ;The rcall/ret-pair will cost us 7 cycles
	mov zlo,baudwaitl	;1c
	mov zhi,baudwaith	;1c
	sbiw zlo,3		;2c
	nop			;1c
	nop			;1c
	
waituartl:
	nop			;1c
	nop			;1c
	sbiw zlo,1		;2c
	brne waituartl		;2c

	ret


