//************************************************************************************
//**  
//**  File name:     C:\Documents and Settings\IgiX\Bureau\BAC\RS232.c
//**  Generated by:  Flowcode v3.1.0.31
//**  Date:          Sunday, April 18, 2010 09:24:46
//**  Licence:       Professional
//**  Registered to: ECHO, d.o.o.
//**  
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


//Dfinir pour microcontrleur
#define P18F4620
#define MX_EE
#define MX_EE_TYPE3
#define MX_EE_SIZE 1024
#define MX_SPI
#define MX_SPI_C
#define MX_SPI_SDI 4
#define MX_SPI_SDO 5
#define MX_SPI_SCK 3
#define MX_UART
#define MX_UART_C
#define MX_UART_TX 6
#define MX_UART_RX 7
#define MX_I2C
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 4
#define MX_I2C_SCL 3
#define MX_PWM
#define MX_PWM_PORT portc
#define MX_PWM_TRIS trisc
#define MX_PWM_CNT 2
#define MX_PWM_1 2
#define MX_PWM_2 1

//Fonctions
#include <system.h>
#pragma CLOCK_FREQ 10000000

//Configuration de donnes

//Fonctions internes
#include "C:\Program Files\Matrix Multimedia\Flowcode V3\FCD\internals.h"

//Dclarations de fonction Macro
void FCM_recherche_donnees();
void FCM_envoie_donnees();


//Dclarations de Variable
#define FCSZ_STR_VAL_PANNE 5
#define FCSZ_A_ENVOYER 60
#define FCSZ_ENVOIE_ENCOURS 2
#define FCSZ_PANNE_LETTRE 14
char FCV_STR_VAL_PANNE[FCSZ_STR_VAL_PANNE];
char FCV_NUM_PANNE;
char FCV_VAL_PANNE;
char FCV_ADDR_EEPROM[14];
char FCV_A_ENVOYER[FCSZ_A_ENVOYER];
char FCV_ENVOIE_LIGNE_ENCOURS;
char FCV_ENVOIE_ENCOURS[FCSZ_ENVOIE_ENCOURS];
char FCV_PANNE_LETTRE[FCSZ_PANNE_LETTRE];

char FCLV_LOOP1;



//EEPROM0: //Dclarations de fonction Macro

char FCD_EEPROM0_EEPROMRead(char addr);
void FCD_EEPROM0_WriteEEPROM(char addr, char data);


//RS2320: //Dclarations de fonction Macro

void FCD_RS2320_SendRS232Char(char Char);
char FCD_RS2320_ReceiveRS232Char(char timeout);

//Dfinitions supplmentaires


//Implmentations Macro

void FCM_recherche_donnees()
{
	
	//Commentaire:
	//Initialisation
	//a_envoyer / panne_lettre /
	//addr_eeprom / num_panne


	//
	//Manipulation de chane de caractres:
	//  a_envoyer = ""
	//  panne_lettre = "_ABCDEFGHIJKXY"
	FCI_CONCATENATE("",0,"",0,FCV_A_ENVOYER,FCSZ_A_ENVOYER);
	FCI_CONCATENATE("_ABCDEFGHIJKXY",14,"",0,FCV_PANNE_LETTRE,FCSZ_PANNE_LETTRE);
	

	//
	//Calcul:
	//  addr_eeprom[0] = 0
	//  addr_eeprom[1] = 1
	//  addr_eeprom[2] = 2
	//  addr_eeprom[3] = 3
	//  addr_eeprom[4] = 4
	//  addr_eeprom[5] = 5
	//  addr_eeprom[6] = 6
	//  addr_eeprom[7] = 7
	//  addr_eeprom[8] = 8
	//  addr_eeprom[9] = 9
	//  addr_eeprom[10] = 10
	//  addr_eeprom[11] = 11
	//  addr_eeprom[12] = 100
	//  addr_eeprom[13] = 200
	//  num_panne = 0
	FCV_ADDR_EEPROM[0] =  0 ;
	FCV_ADDR_EEPROM[1] =  1 ;
	FCV_ADDR_EEPROM[2] =  2 ;
	FCV_ADDR_EEPROM[3] =  3 ;
	FCV_ADDR_EEPROM[4] =  4 ;
	FCV_ADDR_EEPROM[5] =  5 ;
	FCV_ADDR_EEPROM[6] =  6 ;
	FCV_ADDR_EEPROM[7] =  7 ;
	FCV_ADDR_EEPROM[8] =  8 ;
	FCV_ADDR_EEPROM[9] =  9 ;
	FCV_ADDR_EEPROM[10] =  10 ;
	FCV_ADDR_EEPROM[11] =  11 ;
	FCV_ADDR_EEPROM[12] =  100 ;
	FCV_ADDR_EEPROM[13] =  200 ;
	FCV_NUM_PANNE =  0 ;
	

	//Commentaire:
	//Boucle pour
	//un "scann" des erreurs


	//
	//Boucle: Boucle 13 fois
	for (FCLV_LOOP1=0; FCLV_LOOP1<13; FCLV_LOOP1++)
	{
		//Commentaire:
		//Dans l'ordre : 
		//- Incrmentation de num_panne
		//- Rcupration de la valeur panne dans val_panne
		//- complter a_envoyer


		//
		//Calcul:
		//  num_panne = num_panne + 1
		FCV_NUM_PANNE =  FCV_NUM_PANNE + 1 ;
		

		//
		//Appel de la Routine Composant: val_panne=EEPROM(0)::EEPROMRead(addr_eeprom[num_panne])
		FCV_VAL_PANNE = FCD_EEPROM0_EEPROMRead(FCV_ADDR_EEPROM[FCV_NUM_PANNE]);


		//Modification de a_envoyer
		//Manipulation de chane de caractres:
		//  str_val_panne = ToString$(val_panne)
		//  a_envoyer = a_envoyer + panne_lettre[num_panne] + str_val_panne
		FCI_TOSTRING(FCV_VAL_PANNE,FCV_STR_VAL_PANNE,FCSZ_STR_VAL_PANNE);
		FCI_CONCATENATE(FCV_A_ENVOYER,FCSZ_A_ENVOYER,(char*)&FCV_PANNE_LETTRE[FCV_NUM_PANNE],1,FCI_TMP_STR,20);
		FCI_CONCATENATE(FCI_TMP_STR,20,FCV_STR_VAL_PANNE,FCSZ_STR_VAL_PANNE,FCV_A_ENVOYER,FCSZ_A_ENVOYER);
		

	}


	//Commentaire:
	// 
	//Envoyer a_envoyer sur C6


	//Appel d'une Macro
	//Appel d'une Macro: envoie_donnees
	FCM_envoie_donnees();


}

void FCM_envoie_donnees()
{
	
	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(76)
	FCD_RS2320_SendRS232Char(76);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(69)
	FCD_RS2320_SendRS232Char(69);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(32)
	FCD_RS2320_SendRS232Char(32);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(66)
	FCD_RS2320_SendRS232Char(66);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(65)
	FCD_RS2320_SendRS232Char(65);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(67)
	FCD_RS2320_SendRS232Char(67);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(32)
	FCD_RS2320_SendRS232Char(32);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(67)
	FCD_RS2320_SendRS232Char(67);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(65)
	FCD_RS2320_SendRS232Char(65);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(32)
	FCD_RS2320_SendRS232Char(32);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(80)
	FCD_RS2320_SendRS232Char(80);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(85)
	FCD_RS2320_SendRS232Char(85);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: RS232(0)::SendRS232Char(69)
	FCD_RS2320_SendRS232Char(69);


}



//EEPROM0: //Implmentations Macro


char FCD_EEPROM0_EEPROMRead(char addr)
{
	    //GetEEPROMReadCode

	    char data = 0;
	    #ifdef MX_EE
	        eeadr = addr;
	        #ifdef MX_EE_TYPE2
	            clear_bit(eecon1, EEPGD);
	        #endif
	        #ifdef MX_EE_TYPE3
	            clear_bit(eecon1, EEPGD);
	            clear_bit(eecon1, CFGS);
	        #endif
	        set_bit(eecon1, RD);
	        data = eedata;
	    #else
	        #ifdef MX_EE_TYPE67X
	            #pragma error "FlowCode does not support EEPROM for this device"
	        #else
	            #ifdef MX_EE_TYPE62X
	                #pragma error "FlowCode does not support EEPROM for this device"
	            #else
	                #pragma error "Chip does not have EEPROM memory"
	            #endif
	        #endif
	    #endif
	    return (data);
}

void FCD_EEPROM0_WriteEEPROM(char addr, char data)
{
	    //GetEEPROMWriteCode

	    #ifdef MX_EE
	        //wait for previous EE writes to complete...
	        while (test_bit(eecon1, WR));

	        eeadr = addr;
	        eedata = data;
	        #ifdef MX_EE_TYPE2
	            clear_bit(eecon1, EEPGD);
	        #endif
	        #ifdef MX_EE_TYPE3
	            clear_bit(eecon1, EEPGD);
	            clear_bit(eecon1, CFGS);
	        #endif
	        set_bit(eecon1, WREN);
	        clear_bit(intcon, GIE);
	        eecon2 = 0x55;
	        eecon2 = 0xAA;
	        set_bit(eecon1, WR);
	        //wait for EE write to complete...
	        while (test_bit(eecon1, WR));
	        set_bit(intcon, GIE);
	        clear_bit(eecon1, WREN);
	    #else
	        #ifdef MX_EE_TYPE67X
	            #pragma error FlowCode does not support EEPROM for this device
	        #else
	            #ifdef MX_EE_TYPE62X
	                #pragma error FlowCode does not support EEPROM for this device
	            #else
	                #pragma error Chip does not have EEPROM memory
	            #endif
	        #endif
	    #endif
}



//RS2320: //Implmentations Macro


void FCD_RS2320_SendRS232Char(char Char)
{
	    //GetSendRS232CharCode

	#define fc_rsSTATUS_LOOP      0
	#define fc_rsSTATUS_TIMEOUT   1
	#define fc_rsSTATUS_RXBYTE    2


	   set_bit(txsta, TXEN);

	   while ((pir1 & (1<< TXIF)) == 0);

	   txreg = Char;
	    
}

char FCD_RS2320_ReceiveRS232Char(char timeout)
{
	    //GetReceiveRS232CharCode

	#define fc_rsSTATUS_LOOP      0
	#define fc_rsSTATUS_TIMEOUT   1
	#define fc_rsSTATUS_RXBYTE    2

	   char delay1 = 0;
	   char delay2 = 0;
	   char dummy = 0;
	   char retVal = 255;
	   char bWaitForever = 0;
	   char rxStatus = fc_rsSTATUS_LOOP;


	   if (timeout == 255)
	   {
	       bWaitForever = 1;
	   }

	   set_bit(rcsta, CREN);

	   while (rxStatus == fc_rsSTATUS_LOOP)
	   {
	       if ((pir1 & (1 << RCIF)) != 0)
	       {
	           //received a Char
	           rxStatus = fc_rsSTATUS_RXBYTE;
	       } else {
	           if (bWaitForever == 0)
	           {
	               //don't wait forever, so do timeout thing...
	               if (timeout == 0)
	               {
	                   rxStatus = fc_rsSTATUS_TIMEOUT;
	                   #ifdef fc_rs232_debug
	                       //FCD_RS2320_SendRS232Char('<');
	                       //FCD_RS2320_SendRS232Char('t');
	                       //FCD_RS2320_SendRS232Char('i');
	                       //FCD_RS2320_SendRS232Char('m');
	                       //FCD_RS2320_SendRS232Char('e');
	                       //FCD_RS2320_SendRS232Char('o');
	                       //FCD_RS2320_SendRS232Char('u');
	                       //FCD_RS2320_SendRS232Char('t');
	                       //FCD_RS2320_SendRS232Char('>');
	                   #endif
	               } else {
	                   //decrement timeout
	                   delay1--;
	                   if (delay1 == 0)
	                   {
	                           timeout--;
	                   }
	               }
	           }
	       }
	   }

	   if (rxStatus == fc_rsSTATUS_RXBYTE)
	   {
	       if ((rcsta & (1 <<FERR)) != 0)
	       {
	           dummy = rcreg;      //need to read the rcreg to clear FERR
	           #ifdef fc_rs232_debug
	               FCD_RS2320_SendRS232Char('<');
	               FCD_RS2320_SendRS232Char('F');
	               FCD_RS2320_SendRS232Char('E');
	               FCD_RS2320_SendRS232Char('R');
	               FCD_RS2320_SendRS232Char('R');
	               FCD_RS2320_SendRS232Char('>');
	           #endif
	       } else {
	       if ((rcsta & (1 << OERR)) != 0)
	           {
	               //need to read the rcreg to clear error
	               clear_bit(rcsta, CREN);
	               set_bit(rcsta, CREN);
	               #ifdef fc_rs232_debug
	                   FCD_RS2320_SendRS232Char('<');
	                   FCD_RS2320_SendRS232Char('O');
	                   FCD_RS2320_SendRS232Char('E');
	                   FCD_RS2320_SendRS232Char('R');
	                   FCD_RS2320_SendRS232Char('R');
	                   FCD_RS2320_SendRS232Char('>');
	               #endif
	           } else {
	               retVal = rcreg; //no error, so rx byte is valid
	               #ifdef fc_rs232_echo
	                   FCD_RS2320_SendRS232Char(retVal);
	               #endif
	           }
	       }
	   }


	   return (retVal);
}

//Installation supplmentaire


void main()
{
	
	//Initialisation
	adcon1 = 0x0F;

	 	   // RS232 initialiasation code

	#define fc_rsSTATUS_LOOP      0
	#define fc_rsSTATUS_TIMEOUT   1
	#define fc_rsSTATUS_RXBYTE    2

	   txsta = 4; // 8-bit, async, low speed, off
	   spbrg = 64; // set the baud rate
	   rcsta = 0;              // 8-bit, disabled
	   set_bit(rcsta, SPEN);   // turn on serial interface
	 

	//Code d'initialisation d'Interruption
	


	//Boucle
	//Boucle: Tant que1
	while( 1 )
	{
		//Sortie
		//Sortie: 134 -> PORT D
		trisd = 0x00;
		portd = 134;


		//Envoie des donnes
		//Appel d'une Macro: recherche_donnees
		FCM_recherche_donnees();


	}


	mainendloop: goto mainendloop;
}

void interrupt(void)
{
	 
}

