#include <p18f2550.h>
#include "i2c.h"
#include "usart.h"
#include "fonctionP2.h"

void init(void)
{
int etat_synchro;
//initialisation PORTA,B,C
TRISA=0x8f; //10001111 et 0=sortie et 1=entree  
PORTA=0x0;
TRISB=0xc7; //11000111
PORTB=0x10; //00010000
TRISC=0x90; //10010000
PORTC=0x0;  //00000000

//////////PORT I2C///////////////////////////////////////////////
OSCCON  = 0b01110000; //Horloge interne 8Mhz
OSCTUNE = 0b10000000; //Horloge regle a 8Mhz
SSPCON1 = 0b00101011;// 0. Global configuration of PIC for i2c protocol
SSPSTAT = 0;
//SSPADD =  0x63; //si quartz
SSPCON2bits.SEN = 1;// 1. Assert a Start condition on SDA and SCL.
while (SSPCON2bits.SEN);
SSPBUF  = 0b00001111;// 3. Write to the SSPBUF register initiating transmission of data/address.
SSPCON2 = 0b00010000;// 5. Generate an Acknowledge condition at the end of a received byte of data.
SSPCON2 = 0b00000100;// 6. Generate a Stop condition on SDA and SCL.

//////////PORT UART////////////////////////////////////////////
TXSTA = 0b00100100;
RCSTA = 0b10000000;
etat_synchro = 0;
}



void antirebond(unsigned int temps)
{
	while (temps--); //anti-rebond de 100 ms
}



int num_module(void)
{
int SWITCH1,SWITCH2,SWITCH3,val_module;
//portA1
	if (PORTA & 0x10)
		{
		SWITCH1=0x10; 
		}
	else SWITCH1=0;

//portA2
	if (PORTA & 0x20)
		{
		SWITCH2=0x20; 
		}
	else SWITCH2=0;

//portA3
	if (PORTA & 0x40)
		{
		SWITCH3=0x40; 
		}
	else SWITCH3=0;		
	val_module=SWITCH3+SWITCH2+SWITCH1;
	return val_module;//renvoie du numero de module
}


int synchro1 (void)
{
int bit_synchro,etat_synchro;
//portA4
	if (PORTA & 0x01)
		{
		antirebond(1000);//tempo pour anti-rebond 10 ms
		if (PORTA & 0x01)
			{
			bit_synchro=1;
			PORTB = PORTB |0x20; //la led synchronisation s'allume
			}
		else bit_synchro=0;
		}	
	else bit_synchro =0;
	etat_synchro =1;
	return bit_synchro;
}

int synchro0 (void)
{
int bit_synchro,etat_synchro;
//portA4
	if (PORTA & 0x01)
		{
		antirebond(1000);//tempo pour anti-rebond 10 ms
		if (PORTA & 0x01)
			{
			bit_synchro=0;
			PORTB = PORTB &0xdf; //la led synchronisation s'teind
			}
		else bit_synchro=1;
		}	
	else bit_synchro =1;
	etat_synchro =0;
	return bit_synchro;
}

unsigned char Write(unsigned char cAddress, unsigned char cValue) 
{
   unsigned char bRet = 0x00;
   IdleI2C();	 //Attente du bus OK
   StartI2C();	 //Envoi de message de dbut
   IdleI2C();	 //Attente de la disponibilit du bus
   putcI2C(cAddress); //Envoi de l'adresse
   IdleI2C();	//Attenre de la disponibilit du bus
   if (SSPCON2bits.ACKSTAT) //Si AckStat == 1, on n'a pas reu d'acquittement
   {
      StopI2C();  //Envoi de la condition de stop
      return bRet;
   } 
   putcI2C(cValue);	//On crit la valeur
   IdleI2C();			//Attente de disponibilit du bus
   if (!SSPCON2bits.ACKSTAT ) //Si on reoit un acquitement, on retourne 1
   {
      bRet = 0x01;
   }
   StopI2C();
   return bRet;
}



unsigned char Read(unsigned char cAddress)
{
   unsigned char bRet = 0x00;
   IdleI2C();	 //Attente du bus OK
   StartI2C();	 //Envoi de message de dbut
   IdleI2C();	 //Attente de la disponibilit du bus
   putcI2C(cAddress); //Envoi de l'adress
   IdleI2C();	//Attente de la disponibilit du bus
   if (SSPCON2bits.ACKSTAT) //Si AckStat == 1, on n'a pas reu d'acquittement
   {
      StopI2C();  //Envoi de la condition de stop
      return bRet;
   }
   bRet = ReadI2C(); //Lecture I2C
   NotAckI2C();       //Pas d'acquittement car on lit qu'un seul caractre
   IdleI2C();
   StopI2C();          //Envoi du stop
   return bRet;        //Retour de la valeur lue
}




void write_uart (char data)
{
if ( BusyUSART()==1)
	{
	WriteUSART(data); //uwrite.c
	}
}