;*****************************************************************************
;   Exemple de communication srie asynchrone.                               *
;   Communication avec le port RS232 d'un PC.                                *
;   Le programme reoit une srie de caractres (maximum 96)                 *
;   Il rpond par la chaine de caractres inverse.                          *
;   La fin de la chaine est dtecte par le caractre "line-feed" (0x0A)     *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    NOM:      RS232                                                         *
;    Date:     23/07/2002                                                    *
;    Version:  1.0                                                           *
;    Circuit:  Platine d'exprimentation                                     *
;    Auteur:   Bigonoff                                                      *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F876.inc                                             *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    La liaison s'effectue au travers d'un MAX232                            *
;    1 start-bit, 8 bits de donne, 1 bit de parit paire, 1 stop-bit        *
;    Liaison en 9600 bauds (9615 bauds rels)                                *
;    Utilisation du module USART                                             *
;    Le PIC travaille  20MHz                                                *
;*****************************************************************************

 ERRORLEVEL -302 ;remove message about using proper bank ERRORLEVEL -302; 
	LIST       P=PIC16F88           ; Dfinition de processeur
	#include <p16F88.inc>       ; fichier include

__CONFIG  	_CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC
 __CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF

;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------

OSCCONVAL   EQU B'01110000'    ; 8MHZ
OPTIONVAL	EQU	B'00000111'	   ; horloge interne prdiviseur 256 sur TMRO 
INTCONVAL   EQU B'11000000'    ; interuption prphriques                     
PIE1VAL     EQU B'00100000'    ;   

PIE2VAL     EQU B'00000000'

CVRCONVAL   EQU B'00000000'

ANSELVAL    EQU B'00000000'    ;digital 


CMCONVAL    EQU B'00000111'    ;


DIRPORTA    EQU B'11010000'    ; tout les ports configurer en sortie sauf PORTA4
              
DIRPORTB    EQU B'00100100'    ;bit 2 et 5 en entrer pour la reception USART  

;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

BRGVAL	EQU	D'51'	; pour un dbit de 9615 bauds en mode high-speed


;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

MESS	macro	a1,a2,a3,a4	; inscrit le message dans bufout
	BANKSEL	bufout		; passer en banque 3
	movlw	"["		; mettre crochet
	movwf	bufout		; dans bufout
	movlw	a1		; charger argument 1
	movwf	bufout+1	; dans bufout
	movlw	a2		; charger argument 2
	movwf	bufout+2	; dans bufout
	movlw	a3		; charger argument 3
	movwf	bufout+3	; dans bufout
	movlw	a4		; charger argument 4
	movwf	bufout+4	; dans bufout
	movlw	"]"		; mettre crochet
	movwf	bufout+5	; dans bufout
	movlw	0x0D		; charger carriage return
	movwf	bufout+6	; dans bufout
	movlw	0x0A		; charger line-feed
	movwf	bufout+7	; dans bufout
	BANKSEL	0		; repasser banque 0
	endm

;*****************************************************************************
;                        VARIABLES BANQUE 0                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0x20		; Dbut de la zone (0x20  0x6F)
	ptr1 : 1		; pointeur temporaire 1
	ptr2 : 1		; pointeur temporaire 2
	octemp : 1		; sauvegarde temporaire
        ENDC			; Fin de la zone                        

;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone de 16 bytes
; ----------------

	CBLOCK 0x70		; Dbut de la zone (0x70  0x7F)
	w_temp : 1		; Sauvegarde registre W
	status_temp : 1		; sauvegarde registre STATUS
	FSR_temp : 1		; sauvegarde FSR (si indirect en interrupt)
	PCLATH_temp : 1		; sauvegarde PCLATH (si prog>2K)
	bufinptr : 1		; pointeur sur caractre courant buffer entre
	bufoutptr : 1		; pointeur sur caractre courant buffer sortie
	flags : 1		; flags divers
				; b0 : parit calcule
				; b1 : erreur de parit
				; b2 : erreur de frame
				; b3 : erreur overflow
	local1 : 1		; variable locale pour interruptions
	ENDC

#DEFINE PARITE	flags,0		; parit calcule
#DEFINE ER_PAR	flags,1		; erreur de parit
#DEFINE	ER_FR	flags,2		; erreur de frame
#DEFINE	ER_OV	flags,3		; erreur d'overflow

;*****************************************************************************
;                        VARIABLES BANQUE 2                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x110		; Dbut de la zone (0x110  0x16F)
	bufin : D'96'		; zone de stockage des donnes entres

	ENDC			; Fin de la zone                        

;*****************************************************************************
;                        VARIABLES BANQUE 3                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x190		; Dbut de la zone (0x190  0x1EF)
	bufout : D'96'		; message  envoyer
	ENDC			; Fin de la zone                        

;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 		; Adresse de dpart aprs reset
 	goto    init		; Initialiser


; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; La suppression des lignes "goto restorereg" permet dans ce cas de traiter
; l'interruption sur rception et sur mission en une seule fois
;-----------------------------------------------------------------------------

			;sauvegarder registres	
			;---------------------
	org 0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp
	movf	FSR , w		; charger FSR
	movwf	FSR_temp	; sauvegarder FSR

			; switch vers diffrentes interrupts
			;-----------------------------------
	
			; Interruption rception USART
			; ----------------------------

	BANKSEL	PIE1		; slectionner banque 1
	btfss	PIE1,RCIE	; tester si interrupt autorise
	goto 	intsw1		; non sauter
	bcf	STATUS,RP0	; oui, slectionner banque0
	btfss	PIR1,RCIF	; oui, tester si interrupt en cours
	goto 	intsw1		; non sauter
	call	intrc		; oui, traiter interrupt

			; Interruption transmission USART
			; -------------------------------
intsw1
	bsf	STATUS,RP0	; slectionner banque1
	btfss	PIE1,TXIE	; tester si interrupt autorise
	goto 	restorereg	; non sauter
	bcf	STATUS,RP0	; oui, slectionner banque0
	btfss	PIR1,TXIF	; oui, tester si interrupt en cours
	goto 	restorereg	; non sauter
	call	inttx		; oui, traiter interrupt

			;restaurer registres
			;-------------------
restorereg
	movf	FSR_temp , w	; charger FSR sauv
	movwf	FSR		; restaurer FSR
	swapf	status_temp,w	; swap ancien status, rsultat dans w
	movwf   STATUS		; restaurer status
	swapf   w_temp,f	; Inversion L et H de l'ancien W
                       		; sans modifier Z
	swapf   w_temp,w  	; Rinversion de L et H dans W
				; W restaur sans modifier status
	retfie  		; return from interrupt

;*****************************************************************************
;                     INTERRUPTION RECEPTION USART                           *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Reoit le caractre de l'USART et le place dans le buffer d'entre.
; Si la longueur atteint D'94', on n'encode plus, et on place 0x0D en avant-
; dernire position et 0x0A en dernire position
; Si la rception est termine (longueur atteinte ou 0x0A reu), on stoppe les
; interruptions de rception et on repositionne le pointeur au dbut du buffer
; Les erreurs sont dtectes et signales
;-----------------------------------------------------------------------------
intrc
			; tester si erreur de frame
			; -------------------------	
	btfsc	RCSTA,FERR	; tester si erreur de frame
	bsf	ER_FR		; oui, signaler erreur de frame

			; lire la parit
			; --------------
	bcf	PARITE		; par dfaut, parit = 0
	btfsc	RCSTA,RX9D	; parit lue = 1?
	bsf	PARITE		; oui, le signaler

			; lire octet reu
			; ---------------
	bsf	STATUS,IRP	; pointer banques 2 et 3 en indirect
	movf	bufinptr,w	; charger pointeur destination
	movwf	FSR		; dans pointeur d'adresse
	movf	RCREG,w		; charger octet reu
	movwf	INDF		; sauver dans buffer

			; vrifier la parit
			; ------------------
intrc1
	movf	INDF,w		; charger caractre reu
	call	calcpar		; calculer la parit
	movf	RCSTA,w		; charger registre commande
	xorwf	flags,w		; comparer parit reue et calcule
	andlw	0x01		; ne garder que le rsultat
	btfss	STATUS,Z	; b0 = b1? (parit calcule = parit reue?)
	bsf	ER_PAR		; non, signaler erreur de parit

			; tester si erreur d'overflow
			; ---------------------------
	btfsc	PIR1,RCIF	; encore d'autres octets dans RCREG?
	goto	intrc2		; oui, vrifier caractre
	btfss	RCSTA,OERR	; non, erreur d'overflow?
	goto	intrc2		; non, vrifier caractre
	bcf	RCSTA,CREN	; oui, arrt de la rception (reset de OERR)
	bsf	RCSTA,CREN	; remise en service de la rception
	bsf	ER_OV		; signaler erreur overflow
	goto	intrcend	; et fin d'interruption

			; tester si caractre reu = 0x0A
			; -------------------------------
intrc2
	movf	INDF,w		; charger caractre reu
	xorlw	0x0A		; comparer avec line-feed
	btfsc	STATUS,Z	; identique?
	goto	intrcend	; oui, fin de message

			; vrifier si buffer plein
			; ------------------------
	incf	bufinptr,f	; incrmenter pointeur de caractres
	movf	FSR,w		; charger pointeur
	xorlw	0x6D		; comparer avec dernir emplacement possible
	btfss	STATUS,Z	; identique?
	return			; non, fin de rception
	incf	FSR,f		; pointeur sur emplacement suivant
	movlw	0x0D		; mettre carriage-return
	movwf	INDF		; en avant-dernire position
	incf	FSR,f		; pointer sur dernire position
	movlw	0x0A		; charger line-feed
	movwf	INDF		; en dernire position

			; fin de message
			; --------------
intrcend
	movlw	LOW bufin	; oui, adresse de dpart du buffer d'entre
	movwf	bufinptr	; prochain caractre sera le premier
	bsf	STATUS,RP0	; passer banque 1
	bcf	PIE1,RCIE	; fin des interruptions de rception
	bcf	STATUS,RP0	; repasser banque 0
	return			; et retour


;*****************************************************************************
;                     INTERRUPTION EMISSION USART                            *
;*****************************************************************************
;-----------------------------------------------------------------------------
; envoie le caractre point par bufoutptr, puis incrmente le pointeur
; Si ce caractre est le "line-feed", alors on arrte l'mission et on pointe de
; nouveau au dbut du buffer
;-----------------------------------------------------------------------------
inttx
			; prendre octet  envoyer
			; -----------------------

	bsf	STATUS,IRP	; pointer banques 3 et 4
	movf	bufoutptr,w	; charger pointeur d'octets
	movwf	FSR		; dans pointeur
	movf	INDF,w		; charger octet  envoyer

			; calculer parit
			; ---------------
	call	calcpar		; calculer parit
	bsf	STATUS,RP0	; passer banque1
	bcf	TXSTA,TX9D	; par dfaut, parit = 0
	btfsc	PARITE		; parit = 1?
	bsf	TXSTA,TX9D	; oui, positionner parit

			; envoyer octet
			; -------------
	movf	INDF,w		; charger octet  envoyer
	bcf	STATUS,RP0	; passer banque 0
	movwf	TXREG		; envoyer octet + parit
	incf	bufoutptr,f	; pointer sur octet suivant

			; tester si dernier octet
			; -----------------------
	xorlw	0x0A		; comparer octet envoy avec Line-feed
	btfss	STATUS,Z	; galit?
	return			; non, retour d'interruption

			; traiter fin d'mission
			; ----------------------
	bsf	STATUS,RP0	; passer en banque 1
	bcf	PIE1,TXIE	; fin des interruptions mission USART
	bcf	STATUS,RP0	; repasser banque 0
	movlw	LOW bufout	; adresse du buffer de sortie
	movwf	bufoutptr	; prochain caractre = premier
	return			; fin d'interruption


;*****************************************************************************
;                        CALCULER LA PARITE                                  *
;*****************************************************************************
;-----------------------------------------------------------------------------
; L'octet dont on calcule la parit est dans W
; La parit est paire
; le flag PARITE est positionn suivant la valeur calcule
;-----------------------------------------------------------------------------
calcpar
	movwf	local1		; sauver dans variable locale (temporaire)
	bcf	PARITE		; effacer bit de parit

calcparl
	andlw	0x01		; garder bit 0 de l'octet
	xorwf	flags,f		; si " 1 ", inverser parit
	bcf	STATUS,C	; effacer carry pour dcalage
	rrf	local1,f	; amener bit suivant en b0
	movf	local1,w	; charger ce qui reste de l'octet
	btfss	STATUS,Z	; il reste des bits  " 1 " ?
	goto	calcparl	; oui, poursuivre
	return			; non, retour

; ////////////////////////////////////////////////////////////////////////////
;                           P R O G R A M M E
; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; Registre d'options (banque 1)
			; -----------------------------
	BANKSEL	OPTION_REG	; slectionner banque 1
	movlw	OPTIONVAL	; charger masque
	movwf	OPTION_REG	; initialiser registre option
    movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTB		; Direction PORTB
	movwf	TRISB			; criture dans registre direction

			; registres interruptions (banque 1)
			; ----------------------------------
	bsf	INTCON,PEIE	; autoriser interruptions priphriques

			; initialiser USART
			; -----------------
	movlw	B'01000100'	; mission sur 9 bits, mode haute vitesse
	movwf	TXSTA		; dans registre de contrle
	movlw	BRGVAL		; valeur pour baud rate generator
	movwf	SPBRG		; dans SPBRG
	bcf	STATUS,RP0	; passer banque 0
	movlw	B'11000000'	; module USART en service, rception 9 bits
	movwf	RCSTA		; dans registre de contrle

			; Initialiser message de bienvenue
			; --------------------------------
	MESS	"P","R","E","T"	; inscrire PRET dans le buffer de sortie

			; initialiser variables
			; ---------------------
	clrf	flags		; effacer flags
	movlw	LOW bufin	; adresse du buffer de rception
	movwf	bufinptr	; dans pointeur
	movlw	LOW bufout	; adresse basse du buffer d'mission
	movwf	bufoutptr	; dans pointeur

			; autoriser interruptions (banque 0)
			; ----------------------------------
    clrf	PORTA			; Sorties PORTA  0
	clrf	PORTB	
	bsf	INTCON,GIE	; valider interruptions
	goto	start		; programme principal

;*****************************************************************************
;                      PREPARER LA REPONSE                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; copie le buffer d'entre invers dans le buffer de sortie
; en modifiant cette sous-routine, vous pouvez changer le fonctionnement
; de votre programme. Vous pouvez inventer ici de nouvelles rgles de 
; rponse
;-----------------------------------------------------------------------------
preprep
			; rechercher la fin du message
			; ----------------------------

	movlw	LOW bufin-1	; pointer sur dbut du message-1
	movwf	FSR		; dans pointeur
	bsf	STATUS,IRP	; pointer banques 3 et 4 en indirect
prep1
	incf	FSR,f		; pointer sur suivant
	movf	INDF,w		; charger caractre
	xorlw	0x0A		; comparer avec line-feed
	btfss	STATUS,Z	; tester si car = 0x0A
	goto	prep1		; non, suivant
	decf	FSR,w		; oui, prendre pointeur trouv-1
	movwf	ptr1		; sauver dans pointeur temporaire1

			; traiter ligne vide
			; ------------------
	xorlw	0x10		; tester position pointeur
	btfss	STATUS,Z	; ligne vide?
	goto	prep3		; non, sauter
	MESS	"V","I","D","E"	; inscrire "vide dans le buffer de sortie
	return			; fin du traitement

			; copier message invers
			; ----------------------
prep3
	movlw	LOW bufout-1	; adresse du buffer d'mission -1
	movwf	ptr2		; dans pointeur temporaire2			
prep2
	decf	ptr1,f		; pointer sur source suivante
	incf	ptr2,f		; pointer sur destination suivante
	movf	ptr1,w		; charger pointeur source
	movwf	FSR		; dans pointeur d'adresse
	movf	INDF,w		; charger octet
	movwf	octemp		; le sauver
	movf	ptr2,w		; charger pointeur destination
	movwf	FSR		; dans pointeur d'adresse
	movf	octemp,w	; prendre octet source
	movwf	INDF		; dans destination
	movf	ptr1,w		; charger pointeur source
	xorlw	0x10		; comparer avec premire position
	btfss	STATUS,Z	; on a tout copi?
	goto	prep2		; non, suivant

	incf	ptr2,w		; charger position octet suivant bufout
	movwf	FSR		; dans pointeur d'adresses
	movlw	0x0D		; charger carriage-return
	movwf	INDF		; dans buffer de sortie
	incf	FSR,f		; pointer sur suivant
	movlw	0x0A		; charger line-feed
	movwf	INDF		; dans buffer de sortie
	return			; et fin

;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start
		; lancer l'mission, message de bienvenue
		; ---------------------------------------

	bsf	STATUS,RP0	; passer en banque 1
	bsf	TXSTA,TXEN	; mission en service.
	bsf	PIE1,TXIE	; envoyer message "pret"


			; attendre fin de l'mission
			; --------------------------


	btfsc	PIE1,TXIE	; reste des caractres  envoyer?
	goto	$-2		; oui, attendre
	btfss	TXSTA,TRMT	; buffer de sortie vide?
	goto	$-4		; non, attendre

			; lancer la rception
			; --------------------
	bcf	STATUS,RP0	; passer banque 0
	bsf	RCSTA,CREN	; lancer la rception

			; revevoir le message
			; -------------------
	bsf	STATUS,RP0	; passer banque 1
loop
	bsf	PIE1,RCIE	; autoriser interruption rception

	btfsc	PIE1,RCIE	; tester si message complet reu
	goto	$-2		; non, attendre

		; Attendre fin mission prcdente
		; --------------------------------

	btfsc	PIE1,TXIE	; message prcdent envoy?
	goto	$-2		; non, attendre
	btfss	TXSTA,TRMT	; buffer de sortie vide?
	goto	$-4		; non, attendre

			; traiter erreurs
			; ----------------
	movf	flags,w		; charger flags
	andlw	B'00001110'	; conserver flags d'erreur
	btfsc	STATUS,Z	; tester si au moins une erreur
	goto	messprep	; non, traitement normal

	btfss	ER_PAR		; tester si erreur de parit
	goto	err2		; non, sauter
	MESS	"P","A","R"," "	; crire "PAR" dans le buffer de sortie
	bcf	ER_PAR		; acquitter l'erreur
err2
	btfss	ER_FR		; tester si erreur de frame
	goto	err3		; non, sauter
	MESS	"F","E","R","R"	; crire "FERR" dans le buffer de sortie
	bcf	ER_FR		; acquitter l'erreur
err3
	btfss	ER_OV		; tester si erreur d'overflow
	goto	msuite		; envoyer le message
	MESS	"O","E","R","R"	; crire "OERR" dans le buffer de sortie
	bcf	ER_OV		; acquitter l'erreur
	goto	msuite		; envoyer message d'erreur

		; traitement normal du message
		; ----------------------------
messprep
	bcf	STATUS,RP0	; passer banque 0
	call	preprep		; prparer rponse
msuite
	bsf	STATUS,RP0	; passer banque 1
	bsf	PIE1,RCIE	; rautoriser interruption rception
	
			; envoyer rponse
			; ---------------
	bsf	PIE1,TXIE	; lancer le message
	goto	loop		; traiter message suivant

	END 			; directive fin de programme

