
/****************CONFIGURATION BITS ************************/
#pragma config OSC = INTIO2
#pragma config FSCM = OFF
#pragma config IESO = OFF
#pragma config PWRT = OFF
#pragma config BOR = OFF
#pragma config WDT = OFF

#pragma config MCLRE = ON
#pragma config STVR = OFF
#pragma config LVP = OFF
#pragma config DEBUG = OFF
#pragma config CP0 = OFF
#pragma config CP1 = OFF
#pragma config BORV= 42

/************************ INCLUDE ***************************/
#include <p18f1220.h>					/* Defs PIC 18F1220 */

/****************** DECLARATION DES FONCTIONS ******************/
void restart_WDT (void);
void Init_UC (void);
void Init_IT (void);
void Init_RS232 (void);
void Send_RS232(unsigned char Valeur);

/****************** DECLARATION DES VARIABLES ******************/
unsigned char SmokeAlarm = 0x00;

/********************** INTERRUPTIONS **************************/
#pragma interrupt HighInterruptCde
void HighInterruptCde(void)
{
//////  INTERRUPTION - WATCHDOG
  if (RCONbits.TO == 0)								//	Test du drapeau d'IT du WDT
	{
     _asm 
	 RESET
	 _endasm
    }

//////  INTERRUPTION EXTERNE SUR INT0 - RB0 -> Dtection fume (Front Montant)
  if(INTCONbits.INT0IE)                             // Prsence d'un interruption sur INT0 (-> APPUI SUR BP MARCHE)
    {
    if(INTCONbits.INT0IF)                           // Si le flag INT 0 est activ
        {
		SmokeAlarm = 0xFF;							// Flag de dtection de fume -> Alarme active					

        INTCONbits.INT0IF = 0;                   	// Effacement du flag d'interruption
        }
    }
}

#pragma code high_vector=0x08
void HighInterrupt(void)
{
	_asm 
	goto HighInterruptCde
	_endasm
}
#pragma code



/********************************* PROGRAMME PRINCIPAL *******************************/

void main(void)
{
//restart_WDT ();										// Remise a zro du compteur Watchdog
Init_UC();												// Initialisation du microcontrolleur
Init_IT();												// Initialisation du module d'interruptions
Init_RS232 ();											// Initialisation de la communication RS232

SmokeAlarm = 0x00;										// Initialisation Flag de dtection de fume -> Pas d'alarme

 while(1)
   {
	if ( PORTBbits.RB0 == 0 )							// Si le signal en entre est au niveau bas
		{
		SmokeAlarm = 0x00;								// Flag de dtection de fume = 0 ( pas d'alarme)
		}

	Send_RS232(SmokeAlarm);								// Envoi de la donne
	
 	}  		// fin WHILE(1)

} 			// fin MAIN()

/********************************* FONCTIONS *******************************/
/****************************************************************************
Nom   : void restart_WDT (void)
Role  : Remise  zro du watchdog  // NON UTILISE
****************************************************************************/
void restart_WDT (void)
{
  	_asm 
	CLRWDT 
	_endasm
}

/****************************************************************************
Nom   : void Init_UC (void)
Role  : Initialisation du microcontrolleur
****************************************************************************/
void Init_UC (void)
{
//// Oscillator Configuration
OSCCON=0x76;

//// I/O Configuration
 TRISA = 0x00;		// PORT A en SORTIE
 TRISB = 0x13;		// PORT B : ENTREE : RB0(INT0) et RB1(TX) et RB4(RX) / SORTIE :  Tout le reste

// Initialisation
 LATA = 0x00;
 LATB = 0x00;

// A/D PORT Configuration  - A/D Converter Configuration 
 ADCON1 = 0xFF;		// Tous les ports en DIGITAL
}

/****************************************************************************
Nom   : void Init_IT (void)
Role  : Initialisation du module d'interruptions
****************************************************************************/
void Init_IT (void)
{
/// Interruptions sur INT 0 -> RB0
INTCON2bits.INTEDG0 = 1;				// Activation sur Front montant
INTCONbits.INT0IF = 0;					// Mise  zro du flag d'IT
INTCONbits.INT0IE = 1;					// Autorisation des interruptions externes sur INT0
INTCONbits.GIE = 1;              		// Autorise toutes les interruptions
}

/****************************************************************************
Nom   : void Init_RS232 (void)
Role  : Initialisation de la communication RS232
****************************************************************************/
void Init_RS232 (void)
{
TXSTA =0x20;
RCSTA =0x90;
BAUDCTL =0;
SPBRG =12;
TRISBbits.TRISB4 =1;
TRISBbits.TRISB1 =1;
ADCON1bits.PCFG5 =1;
ADCON1bits.PCFG6 =1;
}

/****************************************************************************
Nom   : void Send_RS232(unsigned char Valeur)
Role  : Envoi de la donne via RS232
****************************************************************************/
void Send_RS232(unsigned char Valeur)
{
	unsigned char buf[2]=" ";
	int i=0;
 
	if(Valeur == 0xFF)
		{
		buf[0]='F';
		buf[1]='F';
		}
	if(Valeur == 0x00)
		{
		buf[0]='0';
		buf[1]='0';
		}

// A COMPLETER..... ;)

}