;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 12F675. Il contient  les informations de  base pour              *
;   dmarrer.                                                                *  
;   ecrit                  Sofien    	  		 				 *
;   e-mail: 		Princesofien@live.fr                              *		
;   Merci a Bigonoff    www.abcelectronique.com/bigonoff/*                   *
;*****************************************************************************
;                                                                            *
;    NOM:                                                                    *
;    Date:                                                                   *
;    Version:                                                                *
;    Circuit:                                                                *
;    Auteur:                                                                 *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P12F675.inc                                             *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes:                                                                  *
;                                                                            *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
	ERRORLEVEL -302			; suppression du message bank select 
	LIST      P=PIC12F675          ; Dfinition de processeur
	#include <p12F675.inc>           ; fichier include

	__CONFIG  _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON &  _WDT_OFF & _INTRC_OSC_NOCLKOUT

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection de l'EEprom
; -----------------------
; _CPD_ON		Mmoire EEprom protge
; _CPD_OFF               Mmoire EEprom dprotge

; Protection du programme
; -----------------------
; _CP_ON			protection totale
; _CP_OFF		Pas de protection

; Reset de la PIC si tension <2.1V
; ------------------------------
; _BODEN_ON			Reset tension en service
; _BODEN_OFF			Reset tension en hort service

;Utilisation de la pin MCLR
; -------------------------
; _MCLRE_ON		GP3/MCLR est utilise pour le reset
; _MCLRE_OFF	GP3/MCLR est utilise comme une entree/sortie

; Retard  la mise sous tension
; -----------------------------
; _PWRTE_OFF		Dmarrage rapide
; _PWRTE_ON		Dmarrage temporis

; Watchdog
; --------
; _WDT_ON		Watchdog en service
; _WDT_OFF		Watchdog hors service 

; Oscillateur
; -----------

	
; _LP_OSC			Oscillateur basse vitesse (?<F<200Khz) 			GP4 (osc) 	& GP5 (osc)
; _XT_OSC			Oscilateur moyenne vitesse (0,1MHz<F<4Mhz)		GP4 (osc) 	& GP5 (osc)
; _HS_OSC			Oscillateur haute vitesse (4Mhz<F<20Mhz)		GP4 (osc) 	& GP5 (osc)	
; _EC_OSC			oscillateur externe sur GP5 avec GP4 en I/O		GP4 (osc) 	& GP5 (osc)
; _INTRC_OSC_NOCLKOUT		oscillateur interne avec GP4 et GP5 en I/O		GP4 (I/O) 	& GP5 (I/O)
; _INTRC_OSC_CLKOUT		oscillateur interne avec Fosc/4 sur GP4 et GP5 en I/O	GP4 (Fosc/4) 	& GP5 (I/O)
; _EXTRC_OSC_NOCLKOUT		RC externe sur GP5 avec GP4 en I/O			GP4 (I/O) 	& GP5 (osc)
; _EXTRC_OSC_CLKOUT		RC externe interne sur GP5 avec Fosc/4 sur GP4 		GP4 (Fosc/4) 	& GP5 (osc)





;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration) BK1
; -----------------------------------
OPTIONVAL	EQU	B'10000000'
			; RGPPU			b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    	b6 : 1= Interrupt sur front montant de GP2
			;                    0= Interrupt sur front descendant de GP2
			; TOCS      	b5 : 1= source clock = transition sur GP2
			;                    0= horloge interne
			; TOSE      	b4 : 1= Slection front descendant GP2(si B5=1)
			;                    0= Slection front montant GP2
			; PSA       	b3 : 1= Assignation prdiviseur sur Watchdog
			;                    0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   	b2/b0 valeur du prdiviseur
            ;           	000 =  1/1 (watchdog) ou 	1/2 (tmr0)
			;          		001 =  1/2  	           	1/4
			;          		010 =  1/4		  			1/8
			;          		011 =  1/8					1/16
			;          		100 =  1/16					1/32
			;          		101 =  1/32					1/64
			;          		110 =  1/64					1/128
			;          		111 =  1/128   				1/256


; REGISTRE INTCON (contrle interruptions standard) BK(0-1)
; -------------------------------------------------
INTCONVAL	EQU	B'01001000'		;(interruption sur Timer1)+Mrclr
			; GIE      		b7 : masque autorisation gnrale interrupt
            ;                		ne pas mettre ce bit  1 ici (0=maque desactiv)
            ;                		sera mis en temps utile
			; PEIE      	b6 : masque autorisation gnrale priphriques
			; TOIE    		b5 : masque interruption tmr0
			; INTE      	b4 : masque interuption GP2/Int
			; GPIE      	b3 : masque interruption sur GPIO (IOC doit etre aussi configurer)
			; TOIF    		b2 : flag tmr0
			; INTF      	b1 : flag GP2/Int
			; GPIF      	b0 : flag interruption Sur GPIO


; REGISTRE IOC (contrle interruptions par PIN I/O) BK1
; -------------------------------------------------
IOCVAL		EQU	B'0001000' 	;GIE doit etre configurer
			; IOC      	b7-b6 : Non active, Lecture "0"
			; IOC      	b5-b0 : 1=Activ 0=dsactiv (Ignor si pin non configur en entre numerique) 
			


; REGISTRE PIE1 (contrle interruptions priphriques) BK1
; ----------------------------------------------------
PIE1VAL		EQU	B'00000001'
			; EEIE  		b7 : masque interrupt sur fin ecriture eeprom
			; ADIE      	b6 : masque interrupt convertisseur A/N
			;       		b5 : rserv, laisser  0
			;		     	b4 : rserv, laisser  0
			; CMIE    	 	b3 : masque interrupt Comparator 1
			;	    		b2 : rserv, laisser  0
			; 	  			b1 : rserv, laisser  0
			; TMR1IE    	b0 : masque interrupt dbordement tmr1






; REGISTRE CMCON (COMPARATEURS) BK0
; -----------------------------
CMCONVAL	EQU	B'00000111' 
			; 	    		b7 :rserv, laisser  0
			; COUT     		b6 :sortie comparateur
			;      			b5 :rserv, laisser  0
			; CINV    	 	b4 :inverseur comparateur
			; CIS       	b3 :selection entree des comparateurs (CM2-CM0 = 010 ou 001)
			; CM2-CM0   	b2-0 :mode des comparateurs
							;configurer le mode 111 pour utiliser les ports en I/O
							;autre config voir page 39 du datasheet


			; 		

; REGISTRE ADCON0 (A/N Controle module) BK0
; ------------------------------------
ADCON0VAL	EQU	B'10000000'
			; ADFM      	b7 :Justification du resultat: 1=droite 0=gauche
			; VCFG	     	b6 :Rferance Voltage:  1=Vref Pin 0=Vdd
			; 		       	b5 :rserv, laisser  0
			;    			b4 : rserv, laisser  0
			; CHS1-CHS0  	b3-2 :Choix du canal : 00=AN0--> 11=AN3
			; GO/DONE		b1 : Status de la conversion: 1=depart et progression 0=conversion fini
			; ADON 			b0 : activation du module A/N (chargement du condo)	

; REGISTRE ANSEL (Analogique Controle module) BK1
; ------------------------------------
ANSELVAL	EQU	B'01101100'	;64
			; ADFM      	b7 :rserv, laisser  0
			; ADCS	     	b6-4 :Convertion clock
							;000 = FOSC/2
							;001 = FOSC/8 (meilleur pour 4MHz)
							;010 = FOSC/32
							;x11 = FRC (clock derived from a dedicated internal oscillator = 500 kHz max)
							;100 = FOSC/4
							;101 = FOSC/16
							;110 = FOSC/64
			; ANS3-ANS0  	b3-0 :Configuration du pin ANx en analogique ou numerique
			

					

; REGISTRE VRCON (voltage reference module) BK1
; ------------------------------------
VRCONVAL	EQU	B'00000000'
			; VREN      	b7 :Validation du module si 0 alors Vren = Vss
			;	     		b6 :rserv, laisser  0
			; VRR       	b5 :Choix de la plage 
			; RESERVED   	b4 : rserv, laisser  0
			; VR3-VR0  		b3-0 :Choix de la valeur dans la plage 
								; si VRR=1 Vref=(VR[3:0]/24)*Vdd
								; si VRR=0 Vref=Vdd/4+(VR[3:0]/32)*Vdd




; REGISTRE T1CON (Timer1 Confuguration) BK0
; ------------------------------------
T1CONVAL	EQU	B'00110001'	;timer1 active avec 1/8 predevisuer
			; 			B7 :rserv, laisser  0
			; TMR1GE	B6 :Activation Sortie Timer1
			;		    si TMR1ON = 0 (b0) se bit est ignor
			;		    si TMR1ON = 1 ce bit doit etre a 1 pour utiliser TG1 ou C2OUT 
			; T1CKPS1	b5-b4: prediviseur du timer1
			;		    00:1/1 01:1/2 10:1/4 11:1/8
			; T1OSCEN	b3 :Actile l'oscilateur LP 
			;		    si l'oscilateur interne avec sortie clock est active
			;			1: l'osc LP est active sur Timer1 0: dsactiv
			;		    sinon ignor
			; T1SYNC	b2 :sychronisation du clock externe (il faut que TMR1CS = 1 sinon ignor)
			;			1: Non synchrone (continue en mode sleep et reveille le pic)
			;			0: synchrone (desactiv en mode sleep)
			; TMR1CS	b1 :selection de la source du timmer:
			;			1=externe sur T1CKI
			;			0=interne (Fosc/4)
			; TMR1ON	b0 :activation general du timer
			;			1=Active	
			;			0=Dsactiv
					

	




; REGISTRE WPU (Pull-Up  DES PORTS A) BK1
; --------------------------------------------
WPUVAL		EQU	B'00000000'	; Pull-Up
			;			b7-b6 :rserv, laisser  0
			;WPU5		b:5 (1=Pull-Up ON  0=Pull-Up OFF)
			;WPU4		b:4 (1=Pull-Up ON  0=Pull-Up OFF)
			;			b:3 :rserv, laisser  0
			;WPU2		b:2 (1=Pull-Up ON  0=Pull-Up OFF)
			;WPU1		b:1 (1=Pull-Up ON  0=Pull-Up OFF)
			;WPU0		b:0 (1=Pull-Up ON  0=Pull-Up OFF)

; REGISTRE TRISIO (Direction des ports) BK1
; --------------------------------------------
TRISIOVAL	EQU	B'00011100'	; Direction PORTA (1=entre)
;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; parametrage 
; -------
chauffeH		EQU	B'00000001'		;Valeur blocage systeme a cause du surchauffe(1.9V)
chauffeL		EQU	B'10000101'
risisH			EQU B'00000001'		;Valeur pour laquelle on attend le refroidissement (1.7V)
risisL			EQU B'01011100'

surchargeH		EQU B'00000011'		; valeur de tension excessif appliqu a la  pile (4.8)
surchargeL		EQU B'11010111'		;
dechargeH		EQU B'00000001'		; valeur de tension d'une pile decharg: 2V
dechargeL		EQU B'10011001'		;au dessous on charge en sauft 

seuilinf		EQU B'11001100'		;considrer comme batrie existante (1V)

comptimerH		EQU B'00000000'		;1mn: interval de comparaison tention = 256X256X8X(CompH==ComptL) Us
comptimerL		EQU B'01110010'		;ne pas decendre a moin que 1 car 0==> (CompH==ComptL)=256X256 

comptimerHFT	EQU B'00000100'		;10mn: 1 re charge pour eviter faut delta peak
comptimerLFT	EQU B'01111000'		;

nbrstable		EQU D'5'			;nombre de X de tension constante pour considerer comme charger (pas de delta peak)	
;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************


#DEFINE GOAN	ADCON0,1			; Bit go/done convertion


;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

			; Changement de banques
			; ----------------------

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
	
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
		
	endm

ANPIN0	macro				;Canal convertion A/N PIN0
		bcf	ADCON0,2
		bcf	ADCON0,3
	endm

ANPIN1	macro				;Canal convertion A/N PIN1
		bsf	ADCON0,2
		bcf	ADCON0,3
	endm

ANPIN2	macro				;Canal convertion A/N PIN2
		bcf	ADCON0,2
		bsf	ADCON0,3
	endm
		
ANPIN3	macro				;Canal convertion A/N PIN3
		bsf	ADCON0,2
		bsf	ADCON0,3
	endm

Vout0	macro				;Intensit 0 (R1=0 & R2=0)
		bsf	GPIO,0
		bsf GPIO,1
		bcf	configini,0		;R1 OFF
		bcf	configini,1		;R2 OFF
		bcf	configini,2		;non Calibr
	
		endm

Vout1	macro				;Intensit 0 (R1=1 & R2=0)
		bcf	GPIO,0
		bsf GPIO,1
		bsf	configini,0		;R1 ON
		bcf	configini,1		;R2 OFF
		bsf	configini,2		;Calibr
		endm

Vout2	macro				;Intensit 0 (R1=0 & R2=1)
		bsf	GPIO,0
		bcf GPIO,1
		bcf	configini,0		;R1 OFF
		bsf	configini,1		;R2 ON
		bsf	configini,2		;Calibr
		endm

Vout3	macro				;Intensit 0 (R1=1 & R2=1)
		bcf	GPIO,0
		bcf GPIO,1
		bsf	configini,0		;R1 ON
		bsf	configini,1		;R2 ON
		bsf	configini,2		;Calibr
		endm
	
LEDON	macro				;Led indication ON
		bcf GPIO,5
		endm

LEDOFF	macro				;Led indication OFF
		bsf GPIO,5
		endm

OPENAN	macro				;ouvrir module convertion
		local	loop
		bsf	ADCON0,0
		movlw	D'20'		;Attente 19.7uS avant convertion
		movwf	cmpt
loop
		decfsz	cmpt,F
		goto	loop
		endm

CLOSEAN	macro				;Fermer module convertion
		local	loop
		bcf	ADCON0,0
		movlw	D'4'		;Attente 3.2uS avant vouvelle convertion
		movwf	cmpt
loop
		decfsz	cmpt,F
		goto	loop
		endm
	


; oprations en mmoire eeprom
			; -----------------------------

REEPROM macro	adeeprom		; lire eeprom (adresse dans adeeprom & rsultat en w)
	movlw	adeeprom		; charger adresse eeprom (passage de la valeur en litteral)
	;movf	adeeprom,w		; charger adresse eeprom (passage de la valeur par une variable)
	clrwdt				; reset watchdog
	BANK1				; passer en banque1
	movwf	EEADR			; pointer sur adresse eeprom
	bsf	EECON1,RD		; ordre de lecture
	movf	EEDATA,w		; charger valeur lue
	BANK0				; passer en banque0
	endm


WEEPROM	macro	addwrite	  	; la donne se trouve dans W
	LOCAL	loop
	BANK1				; passer en banque1
	movwf	EEDATA			; placer data dans registre
	movlw	addwrite		; charger adresse d'criture (passage de la valeur en litteral)
	;movf	addwrite,w		; charger adresse d'criture (passage de la valeur par une variable)
	movwf	EEADR			; placer dans registre
	bsf	EECON1 , WREN		; autoriser accs criture
	bcf	INTCON , GIE		; interdire interruptions
	movlw	0x55			; charger 0x55
	movwf	EECON2			; envoyer commande
	movlw	0xAA			; charger 0xAA
	movwf	EECON2			; envoyer commande
	bsf	EECON1 , WR		; lancer cycle d'criture
	bsf	INTCON , GIE		; rautoriser interruptions
loop
	btfsc	EECON1 , WR		; tester si criture termine
	goto	loop			; non, attendre
	bcf	EECON1 , WREN		; verrouiller prochaine criture
	BANK0				; passer en banque0
	endm




;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone Commune de 64 octets
; ----------------

	CBLOCK 0x20			; Dbut de la zone (0x20  0x5F)
	w_temp 		:1			; Sauvegarde registre W
	status_temp :1			; sauvegarde registre STATUS
	FSR_temp 	:1			; sauvegarde FSR (si indirect en interrupt)
	PCLATH_temp :1			; sauvegarde PCLATH (si prog>2K)
	messageM	:2			;message memoir: a charger pour l'affichage
	messageT	:1			;var transition pour formatage du message
	message		:2			;led message 16bits
	configini	:1
							;B7		
							;B6		Conteur timer declanch
							;B5		pille defaillante
							;B4		Surchauffe		
							;B3		charge	:0en charge 1:charg
							;B2		Calibr	
							;B1		Ampere2
							;B0		Ampere1
	cmptstable	:1			;decompteur a debordement de situation stable
	
	cmpt		:2			;comteur de boucle pour charge de maintien
	cmptm		:1			;compteur de boucle pour affichage message
	cmptF		:1			;compteur formatage message	
	cmpt1 		:1			; compteur de boucles 1 (Temp)
	cmpt2 		:1			; compteur de boucles 2	(Temp)
	cmpt3 		:1			; compteur de boucles 1	(Temp)
	cmpt4 		:1			; compteur de boucles 2	(Temp)
	MADRESL		:1			;moyenne de la convertion AN L
	MADRESH		:1			;moyenne de la convertion AN H
	val1		:2			;variables d'opperations
	val2		:2
	Temp		:1			;flag resultat
	var_temp	:1			;variable local d'affichage
	ttimer		:2			;compteur de temp timer
	lastv		:2			;dernire mesure de tention
	ENDC

;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 			; Adresse de dpart aprs reset
  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Si on n'utilise pas l'adressage indirect dans les interrupts, on se passera
; de sauvegarder FSR ainsi que la restauration dans restorereg
; Si le programme ne fait pas plus de 2K, on se passera de la gestion de 
; PCLATH ainsi que la restauration dans restorereg
;-----------------------------------------------------------------------------
			;sauvegarder registres	
			;---------------------
	org 0x004			; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp
	movf	FSR , w			; charger FSR
	movwf	FSR_temp		; sauvegarder FSR
	movf	PCLATH , w		; charger PCLATH
	movwf	PCLATH_temp		; le sauver
	BANK0				; passer en banque0

			; switch vers diffrentes interrupts
			; inverser ordre pour modifier priorits
			; mais attention alors au test PIE1
			; effacer les inutiles
			;----------------------------------------
	
			; Interruption TMR0
			; -----------------

	btfsc	INTCON,T0IE		; tester si interrupt timer autorise
	btfss	INTCON,T0IF		; oui, tester si interrupt timer en cours
	goto 	intsw1			; non test suivant
	call	inttmr0			; oui, traiter interrupt tmr0
	bcf		INTCON,T0IF		; effacer flag interrupt tmr0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; Interruption GP2/INT
			; --------------------
intsw1
	btfsc	INTCON,INTE		; tester si interrupt GP2 autorise
	btfss	INTCON,INTF		; oui, tester si interrupt GP2 en cours
	goto 	intsw2			; non sauter au test suivant
	call	intrgp2			; oui, traiter interrupt GP2
	bcf		INTCON,INTF		; effacer flag interupt GP2
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; interruption GPx
			; --------------------
intsw2
	btfsc	INTCON,GPIE		; tester si interrupt GPx autorise
	btfss	INTCON,GPIF		; oui, tester si interrupt RAx en cours
	goto 	intsw3			; non sauter
	call	intrgpx			; oui, traiter interrupt RAx
	bcf		INTCON,GPIF		; effacer flag interupt RAx (lecture de PORTA est obligatoire avant effacement de RAIF)
	goto	restorereg		; et fin d'interrupt

			; dtection interruptions priphriques
			; le test peut tre supprim si une seule
			; interrupt est traite  la fois
			; --------------------------------------
intsw3
	btfss	INTCON,PEIE		; tester interruption priphrique autorise
	goto	restorereg		; non, fin d'interruption

	

			; Interruption timer1
			; -------------------------------
intsw4
	BANK1				; slectionner banque1
	btfss	PIE1,TMR1IE		; tester si interrupt autorise
	goto 	intsw5			; non sauter
	BANK0					; oui, slectionner banque0
	btfss	PIR1,TMR1IF		; oui, tester si interrupt en cours
	goto 	intsw5			; non sauter
	call	inttmr1			; oui, traiter interrupt
	bcf		PIR1,TMR1IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt


			


			; Interruption comparateur
			; -------------------------
intsw5
	BANK1				; slectionner banque1
	btfss	PIE1,CMIE		; tester si interrupt autorise
	goto 	intsw6			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,CMIF		; oui, tester si interrupt en cours
	goto 	intsw6			; non sauter
	call	intcomp			; oui, traiter interrupt
	goto	restorereg		; et fin d'interrupt
	

			; Interruption C A/N
			; -----------------
intsw6
	BANK1					; slectionner banque1
	btfss	PIE1,ADIE		; tester si interrupt autorise
	goto 	intsw7			; non sauter
	BANK0					; oui, slectionner banque0
	btfss	PIR1,ADIF		; oui, tester si interrupt en cours
	goto 	intsw7			; non sauter
	call	intan		; oui, traiter interrupt
	goto	restorereg		; et fin d'interrupt




			; Interruption EEPROM
			; -------------------
intsw7
	BANK1				; slectionner banque1
	btfss	PIE1,EEIE		; tester si interrupt autorise
	goto 	restorereg			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,EEIF		; oui, tester si interrupt en cours
	goto 	restorereg			; non sauter
	call	inteprom		; oui, traiter interrupt
	bcf		PIR1,EEIF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt
			


			

			;restaurer registres
			;-------------------
restorereg
	movf	PCLATH_temp , w		; recharger ancien PCLATH
	movwf	PCLATH			; le restaurer
	movf	FSR_temp , w		; charger FSR sauv
	movwf	FSR			; restaurer FSR
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt

;*****************************************************************************
;                        INTERRUPTION TIMER 0                                *
;*****************************************************************************
inttmr0
	return				; fin d'interruption timer
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                        INTERRUPTION GP2/INT                                *
;*****************************************************************************
intrgp2
	return				; fin d'interruption GP2/INT
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                         INTERRUPTION GPx                                   *
;*****************************************************************************
intrgpx
	;lecture de GPIO Obligatoire pour arreter l'interruption

	return				; fin d'interruption RAx
					; peut tre remplac par 
					; retlw pour retour code d'erreur


;*****************************************************************************
;                     INTERRUPTION TIMER 1                                   *
;*****************************************************************************
inttmr1

	goto LabT		;condanation du test de surchauffe
	;Lecture de chaleur
	call 	readc
	movf	MADRESL,W	; charger convertion dans val1
	movwf	val1
	movf	MADRESH,W
	movwf	val1+1
	btfsc	configini,4	;surcharg, comparer risis
	goto 	Labc1


Labc0						;pas de surchaufe au depart: configini,4
	movlw	chauffeL		;charger la valeur du taux de surcharge dans val2
	movwf	val2
	movlw	chauffeH
	movwf	val2+1
	call	sub16
	btfss	Temp,3			;verifier si resultat est negative
	bsf 	configini,4			;signaler surchauffe
	btfsc	Temp,2			;verifier si valeur est nulle
	bsf 	configini,4			;signaler surchauffe

	btfss	configini,4
	goto	LabT			;pas de surchauffe
	Vout0					;surchauffe
	movlw	B'11111111'		;charger messge LED	
	movwf	messageM
	movwf	messageM+1			
	return

Labc1
	movlw	risisL		;charger la valeur du taux de surcharge dans val2
	movwf	val2
	movlw	risisH
	movwf	val2+1
	call	sub16
	btfsc	Temp,3			;verifier si resultat est negative
	bcf 	configini,4			;signaler fin surchauffe
	btfsc	Temp,2			;verifier si valeur est nulle
	bcf 	configini,4			;signaler fin surchauffe

	btfss	configini,4
	goto	LabT			;pas de surchauffe
	Vout0					;surchauffe
	movlw	B'11111111'		;charger messge LED	
	movwf	messageM
	movwf	messageM+1			
	return



LabT
	bcf		configini,6		;effacement du flag de debordement du compt timer
	movf	ttimer,F		;charger variable pour test Z
	btfsc	STATUS,Z
	decf 	ttimer+1,F		;ttimer=O donc dec ttimer+1
	decf	ttimer,F		;dec ttimer
				;test resultat
	movf	ttimer,F		;charger variable pour test Z
	btfss	STATUS,Z
	goto	LabV
	movf	ttimer+1,F		;charger variable pour test Z
	btfss	STATUS,Z
	goto	LabV
	bsf		configini,6		;debordement du compteur timer
;NB le compteur de timer doit etre reconfigur dans chaque partie selon le cas et avant le return	
;tout changement de la situation est inscrit sur configini pour
;passer au mode appropri au nouvel inter timer1
LabV
	call 	readv		;lecture de la charge
	btfsc	configini,2	;verifier si tension calib
	goto	LabV1		;oui calibr allez a LabV1
	
	
LabV0					;Non calibr
	;la lecture de charge conserne la valeur de la pille
	movf	MADRESL,W	; charger convertion dans val1
	movwf	val1
	movf	MADRESH,W
	movwf	val1+1		
	movlw	seuilinf	;charger val2 avec seuil inferieur
	movwf	val2
	clrf	val2+1
	call	sub16		;comparaison
	btfss	Temp,3			;verifier si resultat est negatif
	goto	LabV01			;sauter a la procedure pas de charge et pille existe
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	LabV01			;sauter a la procedure pas de charge et pille existe

LabV00						;pas de charge et pas de pille
	clrf	configini		;effacer config
	clrf	lastv			;effacer dernire valeur pille
	clrf 	lastv+1

	Vout0					;arret charge (precotion)
	movlw	comptimerL		;remise a zero compeur timer
	movwf	ttimer
	movlw	comptimerH
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H			
	movlw	B'00010001'		;charger messge LED	
	movwf	messageM	
	clrf	messageM+1

	
	return					;Plus rien a faire ICI

LabV01						;pas de charge et pille existe
	btfsc	configini,3		;verifier si pille charge
	goto	LabV01C
	
	LEDOFF			;Arret Led pour plus de stabilit
	call tempx	;	temp de stabilisation (1s)
	call tempx
	call tempx
	call tempx
	call tempx
	call tempx
	call tempx
	call tempx
		
	call readv				;une 2me lecture de la valeur de la pille (apres temp stabilisation
	

	movf	MADRESL,W
	movwf	lastv			;charger valeur calcul pour prochaine comparaison
	movwf	val1			;charger val1 pour formatage message
	movf	MADRESH,W
	movwf	lastv+1	
	movwf	val1+1			;charger val1+1 pour formatage message
	call	formatM			;formatage de charge
	call	calibrage		;mise en service charge
	movlw	comptimerLFT	;remise a zero compeur timer parametre special pour eviter delta peak precosse
	movwf	ttimer
	movlw	comptimerHFT
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H			
	return					;Plus rien a faire ICI

LabV01C						;pas de charge et pille existe et charge
	Vout1					;charge d'entretien par puls de 0.01sec chaque 0.5 sec
	movlw	0xCF			;attente 0.01sec
	movwf	cmpt
	movlw	0x08
	movwf	cmpt+1
Delay_0
	decfsz	cmpt, f
	goto	$+2
	decfsz	cmpt+1, f
	goto	Delay_0
	goto	$+1
	Vout0				;arret de puls

	movlw	comptimerL		;remise a zero compeur timer
	movwf	ttimer
	movlw	comptimerH
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H			
	movlw	B'01110111'		;charger messge LED	
	movwf	messageM
	clrf	messageM+1	
	return					;Plus rien a faire ICI

LabV1						;Vout est active
	;la lecture de charge conserne la valeur de chargeur
	;verifier niveau tension de charge
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	movf	MADRESH,W
	movwf	val1+1
	movlw	surchargeL		;charger la valeur du taux de surcharge dans val2
	movwf	val2
	movlw	surchargeH
	movwf	val2+1
	call	sub16
	btfss	Temp,3			;verifier si resultat est negative
	goto	LabV11			;sauter au cas de surcharge
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	LabV11			;sauter au cas de surcharg

LabV10						;charge est sans surcharge
	btfss	configini,6		;verification du compteur timer
	
	return					;rien a faire, on continu de charger au meme rithme
	call verifcharge		;verification et traitement periodique	

	return 



LabV11						;Charge avec surcharge
	;verifier si pille existe
	Vout0					;Arreter charge

	call readv				;lire la valeur de la pille
	movf	MADRESL,W	; charger convertion dans val1
	movwf	val1		
	movf	MADRESH,W
	movwf	val1+1		
	movlw	seuilinf	;charger val2 avec seuil inferieur
	movwf	val2
	clrf	val2+1
	call	sub16		;comparaison
	btfss	Temp,3			;verifier si resultat est negatif
	goto	LabV11X			;sauter a la procedure  pille existe
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	LabV11X			;sauter a la procedure pille existe
	clrf	configini		;pas de pille
	movlw	comptimerL		;remise a zero compeur timer
	movwf	ttimer
	movlw	comptimerH
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H			
	return

LabV11X		;la pille existe
	btfsc	configini,6		;compteur timer debord
	goto 	LabV11X1
LabV11X0	;pas debordement compteur timer
	call 	calibrage
	return

LabV11X1	;debordement compteur timer
		call verifcharge		;verification et traitement periodique	
	return 
					; fin d'interruption



;*****************************************************************************
;                     INTERRUPTION COMPARATEUR                               *
;*****************************************************************************
intcomp
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                       INTERRUPTION CAN                                    *
;*****************************************************************************
intan
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION EEPROM                                    *
;*****************************************************************************
inteprom
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur


					; peut tre remplac par 
					; retlw pour retour code d'erreur



; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

		
			; Registre de l'oscillateur
			; -------------------------
	BANK1				
	bsf STATUS,RP0 		; slectionner banque1
	call 3FFh 			; retrieve factory calibration value
	movwf OSCCAL 		; update register with factory cal value 



			; Registre d'options 
			; -----------------------------
	BANK1				; slectionner banque1
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option
	
	
	
			; registres interruptions 
			; ----------------------------------
	BANK1				; slectionner banque1
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions

	movlw	IOCVAL		; charger valeur registre interruption sur PORTA
	movwf	IOC			; initialiser interruptions PORTA

	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1

			; registres Comparateur 
			; ----------------------------------
	BANK1				; slectionner banque0
	movlw	VRCONVAL		; charger masque
	movwf	VRCON			; initialiser le registre du comparateur

	BANK0				; slectionner banque0
	movlw	CMCONVAL		; charger masque
	movwf	CMCON			; initialiser le registre du comparateur

			; registres Convertisseur A/N 
			; ----------------------------------
	BANK1				; slectionner banque0
	movlw	ANSELVAL		; charger masque
	movwf	ANSEL			; initialiser le registre du comparateur
	
	BANK0				; slectionner banque0
	movlw	ADCON0VAL		; charger masque
	movwf	ADCON0			; initialiser le registre du comparateur
	

			; registres TIMER1 
			; ----------------------------------
	BANK0				; slectionner banque0
	movlw	T1CONVAL		; charger masque
	movwf	T1CON			; initialiser le registre du comparateur



			; Effacer RAM banque 0 et Commune
			; --------------------------------
	movlw	0x20	 ; initialisation pointeur
	movwf	FSR	 ; pointeur d'adressage indirect
init1
	clrf	INDF	 ; effacer ram
	incf	FSR,f	 ; pointer sur suivant
	btfss	FSR,6	 ; tester si fin zone atteinte (>=40)
	goto	init1	 ; non, boucler
	btfss	FSR,5	 ; tester si fin zone atteinte (>=60)
	goto	init1	 ; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	bsf		INTCON,GIE		; valider interruptions


			; initialisation PORTS 
			; ------------------------------------

	BANK1					; passer en banque1
	movlw	TRISIOVAL		; charger le masque
	movwf	TRISIO			; initialiser registre

	movlw	WPUVAL			; charger le masque
	movwf	WPU				; initialiser registre
	BANK0					; slectionner banque0
	clrf	GPIO			; Sorties PORTA  0
	Vout0					;arret de charge
			;-------------------------------------

	goto	start			; programme principal


;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start
	




	movlw	comptimerL		;remise a zero compeur timer
	movwf	ttimer
	movlw	comptimerH
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H
	movlw	nbrstable		;Charger nombre max de stabilit de la courbe de charge
	movwf	cmptstable
Affichage
	movf	messageM,W		;charger message a afficher
	movwf	message
	movf	messageM+1,W
	movwf	message+1

	movlw	D'7'
	movwf	cmptm			;charger boucle 7
			
LabM1
	btfsc	message,0
	goto	LabOn1
	goto	LabOff1

LabOn1
	LEDON
	movlw	D'1'
	call 	tempo
	rrf		message,F			;rotation a droite
	decfsz	cmptm,F
	goto	LabM1
	movlw	D'7'
	movwf	cmptm			;charger boucle 7
	goto	LabM2

LabOff1
	LEDOFF
	movlw	D'1'
	call 	tempo
	rrf		message,F			;rotation a droite
	decfsz	cmptm,F
	goto	LabM1
	movlw	D'7'
	movwf	cmptm			;charger boucle 7
	goto	LabM2
LabM2
	btfsc	message+1,F
	goto	LabOn2
	goto	LabOff2

LabOn2
	LEDON
	movlw	D'1'
	call 	tempo
	rrf		message+1,F			;rotation a droite
	decfsz	cmptm,F
	goto	LabM2
	goto	Affichage

LabOff2
	LEDOFF
	movlw	D'1'
	call 	tempo
	rrf		message+1,F			;rotation a droite
	decfsz	cmptm,F
	goto	LabM2
	goto	Affichage
		


;*****************************************************************************
;                              MODULES                                       *
;*****************************************************************************

;*********************************************************************
;                  MODULES  Convertion A/N Tension                   *
;*********************************************************************
readv
	clrf	val1		
	clrf	val1+1
	clrf	val2
	clrf	val2+1

		

	ANPIN2					;Choix du canal2
	OPENAN					;ouverture du module de conversion
	movlw	D'8'
	movwf	cmpt			; boucle pour 8 lectures 

ANLoop1v
	nop
	nop
	nop
	nop
	movlw	D'20'		;Attente 19.7uS avant convertion
	movwf	cmpt+1
loopXX
	decfsz	cmpt+1,F
	goto	loopXX
	bsf		GOAN				;lancer la convertion
ANLoop2v	
	btfsc	GOAN			; attente le repositionnement du bit go/done a 0
	goto	ANLoop2v
	BANK1
	movf	ADRESL,W		;sauvgarde resultat convertion en val2
	movwf	val2
	BANK0
	movf	ADRESH,W
	movwf	val2+1
	call 	add16			; addition des valeur de la convertion
	decfsz	cmpt,F
	goto	ANLoop1v

	CLOSEAN					;arret module de conversion
;devision par 8	des 8 additions
	bcf		STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc 	STATUS,C
	bsf		val1,7
	bcf 	STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc 	STATUS,C
	bsf		val1,7
	bcf 	STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc	STATUS,C
	bsf		val1,7
	
	movf	val1,W
	movwf	MADRESL
	movf	val1+1,W
	movwf	MADRESH

	

	
	return
;*********************************************************************
;                  MODULES  Convertion A/N Chaleur                  *
;*********************************************************************
readc
	clrf	val1		
	clrf	val1+1
	clrf	val2
	clrf	val2+1

		

	ANPIN3					;Choix du canal2
	OPENAN					;ouverture du module de conversion
	movlw	D'8'
	movwf	cmpt			; boucle pour 8 lectures 

ANLoop1c
	nop
	nop
	nop
	nop
	movlw	D'20'		;Attente 19.7uS avant convertion
	movwf	cmpt+1
loopXXc
	decfsz	cmpt+1,F
	goto	loopXXc
	bsf		GOAN				;lancer la convertion
ANLoop2c	
	btfsc	GOAN			; attente le repositionnement du bit go/done a 0
	goto	ANLoop2c
	BANK1
	movf	ADRESL,W		;sauvgarde resultat convertion en val2
	movwf	val2
	BANK0
	movf	ADRESH,W
	movwf	val2+1
	call 	add16			; addition des valeur de la convertion
	decfsz	cmpt,F
	goto	ANLoop1c

	CLOSEAN					;arret module de conversion
;devision par 8	des 8 additions
	bcf		STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc 	STATUS,C
	bsf		val1,7
	bcf 	STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc 	STATUS,C
	bsf		val1,7
	bcf 	STATUS,C 		;Effacer C
	rrf		val1, f
	bcf		STATUS,C 		;Effacer C
	rrf		val1+1, f
	btfsc	STATUS,C
	bsf		val1,7
	
	movf	val1,W
	movwf	MADRESL
	movf	val1+1,W
	movwf	MADRESH

	

	
	return
;*********************************************************************
;                  MODULES  De verification de charge                *
;*********************************************************************	
verifcharge

	Vout0					;Arret charge
	LEDOFF			;Arret Led pour plus de stabilit
	call	tempx			;Temp de stabilisation de la batterie
	call 	tempx
	
		

	call	readv			;lecture de la charge de la pille		
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	movf	MADRESH,W
	movwf	val1+1	
	movf	lastv+1,W		;charger la valeur de la dernire valeur de la pille dans V2
	movwf	val2+1
	movf	lastv,W			;charger la valeur de la dernire valeur de la pille dans V2
	movwf	val2
	call	sub16			;calculer la difference
	bcf		STATUS,Z		; effacement de z pour preparation a la ligne prochaine 	btfsc	STATUS,Z
	
	btfsc	Temp,3			;verifier si resultat est negative
	bsf		configini,3		; batrie charg

	btfsc	Temp,2			;verifier si valeur est nulle
	decf	cmptstable,F	; batrie stable
	btfsc	STATUS,Z		;Verifier nombre de stabilite attend
	bsf		configini,3		; batrie charg
	btfsc	Temp,2			; s'il n'est pas stable en le recharge par sa saleur
	goto 	VrCh
	movlw	nbrstable		;Charger nombre max de stabilit de la courbe de charge
	movwf	cmptstable

VrCh	
	movf	MADRESL,W		;chager lastv par derniere charge
	movwf	lastv		
	movf	MADRESH,W		;chager lastv par derniere charge
	movwf	lastv+1		
	call	formatM
	btfss	configini,3		;laisser Vout0 si charger pour declancher procedure de batrie charge
	call	calibrage		;batterie pas encore charg
	movlw	comptimerL		;remise a zero compeur timer
	movwf	ttimer
	movlw	comptimerH
	movwf	ttimer+1	
	clrf	TMR1L			;remise timer1 a 0
	clrf	TMR1H

	return	


		
;*********************************************************************
;                  MODULES  Calibrage                  *
;*********************************************************************
calibrage

	;Verifier si pille est decharg est doit etre
	;charge a un faible amperage

	Vout0				;Arret charge
	
	call readv				;Lecture taux de charge
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	movf	MADRESH,W
	movwf	val1+1
	movlw	dechargeL		;charger la valeur du taux de decharge dans val2
	movwf	val2
	movlw	dechargeH
	movwf	val2+1
	call	sub16
	btfsc	Temp,3			;verifier si resultat est negative
	goto	XV1				;sauter a la procedure de charge lente
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	XV1				;sauter a la procedure de charge lente
	
	;pille pas decharger: choix de l'amperage le plus elev sans surtension
	
	Vout3					;lancer une charge rapide
	call 	readv			;Lecture taux de charge
	BANK1
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	BANK0
	movf	MADRESH,W
	movwf	val1+1
	movlw	surchargeL		;charger la valeur du taux de decharge dans val2
	movwf	val2
	movlw	surchargeH
	movwf	val2+1
	call	sub16
	btfss	Temp,3			;verifier si resultat est negative
	goto	XV2				;sauter a la procedure de charge plus lente
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	XV2				;sauter a la procedure de charge plus lente
	return

XV2
	Vout2					;lancer une charge rapide
	call 	readv			;Lecture taux de charge
	BANK1
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	BANK0
	movf	MADRESH,W
	movwf	val1+1
	movlw	surchargeL		;charger la valeur du taux de decharge dans val2
	movwf	val2
	movlw	surchargeH
	movwf	val2+1
	call	sub16
	btfss	Temp,3			;verifier si resultat est negative
	goto	XV1				;sauter a la procedure de charge plus lente
	btfsc	Temp,2			;verifier si valeur est nulle
	goto	XV1				;sauter a la procedure de charge plus lente
	return
XV1
	Vout1					;lancer une charge rapide
	call 	readv			;Lecture taux de charge
	BANK1
	movf	MADRESL,W		;sauvgarde resultat convertion en val1
	movwf	val1
	BANK0
	movf	MADRESH,W
	movwf	val1+1
	movlw	surchargeL		;charger la valeur du taux de decharge dans val2
	movwf	val2
	movlw	surchargeH
	movwf	val2+1
	call	sub16
	btfss	Temp,3			;verifier si resultat est negative
	bsf		configini,5		;signaler pille defaillante
	btfsc	Temp,2			;verifier si valeur est nulle
	bsf		configini,5		;signaler pille defaillante
	return

;*********************************************************************
;                  MODULES  Soustraction    16Bits                   *
;*********************************************************************
; soustraction 16 bits:   	val1 = val1 - val2
;							Temp = 0000 C Z Z1 Z0 
;									C=1 	R Negatif
;									Z=1		resultat 16 Bit=0
;									Z1=1	8 bits poid ford =0
;									Z0=1	8 bits poid faible =0

sub16						;Procedure Principale
	clrf	Temp	
	movf	val2+1,w
	subwf	val1+1,w
	btfss	STATUS,C		;Test si resultat negatif (Partie H)
	goto	Val_Swap		;sinon inverser variables
	btfss	STATUS,Z		;tester si resultat =0
	goto	Calcul_sub		 
	movf	val2,w			;second test pour partie L
	subwf	val1,w
	btfss	STATUS,C		;Test si resultat negatif
	goto	Val_Swap		;sinon inverser
	clrf	Temp			;Effacer Temp pour vaoir signe
	
Calcul_sub
	movf   	val2,w		
	subwf  	val1,f
	btfsc	STATUS,Z
	bsf		Temp,0			;Signale zone Low =0	
	movf   	val2+1,w
	btfss  	STATUS,C
	addlw	01
	subwf  	val1+1,f
	btfsc	STATUS,Z
	bsf		Temp,1			;Signale zone High =0
	movf	Temp,W
	movwf	val2			;verifier si Z0 et Z1 sont null
	rrf		val2
	andwf	val2,F
	btfsc	val2,0
	bsf		Temp,2			;Resultat total =0
	
	return

Val_Swap
	movf    val1+1,W
	movwf   Temp
	movf    val2+1,W        ;val1+1 <--> Val2+1
	movwf   val1+1
	movf    Temp,W
	movwf   val2+1

	movf    val1,W
	movwf   Temp
	movf    val2,W        ;val1 <--> val2
	movwf   val1
	movf    Temp,W
	movwf   val2
	clrf	Temp
	bsf		Temp,3		;signaler negatif 	
	goto	Calcul_sub

;*********************************************************************
;                  MODULES  formatage message tentien 16bits                  *
;*********************************************************************
;les testions etant recupres sur var1 (var1+1 non considr dans l'affichage)
formatM

	incf	val1+1,W
	btfsc	STATUS,Z	; verifier val1+1 =  0XFF on n'incrimente pas
	goto	LabF0
	
	clrf	val2+1		; on ajoute 1 pour clignoter led meme en stable
	movlw	D'1'
	movwf	val2	
	call 	add16
	
LabF0	
	movf 	val1+1,F	;verifier val1+1 non null=> message max
	btfsc	STATUS,Z
	goto	LabF1		;pas de depassement de val1
	movlw	B'11111111'	
	movwf	messageT
	goto	LabFX
	



LabF1				

	movlw	D'7'
	movwf	cmptF
	movf	val1,W
	movwf	messageT	;charger messageT par val1 pour la conserver intacte

LabF11					;Val1<>0	
	btfss	messageT,7
	goto	LabF110
	goto	LabF111



LabF110					;Bit7=0
	rlf		messageT,F
	decfsz	cmptF,F
	goto	LabF11
	goto	LabFX		;situation impossible mais allahou a3lam



LabF111					;Bit7=1	
	bsf		messageT,0
	decfsz	cmptF,F
	goto	LabF111x
	goto 	LabFX


LabF111x
	rlf		messageT
	goto	LabF111



LabFX					;Formatage 16 Bits
	clrf	messageM
	clrf	messageM+1

	btfsc	messageT,0
	bsf		messageM,0

	btfsc	messageT,1
	bsf		messageM,2

	btfsc	messageT,2
	bsf		messageM,4

	btfsc	messageT,3
	bsf		messageM,6

	btfsc	messageT,4
	bsf		messageM+1,0

	btfsc	messageT,5
	bsf		messageM+1,2

	btfsc	messageT,6
	bsf		messageM+1,4

	btfsc	messageT,7
	bsf		messageM+1,6


	return



;*********************************************************************
;                  MODULES  addition    16Bits                   *
;*********************************************************************

add16	

	movf   val2+1,w
	addwf  val1+1,f
	movf   val2,w		; addition 16 bits
	addwf  val1,f		; val1 = val1 + val2
	btfsc  STATUS, C
	incf   val1+1,f
	return


;*********************************************************************
;                      SOUS-ROUTINE DE TEMPORISATION                 *
;*********************************************************************
;---------------------------------------------------------------------
; Cette sous-routine introduit un retard de 125.000 s 
;---------------------------------------------------------------------
tempo
			;124993 cycles
	movlw	0xA6
	movwf	cmpt1
	movlw	0x62
	movwf	cmpt2
Delay_00
	decfsz	cmpt1, f
	goto	$+2
	decfsz	cmpt2, f
	goto	Delay_00

			;3 cycles
	goto	$+1
	nop

			;4 cycles (including call)
	return

;*********************************************************************
;                      SOUS-ROUTINE DE TEMPORISATION                 *
;*********************************************************************
;---------------------------------------------------------------------
; Cette sous-routine introduit un retard de 125.000 s 
;---------------------------------------------------------------------
tempx
			;124993 cycles
	movlw	0xA6
	movwf	cmpt3
	movlw	0x62
	movwf	cmpt4
Delay_01
	decfsz	cmpt3, f
	goto	$+2
	decfsz	cmpt4, f
	goto	Delay_01

			;3 cycles
	goto	$+1
	nop

			;4 cycles (including call)
	return

	END 				; directive fin de programme
