//************************************************************************************
//**  
//**  File name:     C:\Users\edwin\Documents\PIC16F88\pic16F88.c
//**  Generated by:  Flowcode v3.4.7.48
//**  Date:          Sunday, December 26, 2010 17:46:56
//**  Licence:       
//**  Registered to: edwin
//**  
//**  
//**     PAS  USAGE COMMERCIAL
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_PIC

//Dfinir pour microcontrleur
#define P16F88
#define MX_EE
#define MX_EE_TYPE2
#define MX_EE_SIZE 256
#define MX_SPI
#define MX_SPI_B
#define MX_SPI_SDI 1
#define MX_SPI_SDO 2
#define MX_SPI_SCK 4
#define MX_UART
#define MX_UART_B
#define MX_UART_TX 5
#define MX_UART_RX 2
#define MX_I2C
#define MX_I2C_B
#define MX_I2C_SDA 1
#define MX_I2C_SCL 4
#define MX_PWM
#define MX_PWM_CNT 1
#define MX_PWM_TRIS1 trisb
#define MX_PWM_1 0
#define MX_PWM_TRIS1a trisb
#define MX_PWM_1a 3

//Fonctions
#include <system.h>
#pragma CLOCK_FREQ 1000000

//Configuration de donnes
#pragma DATA 0x2007, 0x3f38
#pragma DATA 0x2008, 0x3ffc

//Fonctions internes
#include "C:\Program Files\Matrix Multimedia\Flowcode V3\FCD\internals.h"

//Dclarations de fonction Macro


//Dclarations de Variable
short FCV_ENTIER;




//PWM0: //Dclarations de fonction Macro

void FCD_PWM0_Enable(char nIdx);
void FCD_PWM0_Disable(char nIdx);
void FCD_PWM0_SetDutyCycle(char nIdx, char nDuty);
void FCD_PWM0_ChangePeriod(char nPeriodVal, char nPrescalerVal);


//ADC0: //Dclarations de fonction Macro

void FCD_ADC0_SampleADC();
char FCD_ADC0_ReadAsByte();
short FCD_ADC0_ReadAsInt();

//Dfinitions supplmentaires




//PWM0: //Implmentations Macro


void FCD_PWM0_Enable(char nIdx)
{
	
	  //error checking
	  #ifndef MX_PWM
	    #warning "This chip does not have PWM capability"
	  #else
	    #ifndef MX_PWM_CNT
	      #pragma error FCD file error (no MX_PWM_CNT)
	    #endif
	    #if (MX_PWM_CNT < 1)
	      #pragma error FCD file error (MX_PWM_CNT < 1)
	    #endif
	    #if (MX_PWM_CNT > 2)
	      #pragma error FCD file error (MX_PWM_CNT > 2)
	    #endif
	    #ifndef MX_PWM_TRIS1
	      #pragma error FCD file error (no MX_PWM_TRIS1)
	    #endif
	    #ifndef MX_PWM_1
	      #pragma error FCD file error (no MX_PWM_1)
	    #endif
	    #if (MX_PWM_CNT == 2)
	      #ifndef MX_PWM_TRIS2
	        #pragma error FCD file error (no MX_PWM_TRIS2)
	      #endif
	      #ifndef MX_PWM_2
	        #pragma error FCD file error (no MX_PWM_2)
	      #endif
	    #endif
	    #if (0 == 1)
	      #ifndef MX_PWM_TRIS1a
	        #pragma error PWM component error (using alternative, but no MX_PWM_TRIS1a)
	        #define MX_PWM_ALT_ERROR
	      #endif
	      #ifndef MX_PWM_1a
	        #pragma error PWM component error (using alternative, but no MX_PWM_1a)
	        #define MX_PWM_ALT_ERROR
	      #endif
	    #endif
	    #if (0 == 2)
	      #ifndef MX_PWM_TRIS2a
	        #pragma error PWM component error (using alternative, but no MX_PWM_TRIS2a)
	        #define MX_PWM_ALT_ERROR
	      #endif
	      #ifndef MX_PWM_2a
	        #pragma error PWM component error (using alternative, but no MX_PWM_2a)
	        #define MX_PWM_ALT_ERROR
	      #endif
	    #endif
	  #endif

	 #ifdef MX_PWM
	    pr2 = 255;
	    t2con = 0x04;

	  #if (MX_PWM_CNT >= 1)
	    if (nIdx == 1)
	    {
	        ccp1con = 0x0C;

	      #if (0 == 1)
	       #ifndef MX_PWM_ALT_ERROR
	        clear_bit(MX_PWM_TRIS1a, MX_PWM_1a);
	       #endif
	      #else
	        clear_bit(MX_PWM_TRIS1, MX_PWM_1);
	      #endif
		}
	  #endif

	  #if (MX_PWM_CNT >= 2)
	    if (nIdx == 2)
	    {
	        ccp2con = 0x0C;
	      #if (0 == 2)
	       #ifndef MX_PWM_ALT_ERROR
	        clear_bit(MX_PWM_TRIS2a, MX_PWM_2a);
	       #endif
	      #else
	        clear_bit(MX_PWM_TRIS2, MX_PWM_2);
	      #endif
	   }
	  #endif
	 #endif

	 #ifdef MX_PWM_ALT_ERROR
	   #undef MX_PWM_ALT_ERROR
	 #endif

}

void FCD_PWM0_Disable(char nIdx)
{
	
	  //error checking
	  #ifndef MX_PWM
	    #warning "This chip does not have PWM capability"
	  #endif

	 #ifdef MX_PWM
	  #if (MX_PWM_CNT >= 1)
	    if (nIdx == 1)
	    {
	        ccp1con = 0x00;
	    }
	  #endif

	  #if (MX_PWM_CNT >= 2)
	    if (nIdx == 2)
	    {
	        ccp2con = 0x00;
	    }
	  #endif
	 #endif

}

void FCD_PWM0_SetDutyCycle(char nIdx, char nDuty)
{
	
	  //error checking
	  #ifndef MX_PWM
	    #warning "This chip does not have PWM capability"
	  #endif

	 #ifdef MX_PWM
	  #if (MX_PWM_CNT >= 1)
	    if (nIdx == 1)
	    {
	        ccpr1l = nDuty;
	    }
	  #endif

	  #if (MX_PWM_CNT >= 2)
	    if (nIdx == 2)
	    {
	        ccpr2l = nDuty;
	    }
	  #endif
	 #endif

}

void FCD_PWM0_ChangePeriod(char nPeriodVal, char nPrescalerVal)
{
	
	  //error checking
	  #ifndef MX_PWM
	    #warning "This chip does not have PWM capability"
	  #endif

	  #ifdef MX_PWM
	    pr2 = nPeriodVal;

	    switch (nPrescalerVal)
	    {
	        case 1:
	            t2con = 0x04;
	            break;

	        case 4:
	            t2con = 0x05;
	            break;

	        case 16:
	            t2con = 0x06;
	            break;
	    }
	  #endif

}



//ADC0: //Implmentations Macro


void FCD_ADC0_SampleADC()
{
	//This is from the FCD file...
	//set up ADC conversion
	char old_tris, cnt;
	#define MX_ADC_SAMP_TIME 40
	adcon1 = 0x00;

	//find appropriate bit
	#if (0 == 0)
	  #define MX_ADC_TRIS_REG  trisa
	  #define MX_ADC_TRIS_MSK  0x01
	  ansel = 0x00;
	#endif
	#if (0 == 1)
	  #define MX_ADC_TRIS_REG  trisa
	  #define MX_ADC_TRIS_MSK  0x02
	  ansel = 0x00;
	#endif
	#if (0 == 2)
	  #define MX_ADC_TRIS_REG  trisa
	  #define MX_ADC_TRIS_MSK  0x04
	  ansel = 0x00;
	#endif
	#if (0 == 3)
	  #define MX_ADC_TRIS_REG  trisa
	  #define MX_ADC_TRIS_MSK  0x08
	  ansel = 0x00;
	#endif
	#if (0 == 4)
	  #define MX_ADC_TRIS_REG  trisa
	  #define MX_ADC_TRIS_MSK  0x10
	  ansel = 0x00;
	#endif
	#if (0 == 5)
	  #define MX_ADC_TRIS_REG  trisb
	  #define MX_ADC_TRIS_MSK  0x20
	  ansel = 0x00;
	#endif
	#if (0 == 6)
	  #define MX_ADC_TRIS_REG  trisb
	  #define MX_ADC_TRIS_MSK  0x40
	  ansel = 0x00;
	#endif

	//sanity check
	#ifndef MX_ADC_TRIS_REG
	  #pragma error ADC conversion code error - please contact technical support
	#endif

	//store old tris value, and set the i/o pin as an input
	old_tris = MX_ADC_TRIS_REG;
	MX_ADC_TRIS_REG = MX_ADC_TRIS_REG | MX_ADC_TRIS_MSK;

	//turn ADC on
	adcon0 = 0x81 | (0 << 3);

	//wait the acquisition time
	cnt = 0;
	while (cnt < MX_ADC_SAMP_TIME) cnt++;

	//begin conversion and wait until it has finished
	adcon0 = adcon0 | 0x04;
	while (adcon0 & 0x04);

	//restore old tris value, and reset adc registers
	MX_ADC_TRIS_REG = old_tris;
	ansel = 0x00;
	adcon0 = 0x80;
	#undef MX_ADC_TRIS_REG
	#undef MX_ADC_TRIS_MSK
	#undef MX_ADC_SAMP_TIME

}

char FCD_ADC0_ReadAsByte()
{
	//This is from the FCD file...
	return adresh;

}

short FCD_ADC0_ReadAsInt()
{
	//This is from the FCD file...
	short iRetVal;
	iRetVal = (adresh << 2);
	iRetVal += (adresl >> 6);
	return (iRetVal);

}

//Implmentations Macro

//Installation supplmentaire


void main()
{
	
	//Initialisation
	ansel = 0;
	cmcon = 0x07;


	//Code d'initialisation d'Interruption
	option_reg = 0xC0;


	//Appel de la Routine Composant
	//Appel de la Routine Composant: PWM(0)::Enable(1)
	FCD_PWM0_Enable(1);


	//Boucle
	//Boucle: Tant que1
	while (1)
	{
		//Appel de la Routine Composant
		//Appel de la Routine Composant: ADC(0)::SampleADC
		FCD_ADC0_SampleADC();


		//Appel de la Routine Composant
		//Appel de la Routine Composant: entier=ADC(0)::ReadAsInt
		FCV_ENTIER = FCD_ADC0_ReadAsInt();


		//Calcul
		//Calcul:
		//  entier = entier / 4
		FCV_ENTIER = FCV_ENTIER / 4;
		

		//Appel de la Routine Composant
		//Appel de la Routine Composant: PWM(0)::SetDutyCycle(1, entier)
		FCD_PWM0_SetDutyCycle(1, FCV_ENTIER);


	}


	mainendloop: goto mainendloop;
}

void interrupt(void)
{
}



