#ifndef LCD_CONSTS_H
#define LCD_CONSTS_H

/* DATA_PORT defines the port to which the LCD data lines are connected */
#define DATA_PORT      PORTC
#define TRIS_DATA_PORT TRISC

/* CTRL_PORT defines the port where the control lines are connected.
 * These are just samples, change to match your application.
 */
#define TRIS_RW  TRISAbits.TRISA7    /* TRIS for RW */ 
#define TRIS_RS  TRISAbits.TRISA5    /* TRIS for RS */ 
#define TRIS_E   TRISAbits.TRISA6    /* TRIS for E  */

#define RW_PIN   LATAbits.LATA7   /* 6 PORT for RW */ 
#define RS_PIN   LATAbits.LATA5  /* 5 PORT for RS */ 
#define E_PIN    LATAbits.LATA6  /* 4 PORT for E  */ 

#define LCD_LOWER

#ifdef LCD_LOWER
	#define LCD_MASK_ET_0 (0xF0)
	#define LCD_MASK_ET_1 (0x0F)
	#define LCD_MASK_OU_0 (0xF0)
	#define LCD_MASK_OU_1 (0x0F)
#elif defined(LCD_UPPER)
	#define LCD_MASK_ET_0 (0x0F)
	#define LCD_MASK_ET_1 (0xF0)
	#define LCD_MASK_OU_0 (0x0F)
	#define LCD_MASK_OU_1 (0xF0)
#else
	#error vous devez choisir LCD_UPPER ou LCD_LOWER
#endif

/* Display ON/OFF Control defines */
#define DON         0b00001111  /* Display on      */
#define DOFF        0b00001011  /* Display off     */
#define CURSOR_ON   0b00001111  /* Cursor on       */
#define CURSOR_OFF  0b00001101  /* Cursor off      */
#define BLINK_ON    0b00001111  /* Cursor Blink    */
#define BLINK_OFF   0b00001110  /* Cursor No Blink */
#define DCLEAR		0b00000001  // display clear

/* Entry set : cursor decrement ou increment, cursor accompagne shift ou non */
#define ENTRY_SET		0b00000111
#define CURSOR_DEC		0b00000101
#define CURSOR_NOT_ACC	0b00000110

/* Cursor or Display Shift defines */
#define SHIFT_CUR_LEFT    0b00010011  /* Cursor shifts to the left   */
#define SHIFT_CUR_RIGHT   0b00010111  /* Cursor shifts to the right  */
#define SHIFT_DISP_LEFT   0b00011011  /* Display shifts to the left  */
#define SHIFT_DISP_RIGHT  0b00011111  /* Display shifts to the right */

/* Function Set defines */
#define FOUR_BIT   0b00101100  /* 4-bit Interface               */
#define EIGHT_BIT  0b00111100  /* 8-bit Interface               */
#define ONE_LINE   0b00110100  /* 5x7 characters, multiple line */
#define TWO_LINES  0b00111100  /* 5x7 characters, multiple line */
#define LINE_5X7   0b00111000  /* 5x7 characters, single line   */
#define LINE_5X10  0b00111100  /* 5x10 characters               */

// caractres
#define CARAC_INFINI 0xF3
// caractres perso : entre 0 et 15 compris
// (si 0, ne pas utiliser directement dans la chane
//  car 0 = fin de chane)
#define CARAC_e_AIGU	0x00
#define CARAC_e_GRAVE	0x01
#define CARAC_E_AIGU	0x02
#define CARAC_a_GRAVE	0x03
#define CARAC_A_GRAVE	0x04
#define CARAC_e_CIRCON	0x05
#define CARAC_c_CEDILLE	0x06
#define CARAC_x_MOY		0xF8

#endif
