#include <delays.h>
#include "lcd_fonctions.h"
#include "lcd_constantes.h"
#include "commun.h"

#ifdef __DEBUG
	char LCD_ligne1[17];
	char LCD_ligne2[17];
	UINT8 adresseLCD = 0; // Adresse, premier bit = 1 pour CGRAM
#endif

// prototypes
char read_4bits(char RS);

UINT8 nb_delai = 0;
char lu;
char timeout_LCD = 0;
/*void DelayFor18TCY(void) {
	Delay10TCYx(20); //Delay 120 cycles pour read
}
*/

	
char busyLCD() {
	#ifndef __DEBUG
		if (timeout_LCD) return 0;
		else {
			#ifdef LCD_UPPER
				return (read_4bits(0) & 0x80);
				#error x
			#else
				return (read_4bits(0) & 0x08);
			#endif
		}	
	#else
		return 0;
	#endif
}

void write_4bits(char x, char RS) {
	TRIS_DATA_PORT &= LCD_MASK_ET_0;
	RW_PIN = 0;                     // R/W pin made low
	RS_PIN = RS;                     // Register select pin made low
	
	E_PIN = 1;                      // Clock pin made low
	DATA_PORT &= LCD_MASK_ET_0;
	DATA_PORT |= (x & LCD_MASK_ET_1);
	
	#ifdef PLL_EN
		Delay10TCYx(1);
	#endif
	
	E_PIN = 0;
	//fin
	#ifdef PLL_EN
		Delay10TCYx(1);
	#endif
	
}

// ajouts
void write_8bits(char x, char RS) {
	#ifdef LCD_UPPER
		write_4bits(x, RS);
		//DelayFor18TCY();
		
		write_4bits(x<<4, RS);
		//DelayFor18TCY();
	#else
		write_4bits(x>>4, RS);
		//DelayFor18TCY();
		
		write_4bits(x, RS);
		//DelayFor18TCY();
	#endif
	
	#ifdef __DEBUG
		if (RS == 0) {
			// Instructions
			if (x == DCLEAR) {
				UINT16 i;
				for(i=0; i<16; ++i) {
					LCD_ligne1[i] = ' ';
					LCD_ligne2[i] = ' ';
				}
				LCD_ligne1[16] = '\0';
				LCD_ligne2[16] = '\0';
			}
			else if ((x & 0x80) == 0x80) {
				// Instruction SetDDRAMAdresse
				adresseLCD = (x & 0x7F);
			}
			else if ((x & 0x40) == 0x40) {
				// Instruction SetCGRAMAdresse
				adresseLCD = 0x80 | (x & 0x3F);
			}
		}
		else if (RS == 1) {
			// Donnes mmoire
			if (0<=adresseLCD && adresseLCD<16) {
				LCD_ligne1[adresseLCD] = x;
			}
			else if (0x40<=adresseLCD && adresseLCD<(0x40+16)){
				LCD_ligne2[adresseLCD-0x40] = x;
			}

			// bit n7  1 = CGRAM
			if ((adresseLCD & 0x80) == 0) {
				adresseLCD++;
				adresseLCD &= 0x7F;
			}
			else {
				// CGRAM
				adresseLCD++;
				adresseLCD |= 0x80;
			}
		}
	#endif
}

char read_4bits(char RS) {
	char lu = 0;
	
	TRIS_DATA_PORT |= LCD_MASK_OU_1; // 1 pr lecture
	RS_PIN = RS;
	RW_PIN = 1;
	
	Nop();
	
	#ifdef PLL_EN
		Delay10TCYx(1);
	#endif
	
	E_PIN = 1;
	Nop(); Nop(); Nop();
	#ifdef PLL_EN
		Delay10TCYx(1);
	#endif
	E_PIN = 0;
	
	#ifdef PLL_EN
		Delay10TCYx(1);
	#endif
	Nop();
	lu = (DATA_PORT & LCD_MASK_ET_1);
	return lu;
}

/*
char read_up(char RS) {
	char lu = 0;
	
	TRIS_DATA_PORT |= 0xF0; // 1 pr lecture
	RW_PIN = 1;
	RS_PIN = RS;
	
	// poids fort
	E_PIN = 1;
	DelayFor18TCY();
	E_PIN = 0;
	
	lu = DATA_PORT & 0xF0;
	
	// poids faible
	E_PIN = 1;
	DelayFor18TCY();
	E_PIN = 0;
	
	lu |= ((DATA_PORT & 0xF0) >> 4);
	
	return lu;
}
*/




void openLCD() {
	
	TRIS_RW = 0;
	TRIS_RS = 0;
	TRIS_E = 0;
	
	timeout_LCD = 0;
	
	/* avant :
	0, 1, 0, 0, 1
	avec 5ms entre chaque
	*/
	write_ins(DCLEAR); // 5ms
	delai_ms(5);
	/*write_4bits(0, 0);
	delai_ms(5);
	write_ins(DCLEAR); // 5ms
	delai_ms(5);*/
	
	
	// dbut
	write_4bits(EIGHT_BIT, 0); // 5ms
	delai_ms(5);
	
	write_4bits(EIGHT_BIT, 0); // 100s
	delai_10us(10);
	
	write_4bits(EIGHT_BIT, 0);
	
	//delai_10us(10);
	attente_LCD();
	
	write_4bits(FOUR_BIT, 0);
	attente_LCD();
	write_ins(FOUR_BIT & TWO_LINES & LINE_5X7); // 0010NFxx display set
	
	attente_LCD();
	write_ins(DON & CURSOR_OFF & BLINK_OFF); // DON & CUR_OFF & BOFF
	
	attente_LCD();
	write_ins(ENTRY_SET & CURSOR_NOT_ACC); // entry mode set : 1 I/D S
	
	attente_LCD();
	write_ins(DCLEAR); // display clear
	
	// end
	// set adresse
	
}

void setDDRAMaddress(UINT8 x) {
	attente_LCD();
	write_ins(x | 0x80);
}
//#define READ_UP() {TRIS_DATA_PORT &= 0x0F; DATA_PORT &= 0x0F; DATA_PORT |= (x<<4);}

void puts_LCD(const char* buffer) {
	while(*buffer) {            // Write data to LCD up to null
		write_LCD(*buffer); // Write character to LCD
		buffer++;               // Increment buffer
	}
}

void puts_LCD_rom(const rom char* buffer) {
	while(*buffer) {            // Write data to LCD up to null
		write_LCD(*buffer); // Write character to LCD
		buffer++;               // Increment buffer
	}
}


// convertit un caractre spcial et crit sur le LCD
void write_LCD(char x) {	
	 char y;
	 y = convertAscii2Lcd(x);
	 attente_LCD();
	 write_data(y);
}	 


void add_carac(UINT8 num, char l1, char l2, char l3,
		char l4, char l5, char l6, char l7) {
	// setCGRAMaddress(num*8) :
	attente_LCD();
	write_ins(0b01000000 | ((num*8) & 0x3F));

	attente_LCD();
	write_data(l1);

	attente_LCD();
	write_data(l2);

	attente_LCD();
	write_data(l3);

	attente_LCD();
	write_data(l4);

	attente_LCD();
	write_data(l5);

	attente_LCD();
	write_data(l6);

	attente_LCD();
	write_data(l7);
	
	attente_LCD();
	write_data(0); // curseur
}

void clear_LCD() {
	attente_LCD();
	write_ins(DCLEAR);
	delai_ms(2);
}


void testLCD(char param) {
	UINT8 i;
	
	openLCD();
	delai_ms(10);
	
	/*if (param & 0x01) {
		write_ins(ENTRY_SET); // entry mode set : 1 I/D S
		delai_ms(10);
		write_ins(DCLEAR);
		delai_ms(10);
	}
	
	if (param & 0x02) {
		write_ins(0x02); // return home
		delai_ms(10);
	}
	*/
	
	clear_LCD();
	delai_ms(10);
	
	goto_line1();
	
	for(i=0; i<16; ++i) {
		attente_LCD();
		write_data('a' + i);
	}
}


void attente_LCD() {
	UINT16 attente_timeout;
	
	if (!busyLCD()) return;
	
	attente_timeout = 32000;
	
	while(busyLCD()) {
		attente_timeout++;
		
		// si on a attendu trop longtemps : timeout = 1
		if (attente_timeout==0) timeout_LCD = 1;
	}
}

void delai_ms(UINT16 n) {
	UINT16 i;
	for(i=0; i<n; ++i) {
		delai_100us(10);
		Nop();
	}	
}	


// Convertit les caractres accentus
char convertAscii2Lcd(char x) {
	// HEX : E0  E9
	static rom const char corresp[] =
	{
	// A0 -> AF
	 '.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,0x5C	// 8 ou  (mais  sur LCD = \ )
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.',
	 
	// B0 -> BF
	 0xDF //  (degr)
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.'
	 ,'.',
	 
	// C0 -> CF
	 CARAC_A_GRAVE	// 
	 ,'A'	// 
	 ,'A'	// 
	 ,'A'	// 
	 ,'A'	// 
	 ,'A'	// 
	 ,'A'	// 
	 ,'C'	// 
	 ,'E'	// 
	 ,CARAC_E_AIGU	// 
	 ,'E'	// 
	 ,'E'	// 
	 ,'I'	// 
	 ,'I'	// 
	 ,'I'	// 
	 ,'I',	// 
	 
	// D0 -> DF
	 '.'	// 
	 ,'.'	// 
	 ,'O'	// 
	 ,'O'	// 
	 ,'O'	// 
	 ,'O'	// 
	 ,'O'	// 
	 ,'.'	// 
	 ,'.'	// 
	 ,'U'	// 
	 ,'U'	// 
	 ,'U'	// 
	 ,'U'	// 
	 ,'Y'	// 
	 ,'.'	// 
	 ,'.',	// 
	
	// E0 :                   
	 CARAC_a_GRAVE, // 
	 'a', // 
	 'a', // 
	 'a', // 
	 0xE1, // 
	 'a', // 
	 'a', // 
	 CARAC_c_CEDILLE, // 
	 CARAC_e_GRAVE,	// 
	 CARAC_e_AIGU, // 
	 CARAC_e_CIRCON, // 
	 'e', // 
	 'i', // 
	 'i', // 
	 'i', // 
	 'i'  // 
	 
	// F0 -> FF
	 ,'o' // 
	 ,0xEE // 
	 ,'o' // 
	 ,CARAC_INFINI //  (mais LCD = symbole infini)
	 ,'o'
	 ,'o'
	 ,0xEF // 
	 ,0xFD // 
	 ,CARAC_x_MOY //  (mais x moyenne sur LCD)
	 ,'u'
	 ,'u'
	 ,'u'
	 ,0xF5 // 
	 ,'y' // 
	 ,'.' // 
	 ,'y' // 
	};
	
	// 21 -> 7D sauf 5C : caractres normaux (lettres ,.+- ...)
	//  (sauf 5C =  au lieu de \ )
	// C0 -> DF : MAJ ACCENTUEES
	// E0 -> FF : min accentues
	if (x>0x9F) { // && x<0xEA) {
		#ifndef __DEBUG
		x = corresp[x-0xA0];
		#endif
	}
	return x;
}


void registerCaracLcd(void) {
	// caractre 
	#ifdef CARAC_e_AIGU
		add_carac(CARAC_e_AIGU, 2, 4, 14, 17, 31, 16, 14);
	#endif
	// caractre 
	#ifdef CARAC_e_GRAVE
		add_carac(CARAC_e_GRAVE, 8, 4, 14, 17, 31, 16, 14);
	#endif
	// caractre 
	#ifdef CARAC_a_GRAVE
		add_carac(CARAC_a_GRAVE, 8, 4, 14, 1, 15, 17, 15);
	#endif
	// caractre 
	#ifdef CARAC_A_GRAVE
		add_carac(CARAC_A_GRAVE, 8, 4, 14, 17, 31, 17, 17);
	#endif
	// caractre 
	#ifdef CARAC_E_AIGU
		add_carac(CARAC_E_AIGU, 2, 4, 31, 16, 30, 16, 31);
	#endif
	// caractre 
	#ifdef CARAC_c_CEDILLE
		add_carac(CARAC_c_CEDILLE, 15, 16, 16, 16, 15, 2, 14);
	#endif
	// caractre 
	#ifdef CARAC_e_CIRCON
		add_carac(CARAC_e_CIRCON, 14, 17, 14, 17, 31, 16, 14);
	#endif
}	

