#ifndef LCD_FONCTIONS_H
#define LCD_FONCTIONS_H

#include "commun.h"

// prototypes
char read_up(char RS);
void delai_100us(UINT8);
void delai_ms(UINT16);

#ifdef PLL_EN
	#define delai_10us(n)	Delay10TCYx((n)<<3)
//	#define delai_ms(n)	Delay1KTCYx((n)<<3)
#else
	#define delai_10us(n)	Delay10TCYx((n)<<1)
//	#define delai_ms(n)	Delay1KTCYx((n)<<1)
#endif

char busyLCD();

// ajouts
void write_4bits(char x, char RS);
void write_8bits(char x, char RS);

#define write_ins(x) write_8bits(x, 0)

char read_up(char RS);

void openLCD(void);

void setDDRAMaddress(UINT8 x);
//#define READ_UP() {TRIS_DATA_PORT &= 0x0F; DATA_PORT &= 0x0F; DATA_PORT |= (x<<4);}

void attente_LCD(void);

//void write_data(char x);

char convertAscii2Lcd(char x);

#define write_data(x) write_8bits(x, 1)

void write_LCD(char x);

void puts_LCD(const char* buffer);
void puts_LCD_rom(const rom char* buffer);

#define goto_line1() setDDRAMaddress(0x0);
#define goto_line2() setDDRAMaddress(0x40);
#define goto_carac(l, c) setDDRAMaddress(0x40*(l-1) + (c));

// ajouter un caractre
void add_carac(UINT8 num, char l1, char l2, char l3,
		char l4, char l5, char l6, char l7);

void clear_LCD(void);

void testLCD(char);

void registerCaracLcd(void);

#endif
