;					
; 				COMMANDE TELEPHONIQUE
;
;	
;    NOM			:		cde_tel1_essai.asm
;    Projet			:		
;    fichier travail:  	
;    Date			:       jeudi 25 novembre 2010   12h15
;    Version		:   	V.01_01                                                  
;    Auteur			:  		CAPAMINODE
;    Commentaires  	:   	le programme fonctionne jusqu' la dtermination du code
;							d'entre  4 chiffres	
;
;
;
; MT8870 
;	SIGNAL DTMF entre     valeur sortie binaire
;		
;		1						0001
;		2						0010
;		3						0011
;		4						0100
;		5						0101
;		6						0110
;		7						0111
;		8						1000
;		9						1001
;		0						1010

;*****************************************************************************************
;    Fichier requis: P16F648A.inc 
;*****************************************************************************************
 
	LIST      p=16F648A           ; Dfinition de processeur
	#include <p16F648A.inc>       ; Dfinitions des constantes

	__CONFIG _CP_OFF & _BODEN_OFF & _PWRTE_ON  & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _XT_OSC

;_CP_OFF   : pas de protection du code
;_BODEN_ON : reset du PIC si tension alim en dessous seuil ?
;_WDT_OFF  : pas de watchdog
;_PWRTE_ON : attendre 72ms aprs mise sous tension
;_LVP_OFF  : pas de mode programmation basse tension
;_MCLRE_ON : reset du PIC lors de la mise sous tension
;_MCLRE_OFF: reset du PIC en interne, RA5 est configure en entre
;_XT_OSC   : quartz 2 et 4 MHz
;_HS_OSC   : quartz 8 et 16 MHz
;_INTRC_OSC_NOCLKOUT : oscillateur interne

	ERRORLEVEL	-302
	ERRORLEVEL	-305
	ERRORLEVEL	-306
;*********************************************************************
;                        ASSIGNATIONS                          
;*********************************************************************

OPTION_val	EQU	b'11000111'		; Rsistances pull-up dsatives(1)/actives(0)
								; Interrupt flanc montant RB0 (1)
								; selection horloge en interne (0) sinon sur RA4 (1)
								; incrementation TMR0 sur front montant (0)
								; Prescaler sur timer0 (0) sur WDT (1)
								; reglage du prescaler sur 256 (0111)
								; RBPU (bit7) dsactivation auto quand le PORT est en sortie
STATUS_val	equ	b'00000000'
INTCON_val	equ	b'11000000' 	;interr globale autorisee
TRISA_val	equ	b'00001111'
TRISB_val	equ	b'10000001'		;tout en entree
PCON_val	equ	b'00001000'	
PIE1_val	equ	b'00000000'		;
PIR1_val	equ	b'00000000'		;
CMCON_val	equ	b'00000000'		;
VRCON_val	equ	b'00110000'		;rfrence tension pour comparateurs

prescal_TMR1		equ	b'00110000'	;prescal TMR1 rgl  8 (bits 5,4)
val_nbre_sonnerie	equ	4
t_code				equ	20		;dcompt toutes les 524 ms (pour temps_code = 20 ---> 10s)


;-------------------- codes entre  -------------------
nbre_chiffre_code_entree			equ		0x04	;4
chiffre_code_entree_1				equ		1
chiffre_code_entree_2				equ		2
chiffre_code_entree_3				equ		1
chiffre_code_entree_4				equ		2

;-------------------- codes matriel  -------------------
nbre_chiffre_code_materiel			equ		0x04	;4
nbre_materiel_commande				equ		0x04
;CHAUFFE-EAU
chiffre_code_materiel_11			equ		b'00000001'		;1
chiffre_code_materiel_l2			equ		b'00000001'		;2
chiffre_code_materiel_l3			equ		b'00000001'		;3
chiffre_code_materiel_l4			equ		b'00000001'		;4
materiel_numero_1					equ		b'00000001'

;CHAUFFAGE N1
chiffre_code_materie1_21			equ		b'00000010'		;5
chiffre_code_materiel_22			equ		b'00000010'		;6
chiffre_code_materiel_23			equ		b'00000010'		;7
chiffre_code_materiel_24			equ		b'00000010'		;8
materiel_numero_2					equ		b'00000010'

;CHAUFFAGE N2
chiffre_code_materie1_31			equ		b'00000011'		;9
chiffre_code_materiel_32			equ		b'00000011'		;0
chiffre_code_materiel_33			equ		b'00000011'		;1
chiffre_code_materiel_34			equ		b'00000011'		;2
materiel_numero_3					equ		b'00000011'

;CHAUFFAGE N3
chiffre_code_materie1_41			equ		b'00000100'		;8
chiffre_code_materiel_42			equ		b'00000100'		;0
chiffre_code_materiel_43			equ		b'00000100'		;2
chiffre_code_materiel_44			equ		b'00000100'		;2
materiel_numero_4					equ		b'00000100'


;**************************************
;		DEFINE
;**************************************

#define		decrocher_telephone	bsf	PORTB,5
#define		racrocher_telephone	bcf	PORTB,5

;**************************************
;		MACRO
;**************************************

bank0	macro
		bcf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank1	macro
		bsf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank2	macro
		bcf	STATUS,RP0
		bsf	STATUS,RP1
		endm

bank3	macro
		bsf	STATUS,RP0
		bsf	STATUS,RP1
		endm	

;;;;;;;;;;;;;;;;;;;;;;;; MACRO TMR1 ;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;; MACRO TMR0 ;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;; MACRO RB0 ;;;;;;;;;;;;;;;;;;;;;;;
effacer_flag_RB0	macro
					bcf	INTCON,1
					endm

activer_interr_RB0	macro
					bsf	INTCON,4					
					endm
desactiver_interr_RB0	macro
						bcf	INTCON,4					
						endm

front_montant_RB0	macro
					bank1
					bsf	OPTION_REG,6
					bank0
					endm
front_descendant_RB0	macro
						bank1
						bcf	OPTION_REG,6
						bank0
						endm


recharger_nbre_sonnerie	macro
						movlw	val_nbre_sonnerie
						movwf	nbre_sonnerie
						endm
						
;::::::::::::::::::::::::::::::::::::::::::::::::

charger_NCCE_dans_NCC	macro
						movlw	0x00
						movwf	repere_2EPROM
						call	lire_repere_2EPROM
						movwf	NCC
						endm

charger_NCCM_dans_NCC	macro
						movlw	0x10
						movwf	repere_2EPROM
						call	lire_repere_2EPROM
						movwf	NCC
						endm

					;charger_nbre_materiel_commande_dans_NMC		
cnmc_NMC			macro
					movlw	0x20
					movwf	repere_2EPROM
					call	lire_repere_2EPROM
					movwf	NMC
					endm

ecrire_dans_numero_materiel		macro
								movwf	numero_materiel
								endm
															
;:::::::::::::::  DTMF  ::::::::::::::::::						

lecture_decodeur_DTMF	macro
						movlw	b'00001111'
						andwf	PORTA,0
						movwf	valeur_lue		;lecture PORTA 3210 dans "valeur_lue"
						endm
						
incrementer_RAM			macro
						incf	pointeur_RAM,1
						movf	pointeur_RAM,0
						movwf	FSR
						endm
						
ecrire_dansRAM			macro
						movf	valeur_lue,0
						movwf	INDF
						endm

						
pointer_debut_RAM		macro
						movlw	0x20
						movwf	pointeur_RAM
						movwf	FSR
						endm				

lire_valeur_lue_RAM			macro
							movf	INDF,0
							movwf	valeur_lue
							endm					
;:::::::::::::::  interr RB  :::::::::::::::::::::
activer_interr_RB	macro
					bsf		INTCON,3
					endm

desactiver_interr_RB	macro
						bcf		INTCON,3
						endm
						
effacer_flag_RB		macro
					movf	PORTB,1		;avant d'effacer le flag RBIF il faut lire
					bcf		INTCON,0	;le PORTB
					endm
;:::::::::::::::::::::::::::::::::::::::::::::::::					

charger_temps_code	macro
							movlw	t_code
							movwf	temps_code		
							endm


;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

;exemples
;---------

	CBLOCK 0x20   		; dbut de la zone variables


	w_temp			:		1
	status_temp 	:		1		; zone de 1 byte
	PDel0			:		1
	PDel1			:		1
	PDel2			:		1
	t1				:		1
	t2				:		1

	ENDC

;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

			org 	0x000 		; Adresse de dpart aprs reset
 	    	goto	init		; Adresse 0: initialiser

;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 	0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp
	
	;+++++++++++++++++++++++++++++++++++++++++++
	
								
			;autorisation interr RB0 ?
AI_RB0		btfss	INTCON,4	
			goto	ITA3

			;tat flag RB0 ?
F_RB0		btfss	INTCON,1
			goto	ITA3
			effacer_flag_RB0

	;+++++++++++++++++++++++++++++++++++++++++++


			;autorisation interr RB ?
ITA3		btfss	INTCON,3
			goto	fin_interr

			;etat flag RB ?
ITA4		btfss	PORTB,7
			goto	fin_interr
				


attente		btfsc	PORTB,7
			goto	attente
																
			effacer_flag_RB
			goto	fin_interr

	;+++++++++++++++++++++++++++++++++++++++++++
			;restaurer registres
			;-------------------

fin_interr	swapf	status_temp,w	
			movwf	STATUS	 
			swapf	w_temp,f	           	
			swapf	w_temp,w
			retfie  	

;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

init	bank1				; slectionner banque 1
		clrf	EEADR		; permet de diminuer la consommation
		movlw	OPTION_val	; charger masque
		movwf	OPTION_REG	; initialiser registre option
		movlw	TRISA_val
		movwf	TRISA
		movlw	TRISB_val
		movwf	TRISB
		movlw	PIE1_val
		movwf	PIE1
		bank0				; Slectionner banque 0
		clrf	PORTA		; Sorties portA  0
		clrf	PORTB		; sorties portB  0
		movlw	INTCON_val	; masque interruption
		movwf	INTCON		; charger interrupt control
		movlw	PIR1_val	
		movwf	PIR1
		movlw	b'00000111'	;dsactiver comparateurs
		addwf	CMCON
		
;**************************  effacement de toute la RAM  **************************
init1	movlw	0x20
		movwf	FSR
ini		clrf	INDF
		incf	FSR,1
		movlw	0x80
		subwf	FSR,0
		btfss	STATUS,Z
		goto	ini		
		
;**************************  fin d'effacement de la RAM  **************************

	
	effacer_flag_RB
	activer_interr_RB
	effacer_flag_RB0
	desactiver_interr_RB0
	front_montant_RB0
	
	
loop	nop
		
		goto	loop



;----------------  routines call  --------------------




;&&&&&&&&&&&&&&&&&&&&&&&&&&& TEMPORISATIONS &&&&&&&&&&&&&&&&&&&&&&&&&&&
         
        
;;;;;;;;;;;;;;;;;;;  tempo 1s ;;;;;;;;;;;;;;;;;;;
;	10ms  avec 1 10 247
;	20ms  avec 1 20 247
; 	71ms  avec .1 .1 .247 
;	142ms avec .2 .72 .247
; 	1s    avec .14 .72 .247
;	2s    avec .28 .72 .247
;	3s    avec .42 .72 .247
;	4s    avec .56 .72 .247
;	5s    avec .70 .72 .247


tempo 		movf     t1,0		      
        	movwf     PDel0     
inter_0  	movf     t2,0     
       	 	movwf     PDel1     
inter_1		movlw     247      
        	movwf     PDel2     
inter_2  	clrwdt              
        	decfsz    PDel2, 1  
        	goto      inter_2    
        	decfsz    PDel1,  1 
        	goto      inter_1    
        	decfsz    PDel0,  1 
        	goto      inter_0    
inter_3  	goto 	  inter_4         
inter_4  	clrwdt              
        	return              


	END

