#include <stdio.h>
#include <p18f4550.h>
#include <delays.h>
#include "constante.h"
#include "abclock.h"
#include <usart.h>
#include <i2c.h>






int core_init(void){	
	extern struct flag flag;
	extern int count100it;
	extern int count1000it;
	extern int flagMode;
	
	/*INIT DES PORT */
	PORTD	= 0x00;	PORTA = 0x00;	PORTB = 0x00;	PORTC = 0x00;
	TRISD	= 0x00;	TRISA = 0x00;	TRISB = 0x00;	TRISC = 0x00;
	/* INIT TRISB POUR BP */ 
	TRISB |=0b00000011;	//B3 et B4 en entre
	// CONFIG I2C 
	TRISB |= 0b00011111;	//B0 et B1 en entre I2C / B2 en INT2 sur sortie PCF85838583
	//Activation I2C mode master 100Khz 
	OpenI2C(MASTER,SLEW_OFF);
	//MSSP Baud Rate
	SSPADD = 0x27;
	
/*	#if _DEBUG_	
		StopI2C();	//Pour le debugger PROTEUS VSM et l'analyseur IC
	#endif*/
	
	
	/*INIT PERIPHE*/
	ADCON0 = OFF;				//ADC OFF
	ADCON1 = 0xFF;				//All in TOR
	ADCON2 = OFF;				//Pour la forme
	CMCON = OFF;				//COMPARATEUR OFF
	RCONbits.IPEN = OFF;		//no prior IT
	INTCON2bits.RBPU = OFF;	//no PORTB pull'up
	
	/*IT INIT*/
	T0CON 				= 	0b11000100;		//TMR0 8bit + prescaler
	TMR0L 				= 	TMR0Lstart;		//TMR0 initial value
	
	INTCONbits.TMR0IE 	= 	1;		//IT overflow from TRM0 ON
	INTCON2bits.INTEDG2 	= 	0;		//IT sur RB2 a chaque front montant
	INTCON3bits.INT2IE		=	1;		//INT2 ENABLE
	INTCON3bits.INT2IP 		=	0;
	INTCON3bits.INT2IF 		= 	0; 		//INT2 FLAG cleared
	
	INTCONbits.PEIE 	= 	1;		//IT perif ON
	INTCONbits.GIE 		= 	1;		//IT enable = _IT_ON
	
	count100it			=	0;
	count1000it			=	0;
	
	flag.mode 			= 	_MODE_1;
}
void setTime(){
	extern struct myTime time;
	time.new.u.h = 12;
	time.new.u.m = 12;
	time.new.u.s = 12;
}
void iniTime(void){
	extern struct myTime time;
	time.new.u.h 	= _DEFTIME_H;
	time.new.u.m 	= _DEFTIME_M;
	time.new.u.s 	= _DEFTIME_S;
	
	time.old.u.h 		= _DEFTIME_H;
	time.old.u.m 	= _DEFTIME_M;
	time.old.u.s 		= _DEFTIME_S;
}
void cnt_init(void){
	char i = 0;
	char init = false;
	if(!init)
	{
		cEnb = 0;
		cRst = 1;
		cRst = 0;
		for(i=0;i<9;i++)
		{
			cClk = 1;
			cClk = 0;	
		}
		init = true;
	}	
}

/**********************************************\
*				PCF8583 FUNCTION					  *
\**********************************************/
char bcd2bin(char data){
	return (data&0x0F)+(((data&0xF0)>>4)*10);		
}
char bin2bcd(char data){
	return (((data/10)<<4)+(data%10));	
}
void pcf8583_init(void){	
	//STOP LE COMPTAGE
	pcf8583_write_cfg(0x00 ,_COUNT_STOP);Delay1KTCYx(1);
	pcf8583_write_cfg(_PCF8583_ADDR_HOUR, _MODE12 | _AM|0b00010001);Delay1KTCYx(1);
	pcf8583_write_cfg(_PCF8583_ADDR_MNS,0b01011001);Delay1KTCYx(1);
	pcf8583_write_cfg(_PCF8583_ADDR_SEC,0b01011001);Delay1KTCYx(1);
	pcf8583_write_cfg(0x00 ,_COUNT_START | 0x04);Delay1KTCYx(1);

	pcf8583_write_cfg(0x08,0xC3);Delay1KTCYx(1);	//TIMER EVERY x SECOND
	pcf8583_write_cfg(0x0F,0x01);Delay1KTCYx(1);	//x = 60
	pcf8583_write_cfg(0x07,0x00);Delay1KTCYx(1);	// VALEUR DE DEPARD	
}
void pcf8583_read(char dataType){
	extern struct myTime time;	
	unsigned char buffer[3];
	
	time.old.u.full = time.new.u.full;	//Copy de la future ancienne heure
	_IT_OFF;
	StartI2C();
	WriteI2C(_PCF8583_ADDR_WRITE);
		IdleI2C();
	WriteI2C(2);
		IdleI2C();
	RestartI2C();
	WriteI2C(_PCF8583_ADDR_READ);
		IdleI2C();
	buffer[0] = ReadI2C(); //read seconds
		AckI2C();
	buffer[1] = ReadI2C();//read minutes
		AckI2C();
	buffer[2] = ReadI2C();//read hour
		NotAckI2C();
	StopI2C();	
	_IT_ON;
	if(dataType&_SEC)time.new.u.s = bcd2bin(buffer[0]);
	if(dataType&_MNS)time.new.u.m = bcd2bin(buffer[1]);
	if(dataType&_HRS)time.new.u.h = bcd2bin(buffer[2]&0x3F);	
	//if((buffer[2]&0b01000000) >= 1) time.new.u.mnt = 1;	//A tester sur le HARD si les changement entre 11AM/PM et 12PM/AM ce font bien...

	if(time.new.u.h == 12 && time.old.u.h == 11)
	{
		if(time.old.u.mnt)time.new.u.mnt = 0;
		else time.new.u.mnt = 1;
	}	
}
void pcf8583_write_cfg(char reg, char data){
	_IT_OFF;
	StartI2C();
		IdleI2C();
	WriteI2C(_PCF8583_ADDR_WRITE);
		IdleI2C();
	WriteI2C(reg);
		IdleI2C();
	WriteI2C(data);
		IdleI2C();
	StopI2C();	
	_IT_ON;
}

void pcf8583_set_h(char hrs, char mnt){ //recu en format std BIN sur 24H
	
	char data,tmpHour;
	_IT_OFF;

	data =bin2bcd(hrs);
	if(mnt) data |= 0b11000000;
	else data |= 0b10000000;
	StartI2C();
		IdleI2C();
	WriteI2C(_PCF8583_ADDR_WRITE);
		IdleI2C();
	WriteI2C(_HRS);
		IdleI2C();
	WriteI2C(data);
		IdleI2C();
	StopI2C();	
	_IT_ON;
}
void pcf8583_set_m(char mns){// mns e, BIN std
	char data;
	data = bin2bcd(mns);
	_IT_OFF;
	StartI2C();
		IdleI2C();
	WriteI2C(_PCF8583_ADDR_WRITE);
		IdleI2C();
	WriteI2C(_MNS);
		IdleI2C();
	WriteI2C(data);
		IdleI2C();
	StopI2C();	
	_IT_ON;	
}
void pcf8583_raz_it(void){
	pcf8583_write_cfg(0x07,0x00);
	pcf8583_write_cfg(0x00,0x04);
}

/**********************************************\
*				MATRICE FUNCTION					  *
\**********************************************/
void mtc_send_line(int data){
	char i;

	

	
	
	
	rLch = 0;Delay10TCYx(2);	//Latch Disable
	//Parcourt des 11 1er bits de la lignes
	for(i=0;i<16;i++)
	{
		//et mise  l'tat de la sortie
		if((data >>i) & 0x01) rDta = 1;
		else rDta = 0;
	
		//Front d'horloge
		rClk = 0;
		rClk = 1;
	}
	rOpe =	0;	//Output Disable
	cClk = 	0;	//Clock Down
	cClk = 	1;	//Clock Up
	rOpe = 	1;	//Output Enable
	/*Envoie des donne sur le BUS */
	rLch = 	1;	//Latch Enable
	rDta = 	0;	//Data Low
}


void mtc_init(void){
	char i;
	extern int matrice[];
	//Parcourt des  lignes du tableaux et mise   de chacunes
	for(i=0;i<=9;i++)
	{
	 	matrice[i] = 0x0000;
	}	
	 
}
void mtc_updt_line(char line,char data){
	extern int matrice[];
	extern rom int lettrage[];
	//Modifie le ligne "line" de matrice par les donnes "data" de lettrage
	matrice[line-1] |= lettrage[data];	
}
void mtc_update(){
	extern struct myTime time;
	extern struct flag flag;
	extern int matrice[];
	static char cmnt = 0;
	int bmnt = 0,mnt = 0;
	char i =0;
	
	
	
	mtc_init();

	mtc_updt_line(1,_IL);
	mtc_updt_line(1,_EST);	
		//Si on est ds la 1ere demie-heure on affiche l'heure actuelle
		if(time.new.u.m <=30) 
		{			
			switch(time.new.u.h)
			{
				case 1 : mtc_updt_line(4,_UNE);	mtc_updt_line(6,_HEURE);break;
				case 2 : mtc_updt_line(3,_DEUX);mtc_updt_line(6,_HEURES);break;
				case 3 : mtc_updt_line(2,_TROIS);mtc_updt_line(6,_HEURES);break;
				case 4 : mtc_updt_line(4,_QUATRE);mtc_updt_line(6,_HEURES);break;
				case 5 : mtc_updt_line(3,_CINQ);mtc_updt_line(6,_HEURES);break;
				case 6 : mtc_updt_line(3,_SIX);mtc_updt_line(6,_HEURES);break;
				case 7 : mtc_updt_line(2,_SEPT);mtc_updt_line(6,_HEURES);break;
				case 8 : mtc_updt_line(2,_HUIT);mtc_updt_line(6,_HEURES);break;
				case 9 : mtc_updt_line(4,_NEUF);mtc_updt_line(6,_HEURES);break;
				case 10:mtc_updt_line(5,_DIX);mtc_updt_line(6,_HEURES);break;
				case 11: mtc_updt_line(1,_ONZE);mtc_updt_line(6,_HEURES);break;
				case 12:
				{
					if(time.new.u.mnt == 0) mtc_updt_line(5,_MINUIT);
					else mtc_updt_line(5,_MIDI);break;
				}
			}	
		}
		//Si on est dans la 2eme demie-heure on affiche l'heure d'aprs
		else
		{
			if(time.new.u.h < 12) mtc_updt_line(6,_HEURES);
			else mtc_updt_line(6,_HEURE);
			
			switch(time.new.u.h)
			{	
				/*sortir le mtc_updt_line(6,heures); */
				case 12:mtc_updt_line(4,_UNE);mtc_updt_line(6,_HEURE);break;
				case 1 : mtc_updt_line(3,_DEUX);mtc_updt_line(6,_HEURES);break;
				case 2 : mtc_updt_line(2,_TROIS);mtc_updt_line(6,_HEURES);break;
				case 3 : mtc_updt_line(4,_QUATRE);mtc_updt_line(6,_HEURES);break;
				case 4 : mtc_updt_line(3,_CINQ);mtc_updt_line(6,_HEURES);break;
				case 5 : mtc_updt_line(3,_SIX);mtc_updt_line(6,_HEURES);break;
				case 6 : mtc_updt_line(2,_SEPT);mtc_updt_line(6,_HEURES);break;
				case 7 : mtc_updt_line(2,_HUIT);mtc_updt_line(6,_HEURES);break;
				case 8 : mtc_updt_line(4,_NEUF);mtc_updt_line(6,_HEURES);break;
				case 9 : mtc_updt_line(5,_DIX);mtc_updt_line(6,_HEURES);break;
				case 10:mtc_updt_line(1,_ONZE);mtc_updt_line(6,_HEURES);break;
				case 11:
				{
					if(time.new.u.mnt == 0)mtc_updt_line(5,_MINUIT);
					else mtc_updt_line(5,_MIDI);break;
				}
			}	
		}	
		
		//Affichage pour les minutes
		if(time.new.u.m >5 && time.new.u.m<10){mtc_updt_line(8,_mCINQ);mnt=time.new.u.m-5;}
		else if(time.new.u.m >=10 && time.new.u.m<15 ){mtc_updt_line(7,_mDIX);mnt=time.new.u.m-10;}
		else if(time.new.u.m >=15 && time.new.u.m<20 ){mtc_updt_line(6,_ET);mtc_updt_line(9,_QUART);mnt=time.new.u.m-15;}
		else if(time.new.u.m >=20 && time.new.u.m<25 ){mtc_updt_line(8,_VINGT);mnt=time.new.u.m-20;}
		else if(time.new.u.m >=25 && time.new.u.m<30 ){mtc_updt_line(8,_VINGTCINQ);mnt=time.new.u.m-25;}
		else if(time.new.u.m >=30 && time.new.u.m<35){mtc_updt_line(7,_ET);mtc_updt_line(9,_DEMIE);mnt=time.new.u.m-30;}
		else if(time.new.u.m >=35 && time.new.u.m<40 ){mtc_updt_line(7,_MOINS);mtc_updt_line(8,_VINGTCINQ);mnt=time.new.u.m-35;}
		else if(time.new.u.m >=40 && time.new.u.m<45 ){mtc_updt_line(7,_MOINS);mtc_updt_line(8,_VINGT);mnt=time.new.u.m-40;}
		else if(time.new.u.m >=45 && time.new.u.m<50 ){mtc_updt_line(7,_MOINS);mtc_updt_line(7,_LE);mtc_updt_line(9,_QUART);	mnt=time.new.u.m-45;}
		else if(time.new.u.m >=50 && time.new.u.m<55 ){mtc_updt_line(7,_MOINS);mtc_updt_line(7,_mDIX);mnt=time.new.u.m-50;}
		else if(time.new.u.m >=55 && time.new.u.m<60 ){mtc_updt_line(7,_MOINS);mtc_updt_line(8,_mCINQ);mnt=time.new.u.m-55;}
		else mnt = time.new.u.m;
		/*
		On affiche que les multiples de 5 minutes (5,10,15,20,...)
		Pour afficher les unites dans les angles (1,2,3,4,6,7,8,9,...)
		on les 4 derniers bits de la permire ligne de matrice pour
		EX: heure relle 08:17:30
		affichera		08:15
		et 3 led de coin seront allumes
		matrice ligne	= 0b0010xxxxxxxxxxxx
 		*/
	 		if(cmnt != mnt && mnt != 0)
	 		{
		 		if(mnt == 1) bmnt = 0b0001;
				else if(mnt == 2) bmnt = 0b0011;
				else if(mnt == 3) bmnt = 0b0111;
				else if(mnt == 4) bmnt = 0b1111;
				else bmnt = 0b0000;
				//bmnt = bmnt <<12;			
				for(i=0;i<10;i++)
				{
					matrice[i] |= bmnt;	
				}
			cmnt = mnt;
			}
}
/**********************************************\
*				IHM FUNCTION						  *
\**********************************************/
char bp_scan(void){

	extern struct bp bp;
	if(bp3)
	{
		if(bp.b3.etatp) { bp.b3.up = 1; return true; }
		else bp.b3.etatp = 1; 	
	}
	if(bp1 && !bp2)
	{
		if(bp.b1.etatp) { bp.b1.up = 1; return true; }
		else bp.b1.etatp = 1; 
		
	}
	else if(bp2 && !bp1)
	{
		if(bp.b2.etatp) { bp.b2.up = 1; return true; }
		else bp.b2.etatp = 1;	
	}
	else if(bp1 && bp2)
	{
		bp.raz = 1;
		return true;
	}
	else
	{
		if(bp.b1.etatp || bp.b2.etatp)
		{
			bp.b1.etatp = 0;
			bp.b2.etatp = 0;	
		}
		return false;
	}
}
void bp_up_mns(void){
	extern struct myTime time;
	if(time.new.u.m < 59) time.new.u.m++;
	else time.new.u.m = 0;	
	pcf8583_set_m(time.new.u.m);
}
void bp_up_hrs(void){
	extern struct myTime time;
	if(time.new.u.h < 11) time.new.u.h++;
	else if(time.new.u.h == 12) time.new.u.h = 1;
	else
	{
		time.new.u.mnt = !time.new.u.mnt;
		time.new.u.h = 12;	
	}
	pcf8583_set_h(time.new.u.h,time.new.u.mnt);
}
void bp_up_raz(void){
	extern struct myTime time;
	time.new.u.full = 0x0000;
	pcf8583_set_m(0);
	pcf8583_set_h(0,0);	
}
/**********************************************\
*				DIVERS								  *
\**********************************************/

void mode2_init(void){
	pcf8583_write_cfg(0x00,0x04);	//TIMER ENABLE
	pcf8583_write_cfg(0x08,0xC3);	//TIMER EVERY x SECOND
	pcf8583_write_cfg(0x0F,0x01);	//x = 60
	pcf8583_write_cfg(0x07,0x00);	// VALEUR DE DEPARD			
}



void up_sec(void){
	extern struct myTime time;
	if(time.new.u.s < 59) time.new.u.s++;
	else time.new.u.s = 0;
	}
	
void mtc2_edit(void){ //A optimiser!
	char cu,cd,i,cu2,cd2,md,mu;
	extern struct myTime time;
	extern int matrice[];
	extern rom char num[];
	mtc_init();// a voir, pas forcment necessaire!
	cu = (char)time.new.u.s%10;
	cd = (char)time.new.u.s/10;
	mu = cu*7;
	md = cd*7;
	
	
	for(i=0;i<=6;i++)
	{
		
		matrice[1+i] = (((int)num[md+i]<<6)+((int)num[mu+i]))<<5; //35s @ 20MHz
	}
}
void mode1_init(void){
	
	
	
	
	}
/**********************************************\
*				UART FUNCTION						  *
\**********************************************/

void uart_init()
{
	TRISC |= 0b10000000; //RC6 = RX
	
	
	OpenUSART(USART_TX_INT_OFF &
             USART_RX_INT_ON &
             USART_ASYNCH_MODE &
             USART_EIGHT_BIT &
             USART_CONT_RX &
             USART_BRGH_HIGH,129);//  Fosc/(X*(spbrg + 1)) 	
}
void uart_sendTime()
{
	
	extern struct myTime time;
	extern struct flag flag;
	
	if(flag.mode == _MODE_2) printf("\n  TIME :  %d:%d:%d \r",time.new.u.h,time.new.u.m,time.new.u.s);
}
