#ifndef __CONSTANTE_H
	#define __CONSTANTE_H

#define _DEBUG_ 1


#define _MODE_1 1
#define _MODE_2 2
#define _MODE_UART 3
#define _MODE_D _MODE_2







//MACRO
#define bitset(var,bitno) ((var) |= 1 << (bitno))
#define bitclr(var,bitno) ((var) &= ~(1 << (bitno)))
#define clear(var) 	(var = 0)
#define set(var)	(var = 1)
#define _IT_ON INTCONbits.GIE = 1
#define _IT_OFF INTCONbits.GIE = 0
#define NOP _asm NOP _endasm


#define true 	1
#define TRUE 	1
#define false 	0
#define FALSE 	0
#define ON		1
#define OFF 	0
#define _OUTPUT 	0x00
#define _INPUT 		0xFF

#define _SEC	2
#define _MNS	3
#define _HRS	4

/* PIN REMAP */
#define rOpe 	LATDbits.LATD3
#define rDta 	LATDbits.LATD4
#define rClk 	LATDbits.LATD5
#define rLch 	LATDbits.LATD6
#define cClk		LATDbits.LATD2
#define cEnb	LATDbits.LATD1
#define cRst	LATDbits.LATD0
#define SCL		LATDbits.LATD1
#define SDA		LATDbits.LATD0

#define ptest 	LATDbits.LATD7

#define bp1		PORTBbits.RB3
#define bp2		PORTBbits.RB4 
#define bp3		PORTBbits.RB5

#define _BPush	INTCON3bits.INT2IF	//Flag de l'IT INT2




#define TMR0Lstart 0x65 //65 pour it  1ms @ 20mhz



#define _X 	9	// nombre de ligne
#define _Y 	11	// nombre de colonne

#define _DEFTIME_H 12
#define _DEFTIME_M 30
#define _DEFTIME_S 30

#define _PCF8583_ADDR_REG 	0x00
#define _PCF8583_ADDR_PARAM 	0x08
#define _PCF8583_ADDR_READ 	0xA1
#define _PCF8583_ADDR_WRITE 	0xA0
#define _PCF8583_ADDR_HOUR	0x04
#define _PCF8583_ADDR_MNS	0x03
#define _PCF8583_ADDR_SEC		0x02

#define _FREQ_SCAN_BP		10		/* 10 check/sec */
#define _FREQ_SEND_LINE	900 	/* 50 fps*/		
#define _FREQ_UPT_TIME	0.035 	/* 28 sec*/ 


/* PCF8583 DEFINE */
#define _MODE24 0x00
#define _MODE12 0x80
#define _PM 0x40
#define _AM 0x00

#define _NOTIMER 		0x00
#define _TIMER_100s 	0x01
#define _TIMER_SEC 	0x02
#define _TIMER_MNS 	0x03
#define _TIMER_HRS 	0x04
#define _TIMER_DAY 	0x05
#define _TIMER_TEST 	0x07
#define _TIMER_INT 	0x08
#define _TIMER NOINT 	0x00
/* PARAM */
#define _ALARM_NO			0x00
#define _ALARM_DAILY 		0x10
#define _ALARM_WEEKDAY 	0x20
#define _ALARM_DATED 		0x30
#define _ALARM_ENABLE	0x30
#define _ALARM_NOTIMER 	0x00
#define _ALARM_TIMER 		0x40
#define _ALARM_INT 		0x80
#define _ALARM_NOINT 		0x00
/* REGISTRE */
#define _ALARM_SET 	0x04
#define _CLK_50HZ 		0x10
#define _CLK_EVENT 	0x20
#define _CLK_TEST 		0x30
#define _CLK_32768HZ 	0x00
#define _COUNT_START 	0x00
#define _COUNT_STOP 	0x80

#define _IL				0	
#define	_EST			1
#define	_ONZE			2
#define	_HUIT			3
#define	_TROIS			4
#define	_SEPT			5
#define	_SIX			6
#define	_DEUX			7
#define	_CINQ			8
#define	_UNE			9
#define	_NEUF			10
#define	_QUATRE		11
#define	_MIDI			12
#define	_DIX			13
#define	_MINUIT		14
#define	_HEURE			15
#define	_HEURES		16
#define	_ET				17
#define	_MOINS			18
#define	_LE				19
#define	_mDIX			20
#define	_VINGT			21
#define	_mCINQ			22
#define	_TIRRET			23
#define	_VINGTCINQ		24
#define	_QUART			25
#define _DEMIE			26
		



#endif
