#include <p18f4550.h>
#include <delays.h>
#include "constante.h"
#include <stdio.h>
#include <usart.h>

#include "abclock.h"
#include <i2c.h> 
/******************************************************************\
							18F4550
						--------------------
MCLR/ICSP(VPP):	RE3 <---|1			40	|---> (I)RB7 : ICSP (PGD)
					   --	|2			39	|---> (I)RB6 : ICSP (PGC)
					   --	|3			38	|---> (I)RB5 : BP changement de mode
					   --	|4			37	|---> (I)RB4 : BP heures++
					   --	|5			36	|---> (I)RB3 : BP minutes++
					   --	|6			35	|---> (I)RB2 : INT PCF8583
					   --	|7			34	|---> (I)RB1 : IC (SCL)
					   --	|8			33	|---> (I)RB0 : IC (SDA)
					   --	|9			32	|--
					   --	|10			31	|--
					   --	|11			30	|---> (o)RD7 : OSC 50Khz
					   --	|12			29	|---> (o)RD6 : 4094 (latch)
			OSC1(I)	<---	|13			28	|---> (o)RD5 : 4094 (CLK)
			OSC2(I)	<---	|14			27	|---> (o)RD4 : 4094 (DATA)
					   --|15			26	|--
					   --	|16			25	|--
					   --	|17			24	|--
					   --	|18			23	|--
4017(MR):	RD0(o)	<---	|19			22	|---> (o)RD3 : 4094 (Output Enable)
4017(En):	RD1(o)	<---	|20			21	|---> (o)RD2 : 4017 (CLK)
						--------------------
						
					

																			


\*****************************************************************/

		//WatchDog Timer Disabled





int count100it;		//++ tout les 100 IT
int count1000it;		//++ tout les 1K IT
unsigned ptest2;
unsigned ptest3;
unsigned ptest4;
struct myTime time;
struct flag flag;
struct bp bp;




 const rom char num[70] = { //70octets en ROM
/*			0		1		2		3		4		5		6	*/
/* 0 */		0x0E,	0x11,	0x13,	0x15,	0x19,	0x11,	0x0E,
//			7		8		9		10		11		12		13
/* 1 */		0x04,	0x0c,	0x04,	0x04,	0x04,	0x04,	0x0E,
//			14		15		16		17		18		19		20	
/* 2 */		0x0E,	0x11,	0x01,	0x02,	0x04,	0x08,	0x1F,
//			21		22		23		24		25		26		27
/* 3 */		0x1F,	0x02,	0x04,	0x02,	0x01,	0x11,	0x0E,
//			28		29		30		31		32		33		34
/* 4 */		0x02,	0x06,	0x0A,	0x12,	0x1F,	0x02,	0x02,
//			35		36		37		38		39		40		41	
/* 5 */		0x1F,	0x10,	0x1E,	0x01,	0x01,	0x11,	0x0E,
//			42		43		44		45		46		47		48
/* 6 */		0x06,	0x08,	0x10,	0x1E,	0x11,	0x11,	0x0E,
//			49		50		51		52		53		54		55
/* 7 */		0x1F,	0x01,	0x02,	0x04,	0x08,	0x08,	0x08,
//			56		57		58		59		60		61		62
/* 8 */		0x0E,	0x11,	0x11,	0x0E,	0x11,	0x11,	0x0E,
//			63		64		65		66		67		68		69
/* 9 */		0x0E,	0x11,	0x11,	0x0F,	0x01,	0x02,	0x0C
					};
					
					
  int matrice[9]= { //18 octets en RAM
                0b0000000000000000, //0
                0b0000000000000000, //1
                0b0000000000000000, //2
                0b0000000000000000, //3
                0b0000000000000000, //4
                0b0000000000000000, //5
                0b0000000000000000, //6
                0b0000000000000000, //7
                0b0000000000000000,  //8
                };
const rom int lettrage[27] = 	{ //54 octets en ROM
				0b1100000000000000, //1- 0 - IL
				0b0001110000000000, //1- 1 - EST
				0b0000000111100000, //1- 2 - ONZE
				0b1111000000000000, //2- 3 - HUIT
				0b0001111100000000, //2- 4 - TROIS
				0b0000000111100000, //2- 5 - SEPT
				0b1110000000000000, //3- 6 - SIX
				0b0001111000000000, //3- 7 - DEUX
				0b0000000111100000, //3- 8 - CINQ
				0b1110000000000000, //4- 9 - UNE
				0b0011110000000000, //4- 10 - NEUF
				0b0000011111100000, //4- 11 - QUATRE
				0b1111000000000000, //5- 12 - MIDI
				0b0011100000000000, //5- 13 - DIX
				0b0000011111100000, //5- 14 - MINUIT
				0b0111110000000000, //6- 15 - HEURE
				0b0111111000000000, //6- 16 - HEURES
				0b0000000011000000, //6- 17 - ET
				0b1111100000000000, //7- 18 - MOINS
				0b0000001100000000, //7- 19 - LE
				0b0000000011100000, //7- 20 - mDIX
				0b1111100000000000, //8- 21 - VINGT
				0b0000001111000000, //8- 22 - mCINQ
				0b0000010000000000, //8- 23 - TIRRET (-)
				0b1111111111000000, //8- 24 - VING-CINQ
				0b0111110000000000, //9- 25 - QUART
				0b0000001111100000  //9- 26 - DEMIE
				};

//	near unsigned char rxBuffer[8];
	near unsigned char rxi;
				
#pragma interrupt gestionInterruption
void gestionInterruption ()
{
	unsigned char rxBuff;
	/* START GESTION IT */
	if(INTCONbits.TMR0IF)
	{
		ptest = ~ptest;
		TMR0L = TMR0Lstart;// IT toute mes ms
		clear(INTCONbits.TMR0IF);
		set(flag.printLine);
		count100it++;
		count1000it++;
		if(count100it >= 100)	//IT 100mSec
		{
			clear(count100it);
			set(flag.scanBP);
			
		}
		if(count1000it >= 1000) //IT 1sec
		{
			set(flag.updateSec);
			set(flag.oneSec);
			clear(count1000it);
			
		}
	}
	if(INTCON3bits.INT2IF)
	{
		set(flag.updateTime);
		set(flag.rstPcfTimer);
		clear(INTCON3bits.INT2IF);
	}
	if(PIR1bits.RCIF) // RECEPTION UART
	{	
		rxBuff = ReadUSART();
		if(rxBuff == '%')
		{
			if(flag.mode == 3) set(flag.mode);
			else flag.mode++;
		}
		clear(PIR1bits.RCIF);
	}
}	/*END GESTION IT */
#pragma code ITPrioritaire = 0x08
void ITPrioritaire (void)
{
	_asm
 		goto gestionInterruption //jump to interrupt routine
 	_endasm
}
#pragma code

/*********** MAIN ************/
void main(void)
{

	char j = 0;
	char linePrinted = 0;
	
	core_init();
	Delay10KTCYx(1);
	
	uart_init();
	Delay10KTCYx(1);

	pcf8583_init();
	Delay1KTCYx(1);
	
	
	clear(flag.printLine);
	clear(flag.updateMatrice);
	clear(flag.updateHrs);
	clear(flag.updateMns);
	clear(flag.scanBP);
	clear(flag.rstPcfTimer);
	clear(flag.updateSec);
	
	pcf8583_read(_HRS | _MNS | _SEC);
	set(flag.updateTime);
	
	
	
	for(;;)
	{
		int u;
		switch (flag.mode)
		{		
	/*******************************************************\
	*	MODE 1			
	\*******************************************************/	
			case 1 :
			{
				printf("Enter in mode %d \r",flag.mode);
				
				cnt_init();
				mtc_init();
				mtc_update();
				
				clear(linePrinted);
				
				while(flag.mode == _MODE_1) //MODE 1 NOEND LOOP
				{
					if(flag.printLine) //mode printLine standart
					{
						if(linePrinted <= 9)
						{
							if(linePrinted != 9)
							{
								mtc_send_line(matrice[linePrinted]);
							}
							else
							{
								mtc_send_line(0x0000);
							}
							linePrinted++;
						}
						else
						{
							clear(linePrinted);
						}
						clear(flag.printLine);
					} 
					if(flag.rstPcfTimer)
					{
						pcf8583_raz_it();
						clear(flag.rstPcfTimer);	
					}
					if(flag.updateTime) //mise  l'heure
					{
						clear(flag.updateTime);
							pcf8583_read(_HRS | _MNS | _SEC);
						if(time.new.u.full != time.old.u.full) set(flag.updateMatrice);
					}
					if(flag.updateMatrice)
					{
						mtc_update();
						clear(flag.updateMatrice);
					}
					if(flag.scanBP)
					{
						if(bp_scan())
						{
							if(bp.b3.up)
							{
								flag.mode = _MODE_2;
								clear(bp.b3.up);	
							}
							else if(bp.b1.up)
							{
								bp_up_mns();
								clear(bp.b1.up);	
							}
							else if(bp.b2.up)
							{
								bp_up_hrs();
								clear(bp.b2.up);
							}
							else if(bp.raz)
							{
								bp_up_raz();
								clear(bp.raz);	
							}
							set(flag.updateMatrice);
						}
						clear(flag.scanBP);
					}
					if(flag.oneSec)
					{
						uart_sendTime();
						clear(flag.oneSec);	
					}
				}
			}
	/*******************************************************\
	*	MODE 2			
	\*******************************************************/
			case _MODE_2 :
			{
				cnt_init();
				mtc_init();
				clear(linePrinted);
				pcf8583_read(_SEC);
				set(flag.updateSec);
				printf("Enter in mode %d \r",flag.mode);
				while(flag.mode == _MODE_2)
				{
					if(flag.updateSec) //environ 500u @ 20MHz
					{
						NOP;
						up_sec();
						mtc2_edit();
						clear(flag.updateSec);
						//uart_sendTime(); // 20ms  @ 20MHz...
						NOP;
					}
					if(flag.printLine) //mode printLine standart
					{
						
						if(linePrinted <= 9)
						{
							if(linePrinted != 9 )
							{
								mtc_send_line(matrice[linePrinted]);
							}
							else
							{
								mtc_send_line(0x0000);
							}
							linePrinted++;
						}
						else
						{
							clear(linePrinted);
						}
						clear(flag.printLine);
					}
					if(flag.rstPcfTimer)
					{
						pcf8583_raz_it();
						clear(flag.rstPcfTimer);	
					}
					if(flag.scanBP)
					{
					if(bp_scan())
						{
							if(bp.b3.up)
							{
								flag.mode = _MODE_1;
								clear(bp.b3.up);	
							}
						}
						clear(flag.scanBP);
					}
					if(flag.oneSec)
					{
						
						clear(flag.oneSec);	
					}
				}	
				break;// BREAK END MODE 
			}//END WHILE	
			case _MODE_UART :
			{
				printf("Enter in mode %d \r",flag.mode);
				while(flag.mode == _MODE_UART)
				{
					NOP;
				}
				break;
			}
		}//END SWITCH		
	}//END FOR(;;)
}//END MAIN
