﻿// ==UserScript==
// @include       http://search.digikey.com/scripts/DkSearch/dksus.dll*
// @match http://search.digikey.com/scripts/DkSearch/dksus.dll*
// ==/UserScript==


// construct an electronic value (like "+10mV") from 
// its elements
function CreateElectronicValue( label, sign, value, kmg, unit )
{
	this.label	= label;
	this.unit 	= unit;
	
	if( !sign )
		sign = "+";
	else if( sign == "-")
		value = -value;
	this.sign	= sign;
	
	switch( kmg )
	{
		case "p":	this.value = value * 1e-12;	break;
		case "n":	this.value = value * 1e-9;	break;
		case "u":	this.value = value * 1e-6;	break;
		case "µ":	this.value = value * 1e-6;	break;
		case "m":	this.value = value * 1e-3;	break;
		case "k":	this.value = value * 1e+3;	break;
		case "K":	this.value = value * 1e+3;	break;
		case "M":	this.value = value * 1e+6;	break;
		case "G":	this.value = value * 1e+9;	break;
		default:	this.value = value;		break;
	}
}

function ParseElectronicValue( text )
{
	//~ debugLog( "parse : '" + text + "'" );

	m = /([\-+±]?)([.0-9]+) *([pnuµmkKGM]?)(V|Ohm|A|Hz|°C|W|H)/.exec( text );
	
	//~ debugLog( m );
	if( !m ) return null;
	
	var value = parseFloat( m[2] );
	if( isNaN( value )) return null;
	
	return new CreateElectronicValue( text, m[1], value, m[3], m[4] );
}

function ParseUserElectronicValue( text )
{
	//~ debugLog( "parse : '" + text + "'" );

	m = /([\-+±]?)([.0-9]+) *([pnuµmkKGM]?)(V|Ohm|A|Hz|°C|W|H|)/.exec( text );
	
	//~ debugLog( m );
	if( !m ) return null;
	
	var value = parseFloat( m[2] );
	if( isNaN( value )) return null;
	
	return new CreateElectronicValue( text, m[1], value, m[3], m[4] );
}

var DEBUGLOGDATA = "";
function debugLog( x )
{
	DEBUGLOGDATA += "<br />"+x;
}
function printDebugLog()
{
	// document.getElementById( "debug" ).innerHTML = DEBUGLOGDATA;
}

function electronicValuesSortFunc( a,b )
{
	if( a == b ) return 0;
	
	var value_a = ParseElectronicValue( a );
	var value_b = ParseElectronicValue( b );
		
	// both are electronic values
	if( value_a && value_b )
	{
		signs = { "-":-1, "±": 0, "+": 1, "": 1 };
		
		var signcmp = signs[value_a.sign] - signs[value_b.sign];
		if( signcmp ) return signcmp;
		
		return value_a.value - value_b.value;
	}
	
	// only one of them is
	if( value_a ) return 1;
	if( value_b ) return -1;
	
	// both are just strings
	if( a > b ) return 1;
	if( a < b ) return -1;
	
	return 0;
}

function AddToGroup( groups, key, value )
{
	if( !groups[key] )
		groups[key] = [];
	groups[key].push( value );
}

function selectSortFunc( data1, data2 ) {
    var n1 = parseFloat(data1, 10);
    var n2 = parseFloat(data2, 10);
    var r = n1 - n2;
    if (!isNaN(r)) { // two numbers
        return r;
    }
    if (isNaN(n1)) {
        if (isNaN(n2)) { // string comparison
            if (data1 > data2) {
                return 1;
            } else if (data1 < data2) {
                return -1;
            }
            return 0;
        }
        return 1; // data2 is a number
    }
    return -1; // data1 is a number
}


function CreateSelect( labelsvalues, sortFunc )
{
	var label, labels = [];
	
	// sort option labels by numeric value
	for( label in labelsvalues )
		labels.push( label );
	labels.sort( sortFunc );
	
	// insert into a new <select>
	var select = document.createElement( "select" );
	select.multiple = true;
	for( var i=0; i<labels.length; i++ )
	{
		label = labels[i];
		var opt = document.createElement( "option" );
		opt.text = label;
		opt._value = labelsvalues[label];
		select.add( opt, null );
	}
	
	if( labels.length > 20 )		select.size = 20;
	else							select.size = labels.length+1;
	
	return select;
}

function ProcessOptionText( option, callback )
{
	var ranges_count = 0;
	var has_tilde = option.text.indexOf( "~" ) > 0;
	var items = option.text.split( / *, */ );
	for( k=0; k<items.length; k++ )
	{
		var item = items[k];
	
		// separate range text like "100 ~ 500mV" into min and max values
		var m = /([\-+±]?[.0-9]+) *([pnuµmkKGM]?(?:V|Ohm|A|Hz|°C|W|H)) *~ *([\-+±]?[.0-9]+) *([pnuµmkKGM]?(?:V|Ohm|A|Hz|°C|W|H))/.exec( item );
		if( m )
		{
			var mi = m[1] + " " + ( m[2] ? m[2] : m[4] );
			var ma = m[3] + " " + m[4];
			
			mi = ParseElectronicValue( mi );
			ma = ParseElectronicValue( ma );
			
			if( mi && ma && mi.sign == "±" && ma.sign == "±" )
			{
				mi.sign = ma.sign = "+";
				
				if( mi.value > ma.value )
				{
					var t = mi;
					mi = ma;
					ma = t;
				}
				
				callback( item, mi, ma );
				
				mi.value = -mi.value;
				ma.value = -ma.value;
				mi.sign = ma.sign = "-";
			}
			
			if( mi.value > ma.value )
			{
				var t = mi;
				mi = ma;
				ma = t;
			}
			callback( item, mi, ma );
			
			ranges_count ++;
			continue;
		}
		
		// "Adj to ..."
/*		var m = /Adj to ([\-+±]?[.0-9]+) *([pnuµmkKGM]?(?:V|Ohm|A|Hz|°C|W))/.exec( item );
		if( m )
		{
			var v = m[1] + " " + m[2];
			
			v = ParseElectronicValue( v );
			if( !v ) continue;
			
			if( v && v.sign == "±" )
			{
				v.sign = "+";
				callback( item, v, null );
				
				v.value = -v.value;
				v.sign = "-";
			}
			callback( item, v, null );
			
			ranges_count ++;
			continue;
		} */
		
		// get text like "+10mV"
		m = /([\-+±]?[.0-9]+) *([pnuµmkKGM]?(?:V|Ohm|A|Hz|°C|W|H))/.exec( item );
		if( m )
		{
			var v = m[1] + " " + m[2];
			if( !v ) continue;
			
			v = ParseElectronicValue( v );
			
			if( v )
			{
				if( v.sign == "±" )
				{
					v.sign = "+";
									
					callback( item, v, null );
					
					v.value = -v.value;
					v.sign = "-";
				}
				
				callback( item, v, null );
			
				ranges_count ++;
			}
			continue;
		}
	}
	
	return ranges_count;	
}

function EnhanceSearchSelect( select )
{
	// examine <option> values	
	var options = select.options;	
	
	// modify select size
	select.size = Math.min( 20, Math.max( 10, options.length ));
	
	// separate options which contain a list of values separated by ","
	var multichoice = {}, multichoice_count = 0;
	
	// extract min-max from ranges
	var range_mins = {};	// min and max from ranges like 2 ~ 8V
	var range_maxs = {};
	var range_points = {};	// when only one value is specified like "Adj." or "10 V"
	var ranges_count = 0;
		
	for( j=0; j<options.length; j++ )
	{
		var option = options[j];
		
		switch( select.name )
		{
			case "PV16":	// packaging
			{
				// remove number of pins from package name
				multichoice_count += 1;
				var t = option.text;
				t = t.replace( /\(.*\s*$/, "" );
				t = t.replace( /,.*$/, "" );
				t = t.replace( /^[0-9]+-/, "" );
				t = t.replace( /\s*/, "" );
				if( t )	AddToGroup( multichoice, t, option );
				else	AddToGroup( multichoice, option.text, option );
				break;
			}
			
			default:
			{
				// separate option text like "A, B" into distinct values
				var n = ProcessOptionText( option, function( text, mi, ma ){} );
				if( n )
					ranges_count += n;

				var items = option.text.split( / *, */ );
				for( k=0; k<items.length; k++ )
				{
					var item = items[k];
					AddToGroup( multichoice, item, option );
					multichoice_count ++;
				}
			}
		}
	}

	var container = document.createElement( "div" );
	select.parentNode.insertBefore( container, null );
	
	var p = document.createElement( "span" );
	p.innerHTML = "ranges " + ranges_count + " multi " + multichoice_count;
	container.insertBefore( p, null );
	
	// decide on the nature of this select
	if( ranges_count >= 0.7*multichoice_count )
	{
		// select contains ranges


		//~ var invert_checkbox = document.createElement( "input" );
		//~ invert_checkbox.type = "checkbox";
		//~ container.insertBefore( invert_checkbox, null );
		
		p = document.createElement( "p" );
		p.innerHTML = "Minimum value between :";
		container.insertBefore( p, null );
				
		var min_input_1 = document.createElement( "input" );
		min_input_1.type = 'text';
		min_input_1.size = 8;
		container.insertBefore( min_input_1, null );
		
		var min_input_2 = document.createElement( "input" );
		min_input_2.type = 'text';
		min_input_2.size = 8;
		container.insertBefore( min_input_2, null );
		
		p = document.createElement( "p" );
		p.innerHTML = "Maximum value between :";
		container.insertBefore( p, null );
		
		var max_input_1 = document.createElement( "input" );
		max_input_1.type = 'text';
		max_input_1.size = 8;
		container.insertBefore( max_input_1, null );
		
		var max_input_2 = document.createElement( "input" );
		max_input_2.type = 'text';
		max_input_2.size = 8;
		container.insertBefore( max_input_2, null );

		//~ invert_checkbox.onchange = 
		min_input_1.onchange = 
		min_input_2.onchange = 
		max_input_1.onchange = 
		max_input_2.onchange = 
		function()
		{
			// reset original select
			for( var j=0; j<options.length; j++ )
				options[j].selected = false;
			
			// parse user input
			var user_mi_1 = ParseUserElectronicValue( min_input_1.value );
			var user_mi_2 = ParseUserElectronicValue( min_input_2.value );
			var user_ma_1 = ParseUserElectronicValue( max_input_1.value );
			var user_ma_2 = ParseUserElectronicValue( max_input_2.value );
						
			for( j=0; j<options.length; j++ )
			{
				var option = options[j];
				
				ProcessOptionText( option, function( text, mi, ma )
				{								
					if( !ma ) ma = mi;
					if( !mi ) mi = ma;
					
					if( mi && user_mi_1 && mi.value < user_mi_1.value )	return;
					if( mi && user_mi_2 && mi.value > user_mi_2.value )	return;
					
					if( ma && user_ma_1 && ma.value < user_ma_1.value )	return;
					if( ma && user_ma_2 && ma.value > user_ma_2.value )	return;
					
					option.selected = true;					
				} );
			}
		}
	}
	else if( multichoice_count )
	{
		// select contains "A, B" style strings
		// create a select with distinct values of A and B
		var p = document.createElement( "p" );
		p.innerHTML = "<b>Multi-Select :</b>";
		select.parentNode.insertBefore( p, null );
		
		var multi_select = CreateSelect( multichoice, electronicValuesSortFunc );
		select.parentNode.insertBefore( multi_select, null );
		multi_select.onchange = function() 
		{
			// reset original select
			for( var j=0; j<options.length; j++ )
				options[j].selected = false;
			
			// select all lines from the original select which contain
			// one of the options selected in the extra select
			for( var j=0; j<this.options.length; j++ )
			{
				var op = this.options[j];
				if( op.selected )
					for( var i=0; i<op._value.length; i++ )
						op._value[i].selected = true;
			}
		}
	}
}

function FindSearchTable()
{
	// Find the search form, and return the big <table> inside
	var ths = document.getElementsByTagName( "TH" );
	var i;
	
	for( i=0; i<ths.length; i++ )
	{
		var elem = ths[i];
		if( elem.innerText == "Packaging" )
		{
			while( elem && elem.tagName != 'TABLE' )
				elem = elem.parentNode;
			
			return elem;
		}
	}
}

$(document).ready( 
	function () 
	{
		var table = FindSearchTable();
		
		// examine all <select>'s in the search form
		$(table).find("select").each( function(){ 

			var parent = this.parentNode;
			while( parent && parent.tagName != 'TD' )
				parent = parent.parentNode;
			
			if( !parent ) return;
			parent.vAlign = "top";
			
			EnhanceSearchSelect( this );
		});
	}
);
	
