
//*********************************************************************
//***************************CDG2000 in C******************************
//***********************ver 3.0 by YO6OGJ*****************************
//**************************2008.12.26*********************************
//*********************************************************************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

// ********************* Configuration bytes *************************
#pragma config OSC = ECIO, OSCS = OFF
#pragma config PWRT = ON, BOR = OFF, BORV = 42
#pragma config WDT = OFF
#pragma config MODE = MC
#pragma config STVR = OFF, DEBUG = ON, LVP = OFF
#pragma config CP0 = OFF, CP1 = OFF, CP2 = OFF, CP3 = OFF 
#pragma config CPB = OFF, CPD = OFF
#pragma config WRT0 = OFF, WRT1 = OFF, WRT2 = OFF, WRT3 = OFF
#pragma config WRTB = OFF, WRTC = OFF, WRTD = OFF
#pragma config EBTR0 = OFF, EBTR1 = OFF, EBTR2 = OFF, EBTR3 = OFF
#pragma config EBTRB = OFF

//******************************************************************
#pragma idata  access UNear

float			Rig_freq = 14250600;			//First encoder, Opto_1 value	
float	 		Tx_power = 100;
float	 		S_meter = 0;	




char			Matrix_string [11];
char			LCD_line [41];
	
unsigned char 	LO_data;
unsigned char	TxE_data;
unsigned char	FE_data_1;
unsigned char	FE_data_2;
unsigned char	First_half;
unsigned char	MUTE = 0;

near unsigned char 	vol_value_proc = 0;			//volume holding register
near unsigned char 	ifg_value_proc = 0;			//IF gain holding register
near unsigned char 	ifh_value_proc = 0;			//IF hang holding register
near unsigned char	if_switch_value = 0;		//IF switched to internal or external
near unsigned char 	avx_value_proc = 0;			//Anti vox holding register
near unsigned char 	vxg_value_proc = 0;			//VOX gain holding register
near unsigned char 	vxd_value_proc = 0;			//VOX delay holding register
near unsigned char 	mcg_value_proc = 0;			//Mike gain holding register
near unsigned char 	cmp_value_proc = 0;			//Compresssor holding register
near unsigned char 	rfp_value_proc = 0;			//RF power holding register
near unsigned char	vox_onoff_value = 0;		//Vox on or off holding register

unsigned int	Freq_reg1, Freq_reg2, Freq_reg3, Freq_reg4  = 0;
unsigned long	long_BFO_freq = 0;
float			float_BFO_freq = 0;

//******************************************************************
struct {								
    	unsigned  	Freq_change:1;		//Flags for state save
    	unsigned  	Key1_change:1;		//Flags for state save
    	unsigned  	Key2_change:1;		//Flags for state save
		unsigned	Freq_by_kbd:1;		//Flags for state save
    	unsigned  	ENC2_change:1;		//Flags for state save
		unsigned	LCD_update_req:1;	//System flags
		unsigned	BFO_update_req:1;	//System flags
		unsigned	FE_update_req:1;	//System flags
		} Sys_FLAGS ;

struct	{
		unsigned	one:1; 				//Step x1
		unsigned	ten:1;				//Step x10
		unsigned	hundred:1;			//Step x100
		unsigned	kilo:1;				//Step x1000
		} STEP;

struct	{
		unsigned	Att_0dB:1; 			//Pass throught
		unsigned	Att_2dB:1;
    	unsigned	Att_4dB:1;
		unsigned	Att_6dB:1;
		unsigned	Att_8dB:1; 		
		unsigned	Att_10dB:1;
    	unsigned	Att_12dB:1;
		unsigned	Att_14dB:1;
		unsigned	Att_16dB:1; 			//Modif F5JLW
		unsigned	Att_18dB:1;
   		unsigned	Att_20dB:1;
		unsigned	Att_22dB:1;
		unsigned	Att_24dB:1; 		
		unsigned	Att_26dB:1;
   		unsigned	Att_28dB:1;
		unsigned	Att_30dB:1;			//Att position at 30dB
		} ATT;	

struct {								
    	unsigned  	PB_flag:1;			//Flags for state save
    	unsigned	Channel_A_H:1;		//Encoder channel a Latch
    	unsigned	Warn_flag:1;		//Warning light flag
		unsigned 	PTT_flag:1;			//Flag for signaling if ptt pushed
		unsigned	USB_mode:1;			//Flag for signaling if USB mode
		unsigned	LSB_mode:1;			//Flag for signaling if LSB mode
		unsigned	CW_mode:1;			//Flag for signaling if CW mode
		unsigned	Dial :1;			//Flag for signaling if CW mode
		} FLAGS ;

struct {	
    	unsigned  	MUX_bit_1:1;		//MUX division select bit1
    	unsigned	MUX_bit_2:1;		//MUX division select bit2 							
    	unsigned  	VCO_bit_1:1;		//Vco range select bit LR1
    	unsigned	VCO_bit_2:1;		//Vco range select bit LR2
		unsigned	MUX_reset:1;		//Mux reset bit; H=normaly, L=reset
    	unsigned	MUX_div:1;			//Mux; H=direct, L=divided
    	unsigned	PLL_lock:1;			//Input= Lock detect from PLL!
		} VCO_setup ;

struct{
		unsigned	MHz_1_8 : 1;		//Flag for 1.8MHz band
		unsigned	MHz_3_5 : 1;		//Flag for 3.5MHz band
		unsigned	MHz_7 : 1;			//Flag for 7MHz band
		unsigned	MHz_10 : 1;			//Flag for 10MHz band
		unsigned	MHz_14 : 1;			//Flag for 14MHz band
		unsigned	MHz_18 : 1;			//Flag for 18MHz band
		unsigned	MHz_21 : 1;			//Flag for 21MHz band
		unsigned	MHz_24 : 1;			//Flag for 24MHz band
		unsigned	MHz_28 : 1;			//Flag for 28MHz band
		unsigned	MHz_50 : 1;			//Flag for 50MHz band
		} BANDS; 

struct{
		unsigned	Volume : 1;			//Flag for volume
		unsigned	IF_gain : 1;		//If_gain
		unsigned	IF_hang : 1;		//Flag for if hanging
		unsigned	IF_switch: 1;		//Flag for if switch
		unsigned	VOX_gain : 1;		//Flag for VOX gain
		unsigned	VOX_anti : 1;		//Flag for anti VOX
		unsigned	VOX_delay : 1;		//Flag for VOX delay
		unsigned	VOX_On_Off : 1;		//Flag for VOX on or off
		unsigned	Mic_gain : 1;		//Flag for mike gain
		unsigned	Compressor : 1;		//Compressor
		unsigned	RF_pwr : 1;			//Flag for rf power
		} ENC2; 
//******************************************************************
#pragma idata TEXT_RAM
//*** Three banks glued togheter to have 768 byte contignous, in the linker skript

unsigned char 	Knob1_text[10]="Dial lock";//string to append+1
unsigned char 	Knob2_text[10]="Dial free";//string to append+1
unsigned char 	Band_text[7]=" Band=";		//string to append+1
unsigned char	Message_1[41] = "**----Welcome, CDG2007 transceiver----**";
unsigned char 	Message_2[41] = "**-----____ version de F5JLWJ____-----**";
unsigned char 	Message_3[41] = "**-----------Bourgeois Eric-----------**";
unsigned char	Tx_string[9] = "Tx pwr.=";
unsigned char 	kHz[4]="kHz";				//string to append+1
unsigned char 	Rx[4]="Rx=";		   			//string to append
unsigned char 	Tx[4]="Tx=";					//string to append
unsigned char 	USB[5]="USB ";				//string to append+1
unsigned char 	LSB[5]="LSB ";				//string to append+1
unsigned char 	CW[4]="CW ";				//string to append+1
unsigned char 	vol[5]="Vol.";				//string to append+1
unsigned char 	ifg[5]="IFg.";				//string to append+1
unsigned char 	ifh[5]="IFh.";				//string to append+1
unsigned char 	vxg[5]="VXg.";				//string to append+1
unsigned char 	vxd[5]="VXd.";				//string to append+1
unsigned char 	avx[5]="aVX.";				//string to append+1
unsigned char 	mcg[5]="MicG";				//string to append+1
unsigned char 	cmp[5]="Comp";				//string to append+1
unsigned char 	rfp[5]="PWR.";				//string to append+1
unsigned char 	on_txt[3]="On";				//string to append+1
unsigned char 	off_txt[4]="Off";			//string to append+1
unsigned char 	IF_gain_text[8]="IFgain=";	//string to append+1
unsigned char 	switch_IF_txt[7]="IF is:";	//string to append+1
unsigned char 	internal_IF_txt[5]="Int.";	//string to append+1
unsigned char 	external_IF_txt[5]="Ext.";	//string to append+1
unsigned char 	enc2func_text[7]="Enc.2=";	//string to apend
unsigned char	switch_VOX_txt[8]="VOX is:";	//string to append
unsigned char	Step_n[6] = "Step=";
unsigned char	Attenuator[6] = "Att.=";
unsigned char	S_meter_text[11] = "    RSSI >"; 

/******************** Interrupt code**************************/
#pragma code high_vector = 0x08			//ISR code section
void high_interrupt (void)				//High int. vector
	{
  	_asm
    	goto 	HIGH_INT_HANDLE		 	//jump to interrupt routine
 	_endasm
	}
#pragma code							//Return from ISR code section

/****************Interrupt service routine*******************/ 
#pragma interrupt HIGH_INT_HANDLE
void HIGH_INT_HANDLE(void)
{
	unsigned char 	k = 0;
	unsigned char 	temp_data = 0;
	unsigned int	temp_work = 0;
	unsigned int	temp_procent = 0;	

	if (INTCONbits.INT0IF)					//PTT pressed!
	{
		INTCONbits.INT0IF = 0;
		if 	( FLAGS.PTT_flag == 1)
		{		
			FLAGS.PTT_flag = 0;				//***Rx section***
			Tx_switch = 0;
			Nop();
			Rx_switch = 1;
			OpenRB0INT( PORTB_CHANGE_INT_ON & FALLING_EDGE_INT & PORTB_PULLUPS_OFF);

	//*****Load Rx values for relays on FE*****		
			FE_data_1 = ((FE_data_1 & 0b01111111) | 0b00000000);
			IdleI2C();
			StartI2C(); 						//***Setup the IO port on the PCF8574*** 
			IdleI2C();
			WriteI2C(0b01110100);				//Device address = 1000. A2 A1 A0 0 for write to port
			IdleI2C();
			WriteI2C(FE_data_1);				//Data to device
			IdleI2C();
			StopI2C();

	//*****Load Rx values for relays on FE*****		
			FE_data_2 = ((FE_data_2 & 0b11101111) | 0b00000000);
			IdleI2C();
			StartI2C(); 						//***Setup the IO port on the PCF8574*** 
			IdleI2C();
			WriteI2C(0b01110010);				//Device address = 0100. A2 A1 A0 0 for write to port
			IdleI2C();
			WriteI2C(FE_data_2);				//Data to device
			IdleI2C();
			StopI2C();

			Update_BFO();
			Wait(100);

/*	//****Set the Hang time to the original value*****
			temp_procent = (ifh_value_proc & 0x00FF);
			temp_work = temp_procent * 63;	//Multiply to have full coverage (proc is defined between 0-100%!
	 		temp_data = 63 - (temp_work / 100);
	
			IdleI2C();
			StartI2C(); 						//Setup and program of RDAC of the AD5258
			IdleI2C();
			WriteI2C(0x34);						//Device address of U8 on IF board 0x34
			IdleI2C();
			WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
			IdleI2C();
			WriteI2C(temp_data);				//Write data byte
			IdleI2C();
			StopI2C();
*/
	//*****Load back old Volume value*****	
			temp_procent = (vol_value_proc & 0x00FF);
			temp_work = temp_procent * 255;		//Multiply to have full coverage (proc is defined between 0-100%!
	 		temp_data = temp_work / 100;

			IdleI2C();
			StartI2C(); 						//Setup and program of RDAC of the AD5254
			IdleI2C();
			WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
			IdleI2C();
			WriteI2C(0x02);						//Write to RDAC2 register
			IdleI2C();
			WriteI2C(temp_data);				//Write data byte
			IdleI2C();
			NotAckI2C();
			IdleI2C();	
			StopI2C();
		}

		else	
		{
			FLAGS.PTT_flag = 1;				//***Tx section***
			Tx_switch = 1;
			Nop();
			Rx_switch = 0;
			OpenRB0INT( PORTB_CHANGE_INT_ON & RISING_EDGE_INT & PORTB_PULLUPS_OFF);

/*	//****Set the Hang time to maximum*****
			temp_data = (TxE_data & 0b00000100);
			if ((FLAGS.LSB_mode == 1) | (FLAGS.USB_mode == 1))
					TxE_data = TxE_data & 0b11111011;
			IdleI2C();
			StartI2C(); 						//Setup and program of RDAC of the AD5258
			IdleI2C();
			WriteI2C(0x34);						//Device address of U8 on IF board 0x34
			IdleI2C();
			WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
			IdleI2C();
			WriteI2C(0x3F);						//Write data byte (maximal value to lower the HANG time!!!)
			IdleI2C();
			StopI2C();
*/
	//*****Load Tx values for relays on FE*****	
			FE_data_1 = ((FE_data_1 & 0b01111111) | 0b10000000);
			IdleI2C();
			StartI2C(); 						//***Setup the IO port on the PCF8574*** 
			IdleI2C();
			WriteI2C(0b01110100);				//Device address = 1000. A2 A1 A0 0 for write to port
			IdleI2C();
			WriteI2C(FE_data_1);				//Data to device
			IdleI2C();
			StopI2C();

	//*****Load Tx values for relays on FE*****	
			FE_data_2 = ((FE_data_2 & 0b11101111) | 0b00010000);
			IdleI2C();
			StartI2C(); 						//***Setup the IO port on the PCF8574*** 
			IdleI2C();
			WriteI2C(0b01110010);				//Device address = 0100. A2 A1 A0 0 for write to port
			IdleI2C();
			WriteI2C(FE_data_2);				//Data to device
			IdleI2C();
			StopI2C();

	//*****Load 0 to Volume value*****	
	 		temp_data = 0;
			IdleI2C();
			StartI2C(); 						//Setup and program of RDAC of the AD5254
			IdleI2C();
			WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
			IdleI2C();
			WriteI2C(0x02);						//Write to RDAC2 register
			IdleI2C();
			WriteI2C(temp_data);				//Write data byte
			IdleI2C();
			NotAckI2C();
			IdleI2C();	
			StopI2C();

			Update_BFO();
		}
	}

	if (INTCON3bits.INT1IF)					//Optical encoder (freq tuner) changed!
	{
		INTCON3bits.INT1IF = 0;
		Sys_FLAGS.Freq_change = 1;
		if 	(FLAGS.Dial == 0)
		{
			if 	(Opto_1B == 0)
			{ 
				if 		(STEP.one == 1) Rig_freq = Rig_freq + 5  ;	
				else if (STEP.ten == 1)	Rig_freq = Rig_freq + 50 ;	
				else if (STEP.hundred == 1) Rig_freq = Rig_freq + 250 ;
				else if (STEP.kilo == 1) Rig_freq = Rig_freq + 1000 ;
			}
			else 
			{ 
				if 		(STEP.one == 1) Rig_freq = Rig_freq - 5 ;	
				else if (STEP.ten == 1)	Rig_freq = Rig_freq - 50 ;	
				else if (STEP.hundred == 1) Rig_freq = Rig_freq - 250 ;
				else if (STEP.kilo == 1) Rig_freq = Rig_freq - 1000 ;
			}
		}
	}

	if (INTCON3bits.INT2IF)					//Mechanical encoder (menu encoder) changed!
	{
		INTCON3bits.INT2IF = 0;
		if 		(ENC2.Volume == 1) 		k = vol_value_proc;	
		else if (ENC2.IF_gain == 1) 	k = ifg_value_proc;
		else if (ENC2.IF_hang == 1) 	k = ifh_value_proc;
		else if (ENC2.VOX_gain == 1)	k = vxg_value_proc;
		else if (ENC2.VOX_delay == 1)	k = vxd_value_proc;
		else if (ENC2.VOX_anti == 1)	k = avx_value_proc;
		else if (ENC2.Mic_gain == 1)	k = mcg_value_proc;
		else if (ENC2.Compressor == 1) 	k = cmp_value_proc;
		else if (ENC2.RF_pwr == 1)		k = rfp_value_proc;	

		if 	(Opto_2B == 1)	
		{
			if (ENC2.VOX_On_Off == 1)		vox_onoff_value = 0;
			else if (ENC2.IF_switch ==1) 	if_switch_value = 1;
			else
			{
				if ((ENC2.Volume == 1) & (k >= 15))
					k = k + 5;
				else
					k ++;
				if ((k > 100) & (k < 254))
				k = 100;
				if ((k > 253) & (k <= 255))
				k = 0;
			}
			INTCON2bits.INTEDG2 = 1;
		}
		else
		{
			if (ENC2.VOX_On_Off == 1)	vox_onoff_value = 1;
			else if (ENC2.IF_switch ==1) 	if_switch_value = 0;
			else
			{
				if ((ENC2.Volume == 1) & (k >= 15))
					k = k - 5;
				else
					k --;
				if ((k >= 100) & (k < 250))
				k = 100;
				if ((k >= 250) & (k <= 255))
				k = 0;
			}
		//	INTCON2bits.INTEDG1 = 0;
		}

		if 		(ENC2.Volume == 1) 			vol_value_proc = k;	
		else if (ENC2.IF_gain == 1)			ifg_value_proc = k;
		else if (ENC2.IF_hang == 1) 		ifh_value_proc = k;
		else if (ENC2.VOX_gain == 1)		vxg_value_proc = k;
		else if (ENC2.VOX_delay == 1)		vxd_value_proc = k;
		else if (ENC2.VOX_anti == 1)		avx_value_proc = k;
		else if (ENC2.Mic_gain == 1) 		mcg_value_proc = k;
		else if (ENC2.Compressor == 1) 		cmp_value_proc = k;
		else if (ENC2.RF_pwr == 1) 			rfp_value_proc = k;
	
		Sys_FLAGS.ENC2_change = 1;	
	}

	if (INTCON3bits.INT3IF)					//PB pressed on the mechanical encoder
	{
		INTCON3bits.INT3IF = 0;			
	}

	if (INTCONbits.TMR0IF == 1)
	{
		INTCONbits.TMR0IF = 0;
		WriteTimer0	(34286);				//34286 200mS count back from 0xFFFF
		Sys_FLAGS.LCD_update_req = TRUE;
	}
}
/********************** Main code*****************************/
void main (void)
{
	unsigned int i, j, q = 0;
	unsigned char temp_data = 0;

	Setup_MCU ();

	Del_STEP_flags ();
	RAM_erase(Matrix_string,11);

	FLAGS.PTT_flag = 0;

	FLAGS.Dial = 0;
	STEP.ten = 1;
	ATT.Att_0dB = 1;

	First_half = 1;						//LCD's first half
	OpenXLCD (EIGHT_BIT & LINES_5X7);	//Default after init is first line
	putsXLCD (Message_3);				//First line text
	while	(BusyXLCD() == 1);
			SetDDRamAddr (0x40);		//Set second line
	putsXLCD (Message_1);				//Second line text

	First_half = 0;						//LCD's 2nd half
	OpenXLCD (EIGHT_BIT & LINES_5X7);	
	putsXLCD (Message_2);
	while	(BusyXLCD() == 1);
			SetDDRamAddr (0x40);		//Fourth line
	putsXLCD (Message_3);

	First_half = 1;
	while	(BusyXLCD() == 1);
	WriteCmdXLCD (0x0C);				//Cursor OFF
	InitCGRam();						//Load special chars into the CGRAM... (8chars!) 

	First_half = 0;
	while	(BusyXLCD() == 1);
	WriteCmdXLCD (0x0C);				//Cursor Off
	InitCGRam();						//Load special chars into the CGRAM... (8chars!) 
		
	IdleI2C();
	StartI2C(); 						//***Setup the IO port on the PCF8574*** 
	IdleI2C();
	WriteI2C(0b01001010);				//Device address = 0100. A2 A1 A0 0 for write to port
	IdleI2C();
	WriteI2C(LO_data);					//Device address = 0100. A2 A1 A0 0 for write to port
	IdleI2C();
	StopI2C();	

	Sys_FLAGS.Freq_change = 1;

	BL_2 = 1;
	Nop();
	BL_1 = 1;

	//*** Setup Int0 for Rx ***
	FLAGS.PTT_flag = 0;
	Tx_switch = 0;
	Nop(); 
	Rx_switch = 1;
	OpenRB0INT( PORTB_CHANGE_INT_ON & FALLING_EDGE_INT & PORTB_PULLUPS_OFF);

	//*** Setup for audio switching
	vox_onoff_value = 1;			//VOX is in OFF position by default 
	if_switch_value = 0;			//IF switch is Internal by default
	ENC2.VOX_On_Off = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	vxg_value_proc = 60;			//Set default gain vox to 60%
	ENC2.VOX_gain = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	vxd_value_proc = 100;			//Set default vox delay to 100%
	ENC2.VOX_delay = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	avx_value_proc = 30;			//Set default anti vox gain  to 30%
	ENC2.VOX_anti = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	ifg_value_proc = 75;			//Set default if gain to 75%
	ENC2.IF_gain = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	ifh_value_proc = 95;			//Set default if hang time to 95%
	ENC2.IF_hang = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	mcg_value_proc = 40;			//Set default mike gain to 40%
	ENC2.Mic_gain = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	cmp_value_proc = 24;			//Set default mike compressor to 24%
	ENC2.Compressor = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	rfp_value_proc = 95;			//Set default rf pwr to 95%
	ENC2.RF_pwr = 1;
	Update_ENC2_functions();
	Del_ENC2_flags();

	vol_value_proc = 5;			//Set default volume to 15%
	ENC2.Volume = 1;
	Update_ENC2_functions();

	//*** Setup for USB, CW or LSB **
	FLAGS.USB_mode = 1;			//Flag for signaling if USB mode
	FLAGS.LSB_mode = 0;			//Flag for signaling if LSB mode
	FLAGS.CW_mode = 0;			//Flag for signaling if CW mode
	Sys_FLAGS.BFO_update_req = 1;

	Wait(500);		

	while (1)
	{
		if (Sys_FLAGS.LCD_update_req == TRUE)
		{
			Update_LCD_first_line();
			Update_LCD_second_line();
			Update_LCD_third_line();
			Update_LCD_fourth_line ();
		}

		if	((Sys_FLAGS.ENC2_change == 1) & (Sys_FLAGS.LCD_update_req == TRUE))
		{
			Update_ENC2_functions();
			Sys_FLAGS.ENC2_change = 0;
		}

		if 	((Sys_FLAGS.Freq_change == 1)  | (Sys_FLAGS.Freq_by_kbd == 1) | (Sys_FLAGS.FE_update_req == 1))
		{
			Band_select ();
			Update_DDS_1();
			Update_Front_End();
			Update_Filter_SWR ();
			Sys_FLAGS.FE_update_req = 0;
			Sys_FLAGS.Freq_change = 0;
			Sys_FLAGS.Freq_by_kbd = 0;
		}
		
		if (Sys_FLAGS.BFO_update_req == 1)
		{
			Update_BFO();
			Sys_FLAGS.BFO_update_req = 0;
		}

		if (FLAGS.PTT_flag ==1)
		{
				//Get_analog_Tx_power ();
				//Display_TxP ();
		}
		else
		{
				Get_analog_S_meter ();
		}

		Key_scan_1 ();
		Key_scan_2 ();
	//	Sys_FLAGS.LCD_update_req == FALSE;
	}
}
// ******************************************************************
void DelayPORXLCD (void)
{
	Delay10KTCYx(50); // Delay of 50ms
	// Cycles = (TimeDelay * Fosc) / 4
}
// ******************************************************************
void DelayXLCD (void)
{
	Delay10KTCYx(5); // Delay of 8ms
	// Cycles = (TimeDelay * Fosc) / 4
}
// ******************************************************************
void DelayFor18TCY (void)
{
	Delay10TCYx(5);//10
}
/************************************************************/
void RAM_erase (char *str, char length)
{	char j;
	for (j=0;j<=length - 1;j++)			//Erase all alocated Data RAM
		{
			str[j]=0;					//Send character blank
		}
}
/************************************************************/
