// ************************Update LCD line 2******************************************

#include "D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

void Update_LCD_second_line (void)
{	
	extern char 			LCD_line[41];
	extern	unsigned char 	IF_gain_text[8];	//string to append
	extern 	unsigned char 	switch_IF_txt[7];	//string to append+1
	extern 	unsigned char 	internal_IF_txt[5];	//string to append+1
	extern 	unsigned char 	external_IF_txt[5];	//string to append+1
	extern	unsigned char 	enc2func_text[7];	//string to append
	extern	unsigned char 	vol[5];				//string to append+1
	extern	unsigned char 	ifg[5];				//string to append+1
	extern	unsigned char 	ifh[5];				//string to append+1
	extern	unsigned char 	vxg[5];				//string to append+1
	extern	unsigned char 	vxd[5];				//string to append+1
	extern	unsigned char 	avx[5];				//string to append+1
	extern	unsigned char 	mcg[5];				//string to append+1
	extern	unsigned char 	cmp[5];				//string to append+1
	extern	unsigned char 	rfp[5];				//string to append+1
	extern	unsigned char 	on_txt[5];			//string to append+1
	extern	unsigned char 	off_txt[5];			//string to append+1
	extern	unsigned char	switch_VOX_txt[8];		//string to append
	extern 	unsigned char	First_half;
	extern 	unsigned char	MUTE;
	
			unsigned long 	i, k = 0;
			unsigned char 	j, l = 0;
			unsigned char	procentage[4];
	
	extern struct{
			unsigned	Volume : 1;			//Flag for volume
			unsigned	IF_gain : 1;		//If_gain
			unsigned	IF_hang : 1;		//Flag for if hanging
			unsigned	IF_switch: 1;		//Flag for if switch
			unsigned	VOX_gain : 1;		//Flag for VOX gain
			unsigned	VOX_anti : 1;		//Flag for anti VOX
			unsigned	VOX_delay : 1;		//Flag for VOX delay
			unsigned	VOX_On_Off : 1;		//Flag for VOX on or off
			unsigned	Mic_gain : 1;		//Flag for mike gain
			unsigned	Compressor : 1;		//Compressor
			unsigned	RF_pwr : 1;			//Flag for rf power
			} ENC2; 
	
	extern unsigned char 	vol_value_proc ;			//volume holding register
	extern unsigned char 	ifg_value_proc ;			//IF gain holding register
	extern unsigned char 	ifh_value_proc ;			//IF hang holding register
	extern unsigned char 	if_switch_value;			//IF switched to internal or external
	extern unsigned char 	vxg_value_proc ;			//VOX gain holding register
	extern unsigned char 	vxd_value_proc ;			//VOX delay holding register
	extern unsigned char 	avx_value_proc ;			//Anti vox holding register
	extern unsigned char	vox_onoff_value ;			//Vox on or off holding register
	extern unsigned char 	mcg_value_proc ;			//Mike gain holding register
	extern unsigned char 	cmp_value_proc ;			//Compresssor holding register
	extern unsigned char 	rfp_value_proc ;			//RF power holding register

	RAM_erase(procentage,4);
	RAM_erase(LCD_line,41);
	strncpy	(LCD_line, IF_gain_text, 7);	//Put "IF-Gain=" to the begining of the string

	l = strlen (LCD_line);
	for (i = 0; i <= 4 ; i++)
	{
		LCD_line[l] = ' '; 					//Put spaces for bargraph
		l++;
	}

	k = ifg_value_proc;
	ultoa (k, procentage); 					//Convert to string...
	l = strlen (procentage);
	strncat (LCD_line, procentage, l);		//Append procentage to the end of the string
	l = strlen (LCD_line);
	LCD_line[l] = '%';

	l = strlen (LCD_line);
	j = l;
	for (k = j; k <= 19 ; k++)
	{
		LCD_line[l] = ' '; 					//Put a space
		l++;
	}

	strncat	(LCD_line, enc2func_text, 12);//Append enc2func to the end of the string

	if 		(ENC2.Volume == 1) 	
	{
		strncat	(LCD_line, vol, 4);
		k = vol_value_proc;
	}
	else if (ENC2.IF_gain == 1)
	{
	 	strncat	(LCD_line, ifg, 4);
		k = ifg_value_proc;
	}
	else if (ENC2.IF_hang == 1)
	{
		strncat	(LCD_line, ifh, 4);
		k = ifh_value_proc;
	}
	else if (ENC2.IF_switch == 1)
	{
	 	strncat	(LCD_line, switch_IF_txt, 6);
	}

	else if (ENC2.VOX_gain == 1)
	{
		strncat	(LCD_line, vxg, 4);
		k = vxg_value_proc;
	}
	else if (ENC2.VOX_delay == 1)
	{
		strncat	(LCD_line, vxd, 4);
		k = vxd_value_proc;
	}
	else if (ENC2.VOX_anti == 1)
	{
	 	strncat (LCD_line, avx, 4);
		k = avx_value_proc;
	}

	else if (ENC2.VOX_On_Off == 1)
	{
	 	strncat	(LCD_line, switch_VOX_txt, 7);
	}

	else if (ENC2.Mic_gain == 1)
	{
	 	strncat	(LCD_line, mcg, 4);
		k = mcg_value_proc;
	}
	else if (ENC2.Compressor == 1)
	{
	 	strncat	(LCD_line, cmp, 4);
		k = cmp_value_proc;
	}
	else if (ENC2.RF_pwr == 1) 
	{
		strncat	(LCD_line, rfp, 4);
		k = rfp_value_proc;
	}
	

	if (ENC2.VOX_On_Off == 1)
	{
		if (vox_onoff_value == 1) 	strncat(LCD_line, off_txt, 3);
		else						strncat(LCD_line, on_txt, 2);
	}

	else if (ENC2.IF_switch == 1)
	{
		if (if_switch_value == 1) 	strncat(LCD_line, external_IF_txt, 4);
		else						strncat(LCD_line, internal_IF_txt, 4);
	}
	
	else
	{
		l = strlen (LCD_line);
		LCD_line[l] = '=';	 					//Put a = sign
	
		l = strlen (LCD_line);
		if ((MUTE == 1) & (ENC2.Volume == 1))
		{
			LCD_line[l] = 'M';	 					//Write MUTE
			LCD_line[l+1] = 'u';	 				//	
			LCD_line[l+2] = 't';	 				//	
			LCD_line[l+3] = 'e';	 				//	
		}
		else
		{
			for (i = 0; i <= 4 ; i++)
			{
				LCD_line[l] = ' '; 					//Put spaces for bargraph
				l++;
			}
			ultoa (k, procentage); 					//Convert to string...
			l = strlen (procentage);
			strncat (LCD_line, procentage, l);		//Append procentage to the end of the string
			l = strlen (LCD_line);
			LCD_line[l] = '%';
		}
	}
	
	j = strlen (LCD_line);
	l = j;
	for (k = j; k <= 39 ; k++)
	{
		LCD_line[l] = ' ';
		l++;
	}

	First_half = 0;	
	while (BusyXLCD());
	SetDDRamAddr (0x00);					//Second line
	putsXLCD (LCD_line);

	Place_bargraph(0x07, ifg_value_proc);

	if 		((ENC2.Volume == 1) & (MUTE == 0))	Place_bargraph(0x1F, vol_value_proc);
	else if (ENC2.IF_gain == 1)		Place_bargraph(0x1F, ifg_value_proc);
	else if (ENC2.IF_hang == 1)		Place_bargraph(0x1F, ifh_value_proc);
	else if (ENC2.VOX_gain == 1)	Place_bargraph(0x1F, vxg_value_proc);
	else if (ENC2.VOX_delay == 1)	Place_bargraph(0x1F, vxd_value_proc);
	else if (ENC2.VOX_anti == 1)	Place_bargraph(0x1F, avx_value_proc);
	else if (ENC2.Mic_gain == 1)	Place_bargraph(0x1F, mcg_value_proc);
	else if (ENC2.Compressor == 1)	Place_bargraph(0x1F, cmp_value_proc);
	else if (ENC2.RF_pwr == 1) 		Place_bargraph(0x1F, rfp_value_proc);
}
	// ******************************************************************

