/* $Id: openxlcd.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

/********************************************************************
*       Function Name:  OpenXLCD                                    *
*       Return Value:   void                                        *
*       Parameters:     lcdtype: sets the type of LCD (lines)       *
*       Description:    This routine configures the LCD. Based on   *
*                       the Hitachi HD44780 LCD controller. The     *
*                       routine will configure the I/O pins of the  *
*                       microcontroller, setup the LCD for 4- or    *
*                       8-bit mode and clear the display. The user  *
*                       must provide three delay routines:          *
*                       DelayFor18TCY() provides a 18 Tcy delay     *
*                       DelayPORXLCD() provides at least 15ms delay *
*                       DelayXLCD() provides at least 5ms delay     *
********************************************************************/
void OpenXLCD(unsigned char lcdtype)
{
	extern unsigned char	First_half;

		DATA_PORT = 0;
	    DelayFor18TCY();
        TRIS_DATA_PORT = 0xff;
	    DelayFor18TCY();

        TRIS_RW = 0;                    // All control signals made outputs
	    DelayFor18TCY();

        TRIS_RS = 0;
	    DelayFor18TCY();

		if	(First_half == 1)	
		{
			TRIS_E_1 = 0;
	        DelayFor18TCY();
		}
		else
		{
			TRIS_E_2 = 0;		
	        DelayFor18TCY();
		}

        RW_PIN = 0;                     // R/W pin made low
	    DelayFor18TCY();

        RS_PIN = 0;                     // Register select pin made low
	    DelayFor18TCY();

		if	(First_half == 1)	
		{
			E_PIN_1 = 0;
	    	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 0;		
	    	DelayFor18TCY();
		}

        // Delay for 50ms to allow for LCD Power on reset
        DelayPORXLCD();
        
        // Setup interface to LCD
        // 8-bit mode interface
        TRIS_DATA_PORT = 0;             //Data port output
		Nop();
        DATA_PORT = 0b00110000;         //Function set cmd(8-bit interface)
        DelayXLCD();					//100uS Wait at least

       	if	(First_half == 1)			//Clock the cmd in
		{
			E_PIN_1 = 1;
        	DelayFor18TCY();
			E_PIN_1 = 0;
        	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 1;
        	DelayFor18TCY();
			E_PIN_2 = 0;
        	DelayFor18TCY();
		}

        // Delay for at least 4.1ms
        DelayXLCD();

        // Setup interface to LCD
        DATA_PORT = 0b00110000;         // Function set cmd(8-bit interface)
        DelayXLCD();					//100uS Wait at least

       	if	(First_half == 1)			// Clock the cmd in
		{
			E_PIN_1 = 1;
        	DelayFor18TCY();
			E_PIN_1 = 0;
        	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 1;
        	DelayFor18TCY();
			E_PIN_2 = 0;
        	DelayFor18TCY();
		}

        // Delay for at least 100us
        DelayXLCD();

        // Setup interface to LCD
        DATA_PORT = 0b00110000;         // Function set cmd(8-bit interface)
        DelayXLCD();					//100uS Wait at least

       	if	(First_half == 1)			// Clock the cmd in
		{
			E_PIN_1 = 1;
        	DelayFor18TCY();
			E_PIN_1 = 0;
        	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 1;
        	DelayFor18TCY();
			E_PIN_2 = 0;
        	DelayFor18TCY();
		}

        TRIS_DATA_PORT = 0xff;          // Make data port input
        DelayXLCD();					//100uS Wait at least

        // Set data interface width, # lines, font
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(lcdtype);          // Function set cmd
        DelayXLCD();

        // Turn the display on then off
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(DOFF&CURSOR_OFF&BLINK_OFF);        // Display OFF/Blink OFF
        DelayXLCD();

        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(DON);           // Display ON/Blink ON
        DelayXLCD();

        // Clear display
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(0x01);             // Clear display
        DelayXLCD();

        // Set entry mode inc, no shift
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(SHIFT_CUR_LEFT);   // Entry Mode
        DelayXLCD();

        // Set DD Ram address to 0
        while(BusyXLCD());              // Wait if LCD busy
        SetDDRamAddr(0);                // Set Display data ram address to 0
        DelayXLCD();

        return;
}

