


//	AD5258_readback_write ();
//	AD5254_readback_write ();
//	MAX517_preprogram();


/************************************************************/ 
void AD5258_readback_write (void)
{
	unsigned int temp_value = 0;
	/*
	//***Programming the RDAC's EEPROM of AD5258***
	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x9C);						//Device address of U12 on Tx_exciter board 0x9C
	IdleI2C();
	WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
	IdleI2C();
	WriteI2C(45);						//Write data byte
	IdleI2C();
	StopI2C();

	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x30);						//Device address of U7 on IF board 0x30
	IdleI2C();
	WriteI2C(0x20);						//Write instruction byte: I2C --> EEPROM
	IdleI2C();
	WriteI2C(48);						//Write data byte, set to 60%
	IdleI2C();
	StopI2C();
	Wait(100);

								
	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x34);						//Device address of U8 on IF board 0x34
	IdleI2C();
	WriteI2C(0x20);						//Write instruction byte: I2C --> EEPROM
	IdleI2C();
	WriteI2C(29);						//Write data byte, set to 40%
	IdleI2C();
	StopI2C();
	Wait(100);
	*/

	//***Reading back the EEPROM value to the variables***
	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x30);						//Device address of U7 on IF board 0x30
	IdleI2C();
	WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x31);						//Device address of U7 on IF board 0x31 READ!
	IdleI2C();
	temp_value = (ReadI2C() & 0x3F);	//Read data byte and mask the two first bits
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 63));
	ifg_value_proc = temp_value;


	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x34);						//Device address of U8 on IF board 0x34
	IdleI2C();
	WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x35);						//Device address of U8 on IF board 0x35 READ!
	IdleI2C();
	temp_value = (ReadI2C() & 0x3F);	//Read data byte and mask the two first bits
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 63));
	ifh_value_proc = temp_value;

	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5258
	IdleI2C();
	WriteI2C(0x9C);						//Device address of U12 on Tx_exciter board 0x9C
	IdleI2C();
	WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x9D);						//Device address of U12 on Tx_exciter board 0x9C READ!
	IdleI2C();
	temp_value = (ReadI2C() & 0x3F);	//Read data byte and mask the two first bits
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 63));
	cmp_value_proc = temp_value;

	//***End of reading back from AD5258***
}
/************************************************************/ 
void AD5254_readback_write (void)
{
	unsigned int temp_value = 0;

	//***Reading back the EEPROM value to the variables***
	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5254
	IdleI2C();
	WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
	IdleI2C();
	WriteI2C(0x20);						//Write instruction byte, access EEMEM0
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x59);						//Device address of U6 on Tx_exciter board 0x58 READ!
	IdleI2C();
	temp_value = ReadI2C();				//Read data byte
	IdleI2C();	
	NotAckI2C();
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 255));
	vxg_value_proc = temp_value;


	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5254
	IdleI2C();
	WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
	IdleI2C();
	WriteI2C(0x21);						//Write instruction byte, access EEMEM1
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x59);						//Device address of U6 on Tx_exciter board 0x58 READ!
	IdleI2C();
	temp_value = ReadI2C();				//Read data byte
	IdleI2C();	
	NotAckI2C();
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 255));
	avx_value_proc = temp_value;

	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5254
	IdleI2C();
	WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
	IdleI2C();
	WriteI2C(0x22);						//Write instruction byte, access EEMEM2
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x59);						//Device address of U6 on Tx_exciter board 0x58 READ!
	IdleI2C();
	temp_value = ReadI2C();				//Read data byte
	IdleI2C();	
	NotAckI2C();
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 255));
	vol_value_proc = temp_value;

	IdleI2C();
	StartI2C(); 						//Setup and program of RDAC of the AD5254
	IdleI2C();
	WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
	IdleI2C();
	WriteI2C(0x23);						//Write instruction byte, access EEMEM3
	IdleI2C();
	RestartI2C();
	IdleI2C();
	WriteI2C(0x59);						//Device address of U6 on Tx_exciter board 0x58 READ!
	IdleI2C();
	temp_value = ReadI2C();				//Read data byte
	IdleI2C();	
	NotAckI2C();
	IdleI2C();
	StopI2C();

	temp_value = (100-((temp_value * 100) / 255));
	mcg_value_proc = temp_value;

	//***End of reading back from AD5254***
}
/************************************************************/ 
void MAX517_preprogram (void)
{
	unsigned int	 	temp_work = 0;
	unsigned int	 	temp_procent = 0;
	unsigned char		temp_data = 0;

	vxd_value_proc = 30;				//Preload the Procent value holder register with 30%
	temp_procent = (vxd_value_proc & 0x00FF);
	temp_work = temp_procent * 255;		//Multiply to have full coverage (proc is defined between 0-100%)!
 	temp_data = temp_work / 100;

	StartI2C();							//Setup and program of DAC of the MAX517
	IdleI2C();
	WriteI2C(0x5A);						//Device address of U4 on Tx_exciter board 0x5A
	IdleI2C();
	WriteI2C(0x00);						
	IdleI2C();
	WriteI2C(temp_data);				//Load DAC value
	IdleI2C();
	StopI2C();
	IdleI2C();
}
/************************************************************/