// *************************** DDS update ***************************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

void Update_DDS_1 (void)
{
	unsigned char q = 0;
	unsigned long j, k = 0;
	float  i = 0;

	extern	float			Rig_freq;
	extern	unsigned char 	LO_data;
	unsigned char 			temp_LO_data = 0;

	extern	struct {	
    	unsigned  	MUX_bit_1:1;		//MUX division select bit1
    	unsigned	MUX_bit_2:1;		//MUX division select bit2 							
    	unsigned  	VCO_bit_1:1;		//Vco range select bit LR1
    	unsigned	VCO_bit_2:1;		//Vco range select bit LR2
		unsigned	MUX_reset:1;		//Mux reset bit; H=normaly, L=reset
    	unsigned	MUX_div:1;			//Mux; H=direct, L=divided
    	unsigned	PLL_lock:1;			//Input= Lock detect from PLL!
		} VCO_setup ;

	extern	struct{
		unsigned	MHz_1_8 : 1;		//Flag for 1.8MHz band
		unsigned	MHz_3_5 : 1;		//Flag for 3.5MHz band
		unsigned	MHz_7 : 1;			//Flag for 7MHz band
		unsigned	MHz_10 : 1;			//Flag for 10MHz band
		unsigned	MHz_14 : 1;			//Flag for 14MHz band
		unsigned	MHz_18 : 1;			//Flag for 18MHz band
		unsigned	MHz_21 : 1;			//Flag for 21MHz band
		unsigned	MHz_24 : 1;			//Flag for 24MHz band
		unsigned	MHz_28 : 1;			//Flag for 28MHz band
		unsigned	MHz_50 : 1;			//Flag for 50MHz band
		} BANDS; 
	

	if (BANDS.MHz_1_8 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 1;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 0;		//Normal op, divided by MUX_bit_1 and MUX_bit_2
		VCO_setup.MUX_reset = 1;        //No reset normal op.
	}
	else if (BANDS.MHz_3_5 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 0;		//Vco range select bit LR2
		VCO_setup.MUX_reset = 1;        //No reset normal op.
		VCO_setup.MUX_div	= 0;		//Normal op, divided by MUX_bit_1 and MUX_bit_2
	}
	else if (BANDS.MHz_7 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 1;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 1;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 0;		//Normal op, divided by MUX_bit_1 and MUX_bit_2
		VCO_setup.MUX_reset = 1;        //No reset normal op.
	}
	else if (BANDS.MHz_10 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 1;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 0;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 0;		//Normal op, divided by MUX_bit_1 and MUX_bit_2
		VCO_setup.MUX_reset = 1;        //No reset normal op.
	}
	else if (BANDS.MHz_14 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 1;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 1;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 1;		//Don't use division!
		VCO_setup.MUX_reset = 0;        //Keep 74HC163 under reset!
	}
	else if (BANDS.MHz_18 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 1;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 0;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 1;		//Don't use division!
		VCO_setup.MUX_reset = 0;        //Keep 74HC163 under reset!
	}
	else if (BANDS.MHz_21 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 1;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 0;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 1;		//Don't use division!
		VCO_setup.MUX_reset = 0;        //Keep 74HC163 under reset!
	}
	else if (BANDS.MHz_24 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 1;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 1;		//Don't use division!
		VCO_setup.MUX_reset = 0;        //Keep 74HC163 under reset!
	}
	else if (BANDS.MHz_28 == TRUE)
	{
	 	VCO_setup.MUX_bit_1 = 0;		//MUX division select bit1
    	VCO_setup.MUX_bit_2 = 1;		//MUX division select bit2 							
     	VCO_setup.VCO_bit_1 = 0;		//Vco range select bit LR1
    	VCO_setup.VCO_bit_2 = 0;		//Vco range select bit LR2
		VCO_setup.MUX_div	= 1;		//Don't use division!
		VCO_setup.MUX_reset = 0;        //Keep 74HC163 under reset!
	}	
	
	if	(VCO_setup.MUX_bit_1 == 1)
			temp_LO_data = ((temp_LO_data & 0b11111110) | 0b00000001); 
	else	temp_LO_data = ((temp_LO_data & 0b11111110) | 0b00000000);  
	if	(VCO_setup.MUX_bit_2 == 1)
			temp_LO_data = ((temp_LO_data & 0b11111101) | 0b00000010); 
	else	temp_LO_data = ((temp_LO_data & 0b11111101) | 0b00000000); 
	if	(VCO_setup.MUX_reset == 1)
			temp_LO_data = ((temp_LO_data & 0b11111011) | 0b00000100); 
	else	temp_LO_data = ((temp_LO_data & 0b11111011) | 0b00000000); 
	if	(VCO_setup.MUX_div == 1)
			temp_LO_data = ((temp_LO_data & 0b11110111) | 0b00001000); 
	else	temp_LO_data = ((temp_LO_data & 0b11110111) | 0b00000000); 
	if	(VCO_setup.VCO_bit_1 == 1)
			temp_LO_data = ((temp_LO_data & 0b11101111) | 0b00010000); 
	else	temp_LO_data = ((temp_LO_data & 0b11101111) | 0b00000000); 
	if	(VCO_setup.VCO_bit_2 == 1)
			temp_LO_data = ((temp_LO_data & 0b11011111) | 0b00100000); 
	else	temp_LO_data = ((temp_LO_data & 0b11011111) | 0b00000000); 

	i = (Rig_freq + 9000000) * 2;	
	if ((VCO_setup.MUX_bit_1 == 0) & (VCO_setup.MUX_bit_2 == 0) & (VCO_setup.MUX_div != 1))
		i = i * 5;
	else if ((VCO_setup.MUX_bit_1 == 1) & (VCO_setup.MUX_bit_2 == 0) & (VCO_setup.MUX_div != 1))
		i = i * 4;
	else if ((VCO_setup.MUX_bit_1 == 0) & (VCO_setup.MUX_bit_2 == 1) & (VCO_setup.MUX_div != 1))
		i = i * 3;
	else if ((VCO_setup.MUX_bit_1 == 1) & (VCO_setup.MUX_bit_2 == 1) & (VCO_setup.MUX_div != 1))
		i = i * 2;
	else if (VCO_setup.MUX_div == 1)
		i = i;

	//i = i / 512;   
	//i = (i * 134.217728);				//**** 134.217728= ( (2^32)) / 32MHz ****
	i = (i * 0.262144);					//Shorted form! i= (i / 512 *( (2^32)) / 32MHz
	j = i;								//Handle over to a non fp. variable Note: j contains the dds freq!

	for (q = 0; q<=31; q++) 
	{
		k = (j & 0x80000000) ; 
		if 	((k  & 0x80000000)  == 0x80000000)
			DDS_data = 1;
		else
			DDS_data = 0;

		Nop();
		DDS_clk	= 0;
		Nop();
		j = j << 1;
		DDS_clk	= 1;
		Nop();
	}

	DDS_enable_LO	= 0;
	Nop();
	DDS_enable_LO	= 1;					//Return to 1 the Enable line
	Nop();
	DDS_clk	= 0;
	Nop();
	DDS_data = 0;							//Return to 0 the data line

	if (temp_LO_data != LO_data)			//If no change do not update I2C! Reduce traffic...
	{
		LO_data = temp_LO_data;
		IdleI2C();
		StartI2C(); 						//***Setup the IO port on the PCF8574*** 
		IdleI2C();
		WriteI2C(0b01001010);				//Device address = 0100. A2 A1 A0 0 for write to port
		IdleI2C();
		WriteI2C(LO_data);					//Device address = 0100. A2 A1 A0 0 for write to port
		IdleI2C();
		StopI2C();
	}
		
}
// ******************************************************************
