/* $Id: openxlcd.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

/********************************************************************
*       Function Name:  OpenXLCD                                    *
*       Return Value:   void                                        *
*       Parameters:     lcdtype: sets the type of LCD (lines)       *
*       Description:    This routine configures the LCD. Based on   *
*                       the Hitachi HD44780 LCD controller. The     *
*                       routine will configure the I/O pins of the  *
*                       microcontroller, setup the LCD for 4- or    *
*                       8-bit mode and clear the display. The user  *
*                       must provide three delay routines:          *
*                       DelayFor18TCY() provides a 18 Tcy delay     *
*                       DelayPORXLCD() provides at least 15ms delay *
*                       DelayXLCD() provides at least 5ms delay     *
********************************************************************/
void OpenXLCD(unsigned char lcdtype)
{
extern unsigned char	First_half;
        // The data bits must be either a 8-bit port or the upper or
        // lower 4-bits of a port. These pins are made into inputs
#ifdef BIT8                             // 8-bit mode, use whole port
        DATA_PORT = 0;
        DelayFor18TCY();
        TRIS_DATA_PORT = 0xff;
		Nop();
#else                                   // 4-bit mode
#ifdef UPPER                            // Upper 4-bits of the port
        DATA_PORT &= 0x0f;
		Nop();
        TRIS_DATA_PORT |= 0xf0;
		Nop();
#else                                   // Lower 4-bits of the port
        DATA_PORT &= 0xf0;
		Nop();
        TRIS_DATA_PORT |= 0x0f;
#endif
#endif
        TRIS_RW = 0;                    // All control signals made outputs
		Nop();
        DelayFor18TCY();
        TRIS_RS = 0;
		Nop();
		if	(First_half == 1)	
		{
			TRIS_E_1 = 0;
			Nop();
		}
		else
		{
			TRIS_E_2 = 0;		
			Nop();
		}
        RW_PIN = 0;                     // R/W pin made low
		Nop();
        DelayFor18TCY();
        RS_PIN = 0;                     // Register select pin made low
		Nop();
        DelayFor18TCY();
		if	(First_half == 1)	
		{
			E_PIN_1 = 0;
			Nop();
		}
		else
		{
			E_PIN_2 = 0;		
			Nop();
		}

        // Delay for 15ms to allow for LCD Power on reset
        DelayPORXLCD();
        
        // Setup interface to LCD
#ifdef BIT8                             // 8-bit mode interface
        TRIS_DATA_PORT = 0;             // Data port output
		Nop();
        DATA_PORT = 0b00110000;         // Function set cmd(8-bit interface)
		Nop();
#else                                   // 4-bit mode interface
#ifdef UPPER                            // Upper nibble interface
        TRIS_DATA_PORT &= 0x0f;
		Nop();
        DATA_PORT &= 0x0f;
		Nop();
        DATA_PORT |= 0b00100000;        // Function set cmd(4-bit interface)
		Nop();
#else                                   // Lower nibble interface
        TRIS_DATA_PORT &= 0xf0;
		Nop();
        DATA_PORT &= 0xf0;
		Nop();
        DATA_PORT |= 0b00000010;        // Function set cmd(4-bit interface)
		Nop();
#endif
#endif
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 1;
			Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
			Nop();
		}
        DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 0;
			Nop();
		}
		else
		{
			E_PIN_2 = 0;
			Nop();
		}
        // Delay for at least 4.1ms
        DelayXLCD();


        // Setup interface to LCD
#ifdef BIT8 
        DelayFor18TCY();                            // 8-bit interface
        DATA_PORT = 0b00110000;         // Function set cmd(8-bit interface)
		Nop();
#else                                   // 4-bit interface
#ifdef UPPER                            // Upper nibble interface
        DATA_PORT &= 0x0f;              // Function set cmd(4-bit interface)
		Nop();
        DATA_PORT |= 0b00100000;
		Nop();
#else                                   // Lower nibble interface
        DATA_PORT &= 0xf0;              // Function set cmd(4-bit interface)
		Nop();
        DATA_PORT |= 0b00000010;
		Nop();
#endif
#endif
        DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 1;
			Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
			Nop();
		}
        DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 0;
			Nop();
		}
		else
		{
			E_PIN_2 = 0;
			Nop();
		}

        // Delay for at least 100us
        DelayXLCD();

        // Setup interface to LCD
#ifdef BIT8  
        DelayFor18TCY();                           // 8-bit interface
        DATA_PORT = 0b00110000;         // Function set cmd(8-bit interface)
		Nop();
#else                                   // 4-bit interface
#ifdef UPPER                            // Upper nibble interface
        DATA_PORT &= 0x0f;              // Function set cmd(4-bit interface)
		Nop();
        DATA_PORT |= 0b00100000;
		Nop();
#else                                   // Lower nibble interface
        DATA_PORT &= 0xf0;              // Function set cmd(4-bit interface)
		Nop();
        DATA_PORT |= 0b00000010;
		Nop();
#endif
#endif
        DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 1;
			Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
			Nop();
		}
        DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 0;
			Nop();
		}
		else
		{
			E_PIN_2 = 0;
			Nop();
		}

#ifdef BIT8                             // 8-bit interface
        TRIS_DATA_PORT = 0xff;          // Make data port input
		Nop();
#else                                   // 4-bit interface
#ifdef UPPER                            // Upper nibble interface
        TRIS_DATA_PORT |= 0xf0;         // Make data nibble input
		Nop();
#else                                   // Lower nibble interface
        TRIS_DATA_PORT |= 0x0f;         // Make data nibble input
		Nop();
#endif
#endif

        // Set data interface width, # lines, font
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(lcdtype);          // Function set cmd

        // Turn the display on then off
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(DOFF&CURSOR_OFF&BLINK_OFF);        // Display OFF/Blink OFF
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(DON);           // Display ON/Blink ON

        // Clear display
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(0x01);             // Clear display

        // Set entry mode inc, no shift
        while(BusyXLCD());              // Wait if LCD busy
        WriteCmdXLCD(SHIFT_CUR_LEFT);   // Entry Mode

        // Set DD Ram address to 0
        while(BusyXLCD());              // Wait if LCD busy
        SetDDRamAddr(0);                // Set Display data ram address to 0

        return;
}

