/* $Id: setcgram.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include "D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

/********************************************************************
*       Function Name:  SetCGRamAddr                                *
*       Return Value:   void                                        *
*       Parameters:     CGaddr: character generator ram address     *
*       Description:    This routine sets the character generator   *
*                       address of the Hitachi HD44780 LCD          *
*                       controller. The user must check to see if   *
*                       the LCD controller is busy before calling   *
*                       this routine.                               *
********************************************************************/
void SetCGRamAddr(unsigned char CGaddr)
{
extern unsigned char First_half;
#ifdef BIT8  		                            // 8-bit interface
        TRIS_DATA_PORT = 0;                     // Make data port ouput
        DATA_PORT = CGaddr | 0b01000000;        // Write cmd and address to port
        DelayFor18TCY();
	    RW_PIN = 0;                             // Set control signals
        DelayFor18TCY();
        RS_PIN = 0;
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 1;
		else
			E_PIN_2 = 1;                     // Clock the cmd in
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 0;
		else
			E_PIN_2 = 0;
       Wait(1);
        TRIS_DATA_PORT = 0xff;                  // Make data port inputs
#else                                           // 4-bit interface
#ifdef UPPER                                    // Upper nibble interface
        TRIS_DATA_PORT &= 0x0f;                 // Make nibble input
        DATA_PORT &= 0x0f;                      // and write upper nibble
        DATA_PORT |= ((CGaddr | 0b01000000) & 0xf0);
#else                                           // Lower nibble interface
        TRIS_DATA_PORT &= 0xf0;                 // Make nibble input
        DATA_PORT &= 0xf0;                      // and write upper nibble
        DATA_PORT |= (((CGaddr |0b01000000)>>4) & 0x0f);
#endif
        RW_PIN = 0;                             // Set control signals
	Delay1TCY();
        RS_PIN = 0;
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 1;
		else
			E_PIN_2 = 1;                     // Clock the cmd in
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 0;
		else
			E_PIN_2 = 0;
#ifdef UPPER                                    // Upper nibble interface
        DATA_PORT &= 0x0f;                      // Write lower nibble
        DATA_PORT |= ((CGaddr<<4)&0xf0);
#else                                           // Lower nibble interface
        DATA_PORT &= 0xf0;                      // Write lower nibble
        DATA_PORT |= (CGaddr&0x0f);
#endif
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 1;
		else
			E_PIN_2 = 1;                     // Clock the cmd in
        DelayFor18TCY();
       	if	(First_half == 1)	
			E_PIN_1 = 0;
		else
			E_PIN_2 = 0;
#ifdef UPPER                                    // Upper nibble interface
        TRIS_DATA_PORT |= 0xf0;                 // Make inputs
#else                                           // Lower nibble interface
        TRIS_DATA_PORT |= 0x0f;                 // Make inputs
#endif
#endif
        return;
}

