#ifndef __USART_H
#define __USART_H


/* USART Config Bit Defines */
#define USART_TX_INT_ON   0b11111111  // Transmit interrupt on
#define USART_TX_INT_OFF  0b01111111  // Transmit interrupt off
#define USART_RX_INT_ON   0b11111111  // Receive interrupt on
#define USART_RX_INT_OFF  0b10111111  // Receive interrupt off
#define USART_ASYNCH_MODE 0b11111110  // Asynchronous mode
#define USART_SYNCH_MODE  0b11111111  // Synchronous mode
#define USART_EIGHT_BIT   0b11111101  // 8-bit data
#define USART_NINE_BIT    0b11111111  // 9-bit data
#define USART_SYNC_SLAVE  0b11111011  // Synchrounous slave mode
#define USART_SYNC_MASTER 0b11111111  // Synchrounous master mode
#define USART_SINGLE_RX   0b11110111  // Single reception
#define USART_CONT_RX     0b11111111  // Continuous reception
#define USART_BRGH_HIGH   0b11111111  // High baud rate
#define USART_BRGH_LOW    0b11101111  // Low baud rate


#if defined(__18F6620) || defined(__18F6720) || defined(__18F8620) || defined(__18F8720)
/* USART Status Structure */
union USART1
{
  unsigned char val;
  struct
  {
    unsigned RX_NINE:1;         // Receive Bit 8 if 9-bit mode is enabled
    unsigned TX_NINE:1;         // Transmit Bit 8 if 9-bit mode is enabled
    unsigned FRAME_ERROR:1;     // Framing Error for USART
    unsigned OVERRUN_ERROR:1;   // Overrun Error for USART
    unsigned fill:4;
  };
};

union USART2
{
  unsigned char val;
  struct
  {
    unsigned RX_NINE:1;         // Receive Bit 8 if 9-bit mode is enabled
    unsigned TX_NINE:1;         // Transmit Bit 8 if 9-bit mode is enabled
    unsigned FRAME_ERROR:1;     // Framing Error for USART
    unsigned OVERRUN_ERROR:1;   // Overrun Error for USART
    unsigned fill:4;
  };
};

/* 18Cxx20 USART1 Function Prototypes */
/* Change this to near (or omit altogether) if building small memory model
 * versions of the libraries
 */
#define MEM_MODEL far

/* Open1USART
 * Configures the USART
 */
void Open1USART( auto unsigned char, auto char);

/* DataRdy1USART
 * Is data ready to be read from USART1?
 */
#define DataRdy1USART() (PIR1bits.RCIF)

/* Read1USART
 * Read a byte from the USART1
 */
char Read1USART(void);

/* Write1USART
 * Write a byte to the USART1
 */
void Write1USART(auto char);

/* gets1USART
 * Get a string of characters from USART1
 */

void gets1USART(auto char *, auto unsigned char);

/* puts1USART
 * Send a string of characters to the USART1
 */
void puts1USART(auto char *);

/* putrs1USART
 * Send a string of characters in ROM to the USART1
 */
void putrs1USART(auto const MEM_MODEL rom char *);

/* getc1USART
 * Read a byte from the USART1
 */
#define getc1USART Read1USART

/* putc1USART
 * Write a byte to the USART1
 */
#define putc1USART Write1USART

/* Close1USART
 * Disable the USART1 and interrupts
 */
#define Close1USART()   RCSTA1&=0b01001111,TXSTA1bits.TXEN=0,PIE1&=0b11001111

/* Busy1USART
 */
#define Busy1USART()    (!TXSTA1bits.TRMT)


/* 18Cxx20 USART2 Function Prototypes */

/* Change this to near (or omit altogether) if building small memory model
 * versions of the libraries
 */
#define MEM_MODEL far

/* Open2USART
 * Configures the USART
 */
void Open2USART( auto unsigned char, auto char);

/* DataRdy2USART
 * Is data ready to be read from USART2?
 */
#define DataRdy2USART() (PIR3bits.RC2IF)

/* Read2USART
 * Read a byte from the USART2
 */
char Read2USART(void);

/* Write2USART
 * Write a byte to the USART2
 */
void Write2USART(auto char);

/* gets2USART
 * Get a string of characters from USART2
 */

void gets2USART(auto char *, auto unsigned char);

/* puts2USART
 * Send a string of characters to the USART2
 */
void puts2USART(auto char *);

/* putrs1USART2
 * Send a string of characters in ROM to the USART2
 */
void putrs2USART(auto const MEM_MODEL rom char *);

/* getc2USART
 * Read a byte from the USART2
 */
#define getc2USART Read2USART

/* putc2USART
 * Write a byte to the USART2
 */
#define putc2USART Write2USART

/* Close2USART
 * Disable the USART2 and interrupts
 */
#define Close2USART()   RCSTA2&=0b01001111,TXSTA2bits.TXEN=0,PIE3&=0b11001111

/* Busy3USART
 */
#define Busy2USART()    (!TXSTA2bits.TRMT)


#else

/* USART Status Structure */
union USART
{
  unsigned char val;
  struct
  {
#if    __18CXX
    unsigned RX_NINE:1;         // Receive Bit 8 if 9-bit mode is enabled
    unsigned TX_NINE:1;         // Transmit Bit 8 if 9-bit mode is enabled
    unsigned FRAME_ERROR:1;     // Framing Error for USART
    unsigned OVERRUN_ERROR:1;   // Overrun Error for USART
    unsigned fill:4;
#else /* 17CXX */
    unsigned RX1_NINE:1;        // Receive Bit 8 if 9-bit mode is enabled
    unsigned TX1_NINE:1;        // Transmit Bit 8 if 9-bit mode is enabled
    unsigned FRAME_ERROR1:1;    // Framing Error for USART1
    unsigned OVERRUN_ERROR1:1;  // Overrun Error for USART1
    unsigned RX2_NINE:1;        // Receive Bit 8 if 9-bit mode is enabled
    unsigned TX2_NINE:1;        // Transmit Bit 8 if 9-bit mode is enabled
    unsigned FRAME_ERROR2:1;    // Framing Error for USART2
    unsigned OVERRUN_ERROR2:1;  // Overrun Error for USART2
#endif
  };
};


/* Configuration bits for the BAUDCTL register.
 * Pass these to 'baudUSART'.
 */
#if defined(__18F1220) || defined(_18F1320)
#define BAUD_IDLE_CLK_HIGH  0b11111111  // idle state for clock is a low level
#define BAUD_IDLE_CLK_LOW   0b11101111  // idle state for clock is a high level
#define BAUD_16_BIT_RATE    0b11111111  // 16-bit baud generation rate
#define BAUD_8_BIT_RATE     0b11110111  // 8-bit baud generation rate
#define BAUD_WAKEUP_ON      0b11111111  // RX pin monitored
#define BAUD_WAKEUP_OFF     0b11111101  // RX pin not monitored
#define BAUD_AUTO_ON        0b11111111  // auto baud rate measurement enabled
#define BAUD_AUTO_OFF       0b11111110  // auto baud rate measurement disabled
#endif

/* 18Cxxx USART Function Prototypes */

#ifdef  __18CXX

/* Change this to near (or omit altogether) if building small memory model
 * versions of the libraries
 */
#define MEM_MODEL far

/* OpenUSART
 * Configures the USART
 */
void OpenUSART( auto unsigned char, auto unsigned);

/* DataRdyUSART
 * Is data ready to be read from USART?
 */
#define DataRdyUSART() (PIR1bits.RCIF)

/* ReadUSART
 * Read a byte from the USART
 */
char ReadUSART(void);

/* WriteUSART
 * Write a byte to the USART
 */
void WriteUSART(auto char);

/* getsUSART
 * Get a string of characters from USART
 */
void getsUSART(auto char *, auto unsigned char);

/* putsUSART
 * Send a string of characters to the USART
 */
void putsUSART(auto char *);

/* putrsUSART
 * Send a string of characters in ROM to the USART
 */
void putrsUSART(auto const MEM_MODEL rom char *);

/* getcUSART
 * Read a byte from the USART
 */
#define getcUSART ReadUSART

/* putcUSART
 * Write a byte to the USART
 */
#define putcUSART WriteUSART

/* CloseUSART
 * Disable the USART and interrupts
 */
#if defined(__18CXX) || defined(__18C242) || defined(__18C252) || defined(__18C442) || defined(__18C452) || defined(__18C658) || defined(__18C858) || defined(__18C601) || defined(__18C801) || defined(__18F242) || defined(__18F252) || defined(__18F442) || defined(__18F452) || defined(__18F010) || defined(__18F020) || defined(__18F248) || defined(__18F258) || defined(__18CF448)|| defined(__18F458)
#define CloseUSART()   RCSTA&=0b01001111,TXSTAbits.TXEN=0,PIE1&=0b11001111
#endif

/* BusyUSART
 * USART busy?0b01001111

0b01001111
 */
#define BusyUSART()    (!TXSTAbits.TRMT)

#if defined(__18F1220) || defined(__18F1320)
/* baudUSART
 * sets the configuration for BAUDCTL register
 */
void baudUSART(auto unsigned char baudconfig);
#endif

/* 17Cxxx USART1 Function Prototypes */
#else /* 17Cxxx */

/* OpenUSART1
 * Configures the USART
 */
void OpenUSART1(static unsigned char,static char);

/* DataRdyUSART1
 * Is data ready to be read from USART?
 */
#if defined(__17C752)||defined(__17C756)||defined(__17C756A)||defined(__17C766)||defined(__17C762)
#define DataRdyUSART1() (PIR1bits.RC1IF)
#else
#define DataRdyUSART1() (PIRbits.RCIF)
#endif

/* ReadUSART1
 * Read a byte from the USART
 */
char ReadUSART1(void);

/* WriteUSART1
 * Write a byte to the USART
 */
void WriteUSART1(static char);

/* getsUSART1
 * Get a string of characters from USART
 */
void getsUSART1(static char *,static unsigned char);

/* putsUSART1
 * Send a string of characters to USART
 */
void putsUSART1(static char *);

/* putrsUSART1
 * Send a string of characters in ROM to USART
 */
void putrsUSART1(static const MEM_MODEL rom char *);

/* getcUSART1
 * Read a byte from the USART
 */
#define getcUSART1 ReadUSART1

/* putcUSART1
 * Write a byte to the USART
 */
#define putcUSART1 WriteUSART1

/* CloseUSART1
 * Disable the USART and interrupts
 */
#if defined(__17C752)||defined(__17C756)||defined(__17C756A)||defined(__17C766)||defined(__17C762)
#define CloseUSART1()  RCSTA1&=0b01001111,TXSTA1bits.TXEN=0,PIE1&=0b11111100
#else
#define CloseUSART1()  RCSTA&=0b01001111,TXSTAbits.TXEN=0,PIE&=0b11111100
#endif

/* BusyUSART1
 * USART busy?
 */
#if defined(__17C752)||defined(__17C756)||defined(__17C756A)||defined(__17C766)||defined(__17C762)
#define BusyUSART1()  (!TXSTA1bits.TRMT)
#else
#define BusyUSART1()  (!TXSTAbits.TRMT)
#endif

#endif /* 17CXXX */

/* 17C7xx USART2 Function Prototypes */
#if defined(__17C752)||defined(__17C756)||defined(__17C756A)||defined(__17C766)||defined(__17C762)

/* OpenUSART2
 * Configures the USART
 */
void OpenUSART2(static unsigned char,static char);

/* DataRdyUSART2
 * Is data ready to be read from USART?
 */
#define DataRdyUSART2()  (PIR2bits.RC2IF)

/* ReadUSART2
 * Read a byte from the USART
 */
char ReadUSART2(void);

/* WriteUSART2
 * Write a byte to the USART
 */
void WriteUSART2(static char);

/* getcUSART2
 * Read a byte from the USART
 */
#define getcUSART2 ReadUSART2

/* putcUSART2
 * Write a byte to the USART
 */
#define putcUSART2 WriteUSART2

/* getsUSART2
 * Get a string of characters from USART
 */
void getsUSART2(static char *,static unsigned char);

/* putsUSART2
 * Send a string of characters to the USART
 */
void putsUSART2(static char *);

/* putrsUSART2
 * Send a string of characters in ROM to USART
 */
void putrsUSART2(static const MEM_MODEL rom char *);

/* CloseUSART2
 * Disable the USART and interrupts
 */
#define CloseUSART2()  RCSTA2&=0b01001111,TXSTA2bits.TXEN=0,PIE2&=0b11111100

/* BusyUSART2
 * USART busy?
 */
#define BusyUSART2()  (!TXSTA2bits.TRMT)

#endif /* 17C7xx */

#endif /* 18Fxx20 */

#endif
