/* $Id: writdata.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

/********************************************************************
*       Function Name:  WriteDataXLCD                               *
*       Return Value:   void                                        *
*       Parameters:     data: data byte to be written to LCD        *
*       Description:    This routine writes a data byte to the      *
*                       Hitachi HD44780 LCD controller. The user    *
*                       must check to see if the LCD controller is  *
*                       busy before calling this routine. The data  *
*                       is written to the character generator RAM or*
*                       the display data RAM depending on what the  *
*                       previous SetxxRamAddr routine was called.   *
********************************************************************/
void WriteDataXLCD(char data)
{
	extern unsigned char	First_half;

#ifdef BIT8                             // 8-bit interface
        TRIS_DATA_PORT = 0;             // Make port output
        Nop();
        DelayFor18TCY();
        DATA_PORT = data;               // Write data to port
        RS_PIN = 1;                     // Set control bits
	    Nop();							//Ez amit betettem!!!!!!!!!!!!!!!!
        DelayFor18TCY();
        RW_PIN = 0;
        Nop();
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 1;
        	Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
       		Nop();
		}
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 0;
			Nop();
		}
		else
		{
			E_PIN_2 = 0;
        	Nop();
		}
        DelayFor18TCY();

        RS_PIN = 0;                     // Reset control bits
		Nop();
        TRIS_DATA_PORT = 0xff;          // Make port input
        Nop();
#else                                   // 4-bit interface
#ifdef UPPER                            // Upper nibble interface
        TRIS_DATA_PORT &= 0x0f;
        DATA_PORT &= 0x0f;
        DATA_PORT |= data&0xf0;
#else                                   // Lower nibble interface
        TRIS_DATA_PORT &= 0xf0;
        DATA_PORT &= 0xf0;
        DATA_PORT |= ((data>>4)&0x0f);
#endif
        RS_PIN = 1;                     // Set control bits
        Nop();
        RW_PIN = 0;
        Nop();
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 1;
        	Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
        	Nop();
		}
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 0;
        	Nop();
		}
		else
		{
			E_PIN_2 = 0;
        	Nop();
		}
        DelayFor18TCY();

#ifdef UPPER                            // Upper nibble interface
        DATA_PORT &= 0x0f;
        DATA_PORT |= ((data<<4)&0xf0);
#else                                   // Lower nibble interface
        DATA_PORT &= 0xf0;
        DATA_PORT |= (data&0x0f);
#endif
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 1;
        	Nop();
		}
		else
		{
			E_PIN_2 = 1;                     // Clock the cmd in
        	Nop();
		}
       	DelayFor18TCY();
       	if	(First_half == 1)	
		{
			E_PIN_1 = 0;
        	Nop();
		}
		else
		{	
			E_PIN_2 = 0;
        	Nop();
		}
       	DelayFor18TCY();

#ifdef UPPER                            // Upper nibble interface
        TRIS_DATA_PORT |= 0xf0;
#else                                   // Lower nibble interface
        TRIS_DATA_PORT |= 0x0f;
#endif
#endif
        return;
}

