/************************************************************/ 
//********Display analog values of Tx power and Smeter********
/************************************************************/ 

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

void Get_analog_Tx_power(void)
{
	extern	unsigned char 	LCD_line [40];
	extern	float	 		Tx_power;
	unsigned int 			result = 0;
	
	SetChanADC (ADC_CH0);
	Delay10TCYx (15); 					// Delay for 150TCY
	ConvertADC (); 						// Start conversion
	while( BusyADC() ); 				// Wait for completion
	result = ReadADC(); 				// Read result for Tx power
	
	Tx_power = Tx_power * 40.1;	//Convert to Watts
}
/************************************************************/ 
void Get_analog_S_meter(void)
{
	extern	float	 		S_meter;
	unsigned int 			result = 0;
	
	SetChanADC (ADC_CH0);
	ConvertADC (); 						// Start conversion
	while( BusyADC() ); 				// Wait for completion
	result = ReadADC(); 				// Read result for s meter
	
//	Vagc=result*2.5/1024 
//	By meas Vagc at -73dBm input gives 1.812V!!! use this value for calibration
//	result= 1.812*1024/2.498
//	Converting to (mini)Spoint-> @S9=1000 so 
	S_meter = (result-200) * 1.8432;			//Convert to S points 1000 sminipoints= -73dBm=1.812mV=S9
}
/************************************************************/ 
/************************************************************/ 
void Display_TxP (void)
{
	extern	unsigned char 	LCD_line [40];
	extern	float	 		Tx_power;
	extern	unsigned char	Tx_string[9];
			unsigned long 	i = 0;
			unsigned char 	j, k, l = 0;
	
	RAM_erase(LCD_line,20);
	i =	Tx_power * 10 ; 
	ultoa (i, LCD_line); 				//Convert to string...
	j = strlen (LCD_line);				//Determine the lenght of the string

	if (j > 1)
	{ 
		for (k = 0; k <= 1; k++)
		{
			LCD_line[j]=LCD_line[j-1];
			j--; 
		}
		LCD_line[j+1] = ',';
		LCD_line[j+3] = ' ';			//Append " " to the end of the string
		LCD_line[j+4] = 'W';			//Append W to the end of the string
	}
	else 
	{
		LCD_line[j+1] = LCD_line[j-1];	
		LCD_line[j-1] = '0';
		LCD_line[j] = ',';		
		LCD_line[j+2] = ' ';			//Append " " to the end of the string
		LCD_line[j+3] = 'W';			//Append W to the end of the string
	}

	j = strlen (LCD_line);
	l = j-1;
	for (k = 0; k <= j-1 ; k++)
	{
		LCD_line[l+8]=LCD_line[l];
		l--;
	}

	strncpy (LCD_line, Tx_string, 8);	//copy Tx string to the begining of the string

	while (BusyXLCD());
	SetDDRamAddr (0x40);				//Second line
	while (BusyXLCD());
	putsXLCD (LCD_line);
}
/************************************************************/ 
