
//*********************************************************************
#include <p18f8520.h>
#include <adc.h>
#include <STDIO.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include <usart.h>
#include <i2c.h>
#include <portb.h>
#include "D:\Work_MPlab\CDG2000_YO6OGJ\LCD_routines\xlcd.h"
#include "D:\Work_MPlab\CDG2000_YO6OGJ\Delay_routines\delaysmy.h"

#define FALSE 0
#define TRUE 1

#define AGC_in			AN0
#define FWD_pwr			AN1
#define REV_pwr			AN2
#define U_I_load		AN4
#define Switch_U_load 	PORTAbits.RA6
#define Switch_I_load 	PORTAbits.RA4


#define PTT 			PORTBbits.RB0
#define Opto_1A			PORTBbits.RB1
#define Opto_2A			PORTBbits.RB2
#define Opto_PB			PORTBbits.RB3
#define Opto_1B			PORTBbits.RB4
#define Opto_2B			PORTBbits.RB5

#define CTS_RS232		PORTCbits.RC0
#define RTS_RS232		PORTCbits.RC1
#define SCL 			PORTCbits.RC3
#define SDA 			PORTCbits.RC4
#define TxD_RS232 		PORTCbits.RC6
#define RxD_RS232 		PORTCbits.RC7

#define DDS_clk			PORTEbits.RE0
#define DDS_data		PORTEbits.RE1
#define DDS_enable_LO	PORTEbits.RE2
#define DDS_enable_BFO	PORTEbits.RE3
#define Key_0			PORTEbits.RE4
#define Key_1			PORTEbits.RE7

#define BL_1			PORTFbits.RF0
#define BL_2			PORTFbits.RF1
#define CW_switch		PORTFbits.RF2
#define SSB_switch		PORTFbits.RF3
#define Tx_switch		PORTFbits.RF4
#define Rx_switch		PORTFbits.RF5


/*************************Function prototypes***************************/
void HIGH_INT_HANDLE(void);
void Setup_MCU (void);
void Update_DDS_1 (void);
void Update_BFO (void);
void Band_select (void);
void Band_erase (void);
void Update_Front_End (void);
void Update_Filter_SWR (void);
void Update_LCD (void);
void Update_LCD_first_line (void);
void Update_LCD_second_line (void);
void Update_LCD_third_line (void);
void Update_LCD_fourth_line (void);
void RAM_erase (char *str, char length);
void Get_analog_Tx_power (void);
void Get_analog_S_meter (void);
void Display_TxP (void);
void Display_Sm (void);
void Del_STEP_flags (void);
void Del_ENC2_flags (void);
void Del_Att_flags (void);
void Key_scan_1 (void);
void Key_scan_2 (void);
void Place_bargraph (unsigned char DD_address, unsigned char procent);
void Wait(unsigned int msec);
void Update_ENC2_functions(void);
void Write_AD9835 (unsigned int data);

/**********************************************************************/
