
// ********************* Matrix keys scan function ***********************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

void Key_scan_2 (void)
{
	unsigned char 	j, k, l, q, Cleanup = 0;
	unsigned long	i = 0;
	char 	*m, *n ;

	extern	float			Rig_freq;
	extern unsigned	char	Matrix_string [11];
	extern unsigned	char	MUTE;
	extern 	unsigned char 	vol_value_proc;	//volume holding register

	extern struct{
			unsigned	Volume : 1;			//Flag for volume
			unsigned	IF_gain : 1;		//If_gain
			unsigned	IF_hang : 1;		//Flag for if hanging
			unsigned	IF_switch: 1;		//Flag for if switch
			unsigned	VOX_gain : 1;		//Flag for VOX gain
			unsigned	VOX_anti : 1;		//Flag for anti VOX
			unsigned	VOX_delay : 1;		//Flag for VOX delay
			unsigned	VOX_On_Off : 1;		//Flag for VOX on or off
			unsigned	Mic_gain : 1;		//Flag for mike gain
			unsigned	Compressor : 1;		//Compressor
			unsigned	RF_pwr : 1;			//Flag for rf power
			} ENC2; 
	
	extern	struct {								
	    	unsigned  	Freq_change:1;		//Flags for state save
	    	unsigned  	Key1_change:1;		//Flags for state save
	    	unsigned  	Key2_change:1;		//Flags for state save
			unsigned	Freq_by_kbd:1;		//Flags for state save
	    	unsigned  	ENC2_change:1;		//Flags for state save
			unsigned	LCD_update_req:1;	//System flags
			} Sys_FLAGS ;

	PORTJbits.RJ4 = 0;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ5 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ6 = 1;						//Switch to L first row and read
	Delay1TCY();
	if (PORTJbits.RJ7 == 0)	
	{
		q = '#';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ7 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ3 == 0)	
	{
		q = '9';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ3 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ2 == 0)	
	{
		q = '6';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ2 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ1 == 0)	
	{
		q = '3';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ1 == 0);			//Wait untill the button is released
	}


	PORTJbits.RJ4 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ5 = 0;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ6 = 1;						//Switch to L first row and read
	Delay1TCY();
	if (PORTJbits.RJ7 == 0)	
	{
		q = '0';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ7 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ3 == 0)	
	{
		q = '8';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ3 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ2 == 0)	
	{
		q = '5';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ2 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ1 == 0)	
	{
		q = '2';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ1 == 0);			//Wait untill the button is released
	}

	PORTJbits.RJ4 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ5 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ6 = 0;						//Switch to L first row and read
	Delay1TCY();
	if (PORTJbits.RJ7 == 0)	
	{
		q = '.';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ7 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ3 == 0)	
	{
		q = '7';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ3 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ2 == 0)	
	{
		q = '4';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ2 == 0);			//Wait untill the button is released
	}
	if (PORTJbits.RJ1 == 0)	
	{
		q = '1';
		Sys_FLAGS.Key2_change = 1;
		while (PORTJbits.RJ1 == 0);			//Wait untill the button is released
	}


	PORTJbits.RJ4 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ5 = 1;						//Switch to L first row and read
	Delay1TCY();
	PORTJbits.RJ6 = 1;						//Switch to L first row and read
	Delay1TCY();

	if (PORTJbits.RJ0 == 0)	
	{
		while (PORTJbits.RJ0 == 0);			//Wait untill the button is released
		if (MUTE == 0)
		{
			MUTE = 1;						//Store this state
			ENC2.Volume = 1;
			Del_ENC2_flags();
			ENC2.Volume = 1;
			Sys_FLAGS.ENC2_change = 1;
			Sys_FLAGS.LCD_update_req = TRUE;
		}
		else
		{
			MUTE = 0;						//Store this state
			ENC2.Volume = 1;
			Del_ENC2_flags();
			ENC2.Volume = 1;
			Sys_FLAGS.ENC2_change = 1;
			Sys_FLAGS.LCD_update_req = TRUE;
		}
	}

	if (Sys_FLAGS.Key2_change == 1) 
	{
		l = strlen (Matrix_string);
	
		if (l < 10)
		{	
			Matrix_string[l] = q;					//Add last char!
			m = strrchr (Matrix_string, '.');		//Locate the '.' in the string
			n = &Matrix_string[l];

			if (m != 0)
			{
				k = n - m;
				if ((k>6) & (Matrix_string[l] != '#'))						//Check if more than 6 chars after the dot
					Cleanup = 1;
			}

			if ((Matrix_string[l] == '#')& (l > 2))	//Enter received
			{
				Matrix_string[l] = 0x00;
				if (k < 6)							//Complete with zeros
				{
					n = &Matrix_string[0];
					k = (m - n) + 6;

					for (j = l; j <= k; j++)		//Delete the dot sign and copy one position back
					{
						Matrix_string[j] =  '0';
					}
				}

				l = strlen (Matrix_string);
				n = &Matrix_string[0];
				k = m - n;

				for (j = k; j <= l-1; j++)			//Delete the dot sign and copy one position back
				{
					Matrix_string[j] =  Matrix_string[j+1];
				}
				Matrix_string[l-1] = 0x00;
			
				l = strlen (Matrix_string);
				for (j = 0; j <= l-1; j++)			//Transform to number
				{
					q =  Matrix_string[j] - 48;
					i = (i * 10) + q;
				}
		
				if		(((i >= 1800000) & (i <= 2000000)) |
						((i >= 3500000) & (i <= 3850000)) |
						((i >= 7000000) & (i <= 7200000)) |
						((i >= 1010000) & (i <= 10200000)) |
						((i >= 1400000) & (i <= 14400000)) |
						((i >= 18068000) & (i <= 18168000)) |
						((i >= 21000000) & (i <= 21450000)) |
						((i >= 24800000) & (i <= 25000000)) |
						((i >= 28000000) & (i <= 30000000)))
				{
					Rig_freq = i;
					Sys_FLAGS.Freq_by_kbd = 1;	//Signal freq change occured by keyboard entering
					RAM_erase(Matrix_string,11);
				}
				else
					Cleanup = 1;
			}
		}
		else	
			Cleanup = 1;
		Sys_FLAGS.Key2_change = 0;
	}

	if (Cleanup == 1)
	{
		i = 0;
		Sys_FLAGS.Freq_by_kbd = 0;	//Signal freq change not occured by keyboard entering
		RAM_erase(Matrix_string,11);
		Cleanup = 0;
	}
}
// **********************************************************************
