/* $Id: busyxlcd.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

/********************************************************************
*       Function Name:  BusyXLCD                                    *
*       Return Value:   char: busy status of LCD controller         *
*       Parameters:     void                                        *
*       Description:    This routine reads the busy status of the   *
*                       Hitachi HD44780 LCD controller.             *
********************************************************************/
unsigned char BusyXLCD(void)
{
	extern unsigned char First_half;

        TRIS_DATA_PORT = 0xff;          // Make data port inputs
        RW_PIN = 1;                     // Set the control bits for read
        DelayFor18TCY();

        RS_PIN = 0;
        DelayFor18TCY();

         if	(First_half == 1)			// Clock the cmd in
		{
			E_PIN_1 = 1;
        	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 1;
        	DelayFor18TCY();
		}

        if(DATA_PORT & 0x80)            // Read bit 7 (busy bit)
        {                               // If high
	         if	(First_half == 1)		// Clock the cmd in
			{
				E_PIN_1 = 0;
	        	DelayFor18TCY();
			}
			else
			{
				E_PIN_2 = 0;
	        	DelayFor18TCY();
			}

			RW_PIN = 0;            		// Reset control line
      		DelayFor18TCY();

            return 1;               	// Return TRUE
        }
        else                            // Bit 7 low
        {
	         if	(First_half == 1)		// Clock the cmd in
			{
				E_PIN_1 = 0;
	        	DelayFor18TCY();
			}
			else
			{
				E_PIN_2 = 0;
	        	DelayFor18TCY();
			}

			RW_PIN = 0;            		// Reset control line
      		DelayFor18TCY();

            return 0;               	// Return FALSA
        }
}

