/* $Id: wcmdxlcd.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include "D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

/********************************************************************
*       Function Name:  WriteCmdXLCD                                *
*       Return Value:   void                                        *
*       Parameters:     cmd: command to send to LCD                 *
*       Description:    This routine writes a command to the Hitachi*
*                       HD44780 LCD controller. The user must check *
*                       to see if the LCD controller is busy before *
*                       calling this routine.                       *
********************************************************************/
void WriteCmdXLCD(unsigned char cmd)
{
	extern unsigned char	First_half;
        TRIS_DATA_PORT = 0;             // Data port output
        DATA_PORT = cmd;                // Write command to data port
     	DelayFor18TCY();

        RW_PIN = 0;                     // Set the control signals
     	DelayFor18TCY();

        RS_PIN = 0;                     // for sending a command
     	DelayFor18TCY();

       	if	(First_half == 1)			// Clock the cmd in
		{
			E_PIN_1 = 1;
        	DelayFor18TCY();
			E_PIN_1 = 0;
        	DelayFor18TCY();
		}
		else
		{
			E_PIN_2 = 1;
        	DelayFor18TCY();
			E_PIN_2 = 0;
        	DelayFor18TCY();
		}

        TRIS_DATA_PORT = 0xff;          // Data port input

        return;
}

