//************Setup file for the PIC18F8520 MCU ******************** 

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

void Setup_MCU (void)	
{
	extern	struct	{
		unsigned	Att_0dB:1; 			//Pass throught
		unsigned	Att_6dB:1;			//Att position at 6dB
		unsigned	Att_12dB:1;			//Att position at 12dB
		unsigned	Att_18dB:1;			//Att position at 18dB
		} ATT;

	// Port A
    ADCON1 	= 0b00011010;			    //Vref at AN3, AN0, AN1, AN2, AN3, AN4 as analog  
   	PORTA 	= 0x00;	
    LATA	= 0x00;				        //Clear PORT A data latch
    TRISA 	= 0xAF;		             	//RA4 and RA6 inputs rest is out
			             
	// Port B
    INTCON2bits.RBPU = 1;	       		//Turn on the Port B pullups
    PORTB 	= 0x00;				        //Clear PORT B latch
    LATB 	= 0x00;				        //Clear PORT B data latch
    TRISB 	= 0b11111111;			    //Set all bits as input

	// Port C
    PORTC 	= 0x00;                     //Clear PORT C latch
    LATC 	= 0x00;				        //Clear PORT C data latch    
    TRISC 	= 0b10011010; 				//USART IO def's and I2C  

	// Port D
    PORTD 	= 0x00;                     //Clear PORT D latch
    LATD 	= 0x00;				        //Clear PORT D data latch    
    TRISD 	= 0x00; 					//LCD data output bits  

	// Port E
    PORTE 	= 0x00;                     //Clear PORT E latch
    LATE 	= 0x00;				        //Clear PORT E data latch    
    TRISE 	= 0x80; 					//DDS1 and DDS2 data output bits  

	CVRCON 	= 0x00;						//
	CMCON	= 0x07;						//Comparator module off
    ADCON1 	= 0b00011010;			    //Vref at AN3, AN0, AN1, AN2, AN3, AN4 as analog
	// Port F
    PORTF 	= 0x00;                     //Clear PORT F latch
    LATF 	= 0x00;				        //Clear PORT F data latch    
    TRISF 	= 0x00; 					//Power swiching output bits 

	// Port G
    PORTG 	= 0x00;                     //Clear PORT G latch
    LATG 	= 0x00;				        //Clear PORT G data latch    
    TRISG 	= 0x00; 					//LCD command output bits     

	// Port H
    PORTH 	= 0x00;                     //Clear PORT H latch
    LATH 	= 0x00;				        //Clear PORT H data latch    
    TRISH 	= 0xFF; 					//Key_switch_1 input bits  

	// Port J
    PORTJ 	= 0x00;                     //Clear PORT J latch
    LATJ	= 0x00;				        //Clear PORT J data latch    
    TRISJ 	= 0x8F; 					//Key_switch_2 OUTx3 and INx5  bits

	DDS_enable_LO = 1;
	Nop();
	DDS_enable_BFO = 1;
	Nop();
	DDS_clk	= 0;
	Nop();
	DDS_data	= 0;
	Nop();

	INTCON2bits.RBPU = 0;
	INTCONbits.GIE = 1;

	OpenRB0INT( PORTB_CHANGE_INT_ON & FALLING_EDGE_INT & PORTB_PULLUPS_OFF);	//PTT
	OpenRB1INT( PORTB_CHANGE_INT_ON & RISING_EDGE_INT & PORTB_PULLUPS_OFF);		//Opto1 channel A
	OpenRB2INT( PORTB_CHANGE_INT_ON & RISING_EDGE_INT & PORTB_PULLUPS_OFF);		//Opto2 channel A

/*
 	Open1USART	(	USART_ASYNCH_MODE & 
					USART_EIGHT_BIT & 
					USART_TX_INT_OFF & 
					USART_RX_INT_ON & 
					USART_CONT_RX & 
					USART_BRGH_HIGH, 103); 	//Setup USART 1 for 19200 baud communication @ 32MHz!
*/

	OpenADC		( 	ADC_FOSC_64 & 
					ADC_RIGHT_JUST & 
					ADC_5ANA, ADC_CH0 & 
					ADC_INT_OFF & 
					ADC_VREFPLUS_EXT & 
					ADC_VREFMINUS_VSS);		//Open ADC ch

	OpenTimer0	( 	TIMER_INT_ON &
					T0_16BIT &
					T0_SOURCE_INT &
					T0_PS_1_64);			//Setup timer 0
	
	SSPBUF = 0;
    OpenI2C(MASTER, SLEW_OFF);				//Open I2C interface  
	SSPADD = 0x64; 							//Choose 0d100 for 100KHz SCL bus speed @40MHz
	PSPCONbits.PSPMODE = 0;					//


	Write_AD9835 (0xF800);					//Reset and clear

	Write_AD9835 (0x3000);					//Write freq. register0
	Write_AD9835 (0x2100);					//Write freq. register0
	Write_AD9835 (0x3200);					//Write freq. register0
	Write_AD9835 (0x2348);					//Write freq. register0 9MHz
	Write_AD9835 (0x3400);					//Write freq. register1
	Write_AD9835 (0x2500);					//Write freq. register1
	Write_AD9835 (0x3600);					//Write freq. register1
	Write_AD9835 (0x2748);					//Write freq. register1 9MHz

	Write_AD9835 (0x1800);					//Write phase. register0 0deg.
	Write_AD9835 (0x0900);					//Write phase. register0
	Write_AD9835 (0x1A00);					//Write phase. register1
	Write_AD9835 (0x0B00);					//Write phase. register1
	Write_AD9835 (0x1C00);					//Write phase. register2
	Write_AD9835 (0x0D00);					//Write phase. register2
	Write_AD9835 (0x1E00);					//Write phase. register3
	Write_AD9835 (0x0F00);					//Write phase. register3
	
	Write_AD9835 (0x8000);					//Setup IC with Selsource=0 and sync=0	
	Write_AD9835 (0xC000);					//Clear reset!

}
//************************end of setup**********************************
