
// ********************* Update BFO DDS function ***********************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

void Update_BFO (void)
{	
	extern unsigned int		Freq_reg1, Freq_reg2, Freq_reg3, Freq_reg4;
	extern unsigned long	long_BFO_freq;
	extern float			float_BFO_freq;

	unsigned char	q;

	extern struct{
			unsigned	Volume : 1;			//Flag for volume
			unsigned	IF_gain : 1;		//If_gain
			unsigned	IF_hang : 1;		//Flag for if hanging
			unsigned	IF_switch: 1;		//Flag for if switch
			unsigned	VOX_gain : 1;		//Flag for VOX gain
			unsigned	VOX_anti : 1;		//Flag for anti VOX
			unsigned	VOX_delay : 1;		//Flag for VOX delay
			unsigned	VOX_On_Off : 1;		//Flag for VOX on or off
			unsigned	Mic_gain : 1;		//Flag for mike gain
			unsigned	Compressor : 1;		//Compressor
			unsigned	RF_pwr : 1;			//Flag for rf power
			} ENC2; 

	extern	struct {								
	    	unsigned  	PB_flag:1;			//Flags for state save
	    	unsigned	Channel_A_H:1;		//Encoder channel a Latch
	    	unsigned	Warn_flag:1;		//Warning light flag
			unsigned 	PTT_flag:1;			//Flag for signaling if ptt pushed
			unsigned	USB_mode:1;			//Flag for signaling if USB mode
			unsigned	LSB_mode:1;			//Flag for signaling if LSB mode
			unsigned	CW_mode:1;			//Flag for signaling if CW mode
			unsigned	Dial :1;			//Flag for signaling if CW mode
			} FLAGS ;

	if (FLAGS.USB_mode == 1)
		//float_BFO_freq = 9001100;
		long_BFO_freq = 1208107191;

	if (FLAGS.LSB_mode == 1)
		//float_BFO_freq = 8998900;
		long_BFO_freq = 1207811912;

	if (FLAGS.CW_mode == 1)
		//float_BFO_freq = 9000500;
		long_BFO_freq = 1208026660;


	//float_BFO_freq = (float_BFO_freq * 134.217728);	// = ( (2^32)) / 32MHz ****
	//long_BFO_freq = float_BFO_freq;				//Handle over to a non fp. variable Note: i contains the dds freq!

	Freq_reg1 = long_BFO_freq;					//Copy first part of the freq.
	Freq_reg1 = ((Freq_reg1 & 0x00FF) | 0x2000);//Set up to write 16 bits ino defer and present
	long_BFO_freq = long_BFO_freq >> 8;			//Shift 8 times left 	
	Freq_reg2 = long_BFO_freq;					//Copy first part of the freq. 
	Freq_reg2 = ((Freq_reg2 & 0x00FF) | 0x2100);//Set up to write 16 bits ino defer and present
	long_BFO_freq = long_BFO_freq >> 8;			//Shift 8 times left 
	Freq_reg3 = long_BFO_freq;					//Copy first part of the freq. 
	Freq_reg3 = ((Freq_reg3 & 0x00FF) | 0x2200);//Set up to write 16 bits ino defer and present
	long_BFO_freq = long_BFO_freq >> 8;			//Shift 8 times left 
	Freq_reg4 = long_BFO_freq;					//Copy first part of the freq. 
	Freq_reg4 = ((Freq_reg4 & 0x00FF) | 0x2300);//Set up to write 16 bits ino defer and present

	Write_AD9835 (Freq_reg1);					//Write freq. register	
	Write_AD9835 (Freq_reg2);					//Write freq. register
	Write_AD9835 (Freq_reg3);					//Write freq. register
	Write_AD9835 (Freq_reg4);					//Write freq. register

	Write_AD9835 (0xC000);						//Setup IC with Selsource=0 and sync=0	
}
/******************************************************************/
void Write_AD9835 (unsigned int data)
{
	unsigned char q = 0;
	unsigned int  k = 0;	

	DDS_enable_BFO = 0;

	for (q = 0; q <= 15; q++) 
	{
		DDS_clk	= 1;
		k = (data & 0x8000) ; 
		if 	((k  & 0x8000) == 0x8000)
		{
			DDS_data = 1;
			Nop();
		}
		else
		{
			DDS_data = 0;
			Nop();
		}
		DDS_clk	= 0;		//load here the data!!! (on falling edge of the clk)
		data = data << 1;
	}

	DDS_enable_BFO = 1;

	for (q = 0; q <= 2; q++) 
	{
		DDS_clk	= 1;
		Nop();
		DDS_clk	= 0;
		Nop();
	}

	DDS_clk	= 0;
	Nop();
	DDS_data = 0;
}

/******************************************************************/