
//************Update functions for the digipots and other*******
//************ stuffs assigned to ENCoder 2 ******************** 

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	


void Update_ENC2_functions(void)
{
	extern struct{
			unsigned	Volume : 1;			//Flag for volume
			unsigned	IF_gain : 1;		//If_gain
			unsigned	IF_hang : 1;		//Flag for if hanging
			unsigned	IF_switch: 1;		//Flag for if switch
			unsigned	VOX_gain : 1;		//Flag for VOX gain
			unsigned	VOX_anti : 1;		//Flag for anti VOX
			unsigned	VOX_delay : 1;		//Flag for VOX delay
			unsigned	VOX_On_Off : 1;		//Flag for VOX on or off
			unsigned	Mic_gain : 1;		//Flag for mike gain
			unsigned	Compressor : 1;		//Compressor
			unsigned	RF_pwr : 1;			//Flag for rf power
			} ENC2; 

	extern 	unsigned char 	vol_value_proc;	//volume holding register
	extern 	unsigned char 	ifg_value_proc;	//IF gain holding register
	extern 	unsigned char 	ifh_value_proc;	//IF hang holding register
	extern 	unsigned char	if_switch_value;//IF switched to internal or external
	extern 	unsigned char	vxg_value_proc;	//VOX gain holding register
	extern 	unsigned char	vxd_value_proc;	//VOX delay holding register
	extern 	unsigned char	vox_onoff_value ;//Vox on or off holding register
	extern 	unsigned char	avx_value_proc;	//Anti vox holding register
	extern 	unsigned char	mcg_value_proc;	//Mike gain holding register
	extern 	unsigned char	cmp_value_proc;	//Compresssor holding register
	extern 	unsigned char	rfp_value_proc;	//RF power holding register
	extern	unsigned char	TxE_data;		//TxExciter board IO register data
	extern unsigned	char	MUTE;

	far	unsigned int	 	temp_work = 0;
	far	unsigned int	 	temp_procent = 0;
	far	unsigned char		temp_data = 0;		

	if (ENC2.VOX_gain == 1)
	{
		temp_procent = (vxg_value_proc & 0x00FF);
		temp_work = temp_procent * 255;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = temp_work / 100;

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5254
		IdleI2C();
		WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
		IdleI2C();
		WriteI2C(0x00);						//Write to RDAC0 register
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		NotAckI2C();
		IdleI2C();	
		StopI2C();
	}

	if (ENC2.VOX_anti == 1)
	{
		temp_procent = (avx_value_proc & 0x00FF);
		temp_work = temp_procent * 255;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = temp_work / 100;

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5254
		IdleI2C();
		WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
		IdleI2C();
		WriteI2C(0x01);						//Write to RDAC1 register
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		NotAckI2C();
		IdleI2C();	
		StopI2C();
	}

	if (ENC2.Volume == 1)
	{
		if (MUTE == 0)
		{
			temp_procent = (vol_value_proc & 0x00FF);
			temp_work = temp_procent * 255;	//Multiply to have full coverage (proc is defined between 0-100%!
 			temp_data = temp_work / 100;
		}
		else	
			temp_data = 0;

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5254
		IdleI2C();
		WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
		IdleI2C();
		WriteI2C(0x02);						//Write to RDAC2 register
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		NotAckI2C();
		IdleI2C();	
		StopI2C();
	}

	if (ENC2.Mic_gain == 1)
	{
		temp_procent = (mcg_value_proc & 0x00FF);
		temp_work = temp_procent * 255;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = temp_work / 100;

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5254
		IdleI2C();
		WriteI2C(0x58);						//Device address of U6 on Tx_exciter board 0x58
		IdleI2C();
		WriteI2C(0x03);						//Write to RDAC3 register
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		NotAckI2C();
		IdleI2C();	
		StopI2C();
	}

	if (ENC2.IF_gain == 1)
	{
		temp_procent = (ifg_value_proc & 0x00FF);
		temp_work = temp_procent * 63;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = 63 - (temp_work / 100);

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5258
		IdleI2C();
		WriteI2C(0x30);						//Device address of U7 on IF board 0x30
		IdleI2C();
		WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		StopI2C();
	}

	if (ENC2.IF_hang == 1)
	{
		temp_procent = (ifh_value_proc & 0x00FF);
		temp_work = temp_procent * 63;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = 63 - (temp_work / 100);

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5258
		IdleI2C();
		WriteI2C(0x34);						//Device address of U8 on IF board 0x34
		IdleI2C();
		WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		StopI2C();
	}

	if (ENC2.Compressor == 1)
	{
		temp_procent = (cmp_value_proc & 0x00FF);
		temp_work = temp_procent * 63;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = temp_work / 100;

		IdleI2C();
		StartI2C(); 						//Setup and program of RDAC of the AD5258
		IdleI2C();
		WriteI2C(0x9C);						//Device address of U12 on Tx_exciter board 0x9C
		IdleI2C();
		WriteI2C(0x00);						//Write instruction byte: I2C <-> RDAC
		IdleI2C();
		WriteI2C(temp_data);				//Write data byte
		IdleI2C();
		StopI2C();
	}

	if (ENC2.VOX_delay == 1)
	{
		temp_procent = (vxd_value_proc & 0x00FF);
		temp_work = temp_procent * 255;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = temp_work / 100;

		IdleI2C();
		StartI2C();							//Setup and program of DAC of the MAX517
		IdleI2C();
		WriteI2C(0x5A);						//Device address of U8 on Tx_exciter board 0x5A
		IdleI2C();
		WriteI2C(0x00);						
		IdleI2C();
		WriteI2C(temp_data);				//Load DAC value
		IdleI2C();
		StopI2C();
	}

	if ((ENC2.VOX_On_Off == 1) | (ENC2.IF_switch == 1))
	{
		temp_data = (TxE_data & 0b00000010);
		if (if_switch_value == 1)
		{
			if (temp_data != 1)
				TxE_data = ((TxE_data & 0b11111101) | 0b00000010);
		}
		else	TxE_data = TxE_data & 0b11111101;


		temp_data = (TxE_data & 0b00000001);
		if (vox_onoff_value == 1) 	
		{
			if (temp_data != 1)
			TxE_data = ((TxE_data & 0b11111110) | 0b00000001);
		}
		else	TxE_data = TxE_data & 0b11111110;

		IdleI2C();
		StartI2C(); 						//***Setup the IO port on the PCF8574*** 
		IdleI2C();
		WriteI2C(0x46);						//Device address of U4 on Tx_exciter board 0x46
		IdleI2C();
		WriteI2C(TxE_data);					//Data to device
		IdleI2C();
		StopI2C();	
	}

	if (ENC2.RF_pwr == 1)
	{
		temp_procent = (rfp_value_proc & 0x00FF);
		temp_work = temp_procent * 63;	//Multiply to have full coverage (proc is defined between 0-100%!
 		temp_data = 63 - (temp_work / 100);

		IdleI2C();
		StartI2C();							//Setup and program of DAC of the MAX517
		IdleI2C();
		WriteI2C(0x98);						//Device address of U8 on Tx_exciter board 0x5A
		IdleI2C();
		WriteI2C(0x00);						
		IdleI2C();
		WriteI2C(temp_data);				//Load DAC value
		IdleI2C();
		StopI2C();
	}
}