
//********************************************************************************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

void Update_Filter_SWR(void)
{
	extern	struct {								
    	unsigned  	PB_flag:1;			//Flags for state save
    	unsigned	Channel_A_H:1;		//Encoder channel a Latch
    	unsigned	Warn_flag:1;		//Warning light flag
		unsigned 	PTT_flag:1;			//Flag for signaling if ptt pushed
		unsigned	USB_mode:1;			//Flag for signaling if USB mode
		unsigned	LSB_mode:1;			//Flag for signaling if LSB mode
		unsigned	CW_mode:1;			//Flag for signaling if CW mode
		unsigned	Dial :1;			//Flag for signaling if CW mode	
	} FLAGS ;

	extern	struct{
		unsigned	MHz_1_8 : 1;		//Flag for 1.8MHz band
		unsigned	MHz_3_5 : 1;		//Flag for 3.5MHz band
		unsigned	MHz_7 : 1;			//Flag for 7MHz band
		unsigned	MHz_10 : 1;			//Flag for 10MHz band
		unsigned	MHz_14 : 1;			//Flag for 14MHz band
		unsigned	MHz_18 : 1;			//Flag for 18MHz band
		unsigned	MHz_21 : 1;			//Flag for 21MHz band
		unsigned	MHz_24 : 1;			//Flag for 24MHz band
		unsigned	MHz_28 : 1;			//Flag for 28MHz band
		unsigned	MHz_50 : 1;			//Flag for 50MHz band
		} BANDS; 

	unsigned char Filter_data;

	{
		if (BANDS.MHz_1_8 == TRUE)
		Filter_data = 0b10000000;

		if (BANDS.MHz_3_5 == TRUE)
		Filter_data = 0b01000000;

		if (BANDS.MHz_7 == TRUE)
		Filter_data = 0b00010000;

		if (BANDS.MHz_10 == TRUE)
		Filter_data = 0b00100000; 

		if (BANDS.MHz_14 == TRUE)
		Filter_data = 0b00001000;

		if ((BANDS.MHz_18 == TRUE) |(BANDS.MHz_21 == TRUE))

		Filter_data = 0b00000100; 

		if ((BANDS.MHz_28 == TRUE) | (BANDS.MHz_24 == TRUE))
		Filter_data = 0b00000010;
 

		IdleI2C();
		StartI2C(); 						//***Setup the IO port on the PCF8574*** 
		IdleI2C();
		WriteI2C(0x48);				//Device address = 0100. A2 A1 A0 0 for write to port
		IdleI2C();
		WriteI2C(Filter_data);				//Data to device
		IdleI2C();
		StopI2C();
	
	}

}
// ******************************************************************
