
//********************************************************************************

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"	

void Update_Front_End(void)
{
	extern struct	{
		unsigned	Att_0dB:1; 			//Pass throught
		unsigned	Att_2dB:1;
    	unsigned	Att_4dB:1;
		unsigned	Att_6dB:1;
		unsigned	Att_8dB:1; 		
		unsigned	Att_10dB:1;
    	unsigned	Att_12dB:1;
		unsigned	Att_14dB:1;
		unsigned	Att_16dB:1; 			//Modif F5JLW
		unsigned	Att_18dB:1;
   		unsigned	Att_20dB:1;
		unsigned	Att_22dB:1;
		unsigned	Att_24dB:1; 		
		unsigned	Att_26dB:1;
   		unsigned	Att_28dB:1;
		unsigned	Att_30dB:1;			//Att position at 30dB
		} ATT;	

	extern	struct {								
    	unsigned  	PB_flag:1;			//Flags for state save
    	unsigned	Channel_A_H:1;		//Encoder channel a Latch
    	unsigned	Warn_flag:1;		//Warning light flag
		unsigned 	PTT_flag:1;			//Flag for signaling if ptt pushed
		unsigned	USB_mode:1;			//Flag for signaling if USB mode
		unsigned	LSB_mode:1;			//Flag for signaling if LSB mode
		unsigned	CW_mode:1;			//Flag for signaling if CW mode
		unsigned	Dial :1;			//Flag for signaling if CW mode	
	} FLAGS ;

	extern	struct{
		unsigned	MHz_1_8 : 1;		//Flag for 1.8MHz band
		unsigned	MHz_3_5 : 1;		//Flag for 3.5MHz band
		unsigned	MHz_7 : 1;			//Flag for 7MHz band
		unsigned	MHz_10 : 1;			//Flag for 10MHz band
		unsigned	MHz_14 : 1;			//Flag for 14MHz band
		unsigned	MHz_18 : 1;			//Flag for 18MHz band
		unsigned	MHz_21 : 1;			//Flag for 21MHz band
		unsigned	MHz_24 : 1;			//Flag for 24MHz band
		unsigned	MHz_28 : 1;			//Flag for 28MHz band
		unsigned	MHz_50 : 1;			//Flag for 50MHz band
		} BANDS; 

	extern	unsigned char	FE_data_1;
	extern	unsigned char	FE_data_2;
	unsigned char	FE_data_1_local;
	unsigned char	FE_data_2_local;

	if (FLAGS.PTT_flag ==1)
	{
			FE_data_1_local = ((FE_data_1_local & 0b01111111) | 0b10000000);
			FE_data_2_local = ((FE_data_2_local & 0b11101111) | 0b00010000);
	}
	else
	{
			FE_data_1_local = ((FE_data_1_local & 0b01111111) | 0b00000000); 
			FE_data_2_local = ((FE_data_2_local & 0b11101111) | 0b00000000);
	}
	
	if 	(BANDS.MHz_1_8 == TRUE)
			FE_data_1_local = ((FE_data_1_local & 0b11101111) | 0b00010000); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11101111) | 0b00000000); 

	if (BANDS.MHz_3_5 == TRUE)
			FE_data_1_local = ((FE_data_1_local & 0b11110111) | 0b00001000); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11110111) | 0b00000000); 

	if (BANDS.MHz_7 == TRUE)
			FE_data_1_local = ((FE_data_1_local & 0b11111011) | 0b00000100); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11111011) | 0b00000000); 

	if (BANDS.MHz_10 == TRUE)
			FE_data_1_local = ((FE_data_1_local & 0b11111101) | 0b00000010); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11111101) | 0b00000000);
 
	if (BANDS.MHz_14 == TRUE)
			FE_data_1_local = ((FE_data_1_local & 0b11111110) | 0b00000001); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11111110) | 0b00000000); 

	if (BANDS.MHz_18 == TRUE)
			FE_data_2_local = ((FE_data_2_local & 0b11111110) | 0b00000001); 
	else	FE_data_2_local = ((FE_data_2_local & 0b11111110) | 0b00000000); 

	if (BANDS.MHz_21 == TRUE)
			FE_data_2_local = ((FE_data_2_local & 0b11111101) | 0b00000010); 
	else	FE_data_2_local = ((FE_data_2_local & 0b11111101) | 0b00000000);

	if (BANDS.MHz_24 == TRUE)
			FE_data_2_local = ((FE_data_2_local & 0b11111011) | 0b00000100); 
	else	FE_data_2_local = ((FE_data_2_local & 0b11111011) | 0b00000000); 

	if (BANDS.MHz_28 == TRUE)
			FE_data_2_local = ((FE_data_2_local & 0b11110111) | 0b00001000); 
	else	FE_data_2_local = ((FE_data_2_local & 0b11110111) | 0b00000000); 

	if (ATT.Att_6dB == 1)
			FE_data_1_local = ((FE_data_1_local & 0b10111111) | 0b01000000); 
	else	FE_data_1_local = ((FE_data_1_local & 0b10111111) | 0b00000000); 

	if (ATT.Att_12dB == 1)
			FE_data_1_local = ((FE_data_1_local & 0b11011111) | 0b00100000); 
	else	FE_data_1_local = ((FE_data_1_local & 0b11011111) | 0b00000000); 

	if (ATT.Att_18dB == 1)
			FE_data_1_local = ((FE_data_1_local & 0b10011111) | 0b01100000); 
	else if ((ATT.Att_12dB != 1) & (ATT.Att_6dB != 1) & (ATT.Att_18dB != 1))
			FE_data_1_local = ((FE_data_1_local & 0b10011111) | 0b00000000); 

	if ((FE_data_1_local != FE_data_1) | (FE_data_2_local != FE_data_2))
	{
		FE_data_1 = FE_data_1_local;
		FE_data_2 = FE_data_2_local;

		IdleI2C();
		StartI2C(); 						//***Setup the IO port on the PCF8574*** 
		IdleI2C();
		WriteI2C(0b01110100);				//Device address = 0100. A2 A1 A0 0 for write to port
		IdleI2C();
		WriteI2C(FE_data_1);				//Data to device
		IdleI2C();
		StopI2C();
	
		IdleI2C();
		StartI2C(); 						//***Setup the IO port on the PCF8574*** 
		IdleI2C();
		WriteI2C(0b01110010);				//Device address = 0100. A2 A1 A0 0 for write to port
		IdleI2C();
		WriteI2C(FE_data_2);				//Data to device
		IdleI2C();
		StopI2C();
	}

}
// ******************************************************************
