/* $Id: busyxlcd.c,v 1.1 2003/12/09 22:52:09 GrosbaJ Exp $ */

#include	"D:\Work_MPlab\CDG2000_YO6OGJ\CDG2000_YO6OGJ.h"

/********************************************************************
*       Function Name:  BusyXLCD                                    *
*       Return Value:   char: busy status of LCD controller         *
*       Parameters:     void                                        *
*       Description:    This routine reads the busy status of the   *
*                       Hitachi HD44780 LCD controller.             *
********************************************************************/
unsigned char BusyXLCD(void)
{
	unsigned char i;
	extern unsigned char First_half;

        TRIS_DATA_PORT = 0xff;          // Make data port inputs
        RW_PIN = 1;                     // Set the control bits for read
		Nop();
        DelayFor18TCY();
        RS_PIN = 0;
		Nop();
        DelayFor18TCY();
       	if	(First_half == 1)
		{	
			E_PIN_1 = 1;
			Nop();
		}
		else
		{
			E_PIN_2 = 1;                // Clock in the command
			Nop();
		}
        DelayFor18TCY();
#ifdef BIT8                             // 8-bit interface
		i = DATA_PORT & 0x80;
        if(i == 1)              // Read bit 7 (busy bit)
        {                               // If high
		       	if	(First_half == 1)
				{	
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;        // Reset clock line
					Nop();
				}
        		DelayFor18TCY();
                RW_PIN = 0;             // Reset control line
				Nop();
                return 1;               // Return TRUE
        }
        else                            // Bit 7 low
        {
		       	if	(First_half == 1)
				{	
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;        // Reset clock line
					Nop();
				}
	        	DelayFor18TCY();
                RW_PIN = 0;             // Reset control line
				Nop();
                return 0;               // Return FALSE
        }
#else                                   // 4-bit interface
#ifdef UPPER                            // Upper nibble interface
        if(DATA_PORT&0x80)
#else                                   // Lower nibble interface
        if(DATA_PORT&0x08)
#endif
        {
		       	if	(First_half == 1)
				{	
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;             // Reset clock line
					Nop();
				}
                DelayFor18TCY();
		       	if	(First_half == 1)
				{	
					E_PIN_1 = 1;
					Nop();
				}
				else
				{
					E_PIN_2 = 1;                     // Clock the cmd in
					Nop();
				}
		        DelayFor18TCY();
		       	if	(First_half == 1)
				{
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;
					Nop();
				}
		        DelayFor18TCY();
                RW_PIN = 0;             // Reset control line
				Nop();
                return 1;               // Return TRUE
        }
        else                            // Busy bit is low
        {
		       	if	(First_half == 1)	
				{
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;             // Reset clock line
					Nop();
				}
                DelayFor18TCY();
		       	if	(First_half == 1)
				{
					E_PIN_1 = 1;
					Nop();
				}
				else
				{
					E_PIN_2 = 1;            // Clock the cmd in
					Nop();
				}
		        DelayFor18TCY();
		       	if	(First_half == 1)	
				{
					E_PIN_1 = 0;
					Nop();
				}
				else
				{
					E_PIN_2 = 0;
					Nop();
				}
		        DelayFor18TCY();
                RW_PIN = 0;             // Reset control line
				Nop();
                return 0;               // Return FALSE
        }
#endif
}

