/****************************************************************************************************/
/*																									*/
/*	Name:		blinky.c																				*/
/*																									*/
/*	Purpose:	Test Program for STM32VLDiscovery - blinks the LEDs on and off at different rates	*/
/*				(Green = 4 x Slower than Blue). Green is turned off if the button is pressed.		*/
/*																									*/
/*	Created:	21st September 2010																	*/
/*																									*/
/*	Author:		Paul Robson (paul@robsons.org.uk)													*/
/*				Simonsson Fun Techonlogies (original work on code for STM32)						*/
/*																									*/
/****************************************************************************************************/

#include "stm32f10x.h"

#define STACK_TOP 0x20002000										/* This can move quite a lot ! */

void nmi_handler(void);												
void hardfault_handler(void);
void delay(int tempo);
int main(void);

/*	Four vectors - the starting stack pointer value, code entry point and NMI and Hard-Fault handlers */

unsigned int * myvectors[4] 
__attribute__ ((section("vectors")))= {
    (unsigned int *)	STACK_TOP,         
    (unsigned int *) 	main,              
    (unsigned int *)	nmi_handler,       
    (unsigned int *)	hardfault_handler  
};


int main(void){	
int PWMratio;
#ifdef DEBUG
  debug();
#endif

//Switching external oscillator on
RCC->CR|=0x10000;

// Wait for oscillator to be stable
while(!(RCC->CR &0x00020000))
{;}

//Setting PLL multiplication to 9 (to get 72MHz), external clock source (HSE)
RCC->CFGR=0x070D0000;

// Switching PLL on
RCC->CR |=0x01000000;

//Waiting for PLL to be stable
while(!(RCC->CR & 0x02000000))
{;}

// Selecting PLL output as system clock

 RCC->CFGR|=2; 

// stopping internal oscillator
 RCC->CR&=0xFFFFFE;

//Enable Flash and SRAM clocks
RCC->AHBENR = 0x00000014;
RCC->APB2ENR = 0x00005E7D;
	
//RCC->CR|=0x05000000;
//RCC->CFGR|=0x07000000;
RCC->APB2ENR |=0x05;									/* Enable the GPIOA (bit 2) and GPIOC (bit 8) */
GPIOA->CRH= 0x44444443;
GPIOA->CRL = 0x44444803;			/* Set GPIOA Pin 0 to output, GPIOA1 to analog, GPIOA2 to input with pull-up */

GPIOA->ODR -=0x00000004;			// enabling pull-up on PA2
PWMratio=5000;
    while(1)
    {
		if (!(GPIOA->IDR&0x04))
		{
			GPIOA->BSRR=1<<16;
			delay(PWMratio);													/* A short delay */
			GPIOA->BSRR=1<<0;
			delay(10000-PWMratio);	
		}
		else
			GPIOA->ODR&=0xFFFFFFFE;
			//GPIOA->BSRR=1<<16;
    }
}

void delay(int tempo) 
{
	int i = tempo;													/* About 1/4 second delay */
	while (i-- > 0) {
		asm("nop");													/* This stops it optimising code out */
	}
}

void nmi_handler(void)
{
    return ;
}

void hardfault_handler(void)
{
    return ;
}

