

; Utilisation de l'USART du 16F88 
; 9600 bauds/s     8 bits de donnes     Pas de bit de parit
; 1 bit de STOP    P

; 2010

; version 1.0
; microcontrleur PIC 16F88
; dvelopp avec Microchip MPLAB IDE
 ERRORLEVEL -302 ;remove message about using proper bank ERRORLEVEL -302;
 List p=16F88 ; processeur utilis
 #include <p16F88.inc>

     __CONFIG          _CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC
	 __CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF

;xxxxxx
; macro
;xxxxxx

bank1 macro  ; passage en banque 1
  bsf STATUS,RP0
  bcf STATUS,RP1
  endm

bank0 macro  ; passage en banque 0
  bcf STATUS,RP0
  bcf STATUS,RP1
  endm

;xxxxxxxxxxxxxxxxxxxxxxxxx
; dclaration de variables
;xxxxxxxxxxxxxxxxxxxxxxxxx
	
	 CBLOCK H'070'  ; dbut de la zone des registres d'usage gnral du 16F88
	   
	
	 STATUS_TEMP : 1  ; sauvegarde du registre STATUS (routine d'interruption)
	 W_TEMP : 1    ; sauvegarde du registre W  (routine d'interruption)
	 donnee : 1    ; 8 bits de donnes

	 	ENDC

;xxxxxxxxxxxxxxxxxxxx
; dmarrage sur reset
;xxxxxxxxxxxxxxxxxxxx

	 org 0x0000
	 goto initialisation

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
; Routine d'interruption
; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

	 org 0x0004     ; vecteur d'interruption
		
	 retfie 

;xxxxxxxxxxxxxxx
; initialisation
;xxxxxxxxxxxxxxx

initialisation   

	 bank0
	 clrf PORTA   ; mise  0 des sorties du port A
	 clrf PORTB   ; mise  0 des sorties du port B
	

	
	 
	 
	 bank1
	 movlw B'11111101'
	 movwf TRISA


 ; bit 1 du port A (RA1) = 0 : configuration en sortie (LED )
 
	 movlw B'00100100'
	 movwf TRISB

 ; bit 5 du port B  = 1 : configuration en entre (TX : USART)
 ; bit 2 du port B  = 1 : configuration en entre (RX : USART)
 
 
	 movlw B'01100000'		;horloge 4MHZ quartz
	 movwf OSCCON 


     
	
	 movlw B'00000111' ;configurer le mode 111 pour utiliser RA0 RA1 RA2 RA3 en I/O analogique
	 movwf CMCON   
	                       
	

	

	
	    movlw D'25'
	    movwf SPBRG ; (SPBRG) = D'25'
	
	    movlw B'00000100'
	    movwf TXSTA
    ; bit 7 (CSRC) = 0 (non utilis : 0 par exemple)
    ; bit 6 (TX9) = 0 (non utilis : 0 par exemple)
    ; bit 5 (TXEN) = 0 (non utilis : 0 par exemple)
    ; bit 4 (SYNC) = 0 : mode asynchrone
    ; bit 3 = 0 (non implment)
    ; bit 2 (BRGH) = 1 : mode asynchrone haute vitesse
    ; bit 1 (TRMT) = 0 (non utilis : 0 par exemple)
    ; bit 0 (TX9D) = 0 (non utilis : 0 par exemple)

 bank0
	 
	 movlw B'10010000'
	 movwf RCSTA
 ; bit 7 (SPEN) = 1 : utilisation du port srie
 ; bit 6 (RX9)  = 0 : 8 bits de rception
 ; bit 5 (SREN) = 0 (non utilis : 0 par exemple)
 ; bit 4 (CREN) = 1 : autorise la rception
 ; bit 3 (ADEN) = 0 (non utilis : 0 par exemple)
 ; bit 2 (FERR) = 0 (en lecture seule)
 ; bit 1 (OERR) = 0 (en lecture seule)
 ; bit 0 (RX9D) = 0 (non utilis : 0 par exemple)

	
	
	 goto debut_programme 





 
;xxxxxxxxxxxxxxxxxxxxx
; programme principal
;xxxxxxxxxxxxxxxxxxxxx

debut_programme



	call	rx_rs232		;wait for an incoming byte

	movwf	donnee			;copy received by into donnee
	
	 
	 movlw B'01000001'     ; (code ASCII de A= B'0100 0001')
	 subwf donnee,W 
	 btfsc STATUS,Z 
	 goto afficheA    ; donnee = 'A'
	
	 movlw B'01000010'     ; (code ASCII de B= B'0100 0010')A
	 subwf donnee,W 
	 btfsc STATUS,Z 
	 goto afficheB    ;
	 goto debut_programme
afficheA
	 bcf PORTA,1;RA1 est aux 0VDC si on appuis sur la touche A

	goto debut_programme
afficheB 
	bsf PORTA,1;RA1 est aux 0VDC si on appuis sur la touche B
	goto debut_programme ; on attend l'interruption de rception (USART)
	
	
	
; Eusart Sub Routines

rx_rs232 	btfss   PIR1,  RCIF 	    ;check for received data
     		goto    rx_rs232
            movf  	RCREG,W
            return

	
	 END





