#include <16F628A.h>

#FUSES NOWDT                    //No Watch Dog Timer
#FUSES LP                       //Low power osc < 200 khz
#FUSES NOPUT                    //No Power Up Timer
#FUSES NOPROTECT                //Code not protected from reading
#FUSES NOBROWNOUT               //No brownout reset
#FUSES NOMCLR                   //Master Clear pin used for I/O
#FUSES NOLVP                    //No low voltage prgming, B3(PIC16) or B5(PIC18) used for I/O
#FUSES NOCPD                    //No EE protection

#use delay(clock=4000000)
#use rs232(baud=9600,parity=N,xmit=PIN_A3,rcv=PIN_A2,bits=8)


#include <stdlib.h>
#include <string.h>

#use delay (clock=4000000)

#use rs232 (baud=9600, xmit=pin_b2, rcv=pin_b1, parity=N, stop=1)

#define so 10   // dfinir les adresse mmoir EEPROM qu'on va les utiliser
#define mo 15
#define sf 20
#define mf 25

unsigned char send[5],c[5],etat[5],select[5],chaine1[20],chaine2[20],str1[20],str2[20];  // dclaration d'une chaine de caractres d'une taille maximale 20
unsigned int16 s=0,x1=0,y1=0,x2=0,y2=0,a1=0,b1=0,a2=0,b2=0;                          // dclaration d'un entier non sign de longueur 16 bits  
unsigned int1 k=0;         
unsigned int z=0,w,x=0,j,i=0;

#int_ext
void ext_isr()
{
   //DISABLE_INTERRUPTS(INT_ext);
   if(!input(pin_b0)){
   output_low(pin_b4);
   output_low(pin_b5);
   output_low(pin_b6);
   output_low(pin_b7);
   output_high(pin_a2);
   output_low(pin_a1);}
}

#int_timer0 
void timer(){
   z=0;
   if(kbhit()){
   gets(select);
   x=atoi(select);
   switch(x){
   case 1:{
   printf("%lu\r",a1);          // time of LED lighting in seconds
   printf("%lu\r",b1);          // time of LED lighting in minutes
   printf("%lu\r",a2);          // time of LED switched off in seconds
   printf("%lu\r",b2);          // time of LED switched off in minutes
   break;
   }
   case 2:{
   j=2;
   strcpy(c,"2");                
   if(input(pin_b0))             
   printf("%s\r","F");
   while(input(pin_b0)&& j==2)  // boucle pour passer au mode config si on l'est pas deja   
   {
   //delay_ms(1000);
   gets(c);
   j=atoi(c);
   output_high(pin_a1);
   output_low(pin_a2);
   if(input(pin_b0)&& j!=8)
   printf("%s\r","F");
   }
   if(j!=8){
   printf("%s\r","C");
   output_high(pin_a2);
   output_low(pin_a1);
   output_low(pin_b4);         
   output_low(pin_b5);
   output_low(pin_b6);
   output_low(pin_b7);}
   while(z==0 && j!=8 ){
   gets(send);
   printf("%s\r",send);
   s=atol(send);
   if(s==4){
   gets(chaine1);               // acquisition des nouveaux valeurs
   gets(str1);
   gets(chaine2);
   gets(str2);
   x1=atol(chaine1);            // conversion chaine -> entier long
   y1=atol(str1);
   x2=atol(chaine2);
   y2=atol(str2);
   printf("%s\r",chaine1);      // renvoyer les valeurs reu pour une confirmation de l'utilisateur
   printf("%s\r",str1);
   printf("%s\r",chaine2);
   printf("%s\r",str2);
   gets(select);
   w=atoi(select);
   if (w==1) {
   a1=x1;
   a2=x2;
   b1=y1;
   b2=y2;
   write_eeprom(so,a1);
   write_eeprom(mo,b1);
   write_eeprom(sf,a2);
   write_eeprom(mf,b2);
   a1=a1*1000;
   a2=a2*1000;
   z=1;
   }
   else 
   {
   z=0;
   }
   }
   else 
   {
   z=1;
   }
   }
   break;
   }
   case 3:{
   j=3;
   strcpy(c,"3");                
   if(input(pin_b0)==0)             
   printf("%s\r","C");
   while(input(pin_b0)==0 && j==3)  // boucle pour passer au mode config si on l'est pas deja   
   {
   gets(c);
   j=atoi(c);
   if((input(pin_b0)==0) && j!=9 )
   printf("%s\r","C");
   }
   if (j!= 9)
   printf("%s\r","F");
   break;
   }
}
   }
}

void minute (int16 m){    // procdure qui fait un dure d'attente de m minutes
   while(m>0){
   delay_ms(60000);
   m--;}
}

void main()
{
   EXT_INT_EDGE(H_TO_L);
   setup_timer_0(RTCC_INTERNAL | RTCC_DIV_256);
   setup_timer_1(T1_DISABLED);
   setup_timer_2(T2_DISABLED,0,1);
   setup_comparator(NC_NC_NC_NC);
   setup_vref(FALSE);
//Setup_Oscillator parameter not selected from Intr Oscillotar Config tab
   set_timer0(60);
   // TODO: USER CODE!!
   enable_interrupts(GLOBAL);// autoris tout les intrruptions
   a1=read_eeprom(so);
   b1=read_eeprom(mo);
   a2=read_eeprom(sf);
   b2=read_eeprom(mf);
   a1=a1*1000;
   a2=a2*1000;
   while(1)
   {
   enable_interrupts(INT_EXT);
   enable_interrupts(int_timer0);
   if((input(pin_b0))){
   output_high(pin_b4); 
   output_high(pin_b5);
   output_high(pin_b6);
   output_high(pin_b7);
   output_high(pin_a1);
   output_low(pin_a2);
   delay_ms(a1);
   minute(b1);
   output_high(pin_a1);
   output_low(pin_a2);
   output_low(pin_b4);        
   output_low(pin_b5);
   output_low(pin_b6);
   output_low(pin_b7);
   delay_ms(a2);
   minute(b2);
   }      
   else 
   {
   output_high(pin_a2);
   output_low(pin_a1);
   }
   }
}
