/*===========================================================================*
 | Implementation file main.c
 |   implements : 
 |
 |      summary :  Main of the application (slave MCU)
 |
 | Creator : Sylvie Rohrer
 | Creation date : 30.11.2006
 | Copyright: HE-ARC, SWISSCUBE all rights reserved
 |
 | Modification tag : //MODIF1
 |
 | Version of the file : 1
 *===========================================================================*/

#include "scI2C_PIC18.h"

#define I2C_TC74CMD		0x54	/* character 'T' */

/***********************************************************/
int main(void)
/* Main application
************************************************************/
{
	char l_cCmd = 0;

	i2c_init(0);	// Slave mode

	while(1)
	{
		// RECEPTION -----------------------------
		i2c_read_slave();	// Receive the address
		
		l_cCmd = i2c_read_slave();	// Receive the command

		if (l_cCmd == I2C_TC74CMD)	l_cCmd = 66;
		else l_cCmd = 88;

		// TRANSMISSION -----------------------------
		i2c_write_slave(l_cCmd);
	}

	return 0;
}
