/*===========================================================================*
 | Declaration file COMi2c.h
 |   declares : 
 |
 | For more informations (creation date, creator, etc.), please see the
 | corresponding .c file
 |
 *===========================================================================*/

/* Initialize the communication I2C */
void i2c_init(char _cMaster);

/* Start the communication I2C */
void i2c_start(void);

/* Restart the communication I2C */
void i2c_restart(void);

/* Write a char in the i2c communication */
void i2c_write(char byte);

/* Read a char in the i2c communication */
char i2c_read(void);

/* Stop the communication I2C */
void i2c_stop(void);

/* Wait that the interrupt is generated */
void i2c_wait(void);

/* Send an acknowledgment */
void i2c_ack(void);

/* Send not an acknowledgment */
void i2c_nack(void);

/* Set the Master Synchronous Serial Port Interrupt Flag bit to the
   status "Waiting to transmit/receive"
   See : PIR1 (Peripheral Interrupt Request) */
void i2c_initSerialPortInterrupt(void);

/* Wait "pause" ms */
void delayMs(char _cPause);

/* Write a char in the i2c communication (slave mode) */
void i2c_write_slave(char _cData);

/* Read a char from the i2c communication (slave mode) */
char i2c_read_slave(void);
